/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.com.squareup.javapoet;

import com.apollographql.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.relocated.com.squareup.javapoet.ParameterSpec$Builder;
import com.apollographql.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.relocated.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class ParameterSpec {
    public final String name;
    public final List annotations;
    public final Set modifiers;
    public final TypeName type;
    public final CodeBlock javadoc;

    public ParameterSpec(ParameterSpec$Builder parameterSpec$Builder) {
        this.name = (String)Util.checkNotNull(ParameterSpec$Builder.access$000(parameterSpec$Builder), "name == null", new Object[0]);
        this.annotations = Util.immutableList(parameterSpec$Builder.annotations);
        this.modifiers = Util.immutableSet(parameterSpec$Builder.modifiers);
        this.type = (TypeName)Util.checkNotNull(ParameterSpec$Builder.access$100(parameterSpec$Builder), "type == null", new Object[0]);
        this.javadoc = ParameterSpec$Builder.access$200(parameterSpec$Builder).build();
    }

    public static ParameterSpec$Builder builder(TypeName typeName, String string, Modifier ... modifierArray) {
        boolean bl;
        Util.checkNotNull(typeName, "type == null", new Object[0]);
        if (string.endsWith(".this")) {
            String string2 = string;
            bl = SourceVersion.isIdentifier(string2.substring(0, string2.length() - 5));
        } else {
            bl = string.equals("this") || SourceVersion.isName(string);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Util.checkArgument(bl, "not a valid name: %s", objectArray2);
        ParameterSpec$Builder parameterSpec$Builder = new ParameterSpec$Builder(typeName, string);
        Collections.addAll(parameterSpec$Builder.modifiers, modifierArray);
        return parameterSpec$Builder;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (ParameterSpec.class != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        CodeWriter codeWriter;
        Object[] objectArray;
        Object[] objectArray2 = objectArray;
        objectArray = new StringBuilder();
        CodeWriter codeWriter2 = codeWriter;
        try {
            codeWriter2((Appendable)objectArray2);
            codeWriter2.emitAnnotations(this.annotations, true);
            codeWriter2.emitModifiers(this.modifiers, Collections.emptySet());
            this.type.emit(codeWriter2);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = this.name;
        codeWriter.emit(" $L", objectArray2);
        return objectArray.toString();
    }
}

