/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.UploadsHttpBody;
import com.apollographql.apollo3.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.api.json.MapJsonWriter;
import com.apollographql.apollo3.api.json.internal.FileUploadAwareJsonWriter;
import com.apollographql.relocated.kotlin.NoWhenBranchMatchedException;
import com.apollographql.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import com.apollographql.relocated.kotlin.collections.CollectionsKt___CollectionsKt;
import com.apollographql.relocated.kotlin.collections.EmptyList;
import com.apollographql.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.BufferedSink;
import com.apollographql.relocated.okio.ByteString;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    public static final Companion Companion = new Companion(null);
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    private static final String HEADER_ACCEPT_NAME = "Accept";
    private static final String HEADER_ACCEPT_VALUE = "multipart/mixed; deferSpec=20220824, application/json";
    private final String serverUrl;

    public DefaultHttpRequestComposer(String string) {
        Intrinsics.checkNotNullParameter(string, "serverUrl");
        this.serverUrl = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <D extends Operation.Data> HttpRequest compose(ApolloRequest<D> object) {
        HttpRequest httpRequest;
        int n;
        HttpHeader httpHeader;
        HttpHeader httpHeader2;
        HttpHeader httpHeader3;
        HttpMethod httpMethod;
        void v0 = httpMethod;
        Intrinsics.checkNotNullParameter(v0, "apolloRequest");
        Operation operation = v0.getOperation();
        CustomScalarAdapters customScalarAdapters = v0.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        Object[] objectArray = new HttpHeader[3];
        Object object2 = httpHeader3;
        httpHeader3 = new HttpHeader(HEADER_APOLLO_OPERATION_ID, operation.id());
        objectArray[0] = object2;
        object2 = httpHeader2;
        httpHeader2 = new HttpHeader(HEADER_APOLLO_OPERATION_NAME, operation.name());
        objectArray[1] = object2;
        object2 = httpHeader;
        httpHeader = new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE);
        objectArray[2] = object2;
        object2 = CollectionsKt__CollectionsKt.listOf(objectArray);
        Serializable serializable = ((ApolloRequest)((Object)httpMethod)).getHttpHeaders();
        if (serializable == null) {
            serializable = EmptyList.INSTANCE;
        }
        object2 = CollectionsKt___CollectionsKt.plus((Iterable)((Object)serializable), (Collection)object2);
        serializable = ((ApolloRequest)((Object)httpMethod)).getSendApqExtensions();
        boolean bl = serializable != null ? (Boolean)serializable : false;
        Boolean bl2 = ((ApolloRequest)((Object)httpMethod)).getSendDocument();
        boolean bl3 = bl2 != null ? bl2 : true;
        httpMethod = ((ApolloRequest)((Object)httpMethod)).getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        if ((n = WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            String string = bl3 ? operation.document() : null;
            HttpMethod httpMethod2 = HttpMethod.Post;
            httpRequest = new HttpRequest.Builder(httpMethod2, this.serverUrl).addHeaders((List<HttpHeader>)object2).body(Companion.buildPostBody(operation, customScalarAdapters, bl, string)).build();
            return httpRequest;
        } else {
            httpRequest = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters, bl, bl3)).addHeaders((List<HttpHeader>)object2).build();
        }
        return httpRequest;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b+\u0010,JG\u0010\r\u001a\u00020\u0004\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJU\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JK\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001a\u001a\u00020\u0004*\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\u0004\b\u001a\u0010\u001bJ?\u0010\u001d\u001a\u00020\u001c\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ=\u0010 \u001a\u00020\u001f\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b \u0010!J3\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010'R\u0014\u0010)\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b*\u0010'\u00a8\u0006-"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "Lcom/apollographql/apollo3/api/Operation$Data;", "D", "", "serverUrl", "Lcom/apollographql/apollo3/api/Operation;", "operation", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "customScalarAdapters", "", "sendApqExtensions", "sendDocument", "buildGetUrl", "(Ljava/lang/String;Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/CustomScalarAdapters;ZZ)Ljava/lang/String;", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "writer", "query", "", "Lcom/apollographql/apollo3/api/Upload;", "composePostParams", "(Lcom/apollographql/apollo3/api/json/JsonWriter;Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/CustomScalarAdapters;ZLjava/lang/String;)Ljava/util/Map;", "autoPersistQueries", "composeGetParams", "(Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/CustomScalarAdapters;ZZ)Ljava/util/Map;", "parameters", "appendQueryParameters", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "Lcom/apollographql/apollo3/api/http/HttpBody;", "buildPostBody", "(Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/CustomScalarAdapters;ZLjava/lang/String;)Lcom/apollographql/apollo3/api/http/HttpBody;", "Lcom/apollographql/relocated/okio/ByteString;", "buildParamsMap", "(Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/CustomScalarAdapters;ZZ)Lcom/apollographql/relocated/okio/ByteString;", "Lcom/apollographql/apollo3/api/ApolloRequest;", "apolloRequest", "composePayload", "(Lcom/apollographql/apollo3/api/ApolloRequest;)Ljava/util/Map;", "HEADER_ACCEPT_NAME", "Ljava/lang/String;", "HEADER_ACCEPT_VALUE", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "<init>", "()V", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String string, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean bl, boolean bl2) {
            return this.appendQueryParameters(string, this.composeGetParams(operation, customScalarAdapters, bl, bl2));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter jsonWriter, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean bl, String string) {
            JsonWriter jsonWriter2 = jsonWriter;
            JsonWriter jsonWriter3 = jsonWriter;
            jsonWriter3.beginObject();
            jsonWriter3.name("operationName");
            jsonWriter2.value(operation.name());
            jsonWriter2.name("variables");
            FileUploadAwareJsonWriter fileUploadAwareJsonWriter = new FileUploadAwareJsonWriter(jsonWriter);
            fileUploadAwareJsonWriter.beginObject();
            operation.serializeVariables(fileUploadAwareJsonWriter, customScalarAdapters);
            fileUploadAwareJsonWriter.endObject();
            Map<String, Upload> map = fileUploadAwareJsonWriter.collectedUploads();
            if (string != null) {
                JsonWriter jsonWriter4 = jsonWriter;
                jsonWriter4.name("query");
                jsonWriter4.value(string);
            }
            if (bl) {
                JsonWriter jsonWriter5 = jsonWriter;
                jsonWriter5.name("extensions");
                jsonWriter5.beginObject();
                jsonWriter5.name("persistedQuery");
                jsonWriter5.beginObject();
                jsonWriter5.name("version").value(1);
                jsonWriter5.name("sha256Hash").value(operation.id());
                jsonWriter5.endObject();
                jsonWriter5.endObject();
            }
            jsonWriter.endObject();
            return map;
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters object, boolean bl, boolean bl2) {
            BufferedSinkJsonWriter bufferedSinkJsonWriter;
            Buffer buffer;
            LinkedHashMap linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap2();
            linkedHashMap.put("operationName", operation.name());
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            BufferedSinkJsonWriter bufferedSinkJsonWriter2 = bufferedSinkJsonWriter;
            bufferedSinkJsonWriter = new BufferedSinkJsonWriter(buffer2, null);
            FileUploadAwareJsonWriter fileUploadAwareJsonWriter = new FileUploadAwareJsonWriter(bufferedSinkJsonWriter2);
            fileUploadAwareJsonWriter.beginObject();
            operation.serializeVariables(fileUploadAwareJsonWriter, (CustomScalarAdapters)object);
            fileUploadAwareJsonWriter.endObject();
            if (fileUploadAwareJsonWriter.collectedUploads().isEmpty()) {
                linkedHashMap2.put("variables", buffer2.readUtf8());
                if (bl2) {
                    linkedHashMap2.put("query", operation.document());
                }
                if (bl) {
                    Buffer buffer3;
                    object = buffer3;
                    buffer3 = new Buffer();
                    BufferedSinkJsonWriter bufferedSinkJsonWriter3 = new BufferedSinkJsonWriter((BufferedSink)object, null);
                    bufferedSinkJsonWriter3.beginObject();
                    bufferedSinkJsonWriter3.name("persistedQuery");
                    bufferedSinkJsonWriter3.beginObject();
                    bufferedSinkJsonWriter3.name("version").value(1);
                    bufferedSinkJsonWriter3.name("sha256Hash").value(operation.id());
                    bufferedSinkJsonWriter3.endObject();
                    bufferedSinkJsonWriter3.endObject();
                    linkedHashMap2.put("extensions", buffer3.readUtf8());
                }
                return linkedHashMap2;
            }
            throw new IllegalStateException("FileUpload and Http GET are not supported at the same time".toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final String appendQueryParameters(String string, Map<String, String> object) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(string, "<this>");
            Intrinsics.checkNotNullParameter(object, "parameters");
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            stringBuilder.append(string);
            boolean bl = StringsKt__StringsKt.contains$default((CharSequence)string, "?");
            for (Map.Entry entry : object.entrySet()) {
                if (bl) {
                    stringBuilder2.append('&');
                } else {
                    bl = true;
                    stringBuilder2.append('?');
                }
                Object object2 = stringBuilder2;
                ((StringBuilder)object2).append(UrlEncodeKt.urlEncode$default((String)entry.getKey(), false, 1, null));
                ((StringBuilder)object2).append('=');
                stringBuilder2.append(UrlEncodeKt.urlEncode$default((String)entry.getValue(), false, 1, null));
            }
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public final <D extends Operation.Data> HttpBody buildPostBody(Operation<D> object, CustomScalarAdapters customScalarAdapters, boolean bl, String string) {
            BufferedSinkJsonWriter bufferedSinkJsonWriter;
            Buffer buffer;
            Intrinsics.checkNotNullParameter(object, "operation");
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            Object object2 = buffer;
            buffer = new Buffer();
            BufferedSinkJsonWriter bufferedSinkJsonWriter2 = bufferedSinkJsonWriter;
            bufferedSinkJsonWriter = new BufferedSinkJsonWriter((BufferedSink)object2, null);
            object2 = Companion.composePostParams(bufferedSinkJsonWriter2, object, customScalarAdapters, bl, string);
            object = buffer.readByteString(buffer.size);
            if (object2.isEmpty()) {
                return new HttpBody((ByteString)object){
                    private final String contentType;
                    private final long contentLength;
                    final /* synthetic */ ByteString $operationByteString;
                    {
                        this.$operationByteString = byteString;
                        this.contentType = "application/json";
                        this.contentLength = byteString.size();
                    }

                    public String getContentType() {
                        return this.contentType;
                    }

                    public long getContentLength() {
                        return this.contentLength;
                    }

                    public void writeTo(BufferedSink bufferedSink) {
                        Intrinsics.checkNotNullParameter(bufferedSink, "bufferedSink");
                        bufferedSink.write(this.$operationByteString);
                    }
                };
            }
            return new UploadsHttpBody((Map<String, ? extends Upload>)object2, (ByteString)object);
        }

        public final <D extends Operation.Data> ByteString buildParamsMap(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean bl, boolean bl2) {
            BufferedSinkJsonWriter bufferedSinkJsonWriter;
            Buffer buffer;
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            BufferedSinkJsonWriter bufferedSinkJsonWriter2 = bufferedSinkJsonWriter;
            bufferedSinkJsonWriter = new BufferedSinkJsonWriter(buffer2, null);
            String string = bl2 ? operation.document() : null;
            Object object = buffer2;
            Companion.composePostParams(bufferedSinkJsonWriter2, operation, customScalarAdapters, bl, string);
            return ((Buffer)object).readByteString(((Buffer)object).size);
        }

        public final <D extends Operation.Data> Map<String, Object> composePayload(ApolloRequest<D> object) {
            ApolloRequest<D> apolloRequest = object;
            Intrinsics.checkNotNullParameter(apolloRequest, "apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean bl2 = bl != null ? bl : false;
            Boolean bl3 = ((ApolloRequest)object).getSendDocument();
            boolean bl4 = bl3 != null ? bl3 : true;
            object = ((ApolloRequest)object).getExecutionContext().get(CustomScalarAdapters.Key);
            if (object != null) {
                MapJsonWriter mapJsonWriter;
                String string = bl4 ? operation.document() : null;
                MapJsonWriter mapJsonWriter2 = mapJsonWriter;
                mapJsonWriter = new MapJsonWriter();
                Companion.composePostParams(mapJsonWriter2, operation, (CustomScalarAdapters)object, bl2, string);
                Object object2 = mapJsonWriter.root();
                Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                return (Map)object2;
            }
            throw new IllegalStateException("Cannot find a ResponseAdapterCache".toString());
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            nArray[HttpMethod.Get.ordinal()] = 1;
            nArray[HttpMethod.Post.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

