/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XCldrStub {
    public static <T> String join(T[] source2, String separator) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < source2.length; ++i) {
            if (i != 0) {
                result2.append(separator);
            }
            result2.append(source2[i]);
        }
        return result2.toString();
    }

    public static <T> String join(Iterable<T> source2, String separator) {
        StringBuilder result2 = new StringBuilder();
        boolean first = true;
        for (T item : source2) {
            if (!first) {
                result2.append(separator);
            } else {
                first = false;
            }
            result2.append(item.toString());
        }
        return result2.toString();
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }

    public static class RegexUtilities {
        public static int findMismatch(Matcher m, CharSequence s) {
            boolean matches;
            int i;
            for (i = 1; i < s.length() && ((matches = m.reset(s.subSequence(0, i)).matches()) || m.hitEnd()); ++i) {
            }
            return i - 1;
        }

        public static String showMismatch(Matcher m, CharSequence s) {
            int failPoint = RegexUtilities.findMismatch(m, s);
            String show = s.subSequence(0, failPoint) + "\u2639" + s.subSequence(failPoint, s.length());
            return show;
        }
    }

    public static class FileUtilities {
        public static final Charset UTF8 = Charset.forName("utf-8");

        public static BufferedReader openFile(Class<?> class1, String file) {
            return FileUtilities.openFile(class1, file, UTF8);
        }

        public static BufferedReader openFile(Class<?> class1, String file, Charset charset) {
            try {
                InputStream resourceAsStream = class1.getResourceAsStream(file);
                if (charset == null) {
                    charset = UTF8;
                }
                InputStreamReader reader = new InputStreamReader(resourceAsStream, charset);
                BufferedReader bufferedReader = new BufferedReader(reader, 65536);
                return bufferedReader;
            }
            catch (Exception e) {
                String className = class1 == null ? null : class1.getCanonicalName();
                String canonicalName = null;
                try {
                    String relativeFileName = FileUtilities.getRelativeFileName(class1, "../util/");
                    canonicalName = new File(relativeFileName).getCanonicalPath();
                }
                catch (Exception e1) {
                    throw new ICUUncheckedIOException("Couldn't open file: " + file + "; relative to class: " + className, e);
                }
                throw new ICUUncheckedIOException("Couldn't open file " + file + "; in path " + canonicalName + "; relative to class: " + className, e);
            }
        }

        public static String getRelativeFileName(Class<?> class1, String filename) {
            URL resource = class1 == null ? FileUtilities.class.getResource(filename) : class1.getResource(filename);
            String resourceString = resource.toString();
            if (resourceString.startsWith("file:")) {
                return resourceString.substring(5);
            }
            if (resourceString.startsWith("jar:file:")) {
                return resourceString.substring(9);
            }
            throw new ICUUncheckedIOException("File not found: " + resourceString);
        }
    }

    public static class ImmutableMultimap {
        public static <K, V> Multimap<K, V> copyOf(Multimap<K, V> values2) {
            LinkedHashMap<K, Set<V>> temp = new LinkedHashMap<K, Set<V>>();
            for (Map.Entry<K, Set<V>> entry : values2.asMap().entrySet()) {
                Set<V> value = entry.getValue();
                temp.put(entry.getKey(), value.size() == 1 ? Collections.singleton(value.iterator().next()) : Collections.unmodifiableSet(new LinkedHashSet<V>(value)));
            }
            return new Multimap(Collections.unmodifiableMap(temp), null);
        }
    }

    public static class ImmutableMap {
        public static <K, V> Map<K, V> copyOf(Map<K, V> values2) {
            return Collections.unmodifiableMap(new LinkedHashMap<K, V>(values2));
        }
    }

    public static class ImmutableSet {
        public static <T> Set<T> copyOf(Set<T> values2) {
            return Collections.unmodifiableSet(new LinkedHashSet<T>(values2));
        }
    }

    public static class Splitter {
        Pattern pattern;
        boolean trimResults = false;

        public Splitter(char c) {
            this(Pattern.compile("\\Q" + c + "\\E"));
        }

        public Splitter(Pattern p) {
            this.pattern = p;
        }

        public static Splitter on(char c) {
            return new Splitter(c);
        }

        public static Splitter on(Pattern p) {
            return new Splitter(p);
        }

        public List<String> splitToList(String input) {
            String[] items = this.pattern.split(input);
            if (this.trimResults) {
                for (int i = 0; i < items.length; ++i) {
                    items[i] = items[i].trim();
                }
            }
            return Arrays.asList(items);
        }

        public Splitter trimResults() {
            this.trimResults = true;
            return this;
        }

        public Iterable<String> split(String input) {
            return this.splitToList(input);
        }
    }

    public static class Joiner {
        private final String separator;

        private Joiner(String separator) {
            this.separator = separator;
        }

        public static final Joiner on(String separator) {
            return new Joiner(separator);
        }

        public <T> String join(T[] source2) {
            return XCldrStub.join(source2, this.separator);
        }

        public <T> String join(Iterable<T> source2) {
            return XCldrStub.join(source2, this.separator);
        }
    }

    public static class CollectionUtilities {
        public static <T, U extends Iterable<T>> String join(U source2, String separator) {
            return XCldrStub.join(source2, separator);
        }
    }

    public static class LinkedHashMultimap<K, V>
    extends Multimap<K, V> {
        private LinkedHashMultimap() {
            super(new LinkedHashMap(), LinkedHashSet.class);
        }

        public static <K, V> LinkedHashMultimap<K, V> create() {
            return new LinkedHashMultimap<K, V>();
        }
    }

    public static class TreeMultimap<K, V>
    extends Multimap<K, V> {
        private TreeMultimap() {
            super(new TreeMap(), TreeSet.class);
        }

        public static <K, V> TreeMultimap<K, V> create() {
            return new TreeMultimap<K, V>();
        }
    }

    public static class HashMultimap<K, V>
    extends Multimap<K, V> {
        private HashMultimap() {
            super(new HashMap(), HashSet.class);
        }

        public static <K, V> HashMultimap<K, V> create() {
            return new HashMultimap<K, V>();
        }
    }

    private static class ReusableEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        private ReusableEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MultimapIterator<K, V>
    implements Iterator<Map.Entry<K, V>>,
    Iterable<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Set<V>>> it1;
        private Iterator<V> it2 = null;
        private final ReusableEntry<K, V> entry = new ReusableEntry();

        private MultimapIterator(Map<K, Set<V>> map2) {
            this.it1 = map2.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it1.hasNext() || this.it2 != null && this.it2.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.it2 != null && this.it2.hasNext()) {
                this.entry.value = this.it2.next();
            } else {
                Map.Entry<K, Set<V>> e = this.it1.next();
                this.entry.key = e.getKey();
                this.it2 = e.getValue().iterator();
            }
            return this.entry;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Multimaps {
        public static <K, V, R extends Multimap<K, V>> R invertFrom(Multimap<V, K> source2, R target) {
            for (Map.Entry<V, Set<K>> entry : source2.asMap().entrySet()) {
                target.putAll((Collection)entry.getValue(), entry.getKey());
            }
            return target;
        }

        public static <K, V, R extends Multimap<K, V>> R invertFrom(Map<V, K> source2, R target) {
            for (Map.Entry<V, K> entry : source2.entrySet()) {
                target.put(entry.getValue(), entry.getKey());
            }
            return target;
        }

        public static <K, V> Map<K, V> forMap(Map<K, V> map2) {
            return map2;
        }
    }

    public static class Multimap<K, V> {
        private final Map<K, Set<V>> map;
        private final Class<Set<V>> setClass;

        private Multimap(Map<K, Set<V>> map2, Class<?> setClass) {
            this.map = map2;
            this.setClass = setClass != null ? setClass : HashSet.class;
        }

        public Multimap<K, V> putAll(K key, V ... values2) {
            if (values2.length != 0) {
                this.createSetIfMissing(key).addAll(Arrays.asList(values2));
            }
            return this;
        }

        public void putAll(K key, Collection<V> values2) {
            if (!values2.isEmpty()) {
                this.createSetIfMissing(key).addAll(values2);
            }
        }

        public void putAll(Collection<K> keys2, V value) {
            for (K key : keys2) {
                this.put(key, value);
            }
        }

        public void putAll(Multimap<K, V> source2) {
            for (Map.Entry<K, Set<V>> entry : source2.map.entrySet()) {
                this.putAll(entry.getKey(), (Collection)entry.getValue());
            }
        }

        public void put(K key, V value) {
            this.createSetIfMissing(key).add(value);
        }

        private Set<V> createSetIfMissing(K key) {
            Set<V> old = this.map.get(key);
            if (old == null) {
                old = this.getInstance();
                this.map.put(key, old);
            }
            return old;
        }

        private Set<V> getInstance() {
            try {
                return this.setClass.newInstance();
            }
            catch (Exception e) {
                throw new ICUException(e);
            }
        }

        public Set<V> get(K key) {
            Set<V> result2 = this.map.get(key);
            return result2;
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Map<K, Set<V>> asMap() {
            return this.map;
        }

        public Set<V> values() {
            Collection<Set<V>> values2 = this.map.values();
            if (values2.size() == 0) {
                return Collections.emptySet();
            }
            Set<V> result2 = this.getInstance();
            for (Set<V> valueSet : values2) {
                result2.addAll(valueSet);
            }
            return result2;
        }

        public int size() {
            return this.map.size();
        }

        public Iterable<Map.Entry<K, V>> entries() {
            return new MultimapIterator(this.map);
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.map.equals(((Multimap)obj).map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

