/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.frontend;

import com.apollographql.apollo3.compiler.frontend.GQLArgument;
import com.apollographql.apollo3.compiler.frontend.GQLArguments;
import com.apollographql.apollo3.compiler.frontend.GQLBooleanValue;
import com.apollographql.apollo3.compiler.frontend.GQLDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLDirective;
import com.apollographql.apollo3.compiler.frontend.GQLDirectiveDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLDocument;
import com.apollographql.apollo3.compiler.frontend.GQLEnumTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLEnumValue;
import com.apollographql.apollo3.compiler.frontend.GQLField;
import com.apollographql.apollo3.compiler.frontend.GQLFieldDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLFloatValue;
import com.apollographql.apollo3.compiler.frontend.GQLFragmentDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLFragmentSpread;
import com.apollographql.apollo3.compiler.frontend.GQLInlineFragment;
import com.apollographql.apollo3.compiler.frontend.GQLInputValueDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLIntValue;
import com.apollographql.apollo3.compiler.frontend.GQLListType;
import com.apollographql.apollo3.compiler.frontend.GQLListValue;
import com.apollographql.apollo3.compiler.frontend.GQLNamedType;
import com.apollographql.apollo3.compiler.frontend.GQLNonNullType;
import com.apollographql.apollo3.compiler.frontend.GQLNullValue;
import com.apollographql.apollo3.compiler.frontend.GQLObjectField;
import com.apollographql.apollo3.compiler.frontend.GQLObjectTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLObjectValue;
import com.apollographql.apollo3.compiler.frontend.GQLOperationDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLScalarTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLSelection;
import com.apollographql.apollo3.compiler.frontend.GQLSelectionSet;
import com.apollographql.apollo3.compiler.frontend.GQLStringValue;
import com.apollographql.apollo3.compiler.frontend.GQLType;
import com.apollographql.apollo3.compiler.frontend.GQLTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLValue;
import com.apollographql.apollo3.compiler.frontend.GQLVariableDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLVariableValue;
import com.apollographql.apollo3.compiler.frontend.GqlfieldKt;
import com.apollographql.apollo3.compiler.frontend.GqloperationdefinitionKt;
import com.apollographql.apollo3.compiler.frontend.GqltypeKt;
import com.apollographql.apollo3.compiler.frontend.GqltypedefinitionKt;
import com.apollographql.apollo3.compiler.frontend.InputValueScope;
import com.apollographql.apollo3.compiler.frontend.Issue;
import com.apollographql.apollo3.compiler.frontend.Operation_validationKt;
import com.apollographql.apollo3.compiler.frontend.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001OB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J$\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0016\u0010,\u001a\u00020\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u001dH\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u00100\u001a\u00020\u0007J\u0018\u00101\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u00103\u001a\u000204J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u00100\u001a\u00020\u0007J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u00107\u001a\u000208J\"\u00109\u001a\u00020\u00152\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020*0\u001d*\u00020>H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020*0\u001d*\u00020?H\u0002J\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020*0\u001d*\u00020@2\u0006\u0010A\u001a\u00020\u0006H\u0002J*\u0010B\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HD\u0012\u0004\u0012\u0002HD0C0\u001d\"\u0004\b\u0000\u0010D*\b\u0012\u0004\u0012\u0002HD0\u001dH\u0002J\"\u0010E\u001a\u00020\u0015*\u00020\u001e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001d2\u0006\u0010H\u001a\u00020\u0006H\u0002J\"\u0010E\u001a\u00020\u0015*\u00020I2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001d2\u0006\u0010H\u001a\u00020\u0006H\u0002J\f\u0010E\u001a\u00020\u0015*\u00020JH\u0002J\u0014\u0010E\u001a\u00020\u0015*\u00020\u00172\u0006\u0010K\u001a\u00020\u0011H\u0002J\f\u0010E\u001a\u00020\u0015*\u00020\u0007H\u0002J\u0014\u0010E\u001a\u00020\u0015*\u00020>2\u0006\u0010K\u001a\u00020\u0011H\u0002J\u0014\u0010E\u001a\u00020\u0015*\u00020?2\u0006\u0010K\u001a\u00020\u0011H\u0002J\f\u0010E\u001a\u00020\u0015*\u000208H\u0002J\u0014\u0010E\u001a\u00020\u0015*\u00020@2\u0006\u0010K\u001a\u00020\u0011H\u0002J\f\u0010L\u001a\u00020\u0015*\u000204H\u0002J\f\u0010M\u001a\u00020\u0015*\u000204H\u0002J\f\u0010N\u001a\u00020\u0015*\u000204H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/ExecutableDocumentValidator;", "", "schema", "Lcom/apollographql/apollo3/compiler/frontend/Schema;", "fragmentDefinitions", "", "", "Lcom/apollographql/apollo3/compiler/frontend/GQLFragmentDefinition;", "(Lcom/apollographql/apollo3/compiler/frontend/Schema;Ljava/util/Map;)V", "getFragmentDefinitions", "()Ljava/util/Map;", "issues", "", "Lcom/apollographql/apollo3/compiler/frontend/Issue;", "getSchema", "()Lcom/apollographql/apollo3/compiler/frontend/Schema;", "typeDefinitions", "Lcom/apollographql/apollo3/compiler/frontend/GQLTypeDefinition;", "variableReferences", "Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$VariableReference;", "addFieldMergingIssue", "", "fieldA", "Lcom/apollographql/apollo3/compiler/frontend/GQLField;", "fieldB", "message", "areArgumentsEqual", "", "argumentsA", "", "Lcom/apollographql/apollo3/compiler/frontend/GQLArgument;", "argumentsB", "areTypesEqual", "typeA", "Lcom/apollographql/apollo3/compiler/frontend/GQLType;", "typeB", "areValuesEqual", "valueA", "Lcom/apollographql/apollo3/compiler/frontend/GQLValue;", "valueB", "fieldPairCanMerge", "fieldWithParentA", "Lcom/apollographql/apollo3/compiler/frontend/ExecutableDocumentValidator$FieldWithParent;", "fieldWithParentB", "fieldsInSetCanMerge", "fieldsWithParent", "haveSameResponseShape", "inferFragmentVariables", "fragment", "sameResponseShapeRecursive", "validateDocument", "document", "Lcom/apollographql/apollo3/compiler/frontend/GQLDocument;", "validateFragment", "validateOperation", "operation", "Lcom/apollographql/apollo3/compiler/frontend/GQLOperationDefinition;", "validateVariable", "value", "Lcom/apollographql/apollo3/compiler/frontend/GQLVariableValue;", "expectedType", "collectFields", "Lcom/apollographql/apollo3/compiler/frontend/GQLFragmentSpread;", "Lcom/apollographql/apollo3/compiler/frontend/GQLInlineFragment;", "Lcom/apollographql/apollo3/compiler/frontend/GQLSelectionSet;", "parentType", "pairs", "Lkotlin/Pair;", "T", "validate", "inputValueDefinitions", "Lcom/apollographql/apollo3/compiler/frontend/GQLInputValueDefinition;", "debug", "Lcom/apollographql/apollo3/compiler/frontend/GQLArguments;", "Lcom/apollographql/apollo3/compiler/frontend/GQLDirective;", "typeDefinitionInScope", "validateExecutable", "validateFragments", "validateOperations", "FieldWithParent", "apollo-compiler"})
final class ExecutableDocumentValidator {
    private final Map<String, GQLTypeDefinition> typeDefinitions;
    private final List<Issue> issues;
    private final List<InputValueScope.VariableReference> variableReferences;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, GQLFragmentDefinition> fragmentDefinitions;

    @NotNull
    public final List<Issue> validateDocument(@NotNull GQLDocument document) {
        Intrinsics.checkParameterIsNotNull(document, "document");
        this.validateExecutable(document);
        this.validateFragments(document);
        this.validateOperations(document);
        return this.issues;
    }

    @NotNull
    public final List<Issue> validateOperation(@NotNull GQLOperationDefinition operation) {
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        this.validate(operation);
        return this.issues;
    }

    @NotNull
    public final List<Issue> validateFragment(@NotNull GQLFragmentDefinition fragment) {
        Intrinsics.checkParameterIsNotNull(fragment, "fragment");
        this.validate(fragment);
        return this.issues;
    }

    @NotNull
    public final List<InputValueScope.VariableReference> inferFragmentVariables(@NotNull GQLFragmentDefinition fragment) {
        Intrinsics.checkParameterIsNotNull(fragment, "fragment");
        this.variableReferences.clear();
        this.validate(fragment);
        return this.variableReferences;
    }

    private final void validate(GQLField $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLFieldDefinition fieldDefinition = GqlfieldKt.definitionFromScope($this$validate, this.schema, typeDefinitionInScope);
        if (fieldDefinition == null) {
            this.issues.add(new Issue.ValidationError("Can't query `" + $this$validate.getName() + "` on type `" + typeDefinitionInScope.getName() + '`', $this$validate.getSourceLocation()));
            return;
        }
        if (Operation_validationKt.isDeprecated(fieldDefinition)) {
            this.issues.add(new Issue.DeprecatedUsage("Use of deprecated field `" + $this$validate.getName() + '`', $this$validate.getSourceLocation()));
        }
        GQLArguments gQLArguments = $this$validate.getArguments();
        if (gQLArguments != null) {
            this.validate(gQLArguments, fieldDefinition.getArguments(), "field `" + fieldDefinition.getName() + '`');
        }
        GQLTypeDefinition leafTypeDefinition = this.typeDefinitions.get(GqltypeKt.leafType(fieldDefinition.getType()).getName());
        if (leafTypeDefinition == null) {
            this.issues.add(new Issue.ValidationError("Unknown type `" + GqltypeKt.leafType(fieldDefinition.getType()).getName() + '`', $this$validate.getSourceLocation()));
            return;
        }
        if (!(leafTypeDefinition instanceof GQLScalarTypeDefinition) && !(leafTypeDefinition instanceof GQLEnumTypeDefinition)) {
            if ($this$validate.getSelectionSet() == null) {
                this.issues.add(new Issue.ValidationError("Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must have a selection of sub-fields", $this$validate.getSourceLocation()));
                return;
            }
            this.validate($this$validate.getSelectionSet(), leafTypeDefinition);
        } else if ($this$validate.getSelectionSet() != null) {
            this.issues.add(new Issue.ValidationError("Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must not have a selection of sub-fields", $this$validate.getSourceLocation()));
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            this.validate(it);
        }
    }

    private final void validate(GQLDirective $this$validate) {
        block1: {
            GQLDirectiveDefinition directiveDefinition = this.schema.getDirectiveDefinitions().get($this$validate.getName());
            if (directiveDefinition == null) {
                this.issues.add(new Issue.UnknownDirective("Unknown directive '" + $this$validate.getName() + '\'', $this$validate.getSourceLocation()));
                return;
            }
            GQLArguments gQLArguments = $this$validate.getArguments();
            if (gQLArguments == null) break block1;
            this.validate(gQLArguments, directiveDefinition.getArguments(), "directive '" + directiveDefinition.getName() + '\'');
        }
    }

    private final void validate(GQLInlineFragment $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLTypeDefinition inlineFragmentTypeDefinition = this.typeDefinitions.get($this$validate.getTypeCondition().getName());
        if (inlineFragmentTypeDefinition == null) {
            this.issues.add(new Issue.ValidationError("Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for inline fragment", $this$validate.getTypeCondition().getSourceLocation()));
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(inlineFragmentTypeDefinition, typeDefinitionInScope, this.typeDefinitions)) {
            this.issues.add(new Issue.ValidationError("Inline fragment cannot be spread here as result can never be of type `" + $this$validate.getTypeCondition().getName() + '`', $this$validate.getTypeCondition().getSourceLocation()));
            return;
        }
        this.validate($this$validate.getSelectionSet(), inlineFragmentTypeDefinition);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            this.validate(it);
        }
    }

    private final void validate(GQLFragmentSpread $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$validate.getName());
        if (fragmentDefinition == null) {
            this.issues.add(new Issue.ValidationError("Cannot find fragment `" + $this$validate.getName() + '`', $this$validate.getSourceLocation()));
            return;
        }
        GQLTypeDefinition fragmentTypeDefinition = this.typeDefinitions.get(fragmentDefinition.getTypeCondition().getName());
        if (fragmentTypeDefinition == null) {
            this.issues.add(new Issue.ValidationError("Cannot find type `" + fragmentDefinition.getTypeCondition().getName() + "` for fragment " + $this$validate.getName(), fragmentDefinition.getTypeCondition().getSourceLocation()));
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(fragmentTypeDefinition, typeDefinitionInScope, this.typeDefinitions)) {
            this.issues.add(new Issue.ValidationError("Fragment `" + $this$validate.getName() + "` cannot be spread here as result can never be of type `" + typeDefinitionInScope.getName() + '`', $this$validate.getSourceLocation()));
            return;
        }
        this.validate(fragmentDefinition.getSelectionSet(), fragmentTypeDefinition);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            this.validate(it);
        }
    }

    private final void validateExecutable(GQLDocument $this$validateExecutable) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$validateExecutable.getDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLDefinition it = (GQLDefinition)element$iv;
                boolean bl = false;
                if (!(!(it instanceof GQLOperationDefinition) && !(it instanceof GQLFragmentDefinition))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GQLDefinition gQLDefinition = v0;
        if (gQLDefinition != null) {
            GQLDefinition gQLDefinition2 = gQLDefinition;
            boolean bl = false;
            boolean bl2 = false;
            GQLDefinition it = gQLDefinition2;
            boolean bl3 = false;
            this.issues.add(new Issue.ValidationError("Found an non-executable definition.", it.getSourceLocation()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateOperations(GQLDocument $this$validateOperations) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateOperations.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLOperationDefinition it = (GQLOperationDefinition)element$iv;
            boolean bl = false;
            this.validate(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFragments(GQLDocument $this$validateFragments) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateFragments.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)element$iv;
            boolean bl = false;
            this.validate(it);
        }
    }

    private final void validate(GQLFragmentDefinition $this$validate) {
        GQLTypeDefinition fragmentRootTypeDefinition = this.typeDefinitions.get($this$validate.getTypeCondition().getName());
        if (fragmentRootTypeDefinition == null) {
            this.issues.add(new Issue.ValidationError("Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for fragment `" + $this$validate.getName() + '`', $this$validate.getTypeCondition().getSourceLocation()));
            return;
        }
        this.validate($this$validate.getSelectionSet(), fragmentRootTypeDefinition);
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), fragmentRootTypeDefinition.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(GQLOperationDefinition $this$validate) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        this.variableReferences.clear();
        GQLTypeDefinition rootTypeDefinition = GqloperationdefinitionKt.rootTypeDefinition($this$validate, this.schema);
        if (rootTypeDefinition == null) {
            this.issues.add(new Issue.ValidationError("Cannot find a root type for operation type `" + $this$validate.getOperationType() + '`', $this$validate.getSourceLocation()));
            return;
        }
        this.validate($this$validate.getSelectionSet(), rootTypeDefinition);
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), rootTypeDefinition.getName()));
        Iterable $this$forEach$iv = this.variableReferences;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            InputValueScope.VariableReference it = (InputValueScope.VariableReference)element$iv2;
            boolean bl = false;
            this.validateVariable($this$validate, it.getVariable(), it.getExpectedType());
        }
        Iterable $this$map$iv = this.variableReferences;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InputValueScope.VariableReference variableReference = (InputValueScope.VariableReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getVariable().getName();
            collection.add(string);
        }
        Set foundVariables = CollectionsKt.toSet((List)destination$iv$iv);
        Iterable $this$forEach$iv2 = $this$validate.getVariableDefinitions();
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            GQLVariableDefinition it = (GQLVariableDefinition)element$iv3;
            boolean bl = false;
            if (foundVariables.contains(it.getName())) continue;
            this.issues.add(new Issue.UnusedVariable("Variable `" + it.getName() + "` is unused", it.getSourceLocation()));
        }
    }

    private final void validate(GQLSelectionSet $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        if ($this$validate.getSelections().isEmpty()) {
            this.issues.add(new Issue.ValidationError("Selection of type `" + typeDefinitionInScope.getName() + "` must have a selection of sub-fields", $this$validate.getSourceLocation()));
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getSelections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                this.validate((GQLField)it, typeDefinitionInScope);
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                this.validate((GQLInlineFragment)it, typeDefinitionInScope);
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread)) continue;
            this.validate((GQLFragmentSpread)it, typeDefinitionInScope);
        }
    }

    private final void fieldPairCanMerge(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        List<FieldWithParent> list;
        List<FieldWithParent> setA;
        List<GQLArgument> list2;
        GQLType typeB;
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        if (Intrinsics.areEqual(parentTypeDefinitionA.getName(), parentTypeDefinitionB.getName()) ^ true && parentTypeDefinitionA instanceof GQLObjectTypeDefinition && parentTypeDefinitionB instanceof GQLObjectTypeDefinition) {
            this.sameResponseShapeRecursive(fieldWithParentA, fieldWithParentB);
            return;
        }
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLFieldDefinition gQLFieldDefinition = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLType typeA = gQLFieldDefinition != null ? gQLFieldDefinition.getType() : null;
        GQLFieldDefinition gQLFieldDefinition2 = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        GQLType gQLType = typeB = gQLFieldDefinition2 != null ? gQLFieldDefinition2.getType() : null;
        if (typeA == null || typeB == null) {
            return;
        }
        if (!this.areTypesEqual(typeA, typeB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different types");
            return;
        }
        Object object = fieldA.getArguments();
        if (object == null || (object = ((GQLArguments)object).getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((list2 = fieldB.getArguments()) == null || (list2 = ((GQLArguments)((Object)list2)).getArguments()) == null) {
            list2 = CollectionsKt.emptyList();
        }
        if (!this.areArgumentsEqual((List<GQLArgument>)object, list2)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different arguments");
            return;
        }
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return;
        }
        Object object2 = fieldA.getSelectionSet();
        if (object2 == null || (object2 = this.collectFields((GQLSelectionSet)object2, parentTypeDefinitionA.getName())) == null) {
            object2 = setA = CollectionsKt.emptyList();
        }
        if ((list = fieldB.getSelectionSet()) == null || (list = this.collectFields((GQLSelectionSet)((Object)list), parentTypeDefinitionB.getName())) == null) {
            list = CollectionsKt.emptyList();
        }
        List<FieldWithParent> setB = list;
        this.fieldsInSetCanMerge(CollectionsKt.plus((Collection)setA, (Iterable)setB));
    }

    /*
     * WARNING - void declaration
     */
    private final void fieldsInSetCanMerge(List<FieldWithParent> fieldsWithParent) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = fieldsWithParent;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List fieldsForName = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.pairs(fieldsForName);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair it = (Pair)element$iv2;
                boolean bl3 = false;
                this.fieldPairCanMerge((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond());
            }
        }
    }

    private final boolean areTypesEqual(GQLType typeA, GQLType typeB) {
        boolean bl;
        GQLType gQLType = typeA;
        if (gQLType instanceof GQLNonNullType) {
            bl = typeB instanceof GQLNonNullType && this.areTypesEqual(((GQLNonNullType)typeA).getType(), ((GQLNonNullType)typeB).getType());
        } else if (gQLType instanceof GQLListType) {
            bl = typeB instanceof GQLListType && this.areTypesEqual(((GQLListType)typeA).getType(), ((GQLListType)typeB).getType());
        } else if (gQLType instanceof GQLNamedType) {
            bl = typeB instanceof GQLNamedType && Intrinsics.areEqual(((GQLNamedType)typeA).getName(), ((GQLNamedType)typeB).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areArgumentsEqual(List<GQLArgument> argumentsA, List<GQLArgument> argumentsB) {
        void $this$groupByTo$iv$iv;
        if (argumentsA.size() != argumentsB.size()) {
            return false;
        }
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)argumentsA, (Iterable)argumentsB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GQLArgument it = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            if (it.size() != 2) {
                return false;
            }
            if (this.areValuesEqual(((GQLArgument)it.get(0)).getValue(), ((GQLArgument)it.get(1)).getValue())) continue;
            return false;
        }
        return true;
    }

    private final void addFieldMergingIssue(GQLField fieldA, GQLField fieldB, String message) {
        this.issues.add(new Issue.ValidationError('`' + GqlfieldKt.responseName(fieldA) + "` cannot be merged with `" + GqlfieldKt.responseName(fieldB) + "`: " + message, fieldA.getSourceLocation()));
        this.issues.add(new Issue.ValidationError('`' + GqlfieldKt.responseName(fieldB) + "` cannot be merged with `" + GqlfieldKt.responseName(fieldA) + "`: " + message, fieldB.getSourceLocation()));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areValuesEqual(GQLValue valueA, GQLValue valueB) {
        boolean bl;
        GQLValue gQLValue = valueA;
        if (gQLValue instanceof GQLIntValue) {
            GQLValue gQLValue2 = valueB;
            if (!(gQLValue2 instanceof GQLIntValue)) {
                gQLValue2 = null;
            }
            GQLIntValue gQLIntValue = (GQLIntValue)gQLValue2;
            bl = gQLIntValue != null && gQLIntValue.getValue() == ((GQLIntValue)valueA).getValue();
        } else if (gQLValue instanceof GQLFloatValue) {
            GQLValue gQLValue3 = valueB;
            if (!(gQLValue3 instanceof GQLFloatValue)) {
                gQLValue3 = null;
            }
            GQLFloatValue gQLFloatValue = (GQLFloatValue)gQLValue3;
            bl = gQLFloatValue != null && gQLFloatValue.getValue() == ((GQLFloatValue)valueA).getValue();
        } else if (gQLValue instanceof GQLStringValue) {
            GQLValue gQLValue4 = valueB;
            if (!(gQLValue4 instanceof GQLStringValue)) {
                gQLValue4 = null;
            }
            GQLStringValue gQLStringValue = (GQLStringValue)gQLValue4;
            bl = Intrinsics.areEqual(gQLStringValue != null ? gQLStringValue.getValue() : null, ((GQLStringValue)valueA).getValue());
        } else if (gQLValue instanceof GQLBooleanValue) {
            GQLValue gQLValue5 = valueB;
            if (!(gQLValue5 instanceof GQLBooleanValue)) {
                gQLValue5 = null;
            }
            GQLBooleanValue gQLBooleanValue = (GQLBooleanValue)gQLValue5;
            bl = gQLBooleanValue != null && gQLBooleanValue.getValue() == ((GQLBooleanValue)valueA).getValue();
        } else if (gQLValue instanceof GQLEnumValue) {
            GQLValue gQLValue6 = valueB;
            if (!(gQLValue6 instanceof GQLEnumValue)) {
                gQLValue6 = null;
            }
            GQLEnumValue gQLEnumValue = (GQLEnumValue)gQLValue6;
            bl = Intrinsics.areEqual(gQLEnumValue != null ? gQLEnumValue.getValue() : null, ((GQLEnumValue)valueA).getValue());
        } else if (gQLValue instanceof GQLNullValue) {
            bl = valueB instanceof GQLNullValue;
        } else if (gQLValue instanceof GQLListValue) {
            if (!(valueB instanceof GQLListValue)) {
                return false;
            }
            int n = 0;
            int n2 = ((GQLListValue)valueA).getValues().size();
            while (n < n2) {
                void i;
                if (!this.areValuesEqual(((GQLListValue)valueA).getValues().get((int)i), ((GQLListValue)valueB).getValues().get((int)i))) {
                    return false;
                }
                ++i;
            }
            bl = true;
        } else if (gQLValue instanceof GQLObjectValue) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            if (!(valueB instanceof GQLObjectValue)) {
                return false;
            }
            Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)((GQLObjectValue)valueA).getFields(), (Iterable)((GQLObjectValue)valueB).getFields());
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                GQLObjectField it = (GQLObjectField)element$iv$iv;
                boolean bl2 = false;
                String key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl4 = false;
                if (it.size() != 2) {
                    return false;
                }
                if (this.areValuesEqual(((GQLObjectField)it.get(0)).getValue(), ((GQLObjectField)it.get(1)).getValue())) continue;
                return false;
            }
            bl = true;
        } else if (gQLValue instanceof GQLVariableValue) {
            GQLValue gQLValue7 = valueB;
            if (!(gQLValue7 instanceof GQLVariableValue)) {
                gQLValue7 = null;
            }
            GQLVariableValue gQLVariableValue = (GQLVariableValue)gQLValue7;
            bl = Intrinsics.areEqual(gQLVariableValue != null ? gQLVariableValue.getName() : null, ((GQLVariableValue)valueA).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean sameResponseShapeRecursive(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        List<FieldWithParent> list;
        List<FieldWithParent> setA;
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return false;
        }
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        Object object = fieldWithParentA.getField().getSelectionSet();
        if (object == null || (object = this.collectFields((GQLSelectionSet)object, parentTypeDefinitionA.getName())) == null) {
            object = setA = CollectionsKt.emptyList();
        }
        if ((list = fieldWithParentA.getField().getSelectionSet()) == null || (list = this.collectFields((GQLSelectionSet)((Object)list), parentTypeDefinitionB.getName())) == null) {
            list = CollectionsKt.emptyList();
        }
        List<FieldWithParent> setB = list;
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)setA, (Iterable)setB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v3;
            block8: {
                List fieldsForName = (List)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.pairs(fieldsForName);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv2;
                    boolean bl3 = false;
                    if (!this.sameResponseShapeRecursive((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond())) continue;
                    v3 = element$iv2;
                    break block8;
                }
                v3 = null;
            }
            if (v3 == null) continue;
            return false;
        }
        return true;
    }

    private final boolean haveSameResponseShape(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        GQLFieldDefinition fieldDefinitionA = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLFieldDefinition fieldDefinitionB = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        if (fieldDefinitionA == null || fieldDefinitionB == null) {
            return true;
        }
        GQLType typeA = fieldDefinitionA.getType();
        GQLType typeB = fieldDefinitionB.getType();
        while (true) {
            if (!(typeA instanceof GQLNonNullType || typeA instanceof GQLListType || typeB instanceof GQLNonNullType)) {
                if (!(typeB instanceof GQLListType)) break;
            }
            if (typeA instanceof GQLNonNullType && !(typeB instanceof GQLNonNullType)) {
                return false;
            }
            if (!(typeA instanceof GQLNonNullType) && typeB instanceof GQLNonNullType) {
                return false;
            }
            if (typeA instanceof GQLNonNullType && typeB instanceof GQLNonNullType) {
                typeA = ((GQLNonNullType)typeA).getType();
                typeB = ((GQLNonNullType)typeB).getType();
            }
            if (typeA instanceof GQLListType && !(typeB instanceof GQLListType)) {
                return false;
            }
            if (!(typeA instanceof GQLListType) && typeB instanceof GQLListType) {
                return false;
            }
            if (!(typeA instanceof GQLListType) || !(typeB instanceof GQLListType)) continue;
            typeA = ((GQLListType)typeA).getType();
            typeB = ((GQLListType)typeB).getType();
        }
        boolean bl = typeA instanceof GQLNamedType && typeB instanceof GQLNamedType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = GqltypeKt.pretty(typeA) + " and " + GqltypeKt.pretty(typeB) + " should be GQLNamedType";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        GQLTypeDefinition typeDefinitionA = this.typeDefinitions.get(((GQLNamedType)typeA).getName());
        GQLTypeDefinition typeDefinitionB = this.typeDefinitions.get(((GQLNamedType)typeB).getName());
        if (typeDefinitionA == null || typeDefinitionB == null) {
            return true;
        }
        if (typeDefinitionA instanceof GQLScalarTypeDefinition || typeDefinitionA instanceof GQLEnumTypeDefinition || typeDefinitionB instanceof GQLScalarTypeDefinition || typeDefinitionB instanceof GQLEnumTypeDefinition) {
            return Intrinsics.areEqual(typeDefinitionA.getName(), typeDefinitionB.getName());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<Pair<T, T>> pairs(List<? extends T> $this$pairs) {
        int n = 0;
        List pairs = new ArrayList();
        n = 0;
        int n2 = $this$pairs.size();
        while (n < n2) {
            void i;
            void var5_5 = i + true;
            int n3 = $this$pairs.size();
            while (var5_5 < n3) {
                void j;
                pairs.add(TuplesKt.to($this$pairs.get((int)i), $this$pairs.get((int)j)));
                ++j;
            }
            ++i;
        }
        return pairs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldWithParent> collectFields(GQLSelectionSet $this$collectFields, String parentType) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectFields.getSelections();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            GQLSelection selection = (GQLSelection)element$iv$iv;
            boolean bl = false;
            GQLSelection gQLSelection = selection;
            if (gQLSelection instanceof GQLField) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = CollectionsKt.listOf(this.typeDefinitions.get(parentType));
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FieldWithParent fieldWithParent;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    GQLTypeDefinition typeDefinition = (GQLTypeDefinition)element$iv$iv2;
                    boolean bl3 = false;
                    if (typeDefinition != null) {
                        GQLTypeDefinition gQLTypeDefinition;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        GQLTypeDefinition it = gQLTypeDefinition;
                        boolean bl6 = false;
                        fieldWithParent = new FieldWithParent((GQLField)selection, it);
                    } else {
                        fieldWithParent = null;
                    }
                    if (fieldWithParent == null) continue;
                    FieldWithParent fieldWithParent2 = fieldWithParent;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FieldWithParent it$iv$iv = fieldWithParent2;
                    boolean bl9 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else if (gQLSelection instanceof GQLInlineFragment) {
                list = this.collectFields((GQLInlineFragment)selection);
            } else if (gQLSelection instanceof GQLFragmentSpread) {
                list = this.collectFields((GQLFragmentSpread)selection);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FieldWithParent> collectFields(GQLInlineFragment $this$collectFields) {
        return this.collectFields($this$collectFields.getSelectionSet(), $this$collectFields.getTypeCondition().getName());
    }

    private final List<FieldWithParent> collectFields(GQLFragmentSpread $this$collectFields) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$collectFields.getName());
        if (fragmentDefinition == null) {
            return CollectionsKt.emptyList();
        }
        return this.collectFields(fragmentDefinition.getSelectionSet(), fragmentDefinition.getTypeCondition().getName());
    }

    private final void validate(GQLArgument $this$validate, List<GQLInputValueDefinition> inputValueDefinitions, String debug) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = inputValueDefinitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), $this$validate.getName())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GQLInputValueDefinition schemaArgument = v0;
        if (schemaArgument == null) {
            this.issues.add(new Issue.ValidationError("Unknown argument `" + $this$validate.getName() + "` on " + debug, $this$validate.getSourceLocation()));
            return;
        }
        InputValueScope.Result coercionResult = Operation_validationKt.coerce($this$validate.getValue(), schemaArgument.getType(), this.schema);
        this.variableReferences.addAll((Collection<InputValueScope.VariableReference>)coercionResult.getVariableReferences());
        this.issues.addAll((Collection<Issue>)coercionResult.getIssues());
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(GQLArguments $this$validate, List<GQLInputValueDefinition> inputValueDefinitions, String debug) {
        void $this$filterTo$iv$iv;
        Pair $this$filter$iv;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = $this$validate.getArguments();
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GQLArgument it = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        list$iv$iv = iterator3.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)list$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Pair pair = CollectionsKt.firstOrNull(MapsKt.toList(destination$iv$iv));
        if (pair != null) {
            $this$filter$iv = pair;
            $i$f$filter = false;
            boolean bl = false;
            Pair it = $this$filter$iv;
            boolean bl3 = false;
            this.issues.add(new Issue.ValidationError("Argument `" + (String)it.getFirst() + "` is defined multiple times", ((GQLArgument)CollectionsKt.first((List)it.getSecond())).getSourceLocation()));
            return;
        }
        Iterable $this$forEach$iv = inputValueDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v2;
            GQLInputValueDefinition inputValueDefinition;
            block8: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = $this$validate.getArguments();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLArgument it = (GQLArgument)element$iv2;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getName(), inputValueDefinition.getName())) continue;
                    v2 = element$iv2;
                    break block8;
                }
                v2 = null;
            }
            GQLArgument gQLArgument = v2;
            GQLValue argumentValue = gQLArgument != null ? gQLArgument.getValue() : null;
            if (argumentValue instanceof GQLNullValue || argumentValue != null) continue;
            this.issues.add(new Issue.ValidationError("No value passed for required argument " + inputValueDefinition.getName(), $this$validate.getSourceLocation()));
        }
        $this$forEach$iv = $this$validate.getArguments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLArgument it = (GQLArgument)element$iv;
            boolean bl = false;
            this.validate(it, inputValueDefinitions, debug);
        }
    }

    private final void validateVariable(GQLOperationDefinition operation, GQLVariableValue value, GQLType expectedType) {
        Object v0;
        block4: {
            if (operation == null) {
                return;
            }
            Iterable $this$firstOrNull$iv = operation.getVariableDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLVariableDefinition it = (GQLVariableDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), value.getName())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        GQLVariableDefinition variableDefinition = v0;
        if (variableDefinition == null) {
            this.issues.add(new Issue.ValidationError("Variable `" + value.getName() + "` is not defined by operation `" + operation.getName() + '`', value.getSourceLocation()));
            return;
        }
        if (!GqltypeKt.canInputValueBeAssignedTo(variableDefinition.getType(), expectedType)) {
            this.issues.add(new Issue.ValidationError("Variable `" + value.getName() + "` of type `" + GqltypeKt.pretty(variableDefinition.getType()) + "` used in position expecting type `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation()));
        }
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final Map<String, GQLFragmentDefinition> getFragmentDefinitions() {
        return this.fragmentDefinitions;
    }

    public ExecutableDocumentValidator(@NotNull Schema schema, @NotNull Map<String, GQLFragmentDefinition> fragmentDefinitions) {
        Intrinsics.checkParameterIsNotNull(schema, "schema");
        Intrinsics.checkParameterIsNotNull(fragmentDefinitions, "fragmentDefinitions");
        this.schema = schema;
        this.fragmentDefinitions = fragmentDefinitions;
        this.typeDefinitions = this.schema.getTypeDefinitions();
        boolean bl = false;
        this.issues = new ArrayList();
        bl = false;
        this.variableReferences = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/ExecutableDocumentValidator$FieldWithParent;", "", "field", "Lcom/apollographql/apollo3/compiler/frontend/GQLField;", "parentTypeDefinition", "Lcom/apollographql/apollo3/compiler/frontend/GQLTypeDefinition;", "(Lcom/apollographql/apollo3/compiler/frontend/GQLField;Lcom/apollographql/apollo3/compiler/frontend/GQLTypeDefinition;)V", "getField", "()Lcom/apollographql/apollo3/compiler/frontend/GQLField;", "getParentTypeDefinition", "()Lcom/apollographql/apollo3/compiler/frontend/GQLTypeDefinition;", "apollo-compiler"})
    private static final class FieldWithParent {
        @NotNull
        private final GQLField field;
        @NotNull
        private final GQLTypeDefinition parentTypeDefinition;

        @NotNull
        public final GQLField getField() {
            return this.field;
        }

        @NotNull
        public final GQLTypeDefinition getParentTypeDefinition() {
            return this.parentTypeDefinition;
        }

        public FieldWithParent(@NotNull GQLField field, @NotNull GQLTypeDefinition parentTypeDefinition) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(parentTypeDefinition, "parentTypeDefinition");
            this.field = field;
            this.parentTypeDefinition = parentTypeDefinition;
        }
    }
}

