/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.frontend.GQLNode;
import com.apollographql.apollo3.compiler.frontend.GqldocumentKt;
import com.apollographql.apollo3.compiler.frontend.GraphQLParser;
import com.apollographql.apollo3.compiler.frontend.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.frontend.Schema;
import com.apollographql.apollo3.compiler.frontend.Schema_to_introspectionKt;
import com.apollographql.apollo3.compiler.introspection.IntrospectionQuery;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchema;
import com.apollographql.apollo3.gradle.internal.SchemaDownloader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u001e\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a*\b\u0012\u0004\u0012\u00020\u00050\rH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloDownloadSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "graph", "getGraph", "graphVariant", "getGraphVariant", "<set-?>", "", "header", "getHeader", "()Ljava/util/List;", "setHeader", "(Ljava/util/List;)V", "key", "getKey", "schema", "getSchema", "taskAction", "", "toMap", "", "apollo-gradle-plugin"})
public abstract class ApolloDownloadSchemaTask
extends DefaultTask {
    @NotNull
    private List<String> header = CollectionsKt.emptyList();

    @Optional
    @Input
    @Option(option="endpoint", description="url of the GraphQL endpoint")
    @NotNull
    public abstract Property<String> getEndpoint();

    @Optional
    @Input
    @Option(option="graph", description="The identifier of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraph();

    @Optional
    @Input
    @Option(option="key", description="The Apollo API key. See https://www.apollographql.com/docs/studio/api-keys/ for more information on how to get your API key.")
    @NotNull
    public abstract Property<String> getKey();

    @Optional
    @Input
    @Option(option="graphVariant", description="The variant of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraphVariant();

    @Input
    @Optional
    @Option(option="schema", description="path where the schema will be downloaded, relative to the current working directory")
    @NotNull
    public abstract Property<String> getSchema();

    @Optional
    @Input
    @NotNull
    public final List<String> getHeader() {
        return this.header;
    }

    @Option(option="header", description="headers in the form 'Name: Value'")
    public final void setHeader(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.header = list;
    }

    @TaskAction
    public final void taskAction() {
        String string;
        File file;
        boolean bl;
        boolean bl2;
        String endpointUrl = (String)this.getEndpoint().getOrNull();
        String string2 = (String)this.getSchema().getOrNull();
        if (string2 != null) {
            String string3 = string2;
            bl2 = false;
            bl = false;
            String it = string3;
            boolean bl3 = false;
            file = new File(it);
        } else {
            file = null;
        }
        File schema = file;
        boolean bl4 = schema != null;
        bl2 = false;
        bl = false;
        if (!bl4) {
            boolean bl5 = false;
            String string4 = "ApolloGraphQL: please specify where to download the schema with --schema";
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        Map<String, String> headers = this.toMap(this.header);
        String introspectionSchema = null;
        String sdlSchema = null;
        String key = (String)this.getKey().getOrNull();
        String graph = (String)this.getGraph().getOrNull();
        String graphVariant = (String)this.getGraphVariant().getOrNull();
        if (graph == null && key != null && StringsKt.startsWith$default((String)key, (String)"service:", (boolean)false, (int)2, null)) {
            graph = (String)StringsKt.split$default((CharSequence)key, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(1);
        }
        if (endpointUrl != null) {
            introspectionSchema = SchemaDownloader.INSTANCE.downloadIntrospection(endpointUrl, headers);
        } else if (graph != null) {
            boolean bl6 = key != null;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string5 = "ApolloGraphQL: please define --key to download graph " + graph;
                throw (Throwable)new IllegalStateException(string5.toString());
            }
            String string6 = graphVariant;
            if (string6 == null) {
                string6 = "current";
            }
            string = string6;
            String string7 = key;
            String string8 = graph;
            sdlSchema = SchemaDownloader.INSTANCE.downloadRegistry(string7, string8, string);
        } else {
            throw (Throwable)new IllegalArgumentException("ApolloGraphQL: either --endpoint or --graph is required");
        }
        File file2 = schema.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        string = FilesKt.getExtension((File)schema);
        boolean bl10 = false;
        String string9 = string;
        if (string9 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)string10, (Object)"json")) {
            if (introspectionSchema == null) {
                String string11 = sdlSchema;
                if (string11 == null) {
                    Intrinsics.throwNpe();
                }
                IntrospectionQuery.Wrapper $this$toJson$iv = IntrospectionSchema.Companion.wrap(Schema_to_introspectionKt.toIntrospectionSchema((Schema)GraphQLParser.INSTANCE.parseSchema(string11)));
                boolean $i$f$toJson = false;
                boolean $i$f$getJsonAdapter = false;
                String string12 = MoshiKt.getMOSHI().adapter(IntrospectionQuery.Wrapper.class).toJson((Object)$this$toJson$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"getJsonAdapter<T>().toJson(this)");
                introspectionSchema = string12;
            }
            FilesKt.writeText$default((File)schema, (String)introspectionSchema, null, (int)2, null);
        } else {
            if (sdlSchema == null) {
                String string13 = introspectionSchema;
                if (string13 == null) {
                    Intrinsics.throwNpe();
                }
                string = string13;
                Charset charset = Charsets.UTF_8;
                boolean bl11 = false;
                String string14 = string;
                boolean bl12 = false;
                String string15 = string14;
                if (string15 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string15.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                sdlSchema = GqldocumentKt.toUtf8((GQLNode)((GQLNode)Introspection_to_schemaKt.toSchema((IntrospectionSchema)IntrospectionSchema.Companion.invoke$default((IntrospectionSchema.Companion)IntrospectionSchema.Companion, (InputStream)new ByteArrayInputStream(byArray), null, (int)2, null)).toDocument()));
            }
            FilesKt.writeText$default((File)schema, (String)sdlSchema, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> toMap(List<String> $this$toMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMap;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)':', (int)0, (boolean)false, (int)6, null);
            boolean bl2 = index > 0 && index < it.length() - 1;
            int n = 0;
            int n2 = 0;
            if (!bl2) {
                boolean bl3 = false;
                String string2 = "header should be in the form 'Name: Value'";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String string3 = it;
            n = 0;
            n2 = 0;
            void v0 = string3;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = v0.substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string4;
            n = 0;
            String string5 = string3;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            string3 = it;
            n = index + 1;
            n2 = it.length();
            boolean bl4 = false;
            String string7 = string3;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string8;
            n = 0;
            String string9 = string3;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            Pair pair = TuplesKt.to((Object)string6, (Object)((Object)StringsKt.trim((CharSequence)string9)).toString());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public ApolloDownloadSchemaTask() {
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        this.getOutputs().cacheIf((Spec)2.INSTANCE);
    }
}

