/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.GQLBooleanValue;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValue;
import com.apollographql.apollo3.ast.GQLEnumValueDefinition;
import com.apollographql.apollo3.ast.GQLFloatValue;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputValueDefinition;
import com.apollographql.apollo3.ast.GQLIntValue;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLListValue;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectField;
import com.apollographql.apollo3.ast.GQLObjectValue;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqlenumvaluedefinitionKt;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.VariableReference;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import com.apollographql.apollo3.ast.internal.VariableReferencesScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010\r\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0010"}, d2={"registerIssue", "", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "value", "Lcom/apollographql/apollo3/ast/GQLValue;", "expectedType", "Lcom/apollographql/apollo3/ast/GQLType;", "validateAndCoerceEnum", "enumTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLEnumTypeDefinition;", "validateAndCoerceInputObject", "expectedTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLInputObjectTypeDefinition;", "validateAndCoerceScalar", "Lcom/apollographql/apollo3/ast/GQLNamedType;", "validateAndCoerceValue", "apollo-graphql-ast"})
public final class InputValueValidationScopeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GQLValue validateAndCoerceValue(@NotNull ValidationScope $this$validateAndCoerceValue, @NotNull GQLValue value, @NotNull GQLType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$validateAndCoerceValue, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        if (value instanceof GQLVariableValue) {
            if (!($this$validateAndCoerceValue instanceof VariableReferencesScope)) {
                ValidationScope.DefaultImpls.registerIssue$default($this$validateAndCoerceValue, "Variable '" + ((GQLVariableValue)value).getName() + "' used in non-variable context", value.getSourceLocation(), null, null, 12, null);
            } else {
                ((VariableReferencesScope)((Object)$this$validateAndCoerceValue)).getVariableReferences().add(new VariableReference((GQLVariableValue)value, expectedType));
            }
            return value;
        }
        if (value instanceof GQLNullValue) {
            if (expectedType instanceof GQLNonNullType) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceValue, value, expectedType);
                return value;
            }
            return value;
        }
        GQLType gQLType = expectedType;
        if (gQLType instanceof GQLNonNullType) {
            return InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceValue, value, ((GQLNonNullType)expectedType).getType());
        }
        if (gQLType instanceof GQLListType) {
            Collection<GQLValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!(value instanceof GQLListValue)) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceValue, value, expectedType);
                return value;
            }
            Iterable iterable = ((GQLListValue)value).getValues();
            SourceLocation sourceLocation = null;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue = (GQLValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                GQLValue gQLValue2 = InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceValue, (GQLValue)it, ((GQLListType)expectedType).getType());
                collection.add(gQLValue2);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = collection;
            SourceLocation sourceLocation2 = sourceLocation;
            return new GQLListValue(sourceLocation2, list, n, defaultConstructorMarker);
        }
        if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition expectedTypeDefinition = $this$validateAndCoerceValue.getTypeDefinitions().get(((GQLNamedType)expectedType).getName());
            if (expectedTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                return InputValueValidationScopeKt.validateAndCoerceInputObject($this$validateAndCoerceValue, value, (GQLInputObjectTypeDefinition)expectedTypeDefinition);
            }
            if (expectedTypeDefinition instanceof GQLScalarTypeDefinition) {
                if (!((GQLScalarTypeDefinition)expectedTypeDefinition).isBuiltIn()) {
                    return value;
                }
                return InputValueValidationScopeKt.validateAndCoerceScalar($this$validateAndCoerceValue, value, (GQLNamedType)expectedType);
            }
            if (expectedTypeDefinition instanceof GQLEnumTypeDefinition) {
                return InputValueValidationScopeKt.validateAndCoerceEnum($this$validateAndCoerceValue, value, (GQLEnumTypeDefinition)expectedTypeDefinition);
            }
            ValidationScope.DefaultImpls.registerIssue$default($this$validateAndCoerceValue, Intrinsics.stringPlus((String)"Value cannot be of non-input type ", (Object)GqltypeKt.pretty(expectedType)), value.getSourceLocation(), null, null, 12, null);
            return value;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final void registerIssue(ValidationScope $this$registerIssue, GQLValue value, GQLType expectedType) {
        ValidationScope.DefaultImpls.registerIssue$default($this$registerIssue, "Value `" + GqlnodeKt.toUtf8$default(value, null, 1, null) + "` cannot be used in position expecting `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation(), null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final GQLValue validateAndCoerceInputObject(ValidationScope $this$validateAndCoerceInputObject, GQLValue value, GQLInputObjectTypeDefinition expectedTypeDefinition) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        GQLNamedType expectedType = new GQLNamedType(null, expectedTypeDefinition.getName(), 1, null);
        if (!(value instanceof GQLObjectValue)) {
            InputValueValidationScopeKt.registerIssue($this$validateAndCoerceInputObject, value, expectedType);
            return value;
        }
        Iterable $this$forEach$iv = expectedTypeDefinition.getInputFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            GQLInputValueDefinition inputValueDefinition;
            block7: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = ((GQLObjectValue)value).getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLObjectField it = (GQLObjectField)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)inputValueDefinition.getName())) continue;
                    v0 = element$iv2;
                    break block7;
                }
                v0 = null;
            }
            if (v0 != null) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateAndCoerceInputObject, Intrinsics.stringPlus((String)"No value passed for required inputField ", (Object)inputValueDefinition.getName()), value.getSourceLocation(), null, null, 12, null);
        }
        $this$forEach$iv = ((GQLObjectValue)value).getFields();
        SourceLocation sourceLocation = null;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GQLObjectField gQLObjectField;
            Object v1;
            GQLObjectField field;
            block8: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                field = (GQLObjectField)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = expectedTypeDefinition.getInputFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)field.getName())) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            GQLInputValueDefinition inputField = v1;
            if (inputField == null) {
                ValidationScope.DefaultImpls.registerIssue$default($this$validateAndCoerceInputObject, "Field " + field.getName() + " is not defined by " + GqltypeKt.pretty(expectedType), field.getSourceLocation(), null, null, 12, null);
                gQLObjectField = null;
            } else {
                gQLObjectField = new GQLObjectField(null, field.getName(), InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceInputObject, field.getValue(), inputField.getType()), 1, null);
            }
            if (gQLObjectField == null) continue;
            GQLObjectField gQLObjectField2 = gQLObjectField;
            boolean bl = false;
            boolean bl5 = false;
            GQLObjectField it$iv$iv = gQLObjectField2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1;
        List list2 = list;
        SourceLocation sourceLocation2 = sourceLocation;
        return new GQLObjectValue(sourceLocation2, list2, n, defaultConstructorMarker);
    }

    private static final GQLValue validateAndCoerceEnum(ValidationScope $this$validateAndCoerceEnum, GQLValue value, GQLEnumTypeDefinition enumTypeDefinition) {
        Object v0;
        block5: {
            GQLNamedType expectedType = new GQLNamedType(null, enumTypeDefinition.getName(), 1, null);
            if (!(value instanceof GQLEnumValue)) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceEnum, value, expectedType);
                return value;
            }
            Iterable $this$firstOrNull$iv = enumTypeDefinition.getEnumValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLEnumValueDefinition it = (GQLEnumValueDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)((GQLEnumValue)value).getValue())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        GQLEnumValueDefinition enumValue = v0;
        if (enumValue == null) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateAndCoerceEnum, "Cannot find enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation(), null, null, 12, null);
        } else if (GqlenumvaluedefinitionKt.isDeprecated(enumValue)) {
            $this$validateAndCoerceEnum.getIssues().add(new Issue.DeprecatedUsage("Use of deprecated enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation()));
        }
        return value;
    }

    private static final GQLValue validateAndCoerceScalar(ValidationScope $this$validateAndCoerceScalar, GQLValue value, GQLNamedType expectedType) {
        GQLValue gQLValue;
        switch (expectedType.getName()) {
            case "Int": {
                if (!(value instanceof GQLIntValue)) {
                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "Float": {
                GQLValue gQLValue2 = value;
                if (gQLValue2 instanceof GQLFloatValue) {
                    gQLValue = value;
                    break;
                }
                if (gQLValue2 instanceof GQLIntValue) {
                    gQLValue = new GQLFloatValue(null, ((GQLIntValue)value).getValue(), 1, null);
                    break;
                }
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                gQLValue = value;
                break;
            }
            case "String": {
                if (!(value instanceof GQLStringValue)) {
                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "Boolean": {
                if (!(value instanceof GQLBooleanValue)) {
                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "ID": {
                if (!(value instanceof GQLStringValue) && !(value instanceof GQLIntValue)) {
                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                }
                gQLValue = value;
                break;
            }
            default: {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                gQLValue = value;
            }
        }
        return gQLValue;
    }
}

