/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.ApiKt;
import com.apollographql.apollo3.ast.GQLArgument;
import com.apollographql.apollo3.ast.GQLArguments;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLDirectiveDefinition;
import com.apollographql.apollo3.ast.GQLDirectiveLocation;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValueDefinition;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFieldDefinition;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputValueDefinition;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLOperationTypeDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLSchemaDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableDefinition;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.ValidationDetails;
import com.apollographql.apollo3.ast.internal.InputValueValidationScopeKt;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a*\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a*\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a&\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a8\u0006\u001b"}, d2={"extraValidateNonNullDirective", "", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "directive", "Lcom/apollographql/apollo3/ast/GQLDirective;", "directiveContext", "Lcom/apollographql/apollo3/ast/GQLNode;", "extraValidateTypePolicyDirective", "validateArgument", "argument", "Lcom/apollographql/apollo3/ast/GQLArgument;", "inputValueDefinitions", "", "Lcom/apollographql/apollo3/ast/GQLInputValueDefinition;", "debug", "", "validateArguments", "arguments", "Lcom/apollographql/apollo3/ast/GQLArguments;", "validateDirective", "validateVariable", "operation", "Lcom/apollographql/apollo3/ast/GQLOperationDefinition;", "value", "Lcom/apollographql/apollo3/ast/GQLVariableValue;", "expectedType", "Lcom/apollographql/apollo3/ast/GQLType;", "apollo-ast"})
public final class ValidationCommonKt {
    public static final void validateDirective(@NotNull ValidationScope $this$validateDirective, @NotNull GQLDirective directive, @NotNull GQLNode directiveContext) {
        Object object;
        GQLDirectiveLocation gQLDirectiveLocation;
        block40: {
            GQLNode gQLNode;
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block39: {
                                Intrinsics.checkParameterIsNotNull((Object)$this$validateDirective, (String)"<this>");
                                Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                                Intrinsics.checkParameterIsNotNull((Object)directiveContext, (String)"directiveContext");
                                gQLNode = directiveContext;
                                if (!(gQLNode instanceof GQLField)) break block39;
                                gQLDirectiveLocation = GQLDirectiveLocation.FIELD;
                                break block40;
                            }
                            if (!(gQLNode instanceof GQLInlineFragment)) break block41;
                            gQLDirectiveLocation = GQLDirectiveLocation.INLINE_FRAGMENT;
                            break block40;
                        }
                        if (!(gQLNode instanceof GQLFragmentSpread)) break block42;
                        gQLDirectiveLocation = GQLDirectiveLocation.FRAGMENT_SPREAD;
                        break block40;
                    }
                    if (!(gQLNode instanceof GQLObjectTypeDefinition)) break block43;
                    gQLDirectiveLocation = GQLDirectiveLocation.OBJECT;
                    break block40;
                }
                if (!(gQLNode instanceof GQLOperationTypeDefinition)) break block44;
                switch (((GQLOperationTypeDefinition)directiveContext).getOperationType()) {
                    case "query": {
                        gQLDirectiveLocation = GQLDirectiveLocation.QUERY;
                        break block40;
                    }
                    case "mutation": {
                        gQLDirectiveLocation = GQLDirectiveLocation.MUTATION;
                        break block40;
                    }
                    case "subscription": {
                        gQLDirectiveLocation = GQLDirectiveLocation.SUBSCRIPTION;
                        break block40;
                    }
                    default: {
                        String string = Intrinsics.stringPlus((String)"unknown operation: ", (Object)directiveContext);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            if (gQLNode instanceof GQLFragmentDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.FRAGMENT_DEFINITION;
            } else if (gQLNode instanceof GQLVariableDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.VARIABLE_DEFINITION;
            } else if (gQLNode instanceof GQLSchemaDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.SCHEMA;
            } else if (gQLNode instanceof GQLScalarTypeDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.SCALAR;
            } else if (gQLNode instanceof GQLFieldDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.FIELD_DEFINITION;
            } else {
                if (gQLNode instanceof GQLInputValueDefinition) {
                    String string = "validating directices on input values is not supported yet as we need to distinguish between arguments and inputfields";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (gQLNode instanceof GQLInterfaceTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.INTERFACE;
                } else if (gQLNode instanceof GQLUnionTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.UNION;
                } else if (gQLNode instanceof GQLEnumTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.ENUM;
                } else if (gQLNode instanceof GQLEnumValueDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.ENUM_VALUE;
                } else if (gQLNode instanceof GQLInputObjectTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.INPUT_OBJECT;
                } else {
                    String string = Intrinsics.stringPlus((String)"Cannot determine directive location for ", (Object)directiveContext);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        GQLDirectiveLocation directiveLocation = gQLDirectiveLocation;
        GQLDirectiveDefinition directiveDefinition = $this$validateDirective.getDirectiveDefinitions().get(directive.getName());
        if (directiveDefinition == null) {
            object = "Unknown directive '" + directive.getName() + '\'';
            SourceLocation sourceLocation = directive.getSourceLocation();
            ValidationDetails validationDetails = ValidationDetails.UnknownDirective;
            Issue.Severity severity = Issue.Severity.WARNING;
            $this$validateDirective.registerIssue((String)object, sourceLocation, severity, validationDetails);
            return;
        }
        if (!directiveDefinition.getLocations().contains((Object)directiveLocation)) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateDirective, "Directive '" + directive.getName() + "' cannot be applied on '" + (Object)((Object)directiveLocation) + '\'', directive.getSourceLocation(), null, null, 12, null);
            return;
        }
        object = directive.getArguments();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            ValidationCommonKt.validateArguments($this$validateDirective, (GQLArguments)it, directiveDefinition.getArguments(), "directive '" + directiveDefinition.getName() + '\'');
        }
        if (Intrinsics.areEqual((Object)directive.getName(), (Object)"nonnull")) {
            ValidationCommonKt.extraValidateNonNullDirective($this$validateDirective, directive, directiveContext);
        }
        if (Intrinsics.areEqual((Object)directive.getName(), (Object)"fieldPolicy")) {
            ValidationCommonKt.extraValidateTypePolicyDirective($this$validateDirective, directive);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void extraValidateNonNullDirective(@NotNull ValidationScope $this$extraValidateNonNullDirective, @NotNull GQLDirective directive, @NotNull GQLNode directiveContext) {
        int n;
        List<GQLArgument> list;
        GQLArguments gQLArguments;
        Intrinsics.checkParameterIsNotNull((Object)$this$extraValidateNonNullDirective, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)directiveContext, (String)"directiveContext");
        if (directiveContext instanceof GQLField && ((gQLArguments = directive.getArguments()) == null ? 0 : ((list = gQLArguments.getArguments()) == null ? 0 : (n = list.size()))) > 0) {
            ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateNonNullDirective, "" + '\'' + directive + ".name' cannot have arguments when applied on a field", directive.getSourceLocation(), null, null, 12, null);
        } else if (directiveContext instanceof GQLObjectTypeDefinition && ((gQLArguments = directive.getArguments()) == null ? 0 : ((list = gQLArguments.getArguments()) == null ? 0 : (n = list.size()))) == 0) {
            void $this$mapTo$iv$iv;
            String string;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object v1;
            boolean $i$f$firstOrNull;
            List<GQLSelection> selections;
            String stringValue;
            block10: {
                List<GQLSelection> list2;
                ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateNonNullDirective, '\'' + directive.getName() + "' must contain a selection of fields", directive.getSourceLocation(), null, null, 12, null);
                GQLArguments gQLArguments2 = directive.getArguments();
                if (gQLArguments2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((list2 = ApiKt.parseAsGQLSelections(stringValue = ((GQLStringValue)((GQLArgument)CollectionsKt.first(gQLArguments2.getArguments())).getValue()).getValue()).getOrNull()) == null) {
                    String string2 = '\'' + stringValue + "' is not a valid selectionSet";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                selections = list2;
                Iterable $this$firstOrNull$iv = selections;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLSelection it = (GQLSelection)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof GQLField))) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            GQLSelection badSelection = v1;
            boolean $this$firstOrNull$iv = badSelection == null;
            $i$f$firstOrNull = false;
            boolean bl = false;
            if (!$this$firstOrNull$iv) {
                boolean bl2 = false;
                String string3 = "" + '\'' + badSelection + "' cannot be made non-null. '" + stringValue + "' should only contain fields.";
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            Iterable $this$map$iv = selections;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                GQLSelection gQLSelection = (GQLSelection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                string = ((GQLField)it).getName();
                collection.add(string);
            }
            Set nonNullFields = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = ((GQLObjectTypeDefinition)directiveContext).getFields();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLFieldDefinition bl3 = (GQLFieldDefinition)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                string = it.getName();
                collection.add(string);
            }
            Set schemaFields = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            Set unknownFields = SetsKt.minus((Set)nonNullFields, (Iterable)schemaFields);
            boolean bl5 = unknownFields.isEmpty();
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl5) {
                boolean bl8 = false;
                String string4 = "Fields '" + CollectionsKt.joinToString$default((Iterable)unknownFields, null, null, null, (int)0, null, null, (int)63, null) + "' are not defined in " + ((GQLObjectTypeDefinition)directiveContext).getName();
                throw (Throwable)new IllegalStateException(string4.toString());
            }
        }
    }

    public static final void extraValidateTypePolicyDirective(@NotNull ValidationScope $this$extraValidateTypePolicyDirective, @NotNull GQLDirective directive) {
        Intrinsics.checkParameterIsNotNull((Object)$this$extraValidateTypePolicyDirective, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        GQLArguments gQLArguments = directive.getArguments();
        if (gQLArguments == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$forEach$iv = ApiKt.parseAsGQLSelections(((GQLStringValue)((GQLArgument)CollectionsKt.first(gQLArguments.getArguments())).getValue()).getValue()).getOrThrow();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            if (!(it instanceof GQLField)) {
                ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateTypePolicyDirective, "Fragments are not supported in @typePolicy directives", it.getSourceLocation(), null, null, 12, null);
                continue;
            }
            if (((GQLField)it).getSelectionSet() == null) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateTypePolicyDirective, "Composite fields are not supported in @typePolicy directives", it.getSourceLocation(), null, null, 12, null);
        }
    }

    private static final void validateArgument(ValidationScope $this$validateArgument, GQLArgument argument, List<GQLInputValueDefinition> inputValueDefinitions, String debug) {
        Object v0;
        GQLArgument $this$validateArgument_u24lambda_u2d8;
        block3: {
            boolean bl = false;
            boolean bl2 = false;
            $this$validateArgument_u24lambda_u2d8 = argument;
            boolean bl3 = false;
            Iterable $this$firstOrNull$iv = inputValueDefinitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$validateArgument_u24lambda_u2d8.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        GQLInputValueDefinition schemaArgument = v0;
        if (schemaArgument == null) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArgument, "Unknown argument `" + $this$validateArgument_u24lambda_u2d8.getName() + "` on " + debug, $this$validateArgument_u24lambda_u2d8.getSourceLocation(), null, null, 12, null);
        } else {
            InputValueValidationScopeKt.validateAndCoerceValue($this$validateArgument, argument.getValue(), schemaArgument.getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateArguments(@NotNull ValidationScope $this$validateArguments, @NotNull GQLArguments arguments, @NotNull List<GQLInputValueDefinition> inputValueDefinitions, @NotNull String debug) {
        Object it;
        Object it2;
        void $this$filterTo$iv$iv2;
        Pair $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$validateArguments, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(inputValueDefinitions, (String)"inputValueDefinitions");
        Intrinsics.checkParameterIsNotNull((Object)debug, (String)"debug");
        Object $this$groupBy$iv = arguments.getArguments();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GQLArgument it3 = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it3.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2;
        boolean element$iv$iv = false;
        for (Map.Entry element$iv$iv2 : iterator.entrySet()) {
            it2 = element$iv$iv2;
            boolean bl = false;
            if (!(((List)it2.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)MapsKt.toList((Map)destination$iv$iv));
        if (pair != null) {
            $this$filter$iv = pair;
            boolean bl = false;
            boolean $this$filterTo$iv$iv2 = false;
            it = $this$filter$iv;
            boolean bl3 = false;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArguments, "Argument `" + (String)it.getFirst() + "` is defined multiple times", ((GQLArgument)CollectionsKt.first((List)((List)it.getSecond()))).getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = inputValueDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLArgument gQLArgument;
            GQLValue argumentValue;
            Map.Entry entry;
            GQLInputValueDefinition inputValueDefinition;
            block8: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = arguments.getArguments();
                boolean $i$f$firstOrNull = false;
                for (Map.Entry element$iv2 : $this$firstOrNull$iv) {
                    it2 = (GQLArgument)((Object)element$iv2);
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)((GQLArgument)it2).getName(), (Object)inputValueDefinition.getName())) continue;
                    entry = element$iv2;
                    break block8;
                }
                entry = null;
            }
            if ((argumentValue = (gQLArgument = (GQLArgument)((Object)entry)) == null ? null : gQLArgument.getValue()) instanceof GQLNullValue || argumentValue != null) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArguments, Intrinsics.stringPlus((String)"No value passed for required argument ", (Object)inputValueDefinition.getName()), arguments.getSourceLocation(), null, null, 12, null);
        }
        $this$forEach$iv = arguments.getArguments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GQLArgument)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateArgument($this$validateArguments, (GQLArgument)it, inputValueDefinitions, debug);
        }
    }

    public static final void validateVariable(@NotNull ValidationScope $this$validateVariable, @Nullable GQLOperationDefinition operation, @NotNull GQLVariableValue value, @NotNull GQLType expectedType) {
        Object v0;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$this$validateVariable, (String)"<this>");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
            if (operation == null) {
                return;
            }
            Iterable $this$firstOrNull$iv = operation.getVariableDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLVariableDefinition it = (GQLVariableDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)value.getName())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        GQLVariableDefinition variableDefinition = v0;
        if (variableDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateVariable, "Variable `" + value.getName() + "` is not defined by operation `" + operation.getName() + '`', value.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypeKt.canInputValueBeAssignedTo(variableDefinition.getType(), expectedType)) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateVariable, "Variable `" + value.getName() + "` of type `" + GqltypeKt.pretty(variableDefinition.getType()) + "` used in position expecting type `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation(), null, null, 12, null);
        }
    }
}

