/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.json;

import com.apollographql.apollo3.api.internal.json.Utils;
import com.apollographql.apollo3.api.internal.json.UtilsKt;
import com.apollographql.apollo3.api.json.JsonNumber;
import com.apollographql.apollo3.api.json.JsonReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 32\u00020\u0001:\u0003345B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010*\u001a\u00020\u0013H\u0016J\b\u0010+\u001a\u00020\u0018H\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\u0018H\u0016J\u0016\u0010/\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000401H\u0016J\b\u00102\u001a\u00020\u0018H\u0016R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "root", "", "", "", "(Ljava/util/Map;)V", "dataStack", "", "[Ljava/lang/Object;", "indexStack", "", "nameIndexStack", "pendingName", "getRoot", "()Ljava/util/Map;", "stackSize", "", "anyToToken", "Lcom/apollographql/apollo3/api/json/JsonReader$Token;", "any", "beginArray", "beginObject", "close", "", "endArray", "endObject", "hasNext", "", "nextBoolean", "nextDouble", "", "nextInt", "nextLong", "", "nextName", "nextNull", "", "nextNumber", "Lcom/apollographql/apollo3/api/json/JsonNumber;", "nextString", "nextValue", "peek", "pop", "push", "data", "rewind", "selectName", "names", "", "skipValue", "Companion", "Entry", "OrderedMap", "apollo-api"})
public final class MapJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> root;
    @NotNull
    private final Object[] dataStack;
    @NotNull
    private final int[] indexStack;
    @NotNull
    private final int[] nameIndexStack;
    private int stackSize;
    @Nullable
    private String pendingName;

    public MapJsonReader(@NotNull Map<String, ? extends Object> root) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        this.root = root;
        this.dataStack = new Object[256];
        this.indexStack = new int[256];
        this.nameIndexStack = new int[256];
        this.push(new OrderedMap(CollectionsKt.listOf((Object)new Entry("root", this.root))));
        this.pendingName = "root";
    }

    @NotNull
    public final Map<String, Object> getRoot() {
        return this.root;
    }

    private final void push(Object data) {
        boolean bl = this.stackSize < 256;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Nesting too deep";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.dataStack[this.stackSize] = data;
        this.indexStack[this.stackSize] = 0;
        this.nameIndexStack[this.stackSize] = 0;
        MapJsonReader mapJsonReader = this;
        n = mapJsonReader.stackSize;
        mapJsonReader.stackSize = n + 1;
        this.pendingName = null;
    }

    private final void pop() {
        this.dataStack[this.stackSize] = null;
        MapJsonReader mapJsonReader = this;
        int n = mapJsonReader.stackSize;
        mapJsonReader.stackSize = n + -1;
        this.pendingName = null;
    }

    private final Object nextValue() {
        Object object;
        Object data = this.dataStack[this.stackSize - 1];
        if (data instanceof List) {
            int[] nArray = this.indexStack;
            int n = this.stackSize - 1;
            int n2 = nArray[n];
            nArray[n] = n2 + 1;
            object = ((List)data).get(n2);
        } else if (data instanceof OrderedMap) {
            boolean bl = this.pendingName != null;
            int n = 0;
            int n3 = 0;
            n3 = 0;
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.pendingName = null;
            int[] nArray = this.indexStack;
            n = this.stackSize - 1;
            n3 = nArray[n];
            nArray[n] = n3 + 1;
            object = ((OrderedMap)data).getEntries().get(n3).getValue();
        } else {
            String string = "";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    @Override
    @NotNull
    public MapJsonReader beginArray() {
        MapJsonReader mapJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        MapJsonReader $this$beginArray_u24lambda_u2d1 = mapJsonReader;
        boolean bl3 = false;
        Object list = $this$beginArray_u24lambda_u2d1.nextValue();
        boolean bl4 = list instanceof List;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        $this$beginArray_u24lambda_u2d1.push(list);
        return mapJsonReader;
    }

    @Override
    @NotNull
    public MapJsonReader endArray() {
        MapJsonReader mapJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        MapJsonReader $this$endArray_u24lambda_u2d2 = mapJsonReader;
        boolean bl3 = false;
        $this$endArray_u24lambda_u2d2.pop();
        return mapJsonReader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MapJsonReader beginObject() {
        Collection<Entry> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MapJsonReader mapJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        MapJsonReader $this$beginObject_u24lambda_u2d4 = mapJsonReader;
        boolean bl3 = false;
        Object map = $this$beginObject_u24lambda_u2d4.nextValue();
        boolean bl4 = map instanceof Map;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Iterable iterable = ((Map)map).entrySet();
        MapJsonReader mapJsonReader2 = $this$beginObject_u24lambda_u2d4;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            Object k = it.getKey();
            if (k == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Entry entry2 = new Entry((String)k, it.getValue());
            collection.add(entry2);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        mapJsonReader2.push(new OrderedMap(list));
        return mapJsonReader;
    }

    @Override
    @NotNull
    public MapJsonReader endObject() {
        MapJsonReader mapJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        MapJsonReader $this$endObject_u24lambda_u2d5 = mapJsonReader;
        boolean bl3 = false;
        $this$endObject_u24lambda_u2d5.pop();
        return mapJsonReader;
    }

    private final JsonReader.Token anyToToken(Object any) {
        JsonReader.Token token;
        Object object = any;
        if (object == null) {
            token = JsonReader.Token.NULL;
        } else if (object instanceof List) {
            token = JsonReader.Token.BEGIN_ARRAY;
        } else if (object instanceof Map) {
            token = JsonReader.Token.BEGIN_OBJECT;
        } else if (object instanceof Integer) {
            token = JsonReader.Token.NUMBER;
        } else if (object instanceof Long) {
            token = JsonReader.Token.NUMBER;
        } else if (object instanceof Double) {
            token = JsonReader.Token.NUMBER;
        } else if (object instanceof String) {
            token = JsonReader.Token.STRING;
        } else if (object instanceof Boolean) {
            token = JsonReader.Token.BOOLEAN;
        } else {
            String string = Intrinsics.stringPlus((String)"Unsupported value ", (Object)any);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return token;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        Object data = this.dataStack[this.stackSize - 1];
        if (data instanceof List) {
            bl = this.indexStack[this.stackSize - 1] < ((List)data).size();
        } else if (data instanceof OrderedMap) {
            bl = this.indexStack[this.stackSize - 1] < ((OrderedMap)data).getEntries().size();
        } else {
            String string = "";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return bl;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() {
        JsonReader.Token token;
        if (this.stackSize == 1 && this.indexStack[0] == 1) {
            return JsonReader.Token.END_DOCUMENT;
        }
        Object data = this.dataStack[this.stackSize - 1];
        if (data instanceof List) {
            token = this.indexStack[this.stackSize - 1] < ((List)data).size() ? this.anyToToken(((List)data).get(this.indexStack[this.stackSize - 1])) : JsonReader.Token.END_ARRAY;
        } else if (data instanceof OrderedMap) {
            if (this.indexStack[this.stackSize - 1] < ((OrderedMap)data).getEntries().size()) {
                if (this.pendingName == null) {
                    token = JsonReader.Token.NAME;
                } else {
                    boolean bl = Intrinsics.areEqual((Object)this.pendingName, (Object)((OrderedMap)data).getEntries().get(this.indexStack[this.stackSize - 1]).getKey());
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Object value = ((OrderedMap)data).getEntries().get(this.indexStack[this.stackSize - 1]).getValue();
                    token = this.anyToToken(value);
                }
            } else {
                token = JsonReader.Token.END_OBJECT;
            }
        } else {
            String string = "";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return token;
    }

    @Override
    @NotNull
    public String nextName() {
        Object data = this.dataStack[this.stackSize - 1];
        boolean bl = data instanceof OrderedMap;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.pendingName == null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = this.pendingName = ((OrderedMap)data).getEntries().get(this.indexStack[this.stackSize - 1]).getKey();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @Nullable
    public String nextString() {
        Object object = this.nextValue();
        return object == null ? null : object.toString();
    }

    @Override
    public boolean nextBoolean() {
        Object object = this.nextValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    @Override
    @Nullable
    public Void nextNull() {
        Object object = this.nextValue();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        boolean bl4 = it == null;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        Object value = this.nextValue();
        if (value instanceof Integer) {
            d = ((Number)value).intValue();
        } else if (value instanceof Long) {
            d = UtilsKt.toDoubleExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            d = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            d = Double.parseDouble(string);
        } else if (value instanceof JsonNumber) {
            String string = ((JsonNumber)value).getValue();
            boolean bl = false;
            d = Double.parseDouble(string);
        } else {
            String string = "Expected Double but got " + this + " instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return d;
    }

    @Override
    public int nextInt() {
        int n;
        Object value = this.nextValue();
        if (value instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (value instanceof Long) {
            n = UtilsKt.toIntExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            n = UtilsKt.toIntExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            n = Integer.parseInt(string);
        } else if (value instanceof JsonNumber) {
            String string = ((JsonNumber)value).getValue();
            boolean bl = false;
            n = Integer.parseInt(string);
        } else {
            String string = "Expected Int but got " + this + " instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    @Override
    public long nextLong() {
        long l;
        Object value = this.nextValue();
        if (value instanceof Integer) {
            l = ((Number)value).intValue();
        } else if (value instanceof Long) {
            l = ((Number)value).longValue();
        } else if (value instanceof Double) {
            l = UtilsKt.toLongExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            String string = (String)value;
            boolean bl = false;
            l = Long.parseLong(string);
        } else if (value instanceof JsonNumber) {
            String string = ((JsonNumber)value).getValue();
            boolean bl = false;
            l = Long.parseLong(string);
        } else {
            String string = "Expected Int but got " + this + " instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return l;
    }

    @Override
    @NotNull
    public JsonNumber nextNumber() {
        JsonNumber jsonNumber;
        Object value = this.nextValue();
        if ((value instanceof Integer ? true : value instanceof Long) ? true : value instanceof Double) {
            jsonNumber = new JsonNumber(value.toString());
        } else if (value instanceof String) {
            jsonNumber = new JsonNumber((String)value);
        } else if (value instanceof JsonNumber) {
            jsonNumber = (JsonNumber)value;
        } else {
            String string = "Expected JsonNumber but got " + this + " instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return jsonNumber;
    }

    @Override
    public void skipValue() {
        this.nextValue();
    }

    @Override
    public void close() {
    }

    @Override
    public int selectName(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (names.isEmpty()) {
            return -1;
        }
        while (this.hasNext()) {
            block7: {
                int n;
                String name = this.nextName();
                int expectedIndex = this.nameIndexStack[this.stackSize - 1];
                if (Intrinsics.areEqual((Object)names.get(expectedIndex), (Object)name)) {
                    int n2 = expectedIndex;
                    n = 0;
                    boolean bl = false;
                    int it = n2;
                    boolean bl2 = false;
                    this.nameIndexStack[this.stackSize - 1] = expectedIndex + 1;
                    if (this.nameIndexStack[this.stackSize - 1] == names.size()) {
                        this.nameIndexStack[this.stackSize - 1] = 0;
                    }
                    return n2;
                }
                int index = 0;
                index = expectedIndex;
                do {
                    if ((index = (n = index) + 1) == names.size()) {
                        index = 0;
                    }
                    if (index == expectedIndex) break block7;
                } while (!Intrinsics.areEqual((Object)names.get(index), (Object)name));
                n = index;
                boolean bl = false;
                boolean bl3 = false;
                int it = n;
                boolean bl4 = false;
                this.nameIndexStack[this.stackSize - 1] = index + 1;
                if (this.nameIndexStack[this.stackSize - 1] == names.size()) {
                    this.nameIndexStack[this.stackSize - 1] = 0;
                }
                return n;
            }
            this.skipValue();
        }
        return -1;
    }

    @Override
    public void rewind() {
        this.indexStack[this.stackSize - 1] = 0;
        this.nameIndexStack[this.stackSize - 1] = 0;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader$OrderedMap;", "", "entries", "", "Lcom/apollographql/apollo3/api/json/MapJsonReader$Entry;", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "apollo-api"})
    private static final class OrderedMap {
        @NotNull
        private final List<Entry> entries;

        public OrderedMap(@NotNull List<Entry> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
        }

        @NotNull
        public final List<Entry> getEntries() {
            return this.entries;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader$Entry;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "apollo-api"})
    private static final class Entry {
        @NotNull
        private final String key;
        @Nullable
        private final Object value;

        public Entry(@NotNull String key, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader$Companion;", "", "()V", "buffer", "Lcom/apollographql/apollo3/api/json/MapJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapJsonReader buffer(@NotNull JsonReader $this$buffer) {
            Intrinsics.checkNotNullParameter((Object)$this$buffer, (String)"<this>");
            if ($this$buffer instanceof MapJsonReader) {
                return (MapJsonReader)$this$buffer;
            }
            JsonReader.Token token = $this$buffer.peek();
            boolean bl = token == JsonReader.Token.BEGIN_OBJECT;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Failed to buffer json reader, expected `BEGIN_OBJECT` but found `" + (Object)((Object)token) + "` json token";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object object = Utils.INSTANCE.readRecursivelyFast($this$buffer);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map data = (Map)object;
            return new MapJsonReader(data);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

