/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.codegen.java.file;

import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.codegen.java.CodegenJavaFile;
import com.apollographql.apollo3.compiler.codegen.java.JavaClassBuilder;
import com.apollographql.apollo3.compiler.codegen.java.JavaContext;
import com.apollographql.apollo3.compiler.codegen.java.JavaResolver;
import com.apollographql.apollo3.compiler.codegen.java.selections.CompiledSelectionsBuilder;
import com.apollographql.apollo3.compiler.ir.IrNamedFragment;
import com.squareup.javapoet.ClassName;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/compiler/codegen/java/file/FragmentSelectionsBuilder;", "Lcom/apollographql/apollo3/compiler/codegen/java/JavaClassBuilder;", "context", "Lcom/apollographql/apollo3/compiler/codegen/java/JavaContext;", "fragment", "Lcom/apollographql/apollo3/compiler/ir/IrNamedFragment;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "allFragmentDefinitions", "", "", "Lcom/apollographql/apollo3/ast/GQLFragmentDefinition;", "(Lcom/apollographql/apollo3/compiler/codegen/java/JavaContext;Lcom/apollographql/apollo3/compiler/ir/IrNamedFragment;Lcom/apollographql/apollo3/ast/Schema;Ljava/util/Map;)V", "getAllFragmentDefinitions", "()Ljava/util/Map;", "getContext", "()Lcom/apollographql/apollo3/compiler/codegen/java/JavaContext;", "getFragment", "()Lcom/apollographql/apollo3/compiler/ir/IrNamedFragment;", "packageName", "getSchema", "()Lcom/apollographql/apollo3/ast/Schema;", "simpleName", "build", "Lcom/apollographql/apollo3/compiler/codegen/java/CodegenJavaFile;", "prepare", "", "apollo-compiler"})
public final class FragmentSelectionsBuilder
implements JavaClassBuilder {
    @NotNull
    private final JavaContext context;
    @NotNull
    private final IrNamedFragment fragment;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, GQLFragmentDefinition> allFragmentDefinitions;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;

    public FragmentSelectionsBuilder(@NotNull JavaContext context, @NotNull IrNamedFragment fragment, @NotNull Schema schema, @NotNull Map<String, GQLFragmentDefinition> allFragmentDefinitions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(allFragmentDefinitions, (String)"allFragmentDefinitions");
        this.context = context;
        this.fragment = fragment;
        this.schema = schema;
        this.allFragmentDefinitions = allFragmentDefinitions;
        this.packageName = this.context.getLayout().fragmentResponseFieldsPackageName(this.fragment.getFilePath());
        this.simpleName = this.context.getLayout().fragmentSelectionsName$apollo_compiler(this.fragment.getName());
    }

    @NotNull
    public final JavaContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrNamedFragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final Map<String, GQLFragmentDefinition> getAllFragmentDefinitions() {
        return this.allFragmentDefinitions;
    }

    @Override
    public void prepare() {
        JavaResolver javaResolver = this.context.getResolver();
        String string = this.fragment.getName();
        ClassName className2 = ClassName.get(this.packageName, this.simpleName, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)className2, (String)"get(packageName, simpleName)");
        javaResolver.registerFragmentSelections(string, className2);
    }

    @Override
    @NotNull
    public CodegenJavaFile build() {
        return new CodegenJavaFile(this.packageName, new CompiledSelectionsBuilder(this.context, this.allFragmentDefinitions, this.schema).build(this.fragment.getSelections(), this.simpleName, this.fragment.getTypeCondition()));
    }
}

