/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio.internal;

import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.ByteString;
import com.apollographql.relocated.okio.ExperimentalFileSystem;
import com.apollographql.relocated.okio.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\u001a\u0015\u0010\u0013\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0081\b\u001a\u0017\u0010\u0015\u001a\u00020\u0016*\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0017H\u0081\b\u001a\r\u0010\u0018\u001a\u00020\r*\u00020\u000eH\u0081\b\u001a\r\u0010\u0019\u001a\u00020\u0016*\u00020\u000eH\u0081\b\u001a\r\u0010\u001a\u001a\u00020\u0016*\u00020\u000eH\u0081\b\u001a\r\u0010\u001b\u001a\u00020\u0016*\u00020\u000eH\u0081\b\u001a\r\u0010\u001c\u001a\u00020\u001d*\u00020\u000eH\u0081\b\u001a\r\u0010\u001e\u001a\u00020\u0001*\u00020\u000eH\u0081\b\u001a\u000f\u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0081\b\u001a\u0015\u0010 \u001a\u00020\u000e*\u00020\u000e2\u0006\u0010!\u001a\u00020\u001dH\u0081\b\u001a\u0015\u0010 \u001a\u00020\u000e*\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0081\b\u001a\f\u0010\"\u001a\u00020\u000e*\u00020\u001dH\u0007\u001a\r\u0010#\u001a\u00020\u001d*\u00020\u000eH\u0081\b\u001a\u0014\u0010$\u001a\u0004\u0018\u00010%*\u00020\u000eH\u0081\b\u00a2\u0006\u0002\u0010&\u001a\f\u0010'\u001a\u00020\u0016*\u00020\u000eH\u0003\u001a\u0014\u0010(\u001a\u00020\u0016*\u00020)2\u0006\u0010*\u001a\u00020\u0001H\u0002\u001a\f\u0010+\u001a\u00020\u000e*\u00020)H\u0001\u001a\f\u0010,\u001a\u00020\u0001*\u00020-H\u0002\u001a\f\u0010,\u001a\u00020\u0001*\u00020\u001dH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0003\"\u0016\u0010\u0006\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\"\u0016\u0010\b\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\"\u0016\u0010\n\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003\"\u001e\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"ANY_SLASH", "Lcom/apollographql/relocated/okio/ByteString;", "getANY_SLASH$annotations", "()V", "BACKSLASH", "getBACKSLASH$annotations", "DOT", "getDOT$annotations", "DOT_DOT", "getDOT_DOT$annotations", "SLASH", "getSLASH$annotations", "indexOfLastSlash", "", "Lcom/apollographql/relocated/okio/Path;", "getIndexOfLastSlash$annotations", "(Lokio/Path;)V", "getIndexOfLastSlash", "(Lokio/Path;)I", "commonCompareTo", "other", "commonEquals", "", "", "commonHashCode", "commonIsAbsolute", "commonIsRelative", "commonIsRoot", "commonName", "", "commonNameBytes", "commonParent", "commonResolve", "child", "commonToPath", "commonToString", "commonVolumeLetter", "", "(Lokio/Path;)Ljava/lang/Character;", "lastSegmentIsDotDot", "startsWithVolumeLetterAndColon", "Lcom/apollographql/relocated/okio/Buffer;", "slash", "toPath", "toSlash", "", "com.apollographql.relocated.okio"})
public final class _PathKt {
    @NotNull
    private static final ByteString SLASH = ByteString.Companion.encodeUtf8("/");
    @NotNull
    private static final ByteString BACKSLASH = ByteString.Companion.encodeUtf8("\\");
    @NotNull
    private static final ByteString ANY_SLASH = ByteString.Companion.encodeUtf8("/\\");
    @NotNull
    private static final ByteString DOT = ByteString.Companion.encodeUtf8(".");
    @NotNull
    private static final ByteString DOT_DOT = ByteString.Companion.encodeUtf8("..");

    private static /* synthetic */ void getSLASH$annotations() {
    }

    private static /* synthetic */ void getBACKSLASH$annotations() {
    }

    private static /* synthetic */ void getANY_SLASH$annotations() {
    }

    private static /* synthetic */ void getDOT$annotations() {
    }

    private static /* synthetic */ void getDOT_DOT$annotations() {
    }

    @ExperimentalFileSystem
    public static final boolean commonIsAbsolute(@NotNull Path $this$commonIsAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$commonIsAbsolute, (String)"<this>");
        boolean $i$f$commonIsAbsolute = false;
        return $this$commonIsAbsolute.getBytes$okio().startsWith(_PathKt.SLASH) || $this$commonIsAbsolute.getBytes$okio().startsWith(_PathKt.BACKSLASH) || $this$commonIsAbsolute.volumeLetter() != null && $this$commonIsAbsolute.getBytes$okio().size() > 2 && $this$commonIsAbsolute.getBytes$okio().getByte(2) == 92;
    }

    @ExperimentalFileSystem
    public static final boolean commonIsRelative(@NotNull Path $this$commonIsRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$commonIsRelative, (String)"<this>");
        boolean $i$f$commonIsRelative = false;
        return !$this$commonIsRelative.isAbsolute();
    }

    @ExperimentalFileSystem
    @Nullable
    public static final Character commonVolumeLetter(@NotNull Path $this$commonVolumeLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$commonVolumeLetter, (String)"<this>");
        boolean $i$f$commonVolumeLetter = false;
        if (ByteString.indexOf$default($this$commonVolumeLetter.getBytes$okio(), _PathKt.SLASH, 0, 2, null) != -1) {
            return null;
        }
        if ($this$commonVolumeLetter.getBytes$okio().size() < 2) {
            return null;
        }
        if ($this$commonVolumeLetter.getBytes$okio().getByte(1) != 58) {
            return null;
        }
        char c = (char)$this$commonVolumeLetter.getBytes$okio().getByte(0);
        if (!('a' <= c ? c <= 'z' : false)) {
            if (!('A' <= c ? c <= 'Z' : false)) {
                return null;
            }
        }
        return Character.valueOf(c);
    }

    private static final int getIndexOfLastSlash(Path $this$indexOfLastSlash) {
        int lastSlash = ByteString.lastIndexOf$default($this$indexOfLastSlash.getBytes$okio(), SLASH, 0, 2, null);
        if (lastSlash != -1) {
            return lastSlash;
        }
        return ByteString.lastIndexOf$default($this$indexOfLastSlash.getBytes$okio(), BACKSLASH, 0, 2, null);
    }

    @ExperimentalFileSystem
    private static /* synthetic */ void getIndexOfLastSlash$annotations(Path $this$getIndexOfLastSlash_u24annotations) {
    }

    @ExperimentalFileSystem
    @NotNull
    public static final ByteString commonNameBytes(@NotNull Path $this$commonNameBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$commonNameBytes, (String)"<this>");
        boolean $i$f$commonNameBytes = false;
        int lastSlash = _PathKt.getIndexOfLastSlash($this$commonNameBytes);
        return lastSlash != -1 ? ByteString.substring$default($this$commonNameBytes.getBytes$okio(), lastSlash + 1, 0, 2, null) : ($this$commonNameBytes.volumeLetter() != null && $this$commonNameBytes.getBytes$okio().size() == 2 ? ByteString.EMPTY : $this$commonNameBytes.getBytes$okio());
    }

    @ExperimentalFileSystem
    @NotNull
    public static final String commonName(@NotNull Path $this$commonName) {
        Intrinsics.checkNotNullParameter((Object)$this$commonName, (String)"<this>");
        boolean $i$f$commonName = false;
        return $this$commonName.nameBytes().utf8();
    }

    @ExperimentalFileSystem
    @Nullable
    public static final Path commonParent(@NotNull Path $this$commonParent) {
        Intrinsics.checkNotNullParameter((Object)$this$commonParent, (String)"<this>");
        boolean $i$f$commonParent = false;
        if (Intrinsics.areEqual((Object)$this$commonParent.getBytes$okio(), (Object)_PathKt.DOT) || Intrinsics.areEqual((Object)$this$commonParent.getBytes$okio(), (Object)_PathKt.SLASH) || Intrinsics.areEqual((Object)$this$commonParent.getBytes$okio(), (Object)_PathKt.BACKSLASH) || _PathKt.lastSegmentIsDotDot($this$commonParent)) {
            return null;
        }
        int lastSlash = _PathKt.getIndexOfLastSlash($this$commonParent);
        if (lastSlash == 2 && $this$commonParent.volumeLetter() != null) {
            if ($this$commonParent.getBytes$okio().size() == 3) {
                return null;
            }
            return new Path(ByteString.substring$default($this$commonParent.getBytes$okio(), 0, 3, 1, null));
        }
        if (lastSlash == 1 && $this$commonParent.getBytes$okio().startsWith(_PathKt.BACKSLASH)) {
            return null;
        }
        if (lastSlash == -1 && $this$commonParent.volumeLetter() != null) {
            if ($this$commonParent.getBytes$okio().size() == 2) {
                return null;
            }
            return new Path(ByteString.substring$default($this$commonParent.getBytes$okio(), 0, 2, 1, null));
        }
        if (lastSlash == -1) {
            return new Path(_PathKt.DOT);
        }
        if (lastSlash == 0) {
            return new Path(ByteString.substring$default($this$commonParent.getBytes$okio(), 0, 1, 1, null));
        }
        return new Path(ByteString.substring$default($this$commonParent.getBytes$okio(), 0, lastSlash, 1, null));
    }

    @ExperimentalFileSystem
    private static final boolean lastSegmentIsDotDot(Path $this$lastSegmentIsDotDot) {
        if ($this$lastSegmentIsDotDot.getBytes$okio().endsWith(DOT_DOT)) {
            if ($this$lastSegmentIsDotDot.getBytes$okio().size() == 2) {
                return true;
            }
            if ($this$lastSegmentIsDotDot.getBytes$okio().rangeEquals($this$lastSegmentIsDotDot.getBytes$okio().size() - 3, SLASH, 0, 1)) {
                return true;
            }
            if ($this$lastSegmentIsDotDot.getBytes$okio().rangeEquals($this$lastSegmentIsDotDot.getBytes$okio().size() - 3, BACKSLASH, 0, 1)) {
                return true;
            }
        }
        return false;
    }

    @ExperimentalFileSystem
    public static final boolean commonIsRoot(@NotNull Path $this$commonIsRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$commonIsRoot, (String)"<this>");
        boolean $i$f$commonIsRoot = false;
        return $this$commonIsRoot.parent() == null && $this$commonIsRoot.isAbsolute();
    }

    @ExperimentalFileSystem
    @NotNull
    public static final Path commonResolve(@NotNull Path $this$commonResolve, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)$this$commonResolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean $i$f$commonResolve = false;
        return $this$commonResolve.resolve(_PathKt.toPath(new Buffer().writeUtf8(child)));
    }

    @ExperimentalFileSystem
    @NotNull
    public static final Path commonResolve(@NotNull Path $this$commonResolve, @NotNull Path child) {
        Intrinsics.checkNotNullParameter((Object)$this$commonResolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean $i$f$commonResolve = false;
        if (child.isAbsolute() || child.volumeLetter() != null) {
            return child;
        }
        ByteString slash = ByteString.indexOf$default($this$commonResolve.getBytes$okio(), _PathKt.SLASH, 0, 2, null) != -1 ? _PathKt.SLASH : (ByteString.indexOf$default($this$commonResolve.getBytes$okio(), _PathKt.BACKSLASH, 0, 2, null) != -1 ? _PathKt.BACKSLASH : (ByteString.indexOf$default(child.getBytes$okio(), _PathKt.SLASH, 0, 2, null) != -1 ? _PathKt.SLASH : (ByteString.indexOf$default(child.getBytes$okio(), _PathKt.BACKSLASH, 0, 2, null) != -1 ? _PathKt.BACKSLASH : _PathKt.toSlash(Path.DIRECTORY_SEPARATOR))));
        Buffer buffer = new Buffer();
        buffer.write($this$commonResolve.getBytes$okio());
        if (buffer.size() > 0L) {
            buffer.write(slash);
        }
        buffer.write(child.getBytes$okio());
        return _PathKt.toPath(buffer);
    }

    @ExperimentalFileSystem
    public static final int commonCompareTo(@NotNull Path $this$commonCompareTo, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonCompareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$commonCompareTo = false;
        return $this$commonCompareTo.getBytes$okio().compareTo(other.getBytes$okio());
    }

    @ExperimentalFileSystem
    public static final boolean commonEquals(@NotNull Path $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEquals, (String)"<this>");
        boolean $i$f$commonEquals = false;
        return other instanceof Path && Intrinsics.areEqual((Object)((Path)other).getBytes$okio(), (Object)$this$commonEquals.getBytes$okio());
    }

    @ExperimentalFileSystem
    public static final int commonHashCode(@NotNull Path $this$commonHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHashCode, (String)"<this>");
        boolean $i$f$commonHashCode = false;
        return $this$commonHashCode.getBytes$okio().hashCode();
    }

    @ExperimentalFileSystem
    @NotNull
    public static final String commonToString(@NotNull Path $this$commonToString) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        boolean $i$f$commonToString = false;
        return $this$commonToString.getBytes$okio().utf8();
    }

    @ExperimentalFileSystem
    @NotNull
    public static final Path commonToPath(@NotNull String $this$commonToPath) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToPath, (String)"<this>");
        return _PathKt.toPath(new Buffer().writeUtf8($this$commonToPath));
    }

    @ExperimentalFileSystem
    @NotNull
    public static final Path toPath(@NotNull Buffer $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        ByteString slash = null;
        Buffer result = new Buffer();
        int leadingSlashCount = 0;
        while ($this$toPath.rangeEquals(0L, SLASH) || $this$toPath.rangeEquals(0L, BACKSLASH)) {
            byte by = $this$toPath.readByte();
            ByteString byteString = slash;
            slash = byteString == null ? _PathKt.toSlash(by) : byteString;
            int n = leadingSlashCount;
            leadingSlashCount = n + 1;
        }
        if (leadingSlashCount >= 2 && Intrinsics.areEqual((Object)slash, (Object)BACKSLASH)) {
            result.write(slash);
            result.write(slash);
        } else if (leadingSlashCount > 0) {
            ByteString byteString = slash;
            Intrinsics.checkNotNull((Object)byteString);
            result.write(byteString);
        } else {
            long l;
            long limit = $this$toPath.indexOfElement(ANY_SLASH);
            ByteString byteString = slash;
            ByteString byteString2 = byteString == null ? ((l = limit) == -1L ? _PathKt.toSlash(Path.DIRECTORY_SEPARATOR) : _PathKt.toSlash($this$toPath.getByte(limit))) : (slash = byteString);
            if (_PathKt.startsWithVolumeLetterAndColon($this$toPath, slash)) {
                if (limit == 2L) {
                    result.write($this$toPath, 3L);
                } else {
                    result.write($this$toPath, 2L);
                }
            }
        }
        boolean absolute = result.size() > 0L;
        boolean bl = false;
        List canonicalParts = new ArrayList();
        while (!$this$toPath.exhausted()) {
            long limit = $this$toPath.indexOfElement(ANY_SLASH);
            ByteString part = null;
            if (limit == -1L) {
                part = $this$toPath.readByteString();
            } else {
                part = $this$toPath.readByteString(limit);
                $this$toPath.readByte();
            }
            if (Intrinsics.areEqual((Object)part, (Object)DOT_DOT)) {
                if (!absolute && (canonicalParts.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.last((List)canonicalParts), (Object)DOT_DOT))) {
                    canonicalParts.add(part);
                    continue;
                }
                CollectionsKt.removeLastOrNull((List)canonicalParts);
                continue;
            }
            if (Intrinsics.areEqual((Object)part, (Object)DOT) || Intrinsics.areEqual((Object)part, (Object)ByteString.EMPTY)) continue;
            canonicalParts.add(part);
        }
        int n = 0;
        int n2 = canonicalParts.size();
        if (n < n2) {
            do {
                int i;
                if ((i = n++) > 0) {
                    result.write(slash);
                }
                result.write((ByteString)canonicalParts.get(i));
            } while (n < n2);
        }
        if (result.size() == 0L) {
            result.write(DOT);
        }
        return new Path(result.readByteString());
    }

    private static final ByteString toSlash(String $this$toSlash) {
        ByteString byteString;
        String string = $this$toSlash;
        if (Intrinsics.areEqual((Object)string, (Object)"/")) {
            byteString = SLASH;
        } else if (Intrinsics.areEqual((Object)string, (Object)"\\")) {
            byteString = BACKSLASH;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"not a directory separator: ", (Object)$this$toSlash));
        }
        return byteString;
    }

    private static final ByteString toSlash(byte $this$toSlash) {
        ByteString byteString;
        byte by = $this$toSlash;
        switch (by) {
            case 47: {
                byteString = SLASH;
                break;
            }
            case 92: {
                byteString = BACKSLASH;
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"not a directory separator: ", (Object)$this$toSlash));
            }
        }
        return byteString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean startsWithVolumeLetterAndColon(Buffer $this$startsWithVolumeLetterAndColon, ByteString slash) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)slash, (Object)BACKSLASH)) {
            return false;
        }
        if ($this$startsWithVolumeLetterAndColon.size() < 2L) {
            return false;
        }
        if ($this$startsWithVolumeLetterAndColon.getByte(1L) != 58) {
            return false;
        }
        char b = (char)$this$startsWithVolumeLetterAndColon.getByte(0L);
        if ('a' <= b) {
            if (b <= 'z') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('A' > b) return false;
        if (b > 'Z') return false;
        return true;
    }
}

