/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio.internal;

import com.apollographql.relocated.okio.BufferedSink;
import com.apollographql.relocated.okio.ExperimentalFileSystem;
import com.apollographql.relocated.okio.FileMetadata;
import com.apollographql.relocated.okio.FileSystem;
import com.apollographql.relocated.okio.Okio;
import com.apollographql.relocated.okio.Path;
import com.apollographql.relocated.okio.Source;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0001\u00a8\u0006\u000f"}, d2={"commonCopy", "", "Lcom/apollographql/relocated/okio/FileSystem;", "source", "Lcom/apollographql/relocated/okio/Path;", "target", "commonCreateDirectories", "dir", "commonDeleteRecursively", "fileOrDirectory", "commonExists", "", "path", "commonMetadata", "Lcom/apollographql/relocated/okio/FileMetadata;", "com.apollographql.relocated.okio"})
public final class _FileSystemKt {
    @ExperimentalFileSystem
    @NotNull
    public static final FileMetadata commonMetadata(@NotNull FileSystem $this$commonMetadata, @NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$commonMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileMetadata fileMetadata = $this$commonMetadata.metadataOrNull(path);
        if (fileMetadata == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
        }
        return fileMetadata;
    }

    @ExperimentalFileSystem
    public static final boolean commonExists(@NotNull FileSystem $this$commonExists, @NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$commonExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return $this$commonExists.metadataOrNull(path) != null;
    }

    @ExperimentalFileSystem
    public static final void commonCreateDirectories(@NotNull FileSystem $this$commonCreateDirectories, @NotNull Path dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$commonCreateDirectories, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ArrayDeque directories = new ArrayDeque();
        for (Path path = dir; path != null && !$this$commonCreateDirectories.exists(path); path = path.parent()) {
            directories.addFirst((Object)path);
        }
        for (Path toCreate : directories) {
            $this$commonCreateDirectories.createDirectory(toCreate);
        }
    }

    @ExperimentalFileSystem
    public static final void commonCopy(@NotNull FileSystem $this$commonCopy, @NotNull Path source2, @NotNull Path target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$commonCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Closeable $this$use$iv = $this$commonCopy.source(source2);
        boolean $i$f$use = false;
        Long result$iv = null;
        Throwable thrown$iv = null;
        try {
            Source bytesIn = (Source)$this$use$iv;
            boolean bl = false;
            Closeable $this$use$iv2 = Okio.buffer($this$commonCopy.sink(target));
            boolean $i$f$use2 = false;
            Long result$iv2 = null;
            Throwable thrown$iv2 = null;
            try {
                BufferedSink bytesOut = (BufferedSink)$this$use$iv2;
                boolean bl2 = false;
                result$iv2 = bytesOut.writeAll(bytesIn);
            }
            catch (Throwable t$iv) {
                thrown$iv2 = t$iv;
            }
            try {
                Closeable t$iv = $this$use$iv2;
                if (t$iv != null) {
                    t$iv.close();
                }
            }
            catch (Throwable t$iv) {
                if (thrown$iv2 == null) {
                    thrown$iv2 = t$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv);
            }
            if (thrown$iv2 != null) {
                throw thrown$iv2;
            }
            Long l = result$iv2;
            Intrinsics.checkNotNull((Object)l);
            result$iv = ((Number)l).longValue();
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Intrinsics.checkNotNull(result$iv);
    }

    @ExperimentalFileSystem
    public static final void commonDeleteRecursively(@NotNull FileSystem $this$commonDeleteRecursively, @NotNull Path fileOrDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$commonDeleteRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
        ArrayDeque stack = new ArrayDeque();
        Collection collection = (Collection)stack;
        boolean bl = false;
        collection.add(fileOrDirectory);
        while (true) {
            List list;
            collection = (Collection)stack;
            bl = false;
            if (!(!collection.isEmpty())) break;
            Path toDelete = (Path)stack.removeLast();
            FileMetadata metadata = $this$commonDeleteRecursively.metadata(toDelete);
            if (metadata.isDirectory()) {
                list = $this$commonDeleteRecursively.list(toDelete);
            } else {
                boolean bl2 = false;
                list = CollectionsKt.emptyList();
            }
            List children = list;
            Collection collection2 = children;
            boolean bl3 = false;
            if (!collection2.isEmpty()) {
                collection2 = (Collection)stack;
                bl3 = false;
                collection2.add(toDelete);
                collection2 = (Collection)stack;
                bl3 = false;
                CollectionsKt.addAll((Collection)collection2, (Iterable)children);
                continue;
            }
            $this$commonDeleteRecursively.delete(toDelete);
        }
    }
}

