/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio;

import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.ByteString;
import com.apollographql.relocated.okio.ExperimentalFileSystem;
import com.apollographql.relocated.okio.internal._PathKt;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001#B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\rH\u0087\u0002\u00a2\u0006\u0002\b\u001aJ\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0002\b\u001aJ\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/apollographql/relocated/okio/Path;", "", "bytes", "Lcom/apollographql/relocated/okio/ByteString;", "(Lokio/ByteString;)V", "getBytes$okio", "()Lokio/ByteString;", "isAbsolute", "", "()Z", "isRelative", "isRoot", "name", "", "()Ljava/lang/String;", "nameBytes", "parent", "()Lokio/Path;", "volumeLetter", "", "()Ljava/lang/Character;", "compareTo", "", "other", "div", "child", "resolve", "equals", "", "hashCode", "toFile", "Ljava/io/File;", "toNioPath", "Ljava/nio/file/Path;", "toString", "Companion", "com.apollographql.relocated.okio"})
@ExperimentalFileSystem
public final class Path
implements Comparable<Path> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString bytes;
    @JvmField
    @NotNull
    public static final String DIRECTORY_SEPARATOR;

    public Path(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    @NotNull
    public final ByteString getBytes$okio() {
        return this.bytes;
    }

    public final boolean isAbsolute() {
        Path $this$commonIsAbsolute$iv = this;
        boolean $i$f$commonIsAbsolute = false;
        return $this$commonIsAbsolute$iv.getBytes$okio().startsWith(_PathKt.access$getSLASH$p()) || $this$commonIsAbsolute$iv.getBytes$okio().startsWith(_PathKt.access$getBACKSLASH$p()) || $this$commonIsAbsolute$iv.volumeLetter() != null && $this$commonIsAbsolute$iv.getBytes$okio().size() > 2 && $this$commonIsAbsolute$iv.getBytes$okio().getByte(2) == 92;
    }

    public final boolean isRelative() {
        Path $this$commonIsRelative$iv = this;
        boolean $i$f$commonIsRelative = false;
        return !$this$commonIsRelative$iv.isAbsolute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmName(name="volumeLetter")
    @Nullable
    public final Character volumeLetter() {
        Path $this$commonVolumeLetter$iv = this;
        boolean $i$f$commonVolumeLetter = false;
        if (ByteString.indexOf$default($this$commonVolumeLetter$iv.getBytes$okio(), _PathKt.access$getSLASH$p(), 0, 2, null) != -1) {
            return null;
        }
        if ($this$commonVolumeLetter$iv.getBytes$okio().size() < 2) {
            return null;
        }
        if ($this$commonVolumeLetter$iv.getBytes$okio().getByte(1) != 58) {
            return null;
        }
        char c$iv = (char)$this$commonVolumeLetter$iv.getBytes$okio().getByte(0);
        if (!('a' <= c$iv ? c$iv <= 'z' : false)) {
            if ('A' > c$iv) return null;
            if (c$iv > 'Z') return null;
            boolean bl = true;
            if (!bl) {
                return null;
            }
        }
        Character c = Character.valueOf(c$iv);
        return c;
    }

    @JvmName(name="nameBytes")
    @NotNull
    public final ByteString nameBytes() {
        Path $this$commonNameBytes$iv = this;
        boolean $i$f$commonNameBytes = false;
        int lastSlash$iv = _PathKt.access$getIndexOfLastSlash($this$commonNameBytes$iv);
        return lastSlash$iv != -1 ? ByteString.substring$default($this$commonNameBytes$iv.getBytes$okio(), lastSlash$iv + 1, 0, 2, null) : ($this$commonNameBytes$iv.volumeLetter() != null && $this$commonNameBytes$iv.getBytes$okio().size() == 2 ? ByteString.EMPTY : $this$commonNameBytes$iv.getBytes$okio());
    }

    @JvmName(name="name")
    @NotNull
    public final String name() {
        Path $this$commonName$iv = this;
        boolean $i$f$commonName = false;
        return $this$commonName$iv.nameBytes().utf8();
    }

    @JvmName(name="parent")
    @Nullable
    public final Path parent() {
        Object object;
        Path $this$commonParent$iv = this;
        boolean $i$f$commonParent = false;
        if (Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)_PathKt.access$getDOT$p()) || Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)_PathKt.access$getSLASH$p()) || Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)_PathKt.access$getBACKSLASH$p()) || _PathKt.access$lastSegmentIsDotDot($this$commonParent$iv)) {
            object = null;
        } else {
            int lastSlash$iv = _PathKt.access$getIndexOfLastSlash($this$commonParent$iv);
            object = lastSlash$iv == 2 && $this$commonParent$iv.volumeLetter() != null ? ($this$commonParent$iv.getBytes$okio().size() == 3 ? null : new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 3, 1, null))) : (lastSlash$iv == 1 && $this$commonParent$iv.getBytes$okio().startsWith(_PathKt.access$getBACKSLASH$p()) ? null : (lastSlash$iv == -1 && $this$commonParent$iv.volumeLetter() != null ? ($this$commonParent$iv.getBytes$okio().size() == 2 ? null : new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 2, 1, null))) : (lastSlash$iv == -1 ? new Path(_PathKt.access$getDOT$p()) : (lastSlash$iv == 0 ? new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 1, 1, null)) : new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, lastSlash$iv, 1, null))))));
        }
        return object;
    }

    public final boolean isRoot() {
        Path $this$commonIsRoot$iv = this;
        boolean $i$f$commonIsRoot = false;
        return $this$commonIsRoot$iv.parent() == null && $this$commonIsRoot$iv.isAbsolute();
    }

    @JvmName(name="resolve")
    @NotNull
    public final Path resolve(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path $this$commonResolve$iv = this;
        boolean $i$f$commonResolve = false;
        return $this$commonResolve$iv.resolve(_PathKt.toPath(new Buffer().writeUtf8(child)));
    }

    @JvmName(name="resolve")
    @NotNull
    public final Path resolve(@NotNull Path child) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path $this$commonResolve$iv = this;
        boolean $i$f$commonResolve = false;
        if (child.isAbsolute() || child.volumeLetter() != null) {
            path = child;
        } else {
            ByteString slash$iv = ByteString.indexOf$default($this$commonResolve$iv.getBytes$okio(), _PathKt.access$getSLASH$p(), 0, 2, null) != -1 ? _PathKt.access$getSLASH$p() : (ByteString.indexOf$default($this$commonResolve$iv.getBytes$okio(), _PathKt.access$getBACKSLASH$p(), 0, 2, null) != -1 ? _PathKt.access$getBACKSLASH$p() : (ByteString.indexOf$default(child.getBytes$okio(), _PathKt.access$getSLASH$p(), 0, 2, null) != -1 ? _PathKt.access$getSLASH$p() : (ByteString.indexOf$default(child.getBytes$okio(), _PathKt.access$getBACKSLASH$p(), 0, 2, null) != -1 ? _PathKt.access$getBACKSLASH$p() : _PathKt.access$toSlash(DIRECTORY_SEPARATOR))));
            Buffer buffer$iv = new Buffer();
            buffer$iv.write($this$commonResolve$iv.getBytes$okio());
            if (buffer$iv.size() > 0L) {
                buffer$iv.write(slash$iv);
            }
            buffer$iv.write(child.getBytes$okio());
            path = _PathKt.toPath(buffer$iv);
        }
        return path;
    }

    @NotNull
    public final File toFile() {
        return new File(this.toString());
    }

    @IgnoreJRERequirement
    @NotNull
    public final java.nio.file.Path toNioPath() {
        java.nio.file.Path path = Paths.get(this.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(toString())");
        return path;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path $this$commonCompareTo$iv = this;
        boolean $i$f$commonCompareTo = false;
        return $this$commonCompareTo$iv.getBytes$okio().compareTo(other.getBytes$okio());
    }

    public boolean equals(@Nullable Object other) {
        Path $this$commonEquals$iv = this;
        boolean $i$f$commonEquals = false;
        return other instanceof Path && Intrinsics.areEqual((Object)((Path)other).getBytes$okio(), (Object)$this$commonEquals$iv.getBytes$okio());
    }

    public int hashCode() {
        Path $this$commonHashCode$iv = this;
        boolean $i$f$commonHashCode = false;
        return $this$commonHashCode$iv.getBytes$okio().hashCode();
    }

    @NotNull
    public String toString() {
        Path $this$commonToString$iv = this;
        boolean $i$f$commonToString = false;
        return $this$commonToString$iv.getBytes$okio().utf8();
    }

    @JvmStatic
    @JvmName(name="get")
    @NotNull
    public static final Path get(@NotNull String $this$get) {
        return Companion.get($this$get);
    }

    @JvmStatic
    @JvmName(name="get")
    @NotNull
    public static final Path get(@NotNull File $this$get) {
        return Companion.get($this$get);
    }

    @JvmStatic
    @JvmName(name="get")
    @IgnoreJRERequirement
    @NotNull
    public static final Path get(@NotNull java.nio.file.Path $this$get) {
        return Companion.get($this$get);
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        DIRECTORY_SEPARATOR = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0007\u00a2\u0006\u0002\b\bJ\u0011\u0010\u0005\u001a\u00020\u0006*\u00020\tH\u0007\u00a2\u0006\u0002\b\bJ\u0011\u0010\n\u001a\u00020\u0006*\u00020\u0004H\u0007\u00a2\u0006\u0002\b\bR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/relocated/okio/Path$Companion;", "", "()V", "DIRECTORY_SEPARATOR", "", "toOkioPath", "Lcom/apollographql/relocated/okio/Path;", "Ljava/io/File;", "get", "Ljava/nio/file/Path;", "toPath", "com.apollographql.relocated.okio"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="get")
        @NotNull
        public final Path get(@NotNull String $this$toPath) {
            Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
            return _PathKt.commonToPath($this$toPath);
        }

        @JvmStatic
        @JvmName(name="get")
        @NotNull
        public final Path get(@NotNull File $this$toOkioPath) {
            Intrinsics.checkNotNullParameter((Object)$this$toOkioPath, (String)"<this>");
            String string = $this$toOkioPath.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            return this.get(string);
        }

        @JvmStatic
        @JvmName(name="get")
        @IgnoreJRERequirement
        @NotNull
        public final Path get(@NotNull java.nio.file.Path $this$toOkioPath) {
            Intrinsics.checkNotNullParameter((Object)$this$toOkioPath, (String)"<this>");
            return this.get(((Object)$this$toOkioPath).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

