/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio;

import com.apollographql.relocated.okio.BufferedSink;
import com.apollographql.relocated.okio.BufferedSource;
import com.apollographql.relocated.okio.ExperimentalFileSystem;
import com.apollographql.relocated.okio.FileHandle;
import com.apollographql.relocated.okio.FileMetadata;
import com.apollographql.relocated.okio.JvmSystemFileSystem;
import com.apollographql.relocated.okio.NioSystemFileSystem;
import com.apollographql.relocated.okio.Okio;
import com.apollographql.relocated.okio.Path;
import com.apollographql.relocated.okio.Sink;
import com.apollographql.relocated.okio.Source;
import com.apollographql.relocated.okio.internal.ResourceFileSystem;
import com.apollographql.relocated.okio.internal._FileSystemKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H&J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H&J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006H&J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H&J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000f\u001a\u00020\u0006H&J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0006J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\u0006H&J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H&J8\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\b#H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\t\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0006H&J8\u0010'\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\b#H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Lcom/apollographql/relocated/okio/FileSystem;", "", "()V", "appendingSink", "Lcom/apollographql/relocated/okio/Sink;", "file", "Lcom/apollographql/relocated/okio/Path;", "atomicMove", "", "source", "target", "canonicalize", "path", "copy", "createDirectories", "dir", "createDirectory", "delete", "deleteRecursively", "fileOrDirectory", "exists", "", "list", "", "metadata", "Lcom/apollographql/relocated/okio/FileMetadata;", "metadataOrNull", "openReadOnly", "Lcom/apollographql/relocated/okio/FileHandle;", "openReadWrite", "read", "T", "readerAction", "Lkotlin/Function1;", "Lcom/apollographql/relocated/okio/BufferedSource;", "Lkotlin/ExtensionFunctionType;", "(Lokio/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sink", "Lcom/apollographql/relocated/okio/Source;", "write", "writerAction", "Lcom/apollographql/relocated/okio/BufferedSink;", "Companion", "com.apollographql.relocated.okio"})
@ExperimentalFileSystem
public abstract class FileSystem {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public static final FileSystem SYSTEM;
    @JvmField
    @NotNull
    public static final Path SYSTEM_TEMPORARY_DIRECTORY;
    @JvmField
    @NotNull
    public static final FileSystem RESOURCES;

    @NotNull
    public abstract Path canonicalize(@NotNull Path var1) throws IOException;

    @NotNull
    public final FileMetadata metadata(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return _FileSystemKt.commonMetadata(this, path);
    }

    @Nullable
    public abstract FileMetadata metadataOrNull(@NotNull Path var1) throws IOException;

    public final boolean exists(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return _FileSystemKt.commonExists(this, path);
    }

    @NotNull
    public abstract List<Path> list(@NotNull Path var1) throws IOException;

    @NotNull
    public abstract FileHandle openReadOnly(@NotNull Path var1) throws IOException;

    @NotNull
    public abstract FileHandle openReadWrite(@NotNull Path var1) throws IOException;

    @NotNull
    public abstract Source source(@NotNull Path var1) throws IOException;

    public final <T> T read(@NotNull Path file, @NotNull Function1<? super BufferedSource, ? extends T> readerAction) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(readerAction, (String)"readerAction");
        boolean $i$f$read = false;
        Closeable $this$use$iv = Okio.buffer(this.source(file));
        boolean $i$f$use = false;
        Object result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSource it = (BufferedSource)$this$use$iv;
            boolean bl = false;
            result$iv = readerAction.invoke((Object)it);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Object object = result$iv;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @NotNull
    public abstract Sink sink(@NotNull Path var1) throws IOException;

    public final <T> T write(@NotNull Path file, @NotNull Function1<? super BufferedSink, ? extends T> writerAction) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(writerAction, (String)"writerAction");
        boolean $i$f$write = false;
        Closeable $this$use$iv = Okio.buffer(this.sink(file));
        boolean $i$f$use = false;
        Object result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSink it = (BufferedSink)$this$use$iv;
            boolean bl = false;
            result$iv = writerAction.invoke((Object)it);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Object object = result$iv;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @NotNull
    public abstract Sink appendingSink(@NotNull Path var1) throws IOException;

    public abstract void createDirectory(@NotNull Path var1) throws IOException;

    public final void createDirectories(@NotNull Path dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        _FileSystemKt.commonCreateDirectories(this, dir);
    }

    public abstract void atomicMove(@NotNull Path var1, @NotNull Path var2) throws IOException;

    public void copy(@NotNull Path source2, @NotNull Path target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        _FileSystemKt.commonCopy(this, source2, target);
    }

    public abstract void delete(@NotNull Path var1) throws IOException;

    public void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
        _FileSystemKt.commonDeleteRecursively(this, fileOrDirectory);
    }

    static {
        JvmSystemFileSystem jvmSystemFileSystem;
        Companion = new Companion(null);
        Object object = Companion;
        boolean bl = false;
        boolean bl2 = false;
        Companion $this$SYSTEM_u24lambda_u2d2 = object;
        boolean bl3 = false;
        try {
            Class.forName("java.nio.file.Files");
            jvmSystemFileSystem = new NioSystemFileSystem();
        }
        catch (ClassNotFoundException e) {
            jvmSystemFileSystem = new JvmSystemFileSystem();
        }
        SYSTEM = jvmSystemFileSystem;
        object = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(\"java.io.tmpdir\")");
        SYSTEM_TEMPORARY_DIRECTORY = Path.Companion.get((String)object);
        object = ResourceFileSystem.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ResourceFileSystem::class.java.classLoader");
        RESOURCES = new ResourceFileSystem((ClassLoader)object, false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/relocated/okio/FileSystem$Companion;", "", "()V", "RESOURCES", "Lcom/apollographql/relocated/okio/FileSystem;", "SYSTEM", "SYSTEM_TEMPORARY_DIRECTORY", "Lcom/apollographql/relocated/okio/Path;", "com.apollographql.relocated.okio"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

