/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.ast.ApiKt;
import com.apollographql.apollo3.ast.Check_key_fieldsKt;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.IssueKt;
import com.apollographql.apollo3.ast.ParseResult;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.transformation.Add_required_fieldsKt;
import com.apollographql.apollo3.compiler.CheckNoConditionalFragmentKt;
import com.apollographql.apollo3.compiler.CompilerMetadata;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.Options;
import com.apollographql.apollo3.compiler.PackageNameGenerator;
import com.apollographql.apollo3.compiler.codegen.ResolverInfo;
import com.apollographql.apollo3.compiler.codegen.java.JavaCodeGen;
import com.apollographql.apollo3.compiler.codegen.kotlin.KotlinCodeGen;
import com.apollographql.apollo3.compiler.ir.Ir;
import com.apollographql.apollo3.compiler.ir.IrBuilder;
import com.apollographql.apollo3.compiler.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.ir.IrOperation;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "()V", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "checkCustomScalars", "", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "customScalarsMapping", "", "", "write", "Lcom/apollographql/apollo3/compiler/CompilerMetadata;", "options", "Lcom/apollographql/apollo3/compiler/Options;", "Logger", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    public static final GraphQLCompiler INSTANCE = new GraphQLCompiler();
    @NotNull
    private static final Logger NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        }
    };

    private GraphQLCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerMetadata write(@NotNull Options options) {
        ResolverInfo resolverInfo;
        boolean bl;
        List list;
        Object $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        String string;
        void $this$mapTo$iv$iv222;
        Iterable it;
        Object object;
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Object element$iv2;
        Object it2;
        Iterator $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv5;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Set<File> executableFiles = options.getExecutableFiles();
        File outputDir = options.getOutputDir();
        File testDir = options.getTestDir();
        File debugDir = options.getDebugDir();
        Schema schema = options.getSchema();
        if (Intrinsics.areEqual((Object)options.getTargetLanguage(), (Object)"java") && !Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"operationBased")) {
            String string2 = "Java codegen does not support " + options.getCodegenModels() + ". Only operationBased is supported.";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (Intrinsics.areEqual((Object)options.getTargetLanguage(), (Object)"java") && !options.getFlattenModels()) {
            String string3 = "Java codegen does not support nested models as it could trigger name clashes when a nested class has the same name as an enclosing one.";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        this.checkCustomScalars(schema, options.getCustomScalarsMapping());
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl4 = file == null ? null : Boolean.valueOf(FilesKt.deleteRecursively((File)file));
        file = debugDir;
        Boolean bl5 = file == null ? null : Boolean.valueOf(file.mkdirs());
        boolean bl6 = false;
        List definitions = new ArrayList();
        boolean bl7 = false;
        List parseIssues = new ArrayList();
        Iterable $this$map$iv3 = executableFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            boolean bl8;
            void file2;
            File file3 = (File)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl9 = false;
            ParseResult<GQLDocument> parseResult = ApiKt.parseAsGQLDocument((File)file2);
            if (parseResult instanceof ParseResult.Success) {
                bl8 = definitions.addAll((Collection)((GQLDocument)((ParseResult.Success)parseResult).getValue()).getDefinitions());
            } else if (parseResult instanceof ParseResult.Error) {
                bl8 = parseIssues.addAll((Collection)((ParseResult.Error)parseResult).getIssues());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object2 = bl8;
            object3.add(object2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IssueKt.checkNoErrors(parseIssues);
        Iterable $this$flatMap$iv = options.getIncomingCompilerMetadata();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerMetadata it3 = (CompilerMetadata)element$iv$iv;
            boolean bl10 = false;
            Iterable list$iv$iv = it3.getFragments();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List incomingFragments = (List)destination$iv$iv2;
        List<Issue> validationIssues = ApiKt.validateAsExecutable(new GQLDocument(CollectionsKt.plus((Collection)definitions, (Iterable)incomingFragments), null), options.getSchema());
        IssueKt.checkNoErrors(validationIssues);
        if (Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"responseBased")) {
            IssueKt.checkNoErrors(CheckNoConditionalFragmentKt.findConditionalFragments(definitions));
        }
        Iterable $this$filter$iv = validationIssues;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator list$iv$iv = $this$filterTo$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv = list$iv$iv.next();
            it2 = (Issue)element$iv$iv;
            boolean bl11 = false;
            if (!(((Issue)it2).getSeverity() == Issue.Severity.WARNING && (!(it2 instanceof Issue.DeprecatedUsage) || options.getWarnOnDeprecatedUsages()))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List warnings = (List)destination$iv$iv3;
        Iterable $this$forEach$iv = warnings;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Issue it4 = (Issue)element$iv2;
            boolean bl12 = false;
            options.getLogger().warning("w: " + it4.getSourceLocation().pretty() + ": ApolloGraphQL: " + it4.getMessage());
        }
        if (options.getFailOnWarnings()) {
            $this$forEach$iv = warnings;
            $i$f$forEach = false;
            if (!$this$forEach$iv.isEmpty()) {
                throw new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
            }
        }
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        element$iv2 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv4;
        boolean $i$f$map2 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it5;
            GQLFragmentDefinition bl11 = (GQLFragmentDefinition)item$iv$iv;
            object3 = destination$iv$iv4;
            boolean bl13 = false;
            object2 = Add_required_fieldsKt.addRequiredFields((GQLFragmentDefinition)it5, options.getSchema());
            object3.add(object2);
        }
        List fragments = (List)destination$iv$iv4;
        Iterable $this$filterIsInstance$iv2 = definitions;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv4 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv5;
        boolean $i$f$map3 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it6;
            GQLOperationDefinition bl13 = (GQLOperationDefinition)item$iv$iv;
            object3 = destination$iv$iv5;
            boolean bl14 = false;
            object2 = Add_required_fieldsKt.addRequiredFields((GQLOperationDefinition)it6, options.getSchema());
            object3.add(object2);
        }
        List operations = (List)destination$iv$iv5;
        Iterable $this$associateBy$iv = CollectionsKt.plus((Collection)fragments, (Iterable)incomingFragments);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo222 = $this$associateBy$iv;
        Map destination$iv$iv6 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            object = (GQLFragmentDefinition)element$iv$iv;
            object3 = destination$iv$iv6;
            boolean bl15 = false;
            object2 = ((GQLFragmentDefinition)((Object)it)).getName();
            object3.put(object2, element$iv$iv);
        }
        Map allFragmentDefinitions = destination$iv$iv6;
        Iterable $this$forEach$iv2 = operations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            it2 = (GQLOperationDefinition)element$iv3;
            boolean bl16 = false;
            Check_key_fieldsKt.checkKeyFields((GQLOperationDefinition)it2, options.getSchema(), (Map<String, GQLFragmentDefinition>)allFragmentDefinitions);
        }
        $this$forEach$iv2 = fragments;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            it2 = (GQLFragmentDefinition)element$iv3;
            boolean bl17 = false;
            Check_key_fieldsKt.checkKeyFields((GQLFragmentDefinition)it2, options.getSchema(), (Map<String, GQLFragmentDefinition>)allFragmentDefinitions);
        }
        Set alwaysGenerateTypesMatching = options.getAlwaysGenerateTypesMatching();
        if (options.getGenerateSchema()) {
            alwaysGenerateTypesMatching = SetsKt.plus(alwaysGenerateTypesMatching, (Object)".*");
        }
        Ir ir = new IrBuilder(options.getSchema(), operations, options.getGenerateTestBuilders(), fragments, allFragmentDefinitions, alwaysGenerateTypesMatching, options.getCustomScalarsMapping(), options.getCodegenModels(), options.getGenerateOptionalOperationVariables()).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Iterable $this$map$iv2222 = ir.getOperations();
        boolean $i$f$map4 = false;
        Iterable bl17 = $this$map$iv2222;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2222, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            void it7;
            IrOperation irOperation = (IrOperation)item$iv$iv;
            object3 = destination$iv$iv7;
            boolean bl18 = false;
            object2 = new OperationDescriptor(it7.getName(), QueryDocumentMinifier.minify(it7.getSourceWithFragments()));
            object3.add(object2);
        }
        $this$map$iv2222 = (List)destination$iv$iv7;
        $i$f$map4 = false;
        boolean $this$mapTo$iv$iv222 = false;
        Iterable it6 = $this$map$iv2222;
        boolean bl192 = false;
        Map<String, OperationDescriptor> operationOutput = options.getOperationOutputGenerator().generate((Collection)it6);
        boolean $this$map$iv2222 = operationOutput.size() == operations.size();
        $i$f$map4 = false;
        $this$mapTo$iv$iv222 = false;
        if (!$this$map$iv2222) {
            boolean bl20 = false;
            String $this$mapTo$iv$iv222 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv222.toString());
        }
        if (options.getOperationOutputFile() != null) {
            void $this$toJson$iv;
            File file4 = options.getOperationOutputFile();
            Map<String, OperationDescriptor> $this$map$iv2222 = operationOutput;
            String indent$iv = "  ";
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            String bl192 = MoshiKt.getMOSHI().adapter(Map.class).indent(indent$iv).toJson((Map)$this$toJson$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl192, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
            FilesKt.writeText$default((File)file4, (String)bl192, null, (int)2, null);
        }
        if (Intrinsics.areEqual((Object)(string = options.getTargetLanguage()), (Object)"kotlin")) {
            boolean bl21;
            Iterable $this$map$iv322 = options.getIncomingCompilerMetadata();
            boolean $i$f$map5 = false;
            it = $this$map$iv322;
            Object destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv322, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it8;
                Object item$iv$iv = iterator.next();
                CompilerMetadata compilerMetadata = (CompilerMetadata)item$iv$iv;
                object3 = destination$iv$iv8;
                bl21 = false;
                object2 = it8.getResolverInfo();
                object3.add(object2);
            }
            list = (List)destination$iv$iv8;
            boolean $this$map$iv322 = options.getGenerateAsInternal();
            $i$f$map5 = options.getUseSemanticNaming();
            $this$mapTo$iv$iv = options.getPackageNameGenerator();
            destination$iv$iv8 = options.getSchemaPackageName();
            $i$f$mapTo = options.getGenerateFilterNotNull();
            bl = options.getGenerateFragmentImplementations();
            boolean item$iv$iv = options.getGenerateQueryDocument();
            boolean it8 = options.getGenerateSchema();
            bl21 = options.getGenerateTestBuilders();
            boolean bl22 = options.getFlattenModels();
            boolean bl23 = !Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"compat");
            List<String> list2 = options.getSealedClassesForEnumsMatching();
            resolverInfo = new KotlinCodeGen(ir, list, $this$map$iv322, $i$f$map5, (PackageNameGenerator)$this$mapTo$iv$iv, (String)destination$iv$iv8, operationOutput, $i$f$mapTo, bl, item$iv$iv, it8, bl21, bl22, bl23, list2).write(outputDir, testDir);
        } else if (Intrinsics.areEqual((Object)string, (Object)"java")) {
            Iterable $this$map$iv4 = options.getIncomingCompilerMetadata();
            boolean $i$f$map6 = false;
            $this$mapTo$iv$iv = $this$map$iv4;
            Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                CompilerMetadata it8 = (CompilerMetadata)item$iv$iv;
                object3 = destination$iv$iv9;
                boolean bl24 = false;
                object2 = it8.getResolverInfo();
                object3.add(object2);
            }
            list = (List)destination$iv$iv9;
            boolean bl25 = options.getUseSemanticNaming();
            PackageNameGenerator packageNameGenerator = options.getPackageNameGenerator();
            object = options.getSchemaPackageName();
            boolean bl26 = options.getGenerateFragmentImplementations();
            boolean bl27 = options.getGenerateQueryDocument();
            bl = options.getGenerateSchema();
            boolean bl28 = options.getFlattenModels();
            resolverInfo = new JavaCodeGen(ir, list, bl25, packageNameGenerator, (String)object, operationOutput, bl26, bl27, bl, bl28, true).write(outputDir);
        } else {
            String string4 = Intrinsics.stringPlus((String)"Target language not supported: ", (Object)options.getTargetLanguage());
            boolean bl29 = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        ResolverInfo outputResolverInfo = resolverInfo;
        return new CompilerMetadata(fragments, outputResolverInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(Schema schema, Map<String, String> customScalarsMapping) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GQLScalarTypeDefinition it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = schema.getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLScalarTypeDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBuiltIn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            it = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = type.getName();
            collection.add(string);
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)customScalarsMapping.keySet(), (Iterable)schemaScalars);
        boolean bl = unknownScalars.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"ApolloGraphQL: unknown custom scalar(s) in customScalarsMapping: ", (Object)CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Logger getNoOpLogger() {
        return NoOpLogger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }
}

