/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchema;
import com.apollographql.apollo3.ast.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.ast.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.ast.introspection.Schema_to_introspectionKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0010H\u0007J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloConvertSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "from", "Lorg/gradle/api/provider/Property;", "", "getFrom", "()Lorg/gradle/api/provider/Property;", "projectRootDir", "getProjectRootDir", "()Ljava/lang/String;", "setProjectRootDir", "(Ljava/lang/String;)V", "to", "getTo", "convert", "", "Ljava/io/File;", "taskAction", "isIntrospection", "", "apollo-gradle-plugin-external"})
public abstract class ApolloConvertSchemaTask
extends DefaultTask {
    public ApolloConvertSchemaTask() {
        this.getOutputs().upToDateWhen(arg_0 -> ApolloConvertSchemaTask._init_$lambda$0(1.INSTANCE, arg_0));
        this.getOutputs().cacheIf(arg_0 -> ApolloConvertSchemaTask._init_$lambda$1(2.INSTANCE, arg_0));
    }

    @Input
    @Option(option="from", description="schema to convert from")
    @NotNull
    public abstract Property<String> getFrom();

    @Input
    @Option(option="to", description="schema to convert to")
    @NotNull
    public abstract Property<String> getTo();

    @Internal
    @NotNull
    public abstract String getProjectRootDir();

    public abstract void setProjectRootDir(@NotNull String var1);

    private final boolean isIntrospection(File $this$isIntrospection) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isIntrospection), (Object)"json");
    }

    public final void convert(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(this.isIntrospection(from) && !this.isIntrospection(to) || !this.isIntrospection(from) && this.isIntrospection(to))) {
            boolean bl = false;
            String string = "Cannot convert from " + from.getName() + " to " + to.getName() + ", they are already the same format";
            throw new IllegalStateException(string.toString());
        }
        if (this.isIntrospection(from)) {
            GqlnodeKt.toUtf8$default((GQLNode)((GQLNode)Introspection_to_schemaKt.toGQLDocument$default((IntrospectionSchema)IntrospectionSchemaKt.toIntrospectionSchema((File)from), null, (int)1, null)), (File)to, null, (int)2, null);
        } else {
            IntrospectionSchemaKt.writeTo((IntrospectionSchema)Schema_to_introspectionKt.toIntrospectionSchema((Schema)Introspection_to_schemaKt.toSchema((File)from)), (File)to);
        }
    }

    @TaskAction
    public final void taskAction() {
        File file = new File(this.getProjectRootDir());
        Object object = this.getFrom().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"from.get()");
        File file2 = FilesKt.resolve((File)file, (String)((String)object));
        File file3 = new File(this.getProjectRootDir());
        Object object2 = this.getTo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"to.get()");
        this.convert(file2, FilesKt.resolve((File)file3, (String)((String)object2)));
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

