/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.compiler.TargetLanguage;
import com.apollographql.apollo3.gradle.api.KotlinProjectKt;
import com.apollographql.apollo3.gradle.api.Service;
import com.apollographql.apollo3.gradle.internal.DefaultApolloExtension;
import com.apollographql.apollo3.gradle.internal.DefaultService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBinary;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0011"}, d2={"checkKotlinPluginVersion", "", "project", "Lorg/gradle/api/Project;", "createAllKotlinSourceSetServices", "apolloExtension", "Lcom/apollographql/apollo3/gradle/internal/DefaultApolloExtension;", "sourceFolder", "", "nameSuffix", "action", "Lorg/gradle/api/Action;", "Lcom/apollographql/apollo3/gradle/api/Service;", "getKotlinTargetLanguage", "Lcom/apollographql/apollo3/compiler/TargetLanguage;", "userSpecified", "linkSqlite", "apollo-gradle-plugin-external"})
@SourceDebugExtension(value={"SMAP\nKotlinPluginFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPluginFacade.kt\ncom/apollographql/apollo3/gradle/internal/KotlinPluginFacadeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n800#2,11:80\n1360#2:91\n1446#2,5:92\n1851#2,2:97\n1549#2:99\n1620#2,3:100\n1851#2,2:103\n*S KotlinDebug\n*F\n+ 1 KotlinPluginFacade.kt\ncom/apollographql/apollo3/gradle/internal/KotlinPluginFacadeKt\n*L\n36#1:80,11\n37#1:91\n37#1:92,5\n38#1:97,2\n45#1:99\n45#1:100,3\n64#1:103,2\n*E\n"})
public final class KotlinPluginFacadeKt {
    @NotNull
    public static final TargetLanguage getKotlinTargetLanguage(@Nullable String userSpecified) {
        TargetLanguage targetLanguage;
        String string = userSpecified;
        if (Intrinsics.areEqual((Object)string, (Object)"1.4")) {
            targetLanguage = TargetLanguage.KOTLIN_1_4;
        } else if (Intrinsics.areEqual((Object)string, (Object)"1.5")) {
            targetLanguage = TargetLanguage.KOTLIN_1_5;
        } else if (string == null) {
            targetLanguage = TargetLanguage.KOTLIN_1_5;
        } else {
            throw new IllegalStateException(("Apollo: languageVersion '" + userSpecified + "' is not supported, must be either '1.4' or '1.5'").toString());
        }
        return targetLanguage;
    }

    /*
     * WARNING - void declaration
     */
    public static final void linkSqlite(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinMultiplatformExtension kotlinMultiplatformExtension = KotlinProjectKt.getKotlinMultiplatformExtension(project);
        if (kotlinMultiplatformExtension == null) {
            return;
        }
        KotlinMultiplatformExtension extension = kotlinMultiplatformExtension;
        Iterable $this$filterIsInstance$iv = (Iterable)extension.getTargets();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinNativeTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KotlinNativeTarget it = (KotlinNativeTarget)element$iv$iv;
            boolean bl = false;
            KotlinNativeBinaryContainer kotlinNativeBinaryContainer = it.getBinaries();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinNativeBinaryContainer, (String)"it.binaries");
            Iterable list$iv$iv = (Iterable)kotlinNativeBinaryContainer;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NativeBinary it = (NativeBinary)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-lsqlite3"};
            it.linkerOpts(stringArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkKotlinPluginVersion(@NotNull Project project) {
        boolean isKotlinSupported;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = KotlinPluginWrapperKt.getKotlinPluginVersion((Project)project);
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt((String)it));
        }
        List version = (List)destination$iv$iv;
        boolean bl = ((Number)version.get(0)).intValue() > 1 ? true : (((Number)version.get(0)).intValue() == 1 ? ((Number)version.get(1)).intValue() >= 5 : (isKotlinSupported = false));
        if (!isKotlinSupported) {
            boolean bl2 = false;
            String string3 = "Apollo Kotlin requires Kotlin plugin version 1.5 or more (found '" + KotlinPluginWrapperKt.getKotlinPluginVersion((Project)project) + "')";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    public static final void createAllKotlinSourceSetServices(@NotNull DefaultApolloExtension apolloExtension, @NotNull Project project, @NotNull String sourceFolder, @NotNull String nameSuffix, @NotNull Action<Service> action) {
        Intrinsics.checkNotNullParameter((Object)apolloExtension, (String)"apolloExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = (Iterable)KotlinProjectKt.getKotlinProjectExtensionOrThrow(project).getSourceSets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)element$iv;
            boolean bl = false;
            String name = kotlinSourceSet.getName() + com.apollographql.apollo3.compiler.StringsKt.capitalizeFirstLetter((String)nameSuffix);
            apolloExtension.service(name, (Action<Service>)((Action)arg_0 -> KotlinPluginFacadeKt.createAllKotlinSourceSetServices$lambda$7$lambda$6(action, kotlinSourceSet, sourceFolder, arg_0)));
        }
    }

    private static final void createAllKotlinSourceSetServices$lambda$7$lambda$6$lambda$5(KotlinSourceSet $kotlinSourceSet, Service.DirectoryConnection connection) {
        $kotlinSourceSet.getKotlin().srcDir(connection.getOutputDir());
    }

    private static final void createAllKotlinSourceSetServices$lambda$7$lambda$6(Action $action, KotlinSourceSet $kotlinSourceSet, String $sourceFolder, Service service) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)$sourceFolder, (String)"$sourceFolder");
        $action.execute((Object)service);
        if (!(!service.getSourceFolder().isPresent())) {
            boolean bl = false;
            String string = "Apollo: service.sourceFolder is not used when calling createAllKotlinJvmSourceSetServices. Use the parameter instead";
            throw new IllegalStateException(string.toString());
        }
        service.srcDir("src/" + $kotlinSourceSet.getName() + "/graphql/" + $sourceFolder);
        Intrinsics.checkNotNull((Object)service, (String)"null cannot be cast to non-null type com.apollographql.apollo3.gradle.internal.DefaultService");
        ((DefaultService)service).setOutputDirAction((Action<? super Service.DirectoryConnection>)((Action)arg_0 -> KotlinPluginFacadeKt.createAllKotlinSourceSetServices$lambda$7$lambda$6$lambda$5($kotlinSourceSet, arg_0)));
    }
}

