/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.gradle.internal.ApolloPlugin;
import com.apollographql.apollo3.tooling.SchemaDownloader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0007J\u001e\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050$*\b\u0012\u0004\u0012\u00020\u00050\rH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u001a\u0010\u0018\u001a\u00020\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007\u00a8\u0006%"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloDownloadSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "graph", "getGraph", "graphVariant", "getGraphVariant", "<set-?>", "", "header", "getHeader", "()Ljava/util/List;", "setHeader", "(Ljava/util/List;)V", "insecure", "", "getInsecure", "key", "getKey", "projectRootDir", "getProjectRootDir", "()Ljava/lang/String;", "setProjectRootDir", "(Ljava/lang/String;)V", "registryUrl", "getRegistryUrl", "schema", "getSchema", "taskAction", "", "toMap", "", "apollo-gradle-plugin-external"})
public abstract class ApolloDownloadSchemaTask
extends DefaultTask {
    @NotNull
    private List<String> header = CollectionsKt.emptyList();

    public ApolloDownloadSchemaTask() {
        this.getOutputs().upToDateWhen(ApolloDownloadSchemaTask::_init_$lambda-0);
        this.getOutputs().cacheIf(ApolloDownloadSchemaTask::_init_$lambda-1);
    }

    @Optional
    @Input
    @Option(option="endpoint", description="url of the GraphQL endpoint for introspection.")
    @NotNull
    public abstract Property<String> getEndpoint();

    @Optional
    @Input
    @Option(option="graph", description="[Apollo Studio users only] The identifier of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraph();

    @Optional
    @Input
    @Option(option="key", description="[Apollo Studio users only] The Apollo API key. See https://www.apollographql.com/docs/studio/api-keys/ for more information on how to get your API key.")
    @NotNull
    public abstract Property<String> getKey();

    @Optional
    @Input
    @Option(option="graphVariant", description="[Apollo Studio users only] The variant of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraphVariant();

    @Optional
    @Input
    @Option(option="registryUrl", description="[Apollo Studio users only] The registry url of the registry instance used to download the schema. Defaults to \"https://graphql.api.apollographql.com/api/graphql\"")
    @NotNull
    public abstract Property<String> getRegistryUrl();

    @Input
    @Option(option="schema", description="path where the schema will be downloaded, relative to the root project directory")
    @NotNull
    public abstract Property<String> getSchema();

    @Internal
    @NotNull
    public abstract String getProjectRootDir();

    public abstract void setProjectRootDir(@NotNull String var1);

    @Optional
    @Input
    @NotNull
    public final List<String> getHeader() {
        return this.header;
    }

    @Option(option="header", description="HTTP headers in the form 'Name: Value'")
    public final void setHeader(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.header = list;
    }

    @Optional
    @Input
    @Option(option="insecure", description="if set to true, TLS/SSL certificates will not be checked when downloading")
    @NotNull
    public abstract Property<Boolean> getInsecure();

    @TaskAction
    public final void taskAction() {
        File file = new File(this.getProjectRootDir());
        Object object = this.getSchema().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"schema.get()");
        File schemaFile = FilesKt.resolve((File)file, (String)((String)object));
        SchemaDownloader schemaDownloader = SchemaDownloader.INSTANCE;
        String string = (String)this.getEndpoint().getOrNull();
        String string2 = (String)this.getGraph().getOrNull();
        String string3 = (String)this.getGraphVariant().getOrElse((Object)"current");
        String string4 = (String)this.getKey().getOrNull();
        String string5 = (String)this.getRegistryUrl().getOrElse((Object)"https://graphql.api.apollographql.com/api/graphql");
        Boolean bl = (Boolean)this.getInsecure().getOrElse((Object)false);
        Map map = MapsKt.plus(this.toMap(this.header), ApolloPlugin.Companion.getExtraHeaders$apollo_gradle_plugin_external());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getOrElse(\"current\")");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getOrElse(\"https://graph\u2026graphql.com/api/graphql\")");
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOrElse(false)");
        schemaDownloader.download(string, string2, string4, string3, string5, schemaFile, bl.booleanValue(), map);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> toMap(List<String> $this$toMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMap;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)':', (int)0, (boolean)false, (int)6, null);
            if (!(index > 0 && index < it.length() - 1)) {
                boolean bl2 = false;
                String string2 = "header should be in the form 'Name: Value'";
                throw new IllegalStateException(string2.toString());
            }
            String string3 = it.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            String string5 = it.substring(index + 1, it.length());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(TuplesKt.to((Object)string4, (Object)((Object)StringsKt.trim((CharSequence)string5)).toString()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final boolean _init_$lambda-0(Task it) {
        return false;
    }

    private static final boolean _init_$lambda-1(Task it) {
        return false;
    }
}

