/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo3.ast.GqldirectiveKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.codegen.CodegenLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"directives", "", "Lcom/apollographql/apollo3/ast/GQLDirective;", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "getDirectives", "(Lcom/apollographql/apollo3/ast/GQLTypeDefinition;)Ljava/util/List;", "checkApolloTargetNameClashes", "Lcom/apollographql/apollo3/ast/Issue;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "apollo-compiler"})
@JvmName(name="-checkApolloDuplicateTargetNames")
public final class -checkApolloDuplicateTargetNames {
    @NotNull
    public static final List<Issue> checkApolloTargetNameClashes(@NotNull Schema schema) {
        String it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        List issues = new ArrayList();
        Iterable $this$sortedBy$iv = schema.getTypeDefinitions().values();
        boolean $i$f$sortedBy = false;
        Iterable $this$associateWith$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GQLTypeDefinition it = (GQLTypeDefinition)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (GQLTypeDefinition)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            GQLTypeDefinition gQLTypeDefinition = (GQLTypeDefinition)t;
            Object t2 = t;
            Map map = result$iv;
            bl = false;
            String string = GqldirectiveKt.findTargetName(-checkApolloDuplicateTargetNames.getDirectives((GQLTypeDefinition)it), (Schema)schema);
            map.put(t2, string);
        }
        Map typesWithTargetName = result$iv;
        Map usedNames = new LinkedHashMap();
        Map $this$filterValues$iv = typesWithTargetName;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (String)entry.getValue();
            bl = false;
            if (!(it == null)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        Iterator iterator = ((Map)result$iv2).entrySet().iterator();
        while (iterator.hasNext()) {
            GQLTypeDefinition type = (GQLTypeDefinition)iterator.next().getKey();
            String name = CodegenLayout.Companion.uniqueName$apollo_compiler(type.getName(), CollectionsKt.toSet((Iterable)usedNames.keySet()));
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            usedNames.put(string, type);
        }
        $this$filterValues$iv = typesWithTargetName;
        $i$f$filterValues = false;
        LinkedHashMap result$iv3 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (String)entry.getValue();
            bl = false;
            if (!(it != null)) continue;
            result$iv3.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : ((Map)result$iv3).entrySet()) {
            String name;
            String targetName;
            GQLTypeDefinition type = (GQLTypeDefinition)entry.getKey();
            String string = targetName = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (usedNames.containsKey(name)) {
                Object v = usedNames.get(name);
                Intrinsics.checkNotNull(v);
                GQLTypeDefinition gQLTypeDefinition = (GQLTypeDefinition)v;
                issues.add(new Issue.ReservedEnumValueName('\'' + targetName + "' cannot be used as a target name for '" + type.getName() + "' because it clashes with '" + gQLTypeDefinition.getName() + "' defined at " + gQLTypeDefinition.getSourceLocation().pretty(), type.getSourceLocation()));
                continue;
            }
            usedNames.put(name, type);
        }
        return issues;
    }

    private static final List<GQLDirective> getDirectives(GQLTypeDefinition $this$directives) {
        List list;
        GQLTypeDefinition gQLTypeDefinition = $this$directives;
        if (gQLTypeDefinition instanceof GQLEnumTypeDefinition) {
            list = ((GQLEnumTypeDefinition)$this$directives).getDirectives();
        } else if (gQLTypeDefinition instanceof GQLInputObjectTypeDefinition) {
            list = ((GQLInputObjectTypeDefinition)$this$directives).getDirectives();
        } else if (gQLTypeDefinition instanceof GQLInterfaceTypeDefinition) {
            list = ((GQLInterfaceTypeDefinition)$this$directives).getDirectives();
        } else if (gQLTypeDefinition instanceof GQLObjectTypeDefinition) {
            list = ((GQLObjectTypeDefinition)$this$directives).getDirectives();
        } else if (gQLTypeDefinition instanceof GQLScalarTypeDefinition) {
            list = ((GQLScalarTypeDefinition)$this$directives).getDirectives();
        } else if (gQLTypeDefinition instanceof GQLUnionTypeDefinition) {
            list = ((GQLUnionTypeDefinition)$this$directives).getDirectives();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }
}

