/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.Check_key_fieldsKt;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLResult;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.IssueKt;
import com.apollographql.apollo3.ast.QueryDocumentMinifier;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.transformation.Add_required_fieldsKt;
import com.apollographql.apollo3.compiler.-checkApolloDuplicateTargetNames;
import com.apollographql.apollo3.compiler.-checkApolloReservedEnumValueNames;
import com.apollographql.apollo3.compiler.-checkCapitalizedFields;
import com.apollographql.apollo3.compiler.CheckConditionalFragmentKt;
import com.apollographql.apollo3.compiler.CompilerMetadata;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.Options;
import com.apollographql.apollo3.compiler.PackageNameGenerator;
import com.apollographql.apollo3.compiler.ScalarInfo;
import com.apollographql.apollo3.compiler.TargetLanguage;
import com.apollographql.apollo3.compiler.codegen.ResolverInfo;
import com.apollographql.apollo3.compiler.codegen.java.JavaCodeGen;
import com.apollographql.apollo3.compiler.codegen.kotlin.KotlinCodeGen;
import com.apollographql.apollo3.compiler.ir.Ir;
import com.apollographql.apollo3.compiler.ir.IrBuilder;
import com.apollographql.apollo3.compiler.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.ir.IrOperation;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/compiler/ApolloCompiler;", "", "()V", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "checkCustomScalars", "", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "scalarMapping", "", "", "Lcom/apollographql/apollo3/compiler/ScalarInfo;", "write", "Lcom/apollographql/apollo3/compiler/CompilerMetadata;", "options", "Lcom/apollographql/apollo3/compiler/Options;", "Logger", "apollo-compiler"})
@ApolloExperimental
public final class ApolloCompiler {
    @NotNull
    public static final ApolloCompiler INSTANCE = new ApolloCompiler();
    @NotNull
    private static final Logger NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        }
    };

    private ApolloCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerMetadata write(@NotNull Options options) {
        ResolverInfo resolverInfo;
        Object object;
        boolean bl;
        List list;
        Object $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv22;
        Object object2;
        void $this$mapTo$iv$iv2;
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        GQLFragmentDefinition it;
        Iterable $this$associateByTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Object element$iv2;
        Iterator $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object3;
        void $this$mapTo$iv$iv5;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set<File> executableFiles = options.getExecutableFiles();
        File outputDir = options.getOutputDir();
        File testDir = options.getTestDir();
        File debugDir = options.getDebugDir();
        Schema schema = options.getSchema();
        if (options.getTargetLanguage() == TargetLanguage.JAVA && !Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"operationBased")) {
            throw new IllegalStateException(("Java codegen does not support " + options.getCodegenModels() + ". Only operationBased is supported.").toString());
        }
        if (options.getTargetLanguage() == TargetLanguage.JAVA && !options.getFlattenModels()) {
            throw new IllegalStateException("Java codegen does not support nested models as it could trigger name clashes when a nested class has the same name as an enclosing one.".toString());
        }
        this.checkCustomScalars(schema, options.getScalarMapping());
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl2 = file != null ? Boolean.valueOf(FilesKt.deleteRecursively((File)file)) : null;
        File file2 = debugDir;
        Boolean bl3 = file2 != null ? Boolean.valueOf(file2.mkdirs()) : null;
        FilesKt.deleteRecursively((File)testDir);
        testDir.mkdirs();
        List definitions = new ArrayList();
        List parseIssues = new ArrayList();
        Iterable $this$map$iv3 = executableFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            boolean bl4;
            void file3;
            File file4 = (File)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl5 = false;
            GQLResult parseResult = ApolloParser.parseAsGQLDocument((BufferedSource)Okio.buffer((Source)Okio.source((File)file3)), (String)file3.getPath());
            if (!((Collection)parseResult.getIssues()).isEmpty()) {
                bl4 = parseIssues.addAll(parseResult.getIssues());
            } else {
                Object object4 = parseResult.getValue();
                Intrinsics.checkNotNull((Object)object4);
                bl4 = definitions.addAll(((GQLDocument)object4).getDefinitions());
            }
            object3.add(bl4);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IssueKt.checkNoErrors((List)parseIssues);
        Iterable $this$flatMap$iv = options.getIncomingCompilerMetadata();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerMetadata it2 = (CompilerMetadata)element$iv$iv;
            boolean bl6 = false;
            Iterable list$iv$iv = it2.getFragments();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List incomingFragments = (List)destination$iv$iv3;
        GQLResult validationResult = ApolloParser.validateAsExecutable((GQLDocument)new GQLDocument(CollectionsKt.plus((Collection)definitions, (Iterable)incomingFragments), null), (Schema)options.getSchema());
        IssueKt.checkNoErrors((List)validationResult.getIssues());
        if (Intrinsics.areEqual((Object)options.getCodegenModels(), (Object)"responseBased")) {
            IssueKt.checkNoErrors(CheckConditionalFragmentKt.checkConditionalFragments(definitions));
        }
        IssueKt.checkNoErrors(-checkApolloReservedEnumValueNames.checkApolloReservedEnumValueNames(schema));
        IssueKt.checkNoErrors(-checkApolloDuplicateTargetNames.checkApolloTargetNameClashes(schema));
        if (!options.getFlattenModels()) {
            IssueKt.checkNoErrors(-checkCapitalizedFields.checkCapitalizedFields(definitions));
        }
        Iterable $this$filter$iv = validationResult.getIssues();
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator list$iv$iv = $this$filterTo$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv = list$iv$iv.next();
            Issue it3 = (Issue)element$iv$iv;
            boolean bl7 = false;
            if (!(it3.getSeverity() == Issue.Severity.WARNING && (!(it3 instanceof Issue.DeprecatedUsage) || options.getWarnOnDeprecatedUsages()))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List warnings = (List)destination$iv$iv4;
        Iterable $this$forEach$iv = warnings;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Issue it4 = (Issue)element$iv2;
            boolean bl8 = false;
            options.getLogger().warning("w: " + it4.getSourceLocation().pretty() + ": Apollo: " + it4.getMessage());
        }
        if (options.getFailOnWarnings() && !((Collection)warnings).isEmpty()) {
            throw new IllegalStateException("Apollo: Warnings found and 'failOnWarnings' is true, aborting.");
        }
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        element$iv2 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv5), (Iterable)incomingFragments);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv5 = $this$associateBy$iv;
        Object destination$iv$iv6 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
            object3 = destination$iv$iv6;
            boolean bl9 = false;
            object3.put(it.getName(), element$iv$iv);
        }
        Map fragmentDefinitions = destination$iv$iv6;
        Iterable $this$filterIsInstance$iv2 = definitions;
        boolean $i$f$filterIsInstance2 = false;
        $this$associateByTo$iv$iv2 = $this$filterIsInstance$iv2;
        destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv6;
        boolean $i$f$map2 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            it = (GQLFragmentDefinition)item$iv$iv;
            object3 = destination$iv$iv6;
            boolean bl10 = false;
            object3.add(Add_required_fieldsKt.addRequiredFields((GQLFragmentDefinition)it, (String)options.getAddTypename(), (Schema)options.getSchema(), (Map)fragmentDefinitions));
        }
        List fragments = (List)destination$iv$iv6;
        Iterable $this$filterIsInstance$iv3 = definitions;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv6 = $this$filterIsInstance$iv3;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv7.add(element$iv$iv);
        }
        $this$filterIsInstance$iv3 = (List)destination$iv$iv7;
        boolean $i$f$map3 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it5;
            GQLOperationDefinition bl10 = (GQLOperationDefinition)item$iv$iv;
            object3 = destination$iv$iv7;
            boolean bl11 = false;
            object3.add(Add_required_fieldsKt.addRequiredFields((GQLOperationDefinition)it5, (String)options.getAddTypename(), (Schema)options.getSchema(), (Map)fragmentDefinitions));
        }
        List operations = (List)destination$iv$iv7;
        Iterable $this$associateBy$iv2 = CollectionsKt.plus((Collection)fragments, (Iterable)incomingFragments);
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable $i$f$mapTo222 = $this$associateBy$iv2;
        Map destination$iv$iv8 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Iterator it6;
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
            object3 = destination$iv$iv8;
            boolean bl12 = false;
            object3.put(it6.getName(), element$iv$iv);
        }
        Map allFragmentDefinitions = destination$iv$iv8;
        if (options.getSchema().hasTypeWithTypePolicy()) {
            GQLOperationDefinition it7;
            Iterable $this$forEach$iv2 = operations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it7 = (GQLOperationDefinition)element$iv3;
                boolean bl13 = false;
                Check_key_fieldsKt.checkKeyFields((GQLOperationDefinition)it7, (Schema)options.getSchema(), (Map)allFragmentDefinitions);
            }
            $this$forEach$iv2 = fragments;
            $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it7 = (GQLFragmentDefinition)element$iv3;
                boolean bl14 = false;
                Check_key_fieldsKt.checkKeyFields((GQLFragmentDefinition)it7, (Schema)options.getSchema(), (Map)allFragmentDefinitions);
            }
        }
        Set alwaysGenerateTypesMatching = options.getAlwaysGenerateTypesMatching();
        if (options.getGenerateSchema()) {
            alwaysGenerateTypesMatching = SetsKt.plus(alwaysGenerateTypesMatching, (Object)".*");
        }
        Ir ir = new IrBuilder(options.getSchema(), operations, options.getGenerateTestBuilders(), fragments, allFragmentDefinitions, alwaysGenerateTypesMatching, options.getScalarMapping(), options.getCodegenModels(), options.getGenerateOptionalOperationVariables()).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Object $this$map$iv4 = ir.getOperations();
        boolean $i$f$map4 = false;
        Iterable bl14 = $this$map$iv4;
        Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it8;
            object2 = (IrOperation)item$iv$iv;
            object3 = destination$iv$iv9;
            boolean bl15 = false;
            object3.add(new OperationDescriptor(it8.getName(), QueryDocumentMinifier.minify((String)it8.getSourceWithFragments())));
        }
        List it9 = (List)destination$iv$iv9;
        boolean bl16 = false;
        Map<String, OperationDescriptor> operationOutput = options.getOperationOutputGenerator().generate(it9);
        if (!(operationOutput.size() == operations.size())) {
            boolean $i$a$-check-ApolloCompiler$write$62 = false;
            String $i$a$-check-ApolloCompiler$write$62 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw new IllegalStateException($i$a$-check-ApolloCompiler$write$62.toString());
        }
        if (options.getOperationOutputFile() != null) {
            void $this$toJson$iv;
            File file5 = options.getOperationOutputFile();
            $this$map$iv4 = operationOutput;
            String indent$iv = "  ";
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            String string = MoshiKt.getMOSHI().adapter(Map.class).indent(indent$iv).toJson((Object)$this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
            FilesKt.writeText$default((File)file5, (String)string, null, (int)2, null);
        }
        if (WhenMappings.$EnumSwitchMapping$0[options.getTargetLanguage().ordinal()] == 1) {
            String it10;
            boolean bl17;
            Iterable $this$map$iv222 = options.getIncomingCompilerMetadata();
            boolean $i$f$map222 = false;
            Iterable item$iv$iv = $this$map$iv222;
            destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv222, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv2 = iterator.next();
                CompilerMetadata compilerMetadata = (CompilerMetadata)item$iv$iv2;
                object3 = destination$iv$iv22;
                bl17 = false;
                object3.add(((CompilerMetadata)((Object)it10)).getResolverInfo());
            }
            list = (List)destination$iv$iv22;
            boolean $this$map$iv222 = options.getUseSemanticNaming();
            PackageNameGenerator $i$f$map222 = options.getPackageNameGenerator();
            $this$mapTo$iv$iv = options.getSchemaPackageName();
            boolean destination$iv$iv22 = options.getUseSchemaPackageNameForFragments();
            $i$f$mapTo = options.getGenerateFragmentImplementations();
            bl = options.getGenerateQueryDocument();
            boolean item$iv$iv2 = options.getGenerateSchema();
            it10 = options.getGeneratedSchemaName();
            bl17 = options.getFlattenModels();
            object = options.getScalarMapping();
            resolverInfo = new JavaCodeGen(ir, list, $this$map$iv222, $i$f$map222, (String)$this$mapTo$iv$iv, destination$iv$iv22, operationOutput, $i$f$mapTo, bl, item$iv$iv2, it10, bl17, (Map<String, ScalarInfo>)object).write(outputDir);
        } else {
            Iterable $this$map$iv5 = options.getIncomingCompilerMetadata();
            boolean $i$f$map5 = false;
            $this$mapTo$iv$iv = $this$map$iv5;
            destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                CompilerMetadata it10 = (CompilerMetadata)item$iv$iv;
                object3 = destination$iv$iv22;
                boolean bl18 = false;
                object3.add(it10.getResolverInfo());
            }
            list = (List)destination$iv$iv22;
            boolean bl19 = options.getGenerateAsInternal();
            boolean bl20 = options.getUseSemanticNaming();
            PackageNameGenerator packageNameGenerator = options.getPackageNameGenerator();
            object2 = options.getSchemaPackageName();
            boolean bl21 = options.getUseSchemaPackageNameForFragments();
            bl = options.getGenerateFilterNotNull();
            boolean bl22 = options.getGenerateFragmentImplementations();
            boolean bl23 = options.getGenerateQueryDocument();
            boolean bl24 = options.getGenerateSchema();
            object = options.getGeneratedSchemaName();
            boolean bl25 = options.getGenerateTestBuilders();
            boolean bl26 = options.getFlattenModels();
            List<String> list2 = options.getSealedClassesForEnumsMatching();
            TargetLanguage targetLanguage = options.getTargetLanguage();
            Map<String, ScalarInfo> map = options.getScalarMapping();
            boolean bl27 = options.getAddJvmOverloads();
            String string = options.getRequiresOptInAnnotation();
            resolverInfo = new KotlinCodeGen(ir, list, bl19, bl20, packageNameGenerator, (String)object2, bl21, operationOutput, bl, bl22, bl23, bl24, (String)object, bl25, bl26, list2, targetLanguage, map, bl27, string).write(outputDir, testDir);
        }
        ResolverInfo outputResolverInfo = resolverInfo;
        return new CompilerMetadata(fragments, outputResolverInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(Schema schema, Map<String, ScalarInfo> scalarMapping) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = schema.getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            GQLScalarTypeDefinition gQLScalarTypeDefinition = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(type.getName());
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)scalarMapping.keySet(), (Iterable)schemaScalars);
        if (!unknownScalars.isEmpty()) {
            boolean bl = false;
            String string = "Apollo: unknown custom scalar(s) in customScalarsMapping: " + CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Logger getNoOpLogger() {
        return NoOpLogger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/ApolloCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetLanguage.values().length];
            nArray[TargetLanguage.JAVA.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

