/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.BooleanExpression;
import com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.internal.IssuesScope;
import com.apollographql.apollo3.compiler.ir.IrBuilderKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001H\u0002\u00a8\u0006\t"}, d2={"findConditionalFragments", "", "Lcom/apollographql/apollo3/ast/Issue;", "definitions", "Lcom/apollographql/apollo3/ast/GQLDefinition;", "", "Lcom/apollographql/apollo3/ast/internal/IssuesScope;", "selections", "Lcom/apollographql/apollo3/ast/GQLSelection;", "apollo-compiler"})
public final class CheckNoConditionalFragmentKt {
    @NotNull
    public static final List<Issue> findConditionalFragments(@NotNull List<? extends GQLDefinition> definitions) {
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        IssuesScope scope2 = new IssuesScope(){
            @NotNull
            private final List<Issue> issues;
            {
                this.issues = new ArrayList<E>();
            }

            @NotNull
            public List<Issue> getIssues() {
                return this.issues;
            }
        };
        Iterable $this$forEach$iv = definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDefinition it = (GQLDefinition)element$iv;
            boolean bl = false;
            GQLDefinition gQLDefinition = it;
            if (gQLDefinition instanceof GQLOperationDefinition) {
                CheckNoConditionalFragmentKt.findConditionalFragments(scope2, ((GQLOperationDefinition)it).getSelectionSet().getSelections());
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            CheckNoConditionalFragmentKt.findConditionalFragments(scope2, ((GQLFragmentDefinition)it).getSelectionSet().getSelections());
        }
        return scope2.getIssues();
    }

    private static final void findConditionalFragments(IssuesScope $this$findConditionalFragments, List<? extends GQLSelection> selections) {
        Iterable $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                Object object = ((GQLField)it).getSelectionSet();
                if (object == null || (object = object.getSelections()) == null) {
                    object = CollectionsKt.emptyList();
                }
                CheckNoConditionalFragmentKt.findConditionalFragments($this$findConditionalFragments, (List<? extends GQLSelection>)object);
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                if (!Intrinsics.areEqual(IrBuilderKt.toBooleanExpression(((GQLInlineFragment)it).getDirectives()), (Object)BooleanExpression.True.INSTANCE)) {
                    $this$findConditionalFragments.getIssues().add(new Issue.ConditionalFragment("'responseBased' models do not support @include/@skip and @defer directives on fragments", it.getSourceLocation()));
                }
                CheckNoConditionalFragmentKt.findConditionalFragments($this$findConditionalFragments, ((GQLInlineFragment)it).getSelectionSet().getSelections());
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread) || Intrinsics.areEqual(IrBuilderKt.toBooleanExpression(((GQLFragmentSpread)it).getDirectives()), (Object)BooleanExpression.True.INSTANCE)) continue;
            $this$findConditionalFragments.getIssues().add(new Issue.ConditionalFragment("'responseBased' models do not support @include/@skip and @defer directives on fragments", it.getSourceLocation()));
        }
    }
}

