/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.compiler.Roots;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0002\b\tJ\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/compiler/PackageNameGenerator;", "", "version", "", "getVersion", "()Ljava/lang/String;", "packageName", "filePath", "FilePathAware", "Flat", "apollo-compiler"})
public interface PackageNameGenerator {
    @NotNull
    public String packageName(@NotNull String var1);

    @NotNull
    public String getVersion();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/compiler/PackageNameGenerator$Flat;", "Lcom/apollographql/apollo3/compiler/PackageNameGenerator;", "packageName", "", "(Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "version", "getVersion", "filePath", "apollo-compiler"})
    public static final class Flat
    implements PackageNameGenerator {
        @NotNull
        private final String packageName;

        public Flat(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            this.packageName = packageName;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @Override
        @NotNull
        public String packageName(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.packageName;
        }

        @Override
        @NotNull
        public String getVersion() {
            return Intrinsics.stringPlus((String)"Flat-", (Object)this.packageName);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/compiler/PackageNameGenerator$FilePathAware;", "Lcom/apollographql/apollo3/compiler/PackageNameGenerator;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "rootPackageName", "", "(Lcom/apollographql/apollo3/compiler/Roots;Ljava/lang/String;)V", "version", "getVersion", "()Ljava/lang/String;", "packageName", "filePath", "apollo-compiler"})
    public static final class FilePathAware
    implements PackageNameGenerator {
        @NotNull
        private final Roots roots;
        @NotNull
        private final String rootPackageName;

        public FilePathAware(@NotNull Roots roots, @NotNull String rootPackageName) {
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)rootPackageName, (String)"rootPackageName");
            this.roots = roots;
            this.rootPackageName = rootPackageName;
        }

        public /* synthetic */ FilePathAware(Roots roots, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(roots, string);
        }

        @Override
        @NotNull
        public String packageName(@NotNull String filePath) {
            String string;
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            try {
                string = StringsKt.removeSuffix((String)this.roots.filePackageName(filePath), (CharSequence)".");
            }
            catch (Exception e) {
                string = "";
            }
            String p = string;
            return StringsKt.removePrefix((String)(this.rootPackageName + '.' + p), (CharSequence)".");
        }

        @Override
        @NotNull
        public String getVersion() {
            return Intrinsics.stringPlus((String)"FilePathAware-", (Object)this.rootPackageName);
        }
    }
}

