/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.frontend;

import com.apollographql.apollo3.compiler.frontend.GQLBooleanValue;
import com.apollographql.apollo3.compiler.frontend.GQLEnumTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLEnumValue;
import com.apollographql.apollo3.compiler.frontend.GQLEnumValueDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLFloatValue;
import com.apollographql.apollo3.compiler.frontend.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLInputValueDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLIntValue;
import com.apollographql.apollo3.compiler.frontend.GQLListType;
import com.apollographql.apollo3.compiler.frontend.GQLListValue;
import com.apollographql.apollo3.compiler.frontend.GQLNamedType;
import com.apollographql.apollo3.compiler.frontend.GQLNonNullType;
import com.apollographql.apollo3.compiler.frontend.GQLNullValue;
import com.apollographql.apollo3.compiler.frontend.GQLObjectField;
import com.apollographql.apollo3.compiler.frontend.GQLObjectValue;
import com.apollographql.apollo3.compiler.frontend.GQLScalarTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLStringValue;
import com.apollographql.apollo3.compiler.frontend.GQLType;
import com.apollographql.apollo3.compiler.frontend.GQLTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLValue;
import com.apollographql.apollo3.compiler.frontend.GQLVariableValue;
import com.apollographql.apollo3.compiler.frontend.GqldocumentKt;
import com.apollographql.apollo3.compiler.frontend.GqltypeKt;
import com.apollographql.apollo3.compiler.frontend.Issue;
import com.apollographql.apollo3.compiler.frontend.Operation_validationKt;
import com.apollographql.apollo3.compiler.frontend.Schema;
import com.apollographql.apollo3.compiler.frontend.SourceAwareException;
import com.apollographql.apollo3.compiler.frontend.SourceLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001cH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/InputValueScope;", "", "schema", "Lcom/apollographql/apollo3/compiler/frontend/Schema;", "(Lcom/apollographql/apollo3/compiler/frontend/Schema;)V", "issues", "", "Lcom/apollographql/apollo3/compiler/frontend/Issue;", "getSchema", "()Lcom/apollographql/apollo3/compiler/frontend/Schema;", "variableReferences", "Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$VariableReference;", "coerce", "Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$Result;", "value", "Lcom/apollographql/apollo3/compiler/frontend/GQLValue;", "expectedType", "Lcom/apollographql/apollo3/compiler/frontend/GQLType;", "registerIssue", "", "validateAndCoerceEnum", "enumTypeDefinition", "Lcom/apollographql/apollo3/compiler/frontend/GQLEnumTypeDefinition;", "validateAndCoerceInputObject", "expectedTypeDefinition", "Lcom/apollographql/apollo3/compiler/frontend/GQLInputObjectTypeDefinition;", "validateAndCoerceInternal", "validateAndCoerceScalar", "Lcom/apollographql/apollo3/compiler/frontend/GQLNamedType;", "Result", "VariableReference", "apollo-compiler"})
public final class InputValueScope {
    private final List<Issue> issues;
    private final List<VariableReference> variableReferences;
    @NotNull
    private final Schema schema;

    @NotNull
    public final Result coerce(@NotNull GQLValue value, @NotNull GQLType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        return new Result(this.validateAndCoerceInternal(value, expectedType), this.variableReferences, this.issues);
    }

    private final void registerIssue(GQLValue value, GQLType expectedType) {
        this.issues.add(new Issue.ValidationError("Value `" + GqldocumentKt.toUtf8(value) + "` cannot be used in position expecting `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation()));
    }

    /*
     * WARNING - void declaration
     */
    private final GQLValue validateAndCoerceInputObject(GQLValue value, GQLInputObjectTypeDefinition expectedTypeDefinition) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        GQLNamedType expectedType = new GQLNamedType(null, expectedTypeDefinition.getName(), 1, null);
        if (!(value instanceof GQLObjectValue)) {
            this.registerIssue(value, expectedType);
            return value;
        }
        Iterable $this$forEach$iv = expectedTypeDefinition.getInputFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            GQLInputValueDefinition inputValueDefinition;
            block7: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = ((GQLObjectValue)value).getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLObjectField it = (GQLObjectField)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)inputValueDefinition.getName())) continue;
                    v0 = element$iv2;
                    break block7;
                }
                v0 = null;
            }
            if (v0 != null) continue;
            this.issues.add(new Issue.ValidationError("No value passed for required inputField " + inputValueDefinition.getName(), value.getSourceLocation()));
        }
        $this$forEach$iv = ((GQLObjectValue)value).getFields();
        SourceLocation sourceLocation = null;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GQLObjectField gQLObjectField;
            Object v1;
            GQLObjectField field;
            block8: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                field = (GQLObjectField)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = expectedTypeDefinition.getInputFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)field.getName())) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            GQLInputValueDefinition inputField = v1;
            if (inputField == null) {
                this.issues.add(new Issue.ValidationError("Field " + field.getName() + " is not defined by " + GqltypeKt.pretty(expectedType), field.getSourceLocation()));
                gQLObjectField = null;
            } else {
                gQLObjectField = new GQLObjectField(null, field.getName(), this.validateAndCoerceInternal(field.getValue(), inputField.getType()), 1, null);
            }
            if (gQLObjectField == null) continue;
            GQLObjectField gQLObjectField2 = gQLObjectField;
            boolean bl = false;
            boolean bl5 = false;
            GQLObjectField it$iv$iv = gQLObjectField2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1;
        List list2 = list;
        SourceLocation sourceLocation2 = sourceLocation;
        return new GQLObjectValue(sourceLocation2, list2, n, defaultConstructorMarker);
    }

    private final GQLValue validateAndCoerceEnum(GQLValue value, GQLEnumTypeDefinition enumTypeDefinition) {
        Object v0;
        block5: {
            GQLNamedType expectedType = new GQLNamedType(null, enumTypeDefinition.getName(), 1, null);
            if (!(value instanceof GQLEnumValue)) {
                this.registerIssue(value, expectedType);
                return value;
            }
            Iterable $this$firstOrNull$iv = enumTypeDefinition.getEnumValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLEnumValueDefinition it = (GQLEnumValueDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)((GQLEnumValue)value).getValue())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        GQLEnumValueDefinition enumValue = v0;
        if (enumValue == null) {
            this.issues.add(new Issue.ValidationError("Cannot find enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation()));
        } else if (Operation_validationKt.isDeprecated(enumValue)) {
            this.issues.add(new Issue.DeprecatedUsage("Use of deprecated enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation()));
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private final GQLValue validateAndCoerceScalar(GQLValue value, GQLNamedType expectedType) {
        block18: {
            block16: {
                block17: {
                    block15: {
                        var3_3 = expectedType.getName();
                        switch (var3_3.hashCode()) {
                            case 67973692: {
                                if (!var3_3.equals("Float")) ** break;
                                break;
                            }
                            case -1808118735: {
                                if (!var3_3.equals("String")) ** break;
                                break block15;
                            }
                            case 2331: {
                                if (!var3_3.equals("ID")) ** break;
                                break block16;
                            }
                            case 1729365000: {
                                if (!var3_3.equals("Boolean")) ** break;
                                break block17;
                            }
                            case 73679: {
                                if (!var3_3.equals("Int")) ** break;
                                if (!(value instanceof GQLIntValue)) {
                                    this.registerIssue(value, expectedType);
                                }
                                v0 = value;
                                break block18;
                            }
                        }
                        var4_4 = value;
                        if (var4_4 instanceof GQLFloatValue) {
                            v0 = value;
                        } else if (var4_4 instanceof GQLIntValue) {
                            v0 = new GQLFloatValue(null, ((GQLIntValue)value).getValue(), 1, null);
                        } else {
                            this.registerIssue(value, expectedType);
                            v0 = value;
                        }
                        break block18;
                    }
                    if (!(value instanceof GQLStringValue)) {
                        this.registerIssue(value, expectedType);
                    }
                    v0 = value;
                    break block18;
                }
                if (!(value instanceof GQLBooleanValue)) {
                    this.registerIssue(value, expectedType);
                }
                v0 = value;
                break block18;
            }
            if (!(value instanceof GQLStringValue) && !(value instanceof GQLIntValue)) {
                this.registerIssue(value, expectedType);
            }
            v0 = value;
            break block18;
            this.registerIssue(value, expectedType);
            v0 = value;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final GQLValue validateAndCoerceInternal(GQLValue value, GQLType expectedType) {
        if (value instanceof GQLVariableValue) {
            this.variableReferences.add(new VariableReference((GQLVariableValue)value, expectedType));
            return value;
        }
        if (value instanceof GQLNullValue) {
            if (expectedType instanceof GQLNonNullType) {
                this.registerIssue(value, expectedType);
                return value;
            }
            return value;
        }
        GQLType gQLType = expectedType;
        if (gQLType instanceof GQLNonNullType) {
            return this.validateAndCoerceInternal(value, ((GQLNonNullType)expectedType).getType());
        }
        if (gQLType instanceof GQLListType) {
            Collection<GQLValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!(value instanceof GQLListValue)) {
                this.registerIssue(value, expectedType);
                return value;
            }
            Iterable iterable = ((GQLListValue)value).getValues();
            SourceLocation sourceLocation = null;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue = (GQLValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                GQLValue gQLValue2 = this.validateAndCoerceInternal((GQLValue)it, ((GQLListType)expectedType).getType());
                collection.add(gQLValue2);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = collection;
            SourceLocation sourceLocation2 = sourceLocation;
            return new GQLListValue(sourceLocation2, list, n, defaultConstructorMarker);
        }
        if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition expectedTypeDefinition = this.schema.typeDefinition(((GQLNamedType)expectedType).getName());
            if (expectedTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                return this.validateAndCoerceInputObject(value, (GQLInputObjectTypeDefinition)expectedTypeDefinition);
            }
            if (expectedTypeDefinition instanceof GQLScalarTypeDefinition) {
                if (!expectedTypeDefinition.isBuiltIn()) {
                    return value;
                }
                return this.validateAndCoerceScalar(value, (GQLNamedType)expectedType);
            }
            if (expectedTypeDefinition instanceof GQLEnumTypeDefinition) {
                return this.validateAndCoerceEnum(value, (GQLEnumTypeDefinition)expectedTypeDefinition);
            }
            this.issues.add(new Issue.ValidationError("Value cannot be of non-input type " + GqltypeKt.pretty(expectedType), value.getSourceLocation()));
            return value;
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    public InputValueScope(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.schema = schema;
        boolean bl = false;
        this.issues = new ArrayList();
        bl = false;
        this.variableReferences = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$VariableReference;", "", "variable", "Lcom/apollographql/apollo3/compiler/frontend/GQLVariableValue;", "expectedType", "Lcom/apollographql/apollo3/compiler/frontend/GQLType;", "(Lcom/apollographql/apollo3/compiler/frontend/GQLVariableValue;Lcom/apollographql/apollo3/compiler/frontend/GQLType;)V", "getExpectedType", "()Lcom/apollographql/apollo3/compiler/frontend/GQLType;", "getVariable", "()Lcom/apollographql/apollo3/compiler/frontend/GQLVariableValue;", "apollo-compiler"})
    public static final class VariableReference {
        @NotNull
        private final GQLVariableValue variable;
        @NotNull
        private final GQLType expectedType;

        @NotNull
        public final GQLVariableValue getVariable() {
            return this.variable;
        }

        @NotNull
        public final GQLType getExpectedType() {
            return this.expectedType;
        }

        public VariableReference(@NotNull GQLVariableValue variable, @NotNull GQLType expectedType) {
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
            this.variable = variable;
            this.expectedType = expectedType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$Result;", "", "coercedValue", "Lcom/apollographql/apollo3/compiler/frontend/GQLValue;", "variableReferences", "", "Lcom/apollographql/apollo3/compiler/frontend/InputValueScope$VariableReference;", "issues", "Lcom/apollographql/apollo3/compiler/frontend/Issue;", "(Lcom/apollographql/apollo3/compiler/frontend/GQLValue;Ljava/util/List;Ljava/util/List;)V", "getCoercedValue", "()Lcom/apollographql/apollo3/compiler/frontend/GQLValue;", "getIssues", "()Ljava/util/List;", "getVariableReferences", "orThrow", "apollo-compiler"})
    public static final class Result {
        @NotNull
        private final GQLValue coercedValue;
        @NotNull
        private final List<VariableReference> variableReferences;
        @NotNull
        private final List<Issue> issues;

        @NotNull
        public final GQLValue orThrow() {
            Collection collection = this.issues;
            boolean bl = false;
            if (!collection.isEmpty()) {
                throw (Throwable)new SourceAwareException(((Issue)CollectionsKt.first(this.issues)).getMessage(), ((Issue)CollectionsKt.first(this.issues)).getSourceLocation());
            }
            return this.coercedValue;
        }

        @NotNull
        public final GQLValue getCoercedValue() {
            return this.coercedValue;
        }

        @NotNull
        public final List<VariableReference> getVariableReferences() {
            return this.variableReferences;
        }

        @NotNull
        public final List<Issue> getIssues() {
            return this.issues;
        }

        public Result(@NotNull GQLValue coercedValue, @NotNull List<VariableReference> variableReferences, @NotNull List<? extends Issue> issues) {
            Intrinsics.checkParameterIsNotNull((Object)coercedValue, (String)"coercedValue");
            Intrinsics.checkParameterIsNotNull(variableReferences, (String)"variableReferences");
            Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
            this.coercedValue = coercedValue;
            this.variableReferences = variableReferences;
            this.issues = issues;
        }
    }
}

