/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.backend.codegen;

import com.apollographql.apollo3.compiler.ReservedKeywordsKt;
import com.apollographql.apollo3.compiler.backend.ast.CodeGenerationAst;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"kotlinNameForAdapterField", "", "type", "Lcom/apollographql/apollo3/compiler/backend/ast/CodeGenerationAst$FieldType;", "kotlinNameForAdapterFieldRecursive", "kotlinNameForEnum", "graphqlEnum", "kotlinNameForEnumValue", "graphqlEnumValue", "kotlinNameForField", "responseName", "kotlinNameForTypeCaseAdapterField", "typeRef", "Lcom/apollographql/apollo3/compiler/backend/ast/CodeGenerationAst$TypeRef;", "apollo-compiler"})
public final class KotlinNamesKt {
    @NotNull
    public static final String kotlinNameForEnumValue(@NotNull String graphqlEnumValue) {
        Intrinsics.checkParameterIsNotNull((Object)graphqlEnumValue, (String)"graphqlEnumValue");
        String string = graphqlEnumValue;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        return string2;
    }

    @NotNull
    public static final String kotlinNameForEnum(@NotNull String graphqlEnum) {
        Intrinsics.checkParameterIsNotNull((Object)graphqlEnum, (String)"graphqlEnum");
        return ReservedKeywordsKt.escapeKotlinReservedWord(graphqlEnum);
    }

    @NotNull
    public static final String kotlinNameForField(@NotNull String responseName) {
        Intrinsics.checkParameterIsNotNull((Object)responseName, (String)"responseName");
        return ReservedKeywordsKt.escapeKotlinReservedWord(responseName);
    }

    @NotNull
    public static final String kotlinNameForAdapterField(@NotNull CodeGenerationAst.FieldType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return StringsKt.decapitalize((String)KotlinNamesKt.kotlinNameForAdapterFieldRecursive(type)) + "Adapter";
    }

    @NotNull
    public static final String kotlinNameForTypeCaseAdapterField(@NotNull CodeGenerationAst.TypeRef typeRef) {
        Intrinsics.checkParameterIsNotNull((Object)typeRef, (String)"typeRef");
        return ReservedKeywordsKt.escapeKotlinReservedWord(typeRef.getName()) + "Adapter";
    }

    private static final String kotlinNameForAdapterFieldRecursive(CodeGenerationAst.FieldType type) {
        String string;
        if (type.getNullable()) {
            return "Nullable" + KotlinNamesKt.kotlinNameForAdapterFieldRecursive(type.nonNullable());
        }
        CodeGenerationAst.FieldType fieldType = type;
        if (fieldType instanceof CodeGenerationAst.FieldType.Array) {
            string = "ListOf" + KotlinNamesKt.kotlinNameForAdapterFieldRecursive(((CodeGenerationAst.FieldType.Array)type).getRawType());
        } else if (fieldType instanceof CodeGenerationAst.FieldType.Object) {
            string = StringsKt.capitalize((String)((CodeGenerationAst.FieldType.Object)type).getTypeRef().getName());
        } else if (fieldType instanceof CodeGenerationAst.FieldType.Scalar) {
            string = StringsKt.capitalize((String)((CodeGenerationAst.FieldType.Scalar)type).getSchemaTypeName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

