/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.DefaultPackageNameProvider;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.Roots;
import com.apollographql.apollo3.compiler.TypesToGenerate;
import com.apollographql.apollo3.compiler.TypesToGenerateKt;
import com.apollographql.apollo3.compiler.VersionKt;
import com.apollographql.apollo3.compiler.backend.GraphQLCodeGenerator;
import com.apollographql.apollo3.compiler.backend.ir.BackendIr;
import com.apollographql.apollo3.compiler.backend.ir.BackendIrBuilder;
import com.apollographql.apollo3.compiler.frontend.Add_typenameKt;
import com.apollographql.apollo3.compiler.frontend.GQLDocument;
import com.apollographql.apollo3.compiler.frontend.GQLFragmentDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLOperationDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GraphQLParser;
import com.apollographql.apollo3.compiler.frontend.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.frontend.Issue;
import com.apollographql.apollo3.compiler.frontend.Schema;
import com.apollographql.apollo3.compiler.frontend.Schema_to_introspectionKt;
import com.apollographql.apollo3.compiler.frontend.SourceAwareException;
import com.apollographql.apollo3.compiler.frontend.ir.FrontendIr;
import com.apollographql.apollo3.compiler.frontend.ir.FrontendIrBuilder;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchema;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo3.compiler.operationoutput.OperationOutputKt;
import com.squareup.kotlinpoet.ClassNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "logger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "(Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;)V", "getLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "anyClassName", "", "generateKotlinModels", "", "write", "", "args", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Arguments;", "Arguments", "Companion", "Logger", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Logger NoOpLogger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Arguments args) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        boolean bl;
        Iterable<Regex> iterable;
        Object it;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv222;
        void $this$map$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv322;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv4;
        void $this$map$iv3;
        Object element$iv$iv6;
        BackendIr.Operation $this$filterIsInstanceTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Object object2;
        Collection collection;
        void $this$mapTo$iv$iv5;
        void $this$map$iv4;
        Object list$iv$iv;
        Iterable destination$iv$iv;
        GQLDocument it2;
        void $this$flatMapTo$iv$iv3;
        void documents;
        Iterable<Object> element$iv3;
        void errors;
        void schema;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        FilesKt.deleteRecursively((File)args.getOutputDir());
        args.getOutputDir().mkdirs();
        Roots roots = new Roots((Collection<? extends File>)args.getRootFolders());
        ApolloMetadata metadata = GraphQLCompiler.Companion.collectMetadata(args.getMetadata());
        Companion.SchemaInfo schemaInfo = GraphQLCompiler.Companion.getSchemaInfo(roots, args.getRootPackageName(), args.getSchemaFile(), metadata);
        Schema schema2 = schemaInfo.component1();
        String schemaPackageName = schemaInfo.component2();
        ApolloMetadata apolloMetadata = metadata;
        boolean generateKotlinModels = apolloMetadata != null ? apolloMetadata.getGenerateKotlinModels() : args.getGenerateKotlinModels();
        Object object3 = metadata;
        if (object3 == null || (object3 = ((ApolloMetadata)object3).getCustomScalarsMapping()) == null) {
            object3 = args.getCustomScalarsMapping();
        }
        Map<String, String> userScalarTypesMap = object3;
        String string = args.getRootPackageName();
        Object object4 = roots;
        DefaultPackageNameProvider packageNameProvider = new DefaultPackageNameProvider(string, (Roots)object4);
        Object object5 = metadata;
        if (object5 == null || (object5 = ((ApolloMetadata)object5).getFragments()) == null) {
            object5 = CollectionsKt.emptyList();
        }
        Object metadataFragments = object5;
        Object object6 = GraphQLParser.INSTANCE.parseExecutableFiles(args.getGraphqlFiles(), (Schema)schema, (List<GQLFragmentDefinition>)metadataFragments);
        object4 = (List)object6.component1();
        List issues = (List)object6.component2();
        Iterable $this$partition$iv = issues;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Issue it3 = (Issue)element$iv2;
            boolean bl2 = false;
            if (it3.getSeverity() == Issue.Severity.ERROR) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        object6 = (List)pair.component1();
        List warnings = (List)pair.component2();
        Issue firstError = (Issue)CollectionsKt.firstOrNull((List)errors);
        if (firstError != null) {
            throw (Throwable)new SourceAwareException(firstError.getMessage(), firstError.getSourceLocation());
        }
        if (args.getWarnOnDeprecatedUsages()) {
            Iterable $this$forEach$iv = warnings;
            boolean $i$f$forEach = false;
            for (Iterable<Object> element$iv3 : $this$forEach$iv) {
                Issue it4 = (Issue)((Object)element$iv3);
                boolean bl3 = false;
                int column = it4.getSourceLocation().getPosition() + 1;
                this.logger.warning("w: " + it4.getSourceLocation().getFilePath() + ':' + it4.getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: " + it4.getMessage());
            }
            if (args.getFailOnWarnings()) {
                $this$forEach$iv = warnings;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw (Throwable)new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        Iterable $this$flatMap$iv2 = (Iterable)documents;
        boolean $i$f$flatMap = false;
        element$iv3 = $this$flatMap$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv3) {
            void $this$filterIsInstanceTo$iv$iv2;
            it2 = (GQLDocument)element$iv$iv2;
            boolean bl4 = false;
            Iterable $this$filterIsInstance$iv = it2.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv3 instanceof GQLFragmentDefinition)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv3 = $this$map$iv4;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
            list$iv$iv = (GQLFragmentDefinition)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            object2 = Add_typenameKt.withTypenameWhenNeeded((GQLFragmentDefinition)((Object)it2), (Schema)schema);
            collection.add(object2);
        }
        List fragments = (List)destination$iv$iv2;
        Iterable $this$flatMap$iv3 = (Iterable)documents;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv2 = $this$flatMap$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv4 : $this$flatMapTo$iv$iv2) {
            Object element$iv$iv3;
            GQLDocument it5 = (GQLDocument)element$iv$iv4;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = it5.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            element$iv$iv3 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (element$iv$iv3.hasNext()) {
                element$iv$iv6 = element$iv$iv3.next();
                if (!(element$iv$iv6 instanceof GQLOperationDefinition)) continue;
                destination$iv$iv4.add(element$iv$iv6);
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv3 = (List)destination$iv$iv3;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator item$iv$iv2 = $this$mapTo$iv$iv4.iterator();
        while (item$iv$iv2.hasNext()) {
            void it6;
            item$iv$iv = item$iv$iv2.next();
            GQLOperationDefinition list$iv$iv2 = (GQLOperationDefinition)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl7 = false;
            object2 = Add_typenameKt.withTypenameWhenNeeded((GQLOperationDefinition)it6, (Schema)schema);
            collection.add(object2);
        }
        List operations = (List)destination$iv$iv3;
        TypesToGenerate typesToGenerate = TypesToGenerateKt.computeTypesToGenerate((List<GQLDocument>)documents, (Schema)schema, metadata, args.getAlwaysGenerateTypesMatching());
        $this$mapTo$iv$iv4 = metadataFragments;
        destination$iv$iv3 = fragments;
        FrontendIr frontendIr = new FrontendIrBuilder((Schema)schema, operations, (List<GQLFragmentDefinition>)$this$mapTo$iv$iv4, (List<GQLFragmentDefinition>)destination$iv$iv3).build();
        BackendIr backendIr = new BackendIrBuilder((Schema)schema, args.getUseSemanticNaming(), packageNameProvider).buildBackendIR(frontendIr);
        Iterable $this$map$iv222 = backendIr.getOperations();
        boolean $i$f$map3 = false;
        item$iv$iv = $this$map$iv222;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv222, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv322) {
            Iterator it7;
            $this$filterIsInstanceTo$iv$iv = (BackendIr.Operation)item$iv$iv3;
            collection = destination$iv$iv5;
            boolean bl8 = false;
            object2 = new OperationDescriptor(((BackendIr.Operation)((Object)it7)).getOperationName(), ((BackendIr.Operation)((Object)it7)).getTargetPackageName(), "", QueryDocumentMinifier.minify((String)((BackendIr.Operation)((Object)it7)).getDefinition()));
            collection.add(object2);
        }
        $this$map$iv222 = (List)destination$iv$iv5;
        $i$f$map3 = false;
        boolean $this$mapTo$iv$iv322 = false;
        Iterable it8 = $this$map$iv222;
        boolean $i$a$-let-GraphQLCompiler$write$operationOutput$32 = false;
        Map<String, OperationDescriptor> operationOutput = args.getOperationOutputGenerator().generate((Collection)it8);
        boolean $this$map$iv222 = operationOutput.size() == operations.size();
        $i$f$map3 = false;
        $this$mapTo$iv$iv322 = false;
        if (!$this$map$iv222) {
            boolean bl9 = false;
            String $this$mapTo$iv$iv322 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv322.toString());
        }
        if (args.getOperationOutputFile() != null) {
            FilesKt.writeText$default((File)args.getOperationOutputFile(), (String)OperationOutputKt.toJson(operationOutput, "  "), null, (int)2, null);
        }
        IntrospectionSchema introspectionSchema = Schema_to_introspectionKt.toIntrospectionSchema((Schema)schema);
        Iterable $this$mapTo$iv$iv322 = introspectionSchema.getTypes().values();
        boolean $i$f$filter = false;
        void $i$a$-let-GraphQLCompiler$write$operationOutput$32 = $this$filter$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            IntrospectionSchema.Type type = (IntrospectionSchema.Type)element$iv$iv5;
            boolean bl10 = false;
            if (!(type instanceof IntrospectionSchema.Type.Scalar && !GQLTypeDefinition.Companion.getBuiltInTypes().contains(type.getName()))) continue;
            destination$iv$iv6.add(element$iv$iv5);
        }
        $this$filter$iv = (List)destination$iv$iv6;
        boolean $i$f$map4 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv222) {
            IntrospectionSchema.Type type = (IntrospectionSchema.Type)item$iv$iv4;
            collection = destination$iv$iv6;
            boolean bl11 = false;
            object2 = type.getName();
            collection.add(object2);
        }
        List schemaScalars = (List)destination$iv$iv6;
        Set unknownScalars = CollectionsKt.subtract((Iterable)userScalarTypesMap.keySet(), (Iterable)CollectionsKt.toSet((Iterable)schemaScalars));
        $i$f$map4 = unknownScalars.isEmpty();
        boolean $this$mapTo$iv$iv222 = false;
        boolean destination$iv$iv222 = false;
        if (!$i$f$map4) {
            boolean bl12 = false;
            String destination$iv$iv222 = "ApolloGraphQL: unknown custom scalar(s): " + CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            throw (Throwable)new IllegalStateException(destination$iv$iv222.toString());
        }
        Iterable $this$mapTo$iv$iv222 = schemaScalars;
        boolean $i$f$map5 = false;
        void bl12 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo5 = false;
        Iterator type22 = $this$mapTo$iv$iv.iterator();
        while (type22.hasNext()) {
            Object item$iv$iv5 = type22.next();
            element$iv$iv6 = (String)item$iv$iv5;
            collection = destination$iv$iv;
            boolean bl13 = false;
            String string2 = userScalarTypesMap.get(it);
            if (string2 == null) {
                string2 = this.anyClassName(generateKotlinModels);
            }
            object2 = TuplesKt.to((Object)it, (Object)string2);
            collection.add(object2);
        }
        Map customScalarsMapping = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = args.getEnumAsSealedClassPatternFilters();
        boolean bl14 = args.getGenerateFilterNotNull();
        boolean bl15 = args.getGenerateAsInternal();
        Map<String, OperationDescriptor> map = operationOutput;
        Map map2 = customScalarsMapping;
        boolean bl16 = typesToGenerate.getGenerateScalarMapping();
        Set set = typesToGenerate.getInputObjectsToGenerate();
        Object object7 = typesToGenerate.getEnumsToGenerate();
        String string3 = schema;
        BackendIr backendIr2 = backendIr;
        $i$f$map5 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo5 = false;
        type22 = $this$mapTo$iv$iv.iterator();
        while (type22.hasNext()) {
            Object item$iv$iv6 = type22.next();
            it = (String)item$iv$iv6;
            iterable = destination$iv$iv;
            bl = false;
            object = it;
            boolean bl17 = false;
            Regex regex = new Regex((String)object);
            iterable.add(regex);
        }
        iterable = (List)destination$iv$iv;
        boolean $this$map$iv32 = args.getGenerateFragmentImplementations();
        Object $i$f$map22 = StringsKt.removePrefix((String)(schemaPackageName + ".fragment"), (CharSequence)".");
        $this$mapTo$iv$iv = StringsKt.removePrefix((String)(schemaPackageName + ".type"), (CharSequence)".");
        destination$iv$iv = iterable;
        $i$f$mapTo5 = bl14;
        boolean type22 = bl15;
        Object object8 = map;
        it = map2;
        bl = bl16;
        object = set;
        Set<String> set2 = object7;
        boolean bl18 = $this$map$iv32;
        String string4 = $i$f$map22;
        Object object9 = $this$mapTo$iv$iv;
        boolean bl19 = bl;
        Object object10 = object;
        Set<String> set3 = set2;
        Iterable iterable3 = destination$iv$iv;
        boolean bl20 = $i$f$mapTo5;
        Map<String, OperationDescriptor> map3 = object8;
        boolean bl21 = type22;
        Object object11 = it;
        void var66_130 = string3;
        BackendIr backendIr3 = backendIr2;
        new GraphQLCodeGenerator(backendIr3, (Schema)var66_130, (Map<String, String>)object11, bl21, map3, bl20, (List<Regex>)iterable3, set3, (Set<String>)object10, bl19, (String)object9, string4, bl18).write(args.getOutputDir());
        args.getMetadataOutputFile().getParentFile().mkdirs();
        $i$f$map22 = (Iterable)documents;
        set = SetsKt.plus(typesToGenerate.getEnumsToGenerate(), (Iterable)typesToGenerate.getInputObjectsToGenerate());
        object7 = args.getModuleName();
        string3 = schemaPackageName;
        backendIr2 = metadata == null ? schema : null;
        boolean $i$f$flatMap3 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        for (Object element$iv$iv6 : $this$flatMapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv3;
            GQLDocument it9 = (GQLDocument)element$iv$iv6;
            boolean bl22 = false;
            Iterable $this$filterIsInstance$iv = it9.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable4 = $this$filterIsInstance$iv;
            Collection destination$iv$iv8 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv7 : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv7 instanceof GQLFragmentDefinition)) continue;
                destination$iv$iv8.add(element$iv$iv7);
            }
            Iterable list$iv$iv3 = (List)destination$iv$iv8;
            CollectionsKt.addAll((Collection)destination$iv$iv7, (Iterable)list$iv$iv3);
        }
        List list = (List)destination$iv$iv7;
        String string5 = VersionKt.getVERSION();
        Map<String, String> map4 = args.getCustomScalarsMapping();
        boolean bl23 = generateKotlinModels;
        List list2 = list;
        Set set4 = set;
        object8 = object7;
        String string6 = string3;
        Map<String, String> map5 = map4;
        String string7 = string5;
        boolean bl24 = bl23;
        Object object12 = object8;
        String string8 = string6;
        Set set5 = set4;
        List list3 = list2;
        BackendIr backendIr4 = backendIr2;
        ApolloMetadata outgoingMetadata = new ApolloMetadata((Schema)((Object)backendIr4), list3, set5, string8, (String)object12, bl24, string7, map5);
        outgoingMetadata.writeTo(args.getMetadataOutputFile());
    }

    private final String anyClassName(boolean generateKotlinModels) {
        if (!generateKotlinModels) {
            String string = "ClassNames.OBJECT.toString()";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Object.class)).toString();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public GraphQLCompiler(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public /* synthetic */ GraphQLCompiler(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = NoOpLogger;
        }
        this(logger);
    }

    public GraphQLCompiler() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        NoOpLogger = new Logger(){

            public void warning(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b=\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00fb\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u0012\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u0012\u0012\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010<\u001a\u00020\u0010H\u00c6\u0003J\t\u0010=\u001a\u00020\u0012H\u00c6\u0003J\t\u0010>\u001a\u00020\u000bH\u00c6\u0003J\t\u0010?\u001a\u00020\u0012H\u00c6\u0003J\u0015\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016H\u00c6\u0003J\t\u0010A\u001a\u00020\u0012H\u00c6\u0003J\t\u0010B\u001a\u00020\u0012H\u00c6\u0003J\t\u0010C\u001a\u00020\u0012H\u00c6\u0003J\t\u0010D\u001a\u00020\u0012H\u00c6\u0003J\t\u0010E\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J\t\u0010G\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010J\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010L\u001a\u00020\u000bH\u00c6\u0003J\t\u0010M\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0089\u0002\u0010P\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00042\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u00122\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u00122\b\b\u0002\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u00122\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0001J\u0013\u0010Q\u001a\u00020\u00122\b\u0010R\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010S\u001a\u00020TH\u00d6\u0001J\t\u0010U\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0011\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u0011\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0011\u0010\u001a\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010 R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010/R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010-R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00101R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010$R\u0011\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010$\u00a8\u0006V"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Arguments;", "", "rootFolders", "", "Ljava/io/File;", "graphqlFiles", "", "schemaFile", "outputDir", "metadata", "moduleName", "", "metadataOutputFile", "alwaysGenerateTypesMatching", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "dumpIR", "", "rootPackageName", "generateKotlinModels", "customScalarsMapping", "", "useSemanticNaming", "warnOnDeprecatedUsages", "failOnWarnings", "generateFragmentImplementations", "generateAsInternal", "generateFilterNotNull", "enumAsSealedClassPatternFilters", "(Ljava/util/List;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/lang/String;Ljava/io/File;Ljava/util/Set;Ljava/io/File;Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;ZLjava/lang/String;ZLjava/util/Map;ZZZZZZLjava/util/Set;)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getCustomScalarsMapping", "()Ljava/util/Map;", "getDumpIR", "()Z", "getEnumAsSealedClassPatternFilters", "getFailOnWarnings", "getGenerateAsInternal", "getGenerateFilterNotNull", "getGenerateFragmentImplementations", "getGenerateKotlinModels", "getGraphqlFiles", "getMetadata", "()Ljava/util/List;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "getOutputDir", "getRootFolders", "getRootPackageName", "getSchemaFile", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class Arguments {
        @NotNull
        private final List<File> rootFolders;
        @NotNull
        private final Set<File> graphqlFiles;
        @Nullable
        private final File schemaFile;
        @NotNull
        private final File outputDir;
        @NotNull
        private final List<File> metadata;
        @NotNull
        private final String moduleName;
        @NotNull
        private final File metadataOutputFile;
        @NotNull
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        private final boolean dumpIR;
        @NotNull
        private final String rootPackageName;
        private final boolean generateKotlinModels;
        @NotNull
        private final Map<String, String> customScalarsMapping;
        private final boolean useSemanticNaming;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        private final boolean generateFragmentImplementations;
        private final boolean generateAsInternal;
        private final boolean generateFilterNotNull;
        @NotNull
        private final Set<String> enumAsSealedClassPatternFilters;

        @NotNull
        public final List<File> getRootFolders() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> getGraphqlFiles() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File getSchemaFile() {
            return this.schemaFile;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> getMetadata() {
            return this.metadata;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        public final boolean getDumpIR() {
            return this.dumpIR;
        }

        @NotNull
        public final String getRootPackageName() {
            return this.rootPackageName;
        }

        public final boolean getGenerateKotlinModels() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> getCustomScalarsMapping() {
            return this.customScalarsMapping;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        public final boolean getGenerateFragmentImplementations() {
            return this.generateFragmentImplementations;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getGenerateFilterNotNull() {
            return this.generateFilterNotNull;
        }

        @NotNull
        public final Set<String> getEnumAsSealedClassPatternFilters() {
            return this.enumAsSealedClassPatternFilters;
        }

        public Arguments(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata, @NotNull String moduleName, @NotNull File metadataOutputFile, @NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean dumpIR, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customScalarsMapping, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, boolean generateFragmentImplementations, boolean generateAsInternal, boolean generateFilterNotNull, @NotNull Set<String> enumAsSealedClassPatternFilters) {
            Intrinsics.checkParameterIsNotNull(rootFolders, (String)"rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, (String)"graphqlFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)metadataOutputFile, (String)"metadataOutputFile");
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, (String)"enumAsSealedClassPatternFilters");
            this.rootFolders = rootFolders;
            this.graphqlFiles = graphqlFiles;
            this.schemaFile = schemaFile;
            this.outputDir = outputDir;
            this.metadata = metadata;
            this.moduleName = moduleName;
            this.metadataOutputFile = metadataOutputFile;
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.dumpIR = dumpIR;
            this.rootPackageName = rootPackageName;
            this.generateKotlinModels = generateKotlinModels;
            this.customScalarsMapping = customScalarsMapping;
            this.useSemanticNaming = useSemanticNaming;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.generateFragmentImplementations = generateFragmentImplementations;
            this.generateAsInternal = generateAsInternal;
            this.generateFilterNotNull = generateFilterNotNull;
            this.enumAsSealedClassPatternFilters = enumAsSealedClassPatternFilters;
        }

        public /* synthetic */ Arguments(List list, Set set, File file, File file2, List list2, String string, File file3, Set set2, File file4, OperationOutputGenerator operationOutputGenerator, boolean bl, String string2, boolean bl2, Map map, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                string = "?";
            }
            if ((n & 0x80) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 0x100) != 0) {
                file4 = null;
            }
            if ((n & 0x200) != 0) {
                operationOutputGenerator = new OperationOutputGenerator.DefaultOperationOuputGenerator(new OperationIdGenerator.Sha256());
            }
            if ((n & 0x400) != 0) {
                bl = false;
            }
            if ((n & 0x800) != 0) {
                string2 = "";
            }
            if ((n & 0x1000) != 0) {
                bl2 = false;
            }
            if ((n & 0x2000) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x4000) != 0) {
                bl3 = true;
            }
            if ((n & 0x8000) != 0) {
                bl4 = true;
            }
            if ((n & 0x10000) != 0) {
                bl5 = false;
            }
            if ((n & 0x20000) != 0) {
                bl6 = false;
            }
            if ((n & 0x40000) != 0) {
                bl7 = false;
            }
            if ((n & 0x80000) != 0) {
                bl8 = false;
            }
            if ((n & 0x100000) != 0) {
                set3 = SetsKt.emptySet();
            }
            this(list, set, file, file2, list2, string, file3, set2, file4, operationOutputGenerator, bl, string2, bl2, map, bl3, bl4, bl5, bl6, bl7, bl8, set3);
        }

        @NotNull
        public final List<File> component1() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> component2() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File component3() {
            return this.schemaFile;
        }

        @NotNull
        public final File component4() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> component5() {
            return this.metadata;
        }

        @NotNull
        public final String component6() {
            return this.moduleName;
        }

        @NotNull
        public final File component7() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final Set<String> component8() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component9() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component10() {
            return this.operationOutputGenerator;
        }

        public final boolean component11() {
            return this.dumpIR;
        }

        @NotNull
        public final String component12() {
            return this.rootPackageName;
        }

        public final boolean component13() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> component14() {
            return this.customScalarsMapping;
        }

        public final boolean component15() {
            return this.useSemanticNaming;
        }

        public final boolean component16() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component17() {
            return this.failOnWarnings;
        }

        public final boolean component18() {
            return this.generateFragmentImplementations;
        }

        public final boolean component19() {
            return this.generateAsInternal;
        }

        public final boolean component20() {
            return this.generateFilterNotNull;
        }

        @NotNull
        public final Set<String> component21() {
            return this.enumAsSealedClassPatternFilters;
        }

        @NotNull
        public final Arguments copy(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata, @NotNull String moduleName, @NotNull File metadataOutputFile, @NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean dumpIR, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customScalarsMapping, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, boolean generateFragmentImplementations, boolean generateAsInternal, boolean generateFilterNotNull, @NotNull Set<String> enumAsSealedClassPatternFilters) {
            Intrinsics.checkParameterIsNotNull(rootFolders, (String)"rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, (String)"graphqlFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)metadataOutputFile, (String)"metadataOutputFile");
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, (String)"enumAsSealedClassPatternFilters");
            return new Arguments(rootFolders, graphqlFiles, schemaFile, outputDir, metadata, moduleName, metadataOutputFile, alwaysGenerateTypesMatching, operationOutputFile, operationOutputGenerator, dumpIR, rootPackageName, generateKotlinModels, customScalarsMapping, useSemanticNaming, warnOnDeprecatedUsages, failOnWarnings, generateFragmentImplementations, generateAsInternal, generateFilterNotNull, enumAsSealedClassPatternFilters);
        }

        public static /* synthetic */ Arguments copy$default(Arguments arguments, List list, Set set, File file, File file2, List list2, String string, File file3, Set set2, File file4, OperationOutputGenerator operationOutputGenerator, boolean bl, String string2, boolean bl2, Map map, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Set set3, int n, Object object) {
            if ((n & 1) != 0) {
                list = arguments.rootFolders;
            }
            if ((n & 2) != 0) {
                set = arguments.graphqlFiles;
            }
            if ((n & 4) != 0) {
                file = arguments.schemaFile;
            }
            if ((n & 8) != 0) {
                file2 = arguments.outputDir;
            }
            if ((n & 0x10) != 0) {
                list2 = arguments.metadata;
            }
            if ((n & 0x20) != 0) {
                string = arguments.moduleName;
            }
            if ((n & 0x40) != 0) {
                file3 = arguments.metadataOutputFile;
            }
            if ((n & 0x80) != 0) {
                set2 = arguments.alwaysGenerateTypesMatching;
            }
            if ((n & 0x100) != 0) {
                file4 = arguments.operationOutputFile;
            }
            if ((n & 0x200) != 0) {
                operationOutputGenerator = arguments.operationOutputGenerator;
            }
            if ((n & 0x400) != 0) {
                bl = arguments.dumpIR;
            }
            if ((n & 0x800) != 0) {
                string2 = arguments.rootPackageName;
            }
            if ((n & 0x1000) != 0) {
                bl2 = arguments.generateKotlinModels;
            }
            if ((n & 0x2000) != 0) {
                map = arguments.customScalarsMapping;
            }
            if ((n & 0x4000) != 0) {
                bl3 = arguments.useSemanticNaming;
            }
            if ((n & 0x8000) != 0) {
                bl4 = arguments.warnOnDeprecatedUsages;
            }
            if ((n & 0x10000) != 0) {
                bl5 = arguments.failOnWarnings;
            }
            if ((n & 0x20000) != 0) {
                bl6 = arguments.generateFragmentImplementations;
            }
            if ((n & 0x40000) != 0) {
                bl7 = arguments.generateAsInternal;
            }
            if ((n & 0x80000) != 0) {
                bl8 = arguments.generateFilterNotNull;
            }
            if ((n & 0x100000) != 0) {
                set3 = arguments.enumAsSealedClassPatternFilters;
            }
            return arguments.copy(list, set, file, file2, list2, string, file3, set2, file4, operationOutputGenerator, bl, string2, bl2, map, bl3, bl4, bl5, bl6, bl7, bl8, set3);
        }

        @NotNull
        public String toString() {
            return "Arguments(rootFolders=" + this.rootFolders + ", graphqlFiles=" + this.graphqlFiles + ", schemaFile=" + this.schemaFile + ", outputDir=" + this.outputDir + ", metadata=" + this.metadata + ", moduleName=" + this.moduleName + ", metadataOutputFile=" + this.metadataOutputFile + ", alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", dumpIR=" + this.dumpIR + ", rootPackageName=" + this.rootPackageName + ", generateKotlinModels=" + this.generateKotlinModels + ", customScalarsMapping=" + this.customScalarsMapping + ", useSemanticNaming=" + this.useSemanticNaming + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", generateFragmentImplementations=" + this.generateFragmentImplementations + ", generateAsInternal=" + this.generateAsInternal + ", generateFilterNotNull=" + this.generateFilterNotNull + ", enumAsSealedClassPatternFilters=" + this.enumAsSealedClassPatternFilters + ")";
        }

        public int hashCode() {
            List<File> list = this.rootFolders;
            Set<File> set = this.graphqlFiles;
            File file = this.schemaFile;
            File file2 = this.outputDir;
            List<File> list2 = this.metadata;
            String string = this.moduleName;
            File file3 = this.metadataOutputFile;
            Set<String> set2 = this.alwaysGenerateTypesMatching;
            File file4 = this.operationOutputFile;
            OperationOutputGenerator operationOutputGenerator = this.operationOutputGenerator;
            int n = ((((((((((list != null ? ((Object)list).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (operationOutputGenerator != null ? operationOutputGenerator.hashCode() : 0)) * 31;
            int n2 = this.dumpIR ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string2 = this.rootPackageName;
            int n3 = ((n + n2) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n4 = this.generateKotlinModels ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            Map<String, String> map = this.customScalarsMapping;
            int n5 = ((n3 + n4) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31;
            int n6 = this.useSemanticNaming ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            int n7 = (n5 + n6) * 31;
            int n8 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            int n9 = (n7 + n8) * 31;
            int n10 = this.failOnWarnings ? 1 : 0;
            if (n10 != 0) {
                n10 = 1;
            }
            int n11 = (n9 + n10) * 31;
            int n12 = this.generateFragmentImplementations ? 1 : 0;
            if (n12 != 0) {
                n12 = 1;
            }
            int n13 = (n11 + n12) * 31;
            int n14 = this.generateAsInternal ? 1 : 0;
            if (n14 != 0) {
                n14 = 1;
            }
            int n15 = (n13 + n14) * 31;
            int n16 = this.generateFilterNotNull ? 1 : 0;
            if (n16 != 0) {
                n16 = 1;
            }
            Set<String> set3 = this.enumAsSealedClassPatternFilters;
            return (n15 + n16) * 31 + (set3 != null ? ((Object)set3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Arguments)) break block3;
                    Arguments arguments = (Arguments)object;
                    if (!Intrinsics.areEqual(this.rootFolders, arguments.rootFolders) || !Intrinsics.areEqual(this.graphqlFiles, arguments.graphqlFiles) || !Intrinsics.areEqual((Object)this.schemaFile, (Object)arguments.schemaFile) || !Intrinsics.areEqual((Object)this.outputDir, (Object)arguments.outputDir) || !Intrinsics.areEqual(this.metadata, arguments.metadata) || !Intrinsics.areEqual((Object)this.moduleName, (Object)arguments.moduleName) || !Intrinsics.areEqual((Object)this.metadataOutputFile, (Object)arguments.metadataOutputFile) || !Intrinsics.areEqual(this.alwaysGenerateTypesMatching, arguments.alwaysGenerateTypesMatching) || !Intrinsics.areEqual((Object)this.operationOutputFile, (Object)arguments.operationOutputFile) || !Intrinsics.areEqual((Object)this.operationOutputGenerator, (Object)arguments.operationOutputGenerator) || this.dumpIR != arguments.dumpIR || !Intrinsics.areEqual((Object)this.rootPackageName, (Object)arguments.rootPackageName) || this.generateKotlinModels != arguments.generateKotlinModels || !Intrinsics.areEqual(this.customScalarsMapping, arguments.customScalarsMapping) || this.useSemanticNaming != arguments.useSemanticNaming || this.warnOnDeprecatedUsages != arguments.warnOnDeprecatedUsages || this.failOnWarnings != arguments.failOnWarnings || this.generateFragmentImplementations != arguments.generateFragmentImplementations || this.generateAsInternal != arguments.generateAsInternal || this.generateFilterNotNull != arguments.generateFilterNotNull || !Intrinsics.areEqual(this.enumAsSealedClassPatternFilters, arguments.enumAsSealedClassPatternFilters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion;", "", "()V", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "collectMetadata", "Lcom/apollographql/apollo3/compiler/ApolloMetadata;", "metadata", "", "Ljava/io/File;", "getSchemaInfo", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion$SchemaInfo;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "rootPackageName", "", "schemaFile", "SchemaInfo", "apollo-compiler"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final ApolloMetadata collectMetadata(List<? extends File> metadata) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = metadata;
            ApolloMetadata.Companion companion = ApolloMetadata.Companion;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ApolloMetadata apolloMetadata;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (ApolloMetadata.Companion.readFrom(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ApolloMetadata it$iv$iv = apolloMetadata;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return companion.merge(list);
        }

        private final SchemaInfo getSchemaInfo(Roots roots, String rootPackageName, File schemaFile, ApolloMetadata metadata) {
            boolean bl = schemaFile != null || metadata != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "ApolloGraphQL: cannot find schema.[json | sdl]";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = schemaFile == null || metadata == null;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                File file = schemaFile;
                String string = "ApolloGraphQL: You can't define a schema in " + (file != null ? file.getAbsolutePath() : null) + " as one is already defined in a dependency. " + "Either remove the schema or the dependency";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (schemaFile != null) {
                String string;
                Schema schema = Intrinsics.areEqual((Object)FilesKt.getExtension((File)schemaFile), (Object)"json") ? Introspection_to_schemaKt.toSchema(IntrospectionSchema.Companion.invoke(schemaFile)) : GraphQLParser.INSTANCE.parseSchema(schemaFile);
                try {
                    String string2 = schemaFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"schemaFile.absolutePath");
                    string = roots.filePackageName(string2);
                }
                catch (IllegalArgumentException e) {
                    string = "";
                }
                String packageName = string;
                String schemaPackageName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(rootPackageName + '.' + packageName), (CharSequence)"."), (CharSequence)".");
                return new SchemaInfo(schema, schemaPackageName);
            }
            if (metadata != null) {
                Schema schema = metadata.getSchema();
                if (schema == null) {
                    Intrinsics.throwNpe();
                }
                String string = metadata.getSchemaPackageName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return new SchemaInfo(schema, string);
            }
            throw (Throwable)new IllegalStateException("There should at least be metadata or schemaFile");
        }

        @NotNull
        public final Logger getNoOpLogger() {
            return NoOpLogger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion$SchemaInfo;", "", "schema", "Lcom/apollographql/apollo3/compiler/frontend/Schema;", "schemaPackageName", "", "(Lcom/apollographql/apollo3/compiler/frontend/Schema;Ljava/lang/String;)V", "getSchema", "()Lcom/apollographql/apollo3/compiler/frontend/Schema;", "getSchemaPackageName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-compiler"})
        private static final class SchemaInfo {
            @NotNull
            private final Schema schema;
            @NotNull
            private final String schemaPackageName;

            @NotNull
            public final Schema getSchema() {
                return this.schema;
            }

            @NotNull
            public final String getSchemaPackageName() {
                return this.schemaPackageName;
            }

            public SchemaInfo(@NotNull Schema schema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
                this.schema = schema;
                this.schemaPackageName = schemaPackageName;
            }

            @NotNull
            public final Schema component1() {
                return this.schema;
            }

            @NotNull
            public final String component2() {
                return this.schemaPackageName;
            }

            @NotNull
            public final SchemaInfo copy(@NotNull Schema schema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
                return new SchemaInfo(schema, schemaPackageName);
            }

            public static /* synthetic */ SchemaInfo copy$default(SchemaInfo schemaInfo, Schema schema, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    schema = schemaInfo.schema;
                }
                if ((n & 2) != 0) {
                    string = schemaInfo.schemaPackageName;
                }
                return schemaInfo.copy(schema, string);
            }

            @NotNull
            public String toString() {
                return "SchemaInfo(schema=" + this.schema + ", schemaPackageName=" + this.schemaPackageName + ")";
            }

            public int hashCode() {
                Schema schema = this.schema;
                String string = this.schemaPackageName;
                return (schema != null ? schema.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SchemaInfo)) break block3;
                        SchemaInfo schemaInfo = (SchemaInfo)object;
                        if (!Intrinsics.areEqual((Object)this.schema, (Object)schemaInfo.schema) || !Intrinsics.areEqual((Object)this.schemaPackageName, (Object)schemaInfo.schemaPackageName)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

