/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.ast.Add_typenameKt;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GqldocumentKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.IssueKt;
import com.apollographql.apollo3.ast.ParseKt;
import com.apollographql.apollo3.ast.ParseResult;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.GraphQLCompiler;
import com.apollographql.apollo3.compiler.MetadataFragment;
import com.apollographql.apollo3.compiler.MoshiKt;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.PackageNameProvider;
import com.apollographql.apollo3.compiler.Roots;
import com.apollographql.apollo3.compiler.VersionKt;
import com.apollographql.apollo3.compiler.codegen.KotlinCodeGen;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchemaKt;
import com.apollographql.apollo3.compiler.introspection.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.ir.Ir;
import com.apollographql.apollo3.compiler.ir.IrBuilder;
import com.apollographql.apollo3.compiler.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.ir.IrEnum;
import com.apollographql.apollo3.compiler.ir.IrInputObject;
import com.apollographql.apollo3.compiler.ir.IrOperation;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "()V", "checkCustomScalars", "", "incomingOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "write", "operationFiles", "", "Ljava/io/File;", "outputDir", "debugDir", "moduleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "Companion", "IncomingOptions", "Logger", "ModuleOptions", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Companion.NoOpLogger.1 NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        }
    };
    @NotNull
    private static final List<MetadataFragment> defaultMetadataFragments = CollectionsKt.emptyList();
    @NotNull
    private static final PackageNameProvider.Flat defaultPackageNameProvider = new PackageNameProvider.Flat("com.apollographql.generated");
    @NotNull
    private static final Set<String> defaultAlwaysGenerateTypesMatching = SetsKt.emptySet();
    @Nullable
    private static final Void defaultOperationOutputFile;
    @NotNull
    private static final OperationOutputGenerator.Default defaultOperationOutputGenerator;
    @NotNull
    private static final Map<String, String> defaultCustomScalarsMapping;
    public static final boolean defaultUseSemanticNaming = true;
    public static final boolean defaultWarnOnDeprecatedUsages = true;
    public static final boolean defaultFailOnWarnings = false;
    @NotNull
    private static final Companion.NoOpLogger.1 defaultLogger;
    public static final boolean defaultGenerateAsInternal = false;
    public static final boolean defaultGenerateFilterNotNull = false;
    public static final boolean defaultGenerateFragmentsAsInterfaces = false;
    public static final boolean defaultGenerateFragmentImplementations = false;
    public static final boolean defaultGenerateResponseFields = true;
    public static final boolean defaultGenerateQueryDocument = true;
    @NotNull
    private static final String defaultModuleName = "apollographql";
    @NotNull
    public static final String defaultCodegenModels = "responseBased";
    @Nullable
    private static final Void defaultMetadataOutputFile;
    @NotNull
    private static final ModuleOptions DefaultModuleOptions;

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Set<? extends File> operationFiles, @NotNull File outputDir, @Nullable File debugDir, @NotNull IncomingOptions incomingOptions, @NotNull ModuleOptions moduleOptions) {
        void $this$mapTo$iv$iv8;
        void $this$mapTo$iv$iv222;
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv5;
        void $this$map$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Collection<GQLFragmentDefinition> collection;
        void $this$mapTo$iv$iv6;
        void $this$map$iv4;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv7;
        Intrinsics.checkParameterIsNotNull(operationFiles, (String)"operationFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)incomingOptions, (String)"incomingOptions");
        Intrinsics.checkParameterIsNotNull((Object)moduleOptions, (String)"moduleOptions");
        this.checkCustomScalars(incomingOptions);
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl = file == null ? null : Boolean.valueOf(FilesKt.deleteRecursively((File)file));
        file = debugDir;
        Boolean bl2 = file == null ? null : Boolean.valueOf(file.mkdirs());
        boolean bl3 = false;
        List definitions = new ArrayList();
        boolean bl4 = false;
        List parseIssues = new ArrayList();
        Iterable $this$map$iv5 = operationFiles;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv5;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv7) {
            boolean bl5;
            void file2;
            File file3 = (File)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl6 = false;
            ParseResult parseResult = ParseKt.parseAsGQLDocument((File)file2);
            if (parseResult instanceof ParseResult.Success) {
                bl5 = definitions.addAll(((GQLDocument)((ParseResult.Success)parseResult).getValue()).getDefinitions());
            } else if (parseResult instanceof ParseResult.Error) {
                bl5 = parseIssues.addAll(((ParseResult.Error)parseResult).getIssues());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = bl5;
            object2.add(object);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        IssueKt.checkNoErrors((List)parseIssues);
        Iterable $i$f$map22 = incomingOptions.getMetadataFragments();
        Collection collection2 = definitions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv4;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv6) {
            void it;
            MetadataFragment bl6 = (MetadataFragment)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl7 = false;
            GQLFragmentDefinition gQLFragmentDefinition = it.getDefinition();
            collection.add(gQLFragmentDefinition);
        }
        collection = (List)destination$iv$iv2;
        String string = null;
        List list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        List validationIssues = GqldocumentKt.validateAsOperations((GQLDocument)new GQLDocument(list, string), (Schema)incomingOptions.getSchema());
        IssueKt.checkNoErrors((List)validationIssues);
        if (moduleOptions.getWarnOnDeprecatedUsages()) {
            Object item$iv$iv;
            Iterable $this$filter$iv = validationIssues;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv = $this$filterTo$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                Object element$iv$iv = item$iv$iv.next();
                Issue it = (Issue)element$iv$iv;
                boolean bl8 = false;
                if (!(it.getSeverity() == Issue.Severity.WARNING)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List warnings = (List)destination$iv$iv3;
            Iterable $this$forEach$iv = warnings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Issue it = (Issue)element$iv;
                boolean bl9 = false;
                int column = it.getSourceLocation().getPosition() + 1;
                moduleOptions.getLogger().warning("w: " + it.getSourceLocation().getFilePath() + ':' + it.getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: " + it.getMessage());
            }
            if (moduleOptions.getFailOnWarnings()) {
                $this$forEach$iv = warnings;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv4;
        boolean $i$f$map3 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv3;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl10 = false;
            object = Add_typenameKt.withTypenameWhenNeeded((GQLFragmentDefinition)it, (Schema)incomingOptions.getSchema());
            object2.add(object);
        }
        List fragments = (List)destination$iv$iv4;
        Iterable $this$filterIsInstance$iv2 = definitions;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv4 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv5;
        boolean $i$f$map322 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv2;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            GQLOperationDefinition bl10 = (GQLOperationDefinition)item$iv$iv;
            object2 = destination$iv$iv5;
            boolean bl11 = false;
            object = Add_typenameKt.withTypenameWhenNeeded((GQLOperationDefinition)it, (Schema)incomingOptions.getSchema());
            object2.add(object);
        }
        List operations = (List)destination$iv$iv5;
        Iterable $i$f$map322 = incomingOptions.getMetadataFragments();
        object2 = fragments;
        boolean $i$f$map4 = false;
        destination$iv$iv5 = $this$map$iv;
        Iterable destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            MetadataFragment bl11 = (MetadataFragment)item$iv$iv;
            object = destination$iv$iv6;
            boolean bl12 = false;
            collection2 = it.getDefinition();
            object.add(collection2);
        }
        object = (List)destination$iv$iv6;
        Iterable $this$associateBy$iv = CollectionsKt.plus((Collection)object2, (Iterable)((Iterable)object));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv6 = $this$associateBy$iv;
        Object destination$iv$iv7 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GQLFragmentDefinition bl12 = (GQLFragmentDefinition)element$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl13 = false;
            object = it.getName();
            object2.put(object, element$iv$iv);
        }
        Map allFragmentDefinitions = destination$iv$iv7;
        Ir ir = new IrBuilder(incomingOptions.getSchema(), operations, allFragmentDefinitions, moduleOptions.getAlwaysGenerateTypesMatching(), incomingOptions.getCustomScalarsMapping(), incomingOptions.getCodegenModels()).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Iterable $this$map$iv2222 = ir.getOperations();
        boolean $i$f$map5 = false;
        destination$iv$iv7 = $this$map$iv2222;
        Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2222, (int)10));
        boolean $i$f$mapTo6 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            void it3;
            IrOperation bl13 = (IrOperation)item$iv$iv;
            object2 = destination$iv$iv8;
            boolean bl14 = false;
            object = new OperationDescriptor(it3.getName(), QueryDocumentMinifier.minify((String)it3.getSourceWithFragments()));
            object2.add(object);
        }
        $this$map$iv2222 = (List)destination$iv$iv8;
        $i$f$map5 = false;
        boolean $this$mapTo$iv$iv222 = false;
        Iterable it = $this$map$iv2222;
        boolean bl1522 = false;
        Map<String, OperationDescriptor> operationOutput = moduleOptions.getOperationOutputGenerator().generate((Collection)it);
        boolean $this$map$iv2222 = operationOutput.size() == operations.size();
        $i$f$map5 = false;
        $this$mapTo$iv$iv222 = false;
        if (!$this$map$iv2222) {
            boolean bl16 = false;
            String $this$mapTo$iv$iv222 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv222.toString());
        }
        if (moduleOptions.getOperationOutputFile() != null) {
            void $this$toJson$iv;
            File file4 = moduleOptions.getOperationOutputFile();
            Map<String, OperationDescriptor> $this$map$iv2222 = operationOutput;
            String indent$iv = "  ";
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            String bl1522 = MoshiKt.getMOSHI().adapter(Map.class).indent(indent$iv).toJson((Object)$this$toJson$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl1522, (String)"getJsonAdapter<T>().indent(indent).toJson(this)");
            FilesKt.writeText$default((File)file4, (String)bl1522, null, (int)2, null);
        }
        boolean $this$toJson$iv = moduleOptions.getGenerateAsInternal();
        boolean indent$iv = moduleOptions.getUseSemanticNaming();
        PackageNameProvider $i$f$toJson = moduleOptions.getPackageNameProvider();
        String $i$f$getJsonAdapter = Intrinsics.stringPlus((String)incomingOptions.getSchemaPackageName(), (Object)".type");
        boolean bl1522 = moduleOptions.getGenerateFilterNotNull();
        boolean element$iv$iv = moduleOptions.getGenerateFragmentImplementations();
        boolean item$iv$iv = moduleOptions.getGenerateQueryDocument();
        Set<String> $this$map$iv6 = (Set<String>)((Object)incomingOptions.getMetadataFragments());
        boolean $i$f$map422 = false;
        Set<String> set = $this$map$iv6;
        Collection destination$iv$iv2222 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo72 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv8) {
            void it2;
            MetadataFragment metadataFragment = (MetadataFragment)item$iv$iv2;
            object2 = destination$iv$iv2222;
            boolean bl17 = false;
            object = it2.getName();
            object2.add(object);
        }
        Set it3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2222));
        $this$map$iv6 = incomingOptions.getMetadataEnums();
        GQLFragmentDefinition $i$f$map422 = incomingOptions.getMetadataInputObjects();
        boolean $this$mapTo$iv$iv8 = !incomingOptions.isFromMetadata();
        boolean destination$iv$iv2222 = incomingOptions.getFlattenModels();
        $i$f$mapTo72 = !Intrinsics.areEqual((Object)incomingOptions.getCodegenModels(), (Object)"compat");
        new KotlinCodeGen(ir, $this$toJson$iv, indent$iv, $i$f$toJson, $i$f$getJsonAdapter, operationOutput, bl1522, element$iv$iv, item$iv$iv, it3, $this$map$iv6, (Set<String>)$i$f$map422, $this$mapTo$iv$iv8, destination$iv$iv2222, $i$f$mapTo72).write(outputDir);
        if (moduleOptions.getMetadataOutputFile() != null) {
            void $this$mapTo$iv$iv9;
            void $this$mapTo$iv$iv10;
            void $this$mapTo$iv$iv11;
            moduleOptions.getMetadataOutputFile().getParentFile().mkdirs();
            Schema schema = incomingOptions.isFromMetadata() ? (Schema)null : incomingOptions.getSchema();
            Iterable $this$map$iv7 = fragments;
            boolean $i$f$map6 = false;
            Iterable bl1522 = $this$map$iv7;
            Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
            boolean $i$f$mapTo222 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv11) {
                Iterator it4;
                $i$f$map422 = (GQLFragmentDefinition)item$iv$iv3;
                object2 = destination$iv$iv9;
                boolean bl18 = false;
                String destination$iv$iv2222 = it4.getName();
                PackageNameProvider packageNameProvider = moduleOptions.getPackageNameProvider();
                String $i$f$mapTo72 = it4.getSourceLocation().getFilePath();
                if ($i$f$mapTo72 == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = packageNameProvider.fragmentPackageName($i$f$mapTo72);
                object = new MetadataFragment(destination$iv$iv2222, (GQLFragmentDefinition)it4, string2);
                object2.add(object);
            }
            List outgoingMetadataFragments = (List)destination$iv$iv9;
            Map<String, String> map = incomingOptions.getCustomScalarsMapping();
            Iterable $this$map$iv8 = ir.getEnums();
            boolean $i$f$map7 = false;
            Iterable $i$f$mapTo222 = $this$map$iv8;
            Iterable destination$iv$iv10 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv8, (int)10));
            boolean $i$f$mapTo8 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv10) {
                void it5;
                IrEnum destination$iv$iv2222 = (IrEnum)item$iv$iv4;
                object2 = destination$iv$iv10;
                boolean bl19 = false;
                object = it5.getName();
                object2.add(object);
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv10));
            Iterable $this$map$iv9 = ir.getInputObjects();
            boolean $i$f$map8 = false;
            destination$iv$iv10 = $this$map$iv9;
            Collection destination$iv$iv11 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv9, (int)10));
            boolean $i$f$mapTo9 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv9) {
                void it6;
                IrInputObject bl19 = (IrInputObject)item$iv$iv5;
                object2 = destination$iv$iv11;
                boolean bl20 = false;
                object = it6.getName();
                object2.add(object);
            }
            Set set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv11));
            String string3 = incomingOptions.getCodegenModels();
            boolean bl21 = incomingOptions.getFlattenModels();
            String string4 = moduleOptions.getModuleName();
            String string5 = VersionKt.getVERSION();
            String string6 = incomingOptions.getSchemaPackageName();
            new ApolloMetadata(schema, outgoingMetadataFragments, set2, set3, string6, string4, string5, map, string3, bl21).writeTo(moduleOptions.getMetadataOutputFile());
        }
    }

    public static /* synthetic */ void write$default(GraphQLCompiler graphQLCompiler, Set set, File file, File file2, IncomingOptions incomingOptions, ModuleOptions moduleOptions, int n, Object object) {
        if ((n & 4) != 0) {
            file2 = null;
        }
        graphQLCompiler.write(set, file, file2, incomingOptions, moduleOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(IncomingOptions incomingOptions) {
        void $this$mapTo$iv$iv;
        GQLScalarTypeDefinition it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = incomingOptions.getSchema().getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLScalarTypeDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBuiltIn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            it = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = type.getName();
            collection.add(string);
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)incomingOptions.getCustomScalarsMapping().keySet(), (Iterable)schemaScalars);
        boolean bl = unknownScalars.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"ApolloGraphQL: unknown custom scalar(s): ", (Object)CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    static {
        defaultOperationOutputGenerator = new OperationOutputGenerator.Default(OperationIdGenerator.Sha256.INSTANCE);
        defaultCustomScalarsMapping = MapsKt.emptyMap();
        defaultLogger = NoOpLogger;
        Set<String> set = defaultAlwaysGenerateTypesMatching;
        Void void_ = defaultOperationOutputFile;
        OperationOutputGenerator.Default default_ = defaultOperationOutputGenerator;
        Companion.NoOpLogger.1 var3_3 = defaultLogger;
        PackageNameProvider.Flat flat = defaultPackageNameProvider;
        Void void_2 = defaultMetadataOutputFile;
        DefaultModuleOptions = new ModuleOptions(set, (File)((Object)void_2), flat, (File)((Object)void_), default_, true, true, false, var3_3, false, false, false, true, true, defaultModuleName);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 !2\u00020\u0001:\u0001!Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0018R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014\u00a8\u0006\""}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "schemaPackageName", "", "customScalarsMapping", "", "codegenModels", "flattenModels", "", "metadataInputObjects", "", "metadataEnums", "isFromMetadata", "metadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "(Lcom/apollographql/apollo3/ast/Schema;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;ZLjava/util/Set;Ljava/util/Set;ZLjava/util/List;)V", "getCodegenModels", "()Ljava/lang/String;", "getCustomScalarsMapping", "()Ljava/util/Map;", "getFlattenModels", "()Z", "getMetadataEnums", "()Ljava/util/Set;", "getMetadataFragments", "()Ljava/util/List;", "getMetadataInputObjects", "getSchema", "()Lcom/apollographql/apollo3/ast/Schema;", "getSchemaPackageName", "Companion", "apollo-compiler"})
    public static final class IncomingOptions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Schema schema;
        @NotNull
        private final String schemaPackageName;
        @NotNull
        private final Map<String, String> customScalarsMapping;
        @NotNull
        private final String codegenModels;
        private final boolean flattenModels;
        @NotNull
        private final Set<String> metadataInputObjects;
        @NotNull
        private final Set<String> metadataEnums;
        private final boolean isFromMetadata;
        @NotNull
        private final List<MetadataFragment> metadataFragments;

        public IncomingOptions(@NotNull Schema schema, @NotNull String schemaPackageName, @NotNull Map<String, String> customScalarsMapping, @NotNull String codegenModels, boolean flattenModels, @NotNull Set<String> metadataInputObjects, @NotNull Set<String> metadataEnums, boolean isFromMetadata, @NotNull List<MetadataFragment> metadataFragments) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
            Intrinsics.checkParameterIsNotNull((Object)codegenModels, (String)"codegenModels");
            Intrinsics.checkParameterIsNotNull(metadataInputObjects, (String)"metadataInputObjects");
            Intrinsics.checkParameterIsNotNull(metadataEnums, (String)"metadataEnums");
            Intrinsics.checkParameterIsNotNull(metadataFragments, (String)"metadataFragments");
            this.schema = schema;
            this.schemaPackageName = schemaPackageName;
            this.customScalarsMapping = customScalarsMapping;
            this.codegenModels = codegenModels;
            this.flattenModels = flattenModels;
            this.metadataInputObjects = metadataInputObjects;
            this.metadataEnums = metadataEnums;
            this.isFromMetadata = isFromMetadata;
            this.metadataFragments = metadataFragments;
        }

        @NotNull
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final String getSchemaPackageName() {
            return this.schemaPackageName;
        }

        @NotNull
        public final Map<String, String> getCustomScalarsMapping() {
            return this.customScalarsMapping;
        }

        @NotNull
        public final String getCodegenModels() {
            return this.codegenModels;
        }

        public final boolean getFlattenModels() {
            return this.flattenModels;
        }

        @NotNull
        public final Set<String> getMetadataInputObjects() {
            return this.metadataInputObjects;
        }

        @NotNull
        public final Set<String> getMetadataEnums() {
            return this.metadataEnums;
        }

        public final boolean isFromMetadata() {
            return this.isFromMetadata;
        }

        @NotNull
        public final List<MetadataFragment> getMetadataFragments() {
            return this.metadataFragments;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions$Companion;", "", "()V", "from", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "schemaFile", "Ljava/io/File;", "extraSchemaFiles", "", "customScalarsMapping", "", "", "codegenModels", "rootPackageName", "flattenModels", "", "fromMetadata", "metadata", "Lcom/apollographql/apollo3/compiler/ApolloMetadata;", "toGQLDocument", "Lcom/apollographql/apollo3/ast/GQLDocument;", "apollo-compiler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IncomingOptions fromMetadata(@NotNull ApolloMetadata metadata) {
                Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
                Schema schema = metadata.getSchema();
                if (schema == null) {
                    Intrinsics.throwNpe();
                }
                return new IncomingOptions(schema, metadata.getSchemaPackageName(), metadata.getCustomScalarsMapping(), metadata.getCodegenModels(), metadata.getFlattenModels(), metadata.getGeneratedInputObjects(), metadata.getGeneratedEnums(), true, metadata.getGeneratedFragments());
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IncomingOptions from(@NotNull Roots roots, @NotNull File schemaFile, @NotNull Set<? extends File> extraSchemaFiles, @NotNull Map<String, String> customScalarsMapping, @NotNull String codegenModels, @NotNull String rootPackageName, boolean flattenModels) {
                void $this$flatMapTo$iv$iv;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
                Intrinsics.checkParameterIsNotNull((Object)schemaFile, (String)"schemaFile");
                Intrinsics.checkParameterIsNotNull(extraSchemaFiles, (String)"extraSchemaFiles");
                Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
                Intrinsics.checkParameterIsNotNull((Object)codegenModels, (String)"codegenModels");
                Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
                try {
                    string = schemaFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schemaFile.absolutePath");
                    string = roots.filePackageName(string);
                }
                catch (Exception e) {
                    string = "";
                }
                String relativeSchemaPackageName = string;
                GQLDocument document = this.toGQLDocument(schemaFile);
                Iterable $this$flatMap$iv = extraSchemaFiles;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ((GQLDocument)ParseKt.parseAsGQLDocument((File)it).getOrThrow()).getDefinitions();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List extraDefinitions = (List)destination$iv$iv;
                Schema schema = GqldocumentKt.toSchema((GQLDocument)new GQLDocument(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)document.getDefinitions(), (Iterable)extraDefinitions), (Iterable)GqldocumentKt.apolloDefinitions()), null));
                return new IncomingOptions(schema, StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(rootPackageName + '.' + relativeSchemaPackageName), (CharSequence)"."), (CharSequence)"."), customScalarsMapping, codegenModels, flattenModels, SetsKt.emptySet(), SetsKt.emptySet(), false, CollectionsKt.emptyList());
            }

            private final GQLDocument toGQLDocument(File $this$toGQLDocument) {
                return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$toGQLDocument), (Object)"json") ? Introspection_to_schemaKt.toGQLDocument(IntrospectionSchemaKt.toIntrospectionSchema($this$toGQLDocument)) : (GQLDocument)ParseKt.parseAsGQLDocument((File)$this$toGQLDocument).getOrThrow();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\rH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\t\u00103\u001a\u00020\rH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\rH\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\t\u0010=\u001a\u00020\u0011H\u00c6\u0003J\u00a9\u0001\u0010>\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010?\u001a\u00020\r2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001c\u00a8\u0006D"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "", "alwaysGenerateTypesMatching", "", "", "metadataOutputFile", "Ljava/io/File;", "packageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "useSemanticNaming", "", "warnOnDeprecatedUsages", "failOnWarnings", "logger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "generateAsInternal", "generateFilterNotNull", "generateFragmentImplementations", "generateResponseFields", "generateQueryDocument", "moduleName", "(Ljava/util/Set;Ljava/io/File;Lcom/apollographql/apollo3/compiler/PackageNameProvider;Ljava/io/File;Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;ZZZLcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;ZZZZZLjava/lang/String;)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getFailOnWarnings", "()Z", "getGenerateAsInternal", "getGenerateFilterNotNull", "getGenerateFragmentImplementations", "getGenerateQueryDocument", "getGenerateResponseFields", "getLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "getPackageNameProvider", "()Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class ModuleOptions {
        @NotNull
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File metadataOutputFile;
        @NotNull
        private final PackageNameProvider packageNameProvider;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        private final boolean useSemanticNaming;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        @NotNull
        private final Logger logger;
        private final boolean generateAsInternal;
        private final boolean generateFilterNotNull;
        private final boolean generateFragmentImplementations;
        private final boolean generateResponseFields;
        private final boolean generateQueryDocument;
        @NotNull
        private final String moduleName;

        public ModuleOptions(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.metadataOutputFile = metadataOutputFile;
            this.packageNameProvider = packageNameProvider;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.useSemanticNaming = useSemanticNaming;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.logger = logger;
            this.generateAsInternal = generateAsInternal;
            this.generateFilterNotNull = generateFilterNotNull;
            this.generateFragmentImplementations = generateFragmentImplementations;
            this.generateResponseFields = generateResponseFields;
            this.generateQueryDocument = generateQueryDocument;
            this.moduleName = moduleName;
        }

        @NotNull
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider getPackageNameProvider() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getGenerateFilterNotNull() {
            return this.generateFilterNotNull;
        }

        public final boolean getGenerateFragmentImplementations() {
            return this.generateFragmentImplementations;
        }

        public final boolean getGenerateResponseFields() {
            return this.generateResponseFields;
        }

        public final boolean getGenerateQueryDocument() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final Set<String> component1() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component2() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider component3() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File component4() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component5() {
            return this.operationOutputGenerator;
        }

        public final boolean component6() {
            return this.useSemanticNaming;
        }

        public final boolean component7() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component8() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger component9() {
            return this.logger;
        }

        public final boolean component10() {
            return this.generateAsInternal;
        }

        public final boolean component11() {
            return this.generateFilterNotNull;
        }

        public final boolean component12() {
            return this.generateFragmentImplementations;
        }

        public final boolean component13() {
            return this.generateResponseFields;
        }

        public final boolean component14() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String component15() {
            return this.moduleName;
        }

        @NotNull
        public final ModuleOptions copy(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            return new ModuleOptions(alwaysGenerateTypesMatching, metadataOutputFile, packageNameProvider, operationOutputFile, operationOutputGenerator, useSemanticNaming, warnOnDeprecatedUsages, failOnWarnings, logger, generateAsInternal, generateFilterNotNull, generateFragmentImplementations, generateResponseFields, generateQueryDocument, moduleName);
        }

        public static /* synthetic */ ModuleOptions copy$default(ModuleOptions moduleOptions, Set set, File file, PackageNameProvider packageNameProvider, File file2, OperationOutputGenerator operationOutputGenerator, boolean bl, boolean bl2, boolean bl3, Logger logger, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String string, int n, Object object) {
            if ((n & 1) != 0) {
                set = moduleOptions.alwaysGenerateTypesMatching;
            }
            if ((n & 2) != 0) {
                file = moduleOptions.metadataOutputFile;
            }
            if ((n & 4) != 0) {
                packageNameProvider = moduleOptions.packageNameProvider;
            }
            if ((n & 8) != 0) {
                file2 = moduleOptions.operationOutputFile;
            }
            if ((n & 0x10) != 0) {
                operationOutputGenerator = moduleOptions.operationOutputGenerator;
            }
            if ((n & 0x20) != 0) {
                bl = moduleOptions.useSemanticNaming;
            }
            if ((n & 0x40) != 0) {
                bl2 = moduleOptions.warnOnDeprecatedUsages;
            }
            if ((n & 0x80) != 0) {
                bl3 = moduleOptions.failOnWarnings;
            }
            if ((n & 0x100) != 0) {
                logger = moduleOptions.logger;
            }
            if ((n & 0x200) != 0) {
                bl4 = moduleOptions.generateAsInternal;
            }
            if ((n & 0x400) != 0) {
                bl5 = moduleOptions.generateFilterNotNull;
            }
            if ((n & 0x800) != 0) {
                bl6 = moduleOptions.generateFragmentImplementations;
            }
            if ((n & 0x1000) != 0) {
                bl7 = moduleOptions.generateResponseFields;
            }
            if ((n & 0x2000) != 0) {
                bl8 = moduleOptions.generateQueryDocument;
            }
            if ((n & 0x4000) != 0) {
                string = moduleOptions.moduleName;
            }
            return moduleOptions.copy(set, file, packageNameProvider, file2, operationOutputGenerator, bl, bl2, bl3, logger, bl4, bl5, bl6, bl7, bl8, string);
        }

        @NotNull
        public String toString() {
            return "ModuleOptions(alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", metadataOutputFile=" + this.metadataOutputFile + ", packageNameProvider=" + this.packageNameProvider + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", useSemanticNaming=" + this.useSemanticNaming + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", logger=" + this.logger + ", generateAsInternal=" + this.generateAsInternal + ", generateFilterNotNull=" + this.generateFilterNotNull + ", generateFragmentImplementations=" + this.generateFragmentImplementations + ", generateResponseFields=" + this.generateResponseFields + ", generateQueryDocument=" + this.generateQueryDocument + ", moduleName=" + this.moduleName + ')';
        }

        public int hashCode() {
            int result = ((Object)this.alwaysGenerateTypesMatching).hashCode();
            result = result * 31 + (this.metadataOutputFile == null ? 0 : this.metadataOutputFile.hashCode());
            result = result * 31 + this.packageNameProvider.hashCode();
            result = result * 31 + (this.operationOutputFile == null ? 0 : this.operationOutputFile.hashCode());
            result = result * 31 + this.operationOutputGenerator.hashCode();
            int n = this.useSemanticNaming ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.failOnWarnings ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            result = result * 31 + this.logger.hashCode();
            int n4 = this.generateAsInternal ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            int n5 = this.generateFilterNotNull ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            result = result * 31 + n5;
            int n6 = this.generateFragmentImplementations ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            result = result * 31 + n6;
            int n7 = this.generateResponseFields ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            result = result * 31 + n7;
            int n8 = this.generateQueryDocument ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            result = result * 31 + n8;
            result = result * 31 + this.moduleName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleOptions)) {
                return false;
            }
            ModuleOptions moduleOptions = (ModuleOptions)other;
            if (!Intrinsics.areEqual(this.alwaysGenerateTypesMatching, moduleOptions.alwaysGenerateTypesMatching)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metadataOutputFile, (Object)moduleOptions.metadataOutputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.packageNameProvider, (Object)moduleOptions.packageNameProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputFile, (Object)moduleOptions.operationOutputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputGenerator, (Object)moduleOptions.operationOutputGenerator)) {
                return false;
            }
            if (this.useSemanticNaming != moduleOptions.useSemanticNaming) {
                return false;
            }
            if (this.warnOnDeprecatedUsages != moduleOptions.warnOnDeprecatedUsages) {
                return false;
            }
            if (this.failOnWarnings != moduleOptions.failOnWarnings) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logger, (Object)moduleOptions.logger)) {
                return false;
            }
            if (this.generateAsInternal != moduleOptions.generateAsInternal) {
                return false;
            }
            if (this.generateFilterNotNull != moduleOptions.generateFilterNotNull) {
                return false;
            }
            if (this.generateFragmentImplementations != moduleOptions.generateFragmentImplementations) {
                return false;
            }
            if (this.generateResponseFields != moduleOptions.generateResponseFields) {
                return false;
            }
            if (this.generateQueryDocument != moduleOptions.generateQueryDocument) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.moduleName, (Object)moduleOptions.moduleName);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion;", "", "()V", "DefaultModuleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "getDefaultModuleOptions", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "NoOpLogger", "com/apollographql/apollo3/compiler/GraphQLCompiler$Companion$NoOpLogger$1", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion$NoOpLogger$1;", "defaultAlwaysGenerateTypesMatching", "", "", "getDefaultAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "defaultCodegenModels", "defaultCustomScalarsMapping", "", "getDefaultCustomScalarsMapping", "()Ljava/util/Map;", "defaultFailOnWarnings", "", "defaultGenerateAsInternal", "defaultGenerateFilterNotNull", "defaultGenerateFragmentImplementations", "defaultGenerateFragmentsAsInterfaces", "defaultGenerateQueryDocument", "defaultGenerateResponseFields", "defaultLogger", "defaultMetadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "getDefaultMetadataFragments", "()Ljava/util/List;", "defaultMetadataOutputFile", "", "defaultModuleName", "defaultOperationOutputFile", "defaultOperationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator$Default;", "defaultPackageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider$Flat;", "defaultUseSemanticNaming", "defaultWarnOnDeprecatedUsages", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<MetadataFragment> getDefaultMetadataFragments() {
            return defaultMetadataFragments;
        }

        @NotNull
        public final Set<String> getDefaultAlwaysGenerateTypesMatching() {
            return defaultAlwaysGenerateTypesMatching;
        }

        @NotNull
        public final Map<String, String> getDefaultCustomScalarsMapping() {
            return defaultCustomScalarsMapping;
        }

        @NotNull
        public final ModuleOptions getDefaultModuleOptions() {
            return DefaultModuleOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

