/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.GQLArgument;
import com.apollographql.apollo3.ast.GQLArguments;
import com.apollographql.apollo3.ast.GQLBooleanValue;
import com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLDirectiveDefinition;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValue;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFieldDefinition;
import com.apollographql.apollo3.ast.GQLFloatValue;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLIntValue;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLListValue;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectField;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLObjectValue;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.GQLSelectionSet;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableDefinition;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqldirectiveKt;
import com.apollographql.apollo3.ast.GqlfieldKt;
import com.apollographql.apollo3.ast.GqloperationdefinitionKt;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.GqltypedefinitionKt;
import com.apollographql.apollo3.ast.InferredVariable;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.ValidationDetails;
import com.apollographql.apollo3.ast.VariableUsage;
import com.apollographql.apollo3.ast.internal.ValidationCommonKt;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001YB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0006H\u0002J$\u0010%\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0018\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J \u00102\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u00103\u001a\u00020 2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0016\u00107\u001a\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u0002050'H\u0002J\u0018\u00109\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020;0'2\u0006\u0010<\u001a\u00020\u0007J\u0018\u0010=\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010?\u001a\u00020@J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010<\u001a\u00020\u0007J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010C\u001a\u00020DJ\u0018\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00170'*\b\u0012\u0004\u0012\u00020\u00070'H\u0002J\u0018\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00170'*\b\u0012\u0004\u0012\u00020D0'H\u0002J\u0012\u0010G\u001a\b\u0012\u0004\u0012\u0002050'*\u00020HH\u0002J\u0012\u0010G\u001a\b\u0012\u0004\u0012\u0002050'*\u00020IH\u0002J\u001a\u0010G\u001a\b\u0012\u0004\u0012\u0002050'*\u00020J2\u0006\u0010K\u001a\u00020\u0006H\u0002J\u0014\u0010L\u001a\u0004\u0018\u00010,*\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010M\u001a\u0004\u0018\u00010,*\u00020,2\u0006\u0010N\u001a\u00020,H\u0002J*\u0010O\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HQ\u0012\u0004\u0012\u0002HQ0P0'\"\u0004\b\u0000\u0010Q*\b\u0012\u0004\u0012\u0002HQ0'H\u0002J\u001c\u0010>\u001a\u00020 *\u00020\"2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010S\u001a\u00020\u0006H\u0002J\f\u0010>\u001a\u00020 *\u00020\u0007H\u0002J$\u0010>\u001a\u00020 *\u00020H2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020U2\u0006\u0010S\u001a\u00020\u0006H\u0002J$\u0010>\u001a\u00020 *\u00020I2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020U2\u0006\u0010S\u001a\u00020\u0006H\u0002J\f\u0010>\u001a\u00020 *\u00020DH\u0002J&\u0010>\u001a\u00020 *\u00020J2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020U2\b\b\u0002\u0010S\u001a\u00020\u0006H\u0002J\u001c\u0010V\u001a\u00020 *\u00020W2\u0006\u0010T\u001a\u00020U2\u0006\u0010S\u001a\u00020\u0006H\u0002J\f\u0010X\u001a\u00020 *\u00020@H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope;", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "fragmentDefinitions", "", "", "Lcom/apollographql/apollo3/ast/GQLFragmentDefinition;", "fieldsOnDisjointTypesMustMerge", "", "(Lcom/apollographql/apollo3/ast/Schema;Ljava/util/Map;Z)V", "deferDirectiveLabels", "", "Lcom/apollographql/apollo3/ast/SourceLocation;", "deferDirectivePathAndLabels", "directiveDefinitions", "Lcom/apollographql/apollo3/ast/GQLDirectiveDefinition;", "getDirectiveDefinitions", "()Ljava/util/Map;", "foreignNames", "getForeignNames", "issues", "", "Lcom/apollographql/apollo3/ast/Issue;", "getIssues", "()Ljava/util/List;", "typeDefinitions", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "getTypeDefinitions", "variableUsages", "Lcom/apollographql/apollo3/ast/VariableUsage;", "addFieldMergingIssue", "", "fieldA", "Lcom/apollographql/apollo3/ast/GQLField;", "fieldB", "message", "areArgumentsEqual", "argumentsA", "", "Lcom/apollographql/apollo3/ast/GQLArgument;", "argumentsB", "areTypesEqual", "typeA", "Lcom/apollographql/apollo3/ast/GQLType;", "typeB", "areValuesEqual", "valueA", "Lcom/apollographql/apollo3/ast/GQLValue;", "valueB", "buildMessage", "fieldPairCanMerge", "fieldWithParentA", "Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope$FieldWithParent;", "fieldWithParentB", "fieldsInSetCanMerge", "fieldsWithParent", "haveSameResponseShape", "inferFragmentVariables", "Lcom/apollographql/apollo3/ast/InferredVariable;", "fragment", "sameResponseShapeRecursive", "validate", "document", "Lcom/apollographql/apollo3/ast/GQLDocument;", "validateFragment", "validateOperation", "operation", "Lcom/apollographql/apollo3/ast/GQLOperationDefinition;", "checkDuplicateFragments", "checkDuplicateOperations", "collectFields", "Lcom/apollographql/apollo3/ast/GQLFragmentSpread;", "Lcom/apollographql/apollo3/ast/GQLInlineFragment;", "Lcom/apollographql/apollo3/ast/GQLSelectionSet;", "parentType", "findCompatibleType", "mergeWith", "other", "pairs", "Lkotlin/Pair;", "T", "parentTypeDefinition", "path", "selectionSetParent", "Lcom/apollographql/apollo3/ast/GQLNode;", "validateDeferDirective", "Lcom/apollographql/apollo3/ast/GQLDirective;", "validateExecutable", "FieldWithParent", "apollo-ast"})
public final class ExecutableValidationScope
implements ValidationScope {
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, GQLFragmentDefinition> fragmentDefinitions;
    private final boolean fieldsOnDisjointTypesMustMerge;
    @NotNull
    private final Map<String, GQLTypeDefinition> typeDefinitions;
    @NotNull
    private final Map<String, GQLDirectiveDefinition> directiveDefinitions;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private final List<VariableUsage> variableUsages;
    @NotNull
    private final Map<String, SourceLocation> deferDirectiveLabels;
    @NotNull
    private final Map<String, SourceLocation> deferDirectivePathAndLabels;

    public ExecutableValidationScope(@NotNull Schema schema, @NotNull Map<String, GQLFragmentDefinition> fragmentDefinitions, boolean fieldsOnDisjointTypesMustMerge) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(fragmentDefinitions, (String)"fragmentDefinitions");
        this.schema = schema;
        this.fragmentDefinitions = fragmentDefinitions;
        this.fieldsOnDisjointTypesMustMerge = fieldsOnDisjointTypesMustMerge;
        this.typeDefinitions = this.schema.getTypeDefinitions();
        this.directiveDefinitions = this.schema.getDirectiveDefinitions();
        this.issues = new ArrayList();
        this.variableUsages = new ArrayList();
        this.deferDirectiveLabels = new LinkedHashMap();
        this.deferDirectivePathAndLabels = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Map<String, GQLTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @Override
    @NotNull
    public Map<String, GQLDirectiveDefinition> getDirectiveDefinitions() {
        return this.directiveDefinitions;
    }

    @Override
    @NotNull
    public Map<String, String> getForeignNames() {
        return this.schema.getForeignNames();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Issue> validate(@NotNull GQLDocument document) {
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.validateExecutable(document);
        Iterable $this$filterIsInstance$iv = document.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        this.checkDuplicateFragments(fragments);
        Iterable $this$forEach$iv = fragments;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)element$iv2;
            boolean bl = false;
            this.validate(it);
        }
        Iterable $this$filterIsInstance$iv2 = document.getDefinitions();
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List operations = (List)destination$iv$iv2;
        this.checkDuplicateOperations(operations);
        Iterable $this$forEach$iv2 = operations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            GQLOperationDefinition it = (GQLOperationDefinition)element$iv3;
            boolean bl = false;
            this.validate(it);
        }
        return this.getIssues();
    }

    @NotNull
    public final List<Issue> validateOperation(@NotNull GQLOperationDefinition operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.validate(operation);
        return this.getIssues();
    }

    @NotNull
    public final List<Issue> validateFragment(@NotNull GQLFragmentDefinition fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.validate(fragment);
        return this.getIssues();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InferredVariable> inferFragmentVariables(@NotNull GQLFragmentDefinition fragment) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.variableUsages.clear();
        this.validate(fragment);
        Iterable $this$groupBy$iv = this.variableUsages;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            VariableUsage it = (VariableUsage)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getVariable().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = destination$iv$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                VariableUsage variableUsage = (VariableUsage)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it2.getLocationType());
            }
            List types = (List)destination$iv$iv2;
            GQLType inferredType = this.findCompatibleType(types);
            if (inferredType == null) {
                throw new IllegalStateException(("Fragment " + fragment.getName() + " uses different types for variable '" + (String)it.getKey() + "': " + CollectionsKt.joinToString$default((Iterable)types, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            InferredVariable it$iv$iv = new InferredVariable((String)it.getKey(), inferredType);
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final GQLType findCompatibleType(List<? extends GQLType> $this$findCompatibleType) {
        void $this$fold$iv;
        Iterable iterable = CollectionsKt.drop((Iterable)$this$findCompatibleType, (int)1);
        Object initial$iv = CollectionsKt.first($this$findCompatibleType);
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void gqlType;
            GQLType gQLType = (GQLType)element$iv;
            GQLType acc = (GQLType)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc == null ? null : this.mergeWith(acc, (GQLType)gqlType);
        }
        return (GQLType)accumulator$iv;
    }

    private final GQLType mergeWith(GQLType $this$mergeWith, GQLType other) {
        GQLType gQLType;
        if ($this$mergeWith instanceof GQLNonNullType && other instanceof GQLNonNullType) {
            GQLNonNullType gQLNonNullType;
            GQLType gQLType2 = this.mergeWith(((GQLNonNullType)$this$mergeWith).getType(), ((GQLNonNullType)other).getType());
            if (gQLType2 != null) {
                GQLType it = gQLType2;
                boolean bl = false;
                gQLNonNullType = new GQLNonNullType(SourceLocation.Companion.getUNKNOWN(), it);
            } else {
                gQLNonNullType = null;
            }
            gQLType = gQLNonNullType;
        } else if ($this$mergeWith instanceof GQLNonNullType && !(other instanceof GQLNonNullType)) {
            GQLNonNullType gQLNonNullType;
            GQLType gQLType3 = this.mergeWith(((GQLNonNullType)$this$mergeWith).getType(), other);
            if (gQLType3 != null) {
                GQLType it = gQLType3;
                boolean bl = false;
                gQLNonNullType = new GQLNonNullType(SourceLocation.Companion.getUNKNOWN(), it);
            } else {
                gQLNonNullType = null;
            }
            gQLType = gQLNonNullType;
        } else if (!($this$mergeWith instanceof GQLNonNullType) && other instanceof GQLNonNullType) {
            GQLNonNullType gQLNonNullType;
            GQLType gQLType4 = this.mergeWith($this$mergeWith, ((GQLNonNullType)other).getType());
            if (gQLType4 != null) {
                GQLType it = gQLType4;
                boolean bl = false;
                gQLNonNullType = new GQLNonNullType(SourceLocation.Companion.getUNKNOWN(), it);
            } else {
                gQLNonNullType = null;
            }
            gQLType = gQLNonNullType;
        } else if ($this$mergeWith instanceof GQLListType && other instanceof GQLListType) {
            GQLListType gQLListType;
            GQLType gQLType5 = this.mergeWith(((GQLListType)$this$mergeWith).getType(), ((GQLListType)other).getType());
            if (gQLType5 != null) {
                GQLType it = gQLType5;
                boolean bl = false;
                gQLListType = new GQLListType(SourceLocation.Companion.getUNKNOWN(), it);
            } else {
                gQLListType = null;
            }
            gQLType = gQLListType;
        } else if ($this$mergeWith instanceof GQLListType && !(other instanceof GQLListType)) {
            gQLType = null;
        } else if (!($this$mergeWith instanceof GQLListType) && other instanceof GQLListType) {
            gQLType = null;
        } else if ($this$mergeWith instanceof GQLNamedType && other instanceof GQLNamedType) {
            gQLType = !Intrinsics.areEqual((Object)((GQLNamedType)$this$mergeWith).getName(), (Object)((GQLNamedType)other).getName()) ? (GQLNamedType)null : (GQLNamedType)$this$mergeWith;
        } else {
            throw new IllegalStateException();
        }
        return gQLType;
    }

    private final void validate(GQLField $this$validate, GQLTypeDefinition parentTypeDefinition, String path) {
        GQLFieldDefinition fieldDefinition = GqlfieldKt.definitionFromScope($this$validate, this.schema, parentTypeDefinition);
        if (fieldDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Can't query `" + $this$validate.getName() + "` on type `" + parentTypeDefinition.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (GqldirectiveKt.findDeprecationReason(fieldDefinition.getDirectives()) != null) {
            this.getIssues().add(new Issue.DeprecatedUsage("Use of deprecated field `" + $this$validate.getName() + '`', $this$validate.getSourceLocation()));
        }
        ValidationScope validationScope = this;
        Object object = $this$validate.getArguments();
        if (object == null || (object = ((GQLArguments)object).getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        ValidationCommonKt.validateArguments(validationScope, (List<GQLArgument>)object, $this$validate.getSourceLocation(), fieldDefinition.getArguments(), "field `" + fieldDefinition.getName() + '`', (Function1<? super VariableUsage, Unit>)((Function1)new Function1<VariableUsage, Unit>(this){
            final /* synthetic */ ExecutableValidationScope this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VariableUsage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExecutableValidationScope.access$getVariableUsages$p(this.this$0).add(it);
            }
        }));
        GQLTypeDefinition typeDefinition = this.getTypeDefinitions().get(GqltypeKt.rawType(fieldDefinition.getType()).getName());
        if (typeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Unknown type `" + GqltypeKt.rawType(fieldDefinition.getType()).getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!(typeDefinition instanceof GQLScalarTypeDefinition) && !(typeDefinition instanceof GQLEnumTypeDefinition)) {
            if ($this$validate.getSelectionSet() == null) {
                ValidationScope.DefaultImpls.registerIssue$default(this, "Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
                return;
            }
            String fieldPath = ((CharSequence)path).length() == 0 ? $this$validate.getName() : path + '.' + $this$validate.getName();
            this.validate($this$validate.getSelectionSet(), typeDefinition, (GQLNode)$this$validate, fieldPath);
        } else if ($this$validate.getSelectionSet() != null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must not have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate, (Function1<? super VariableUsage, Unit>)((Function1)new Function1<VariableUsage, Unit>(this){
                final /* synthetic */ ExecutableValidationScope this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VariableUsage it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ExecutableValidationScope.access$getVariableUsages$p(this.this$0).add(it);
                }
            }));
        }
    }

    private final void validate(GQLInlineFragment $this$validate, GQLTypeDefinition parentTypeDefinition, GQLNode selectionSetParent, String path) {
        GQLTypeDefinition inlineFragmentTypeDefinition = this.getTypeDefinitions().get($this$validate.getTypeCondition().getName());
        if (inlineFragmentTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for inline fragment", $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(inlineFragmentTypeDefinition, parentTypeDefinition, this.schema)) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Inline fragment cannot be spread here as result can never be of type `" + $this$validate.getTypeCondition().getName() + '`', $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate($this$validate.getSelectionSet(), inlineFragmentTypeDefinition, (GQLNode)$this$validate, path);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate, (Function1<? super VariableUsage, Unit>)((Function1)new Function1<VariableUsage, Unit>(this){
                final /* synthetic */ ExecutableValidationScope this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VariableUsage it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ExecutableValidationScope.access$getVariableUsages$p(this.this$0).add(it);
                }
            }));
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"defer") || StringsKt.startsWith$default((CharSequence)path, (char)'-', (boolean)false, (int)2, null)) continue;
            this.validateDeferDirective(it, selectionSetParent, path);
        }
    }

    private final void validate(GQLFragmentSpread $this$validate, GQLTypeDefinition parentTypeDefinition, GQLNode selectionSetParent, String path) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$validate.getName());
        if (fragmentDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find fragment `" + $this$validate.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        GQLTypeDefinition fragmentTypeDefinition = this.getTypeDefinitions().get(fragmentDefinition.getTypeCondition().getName());
        if (fragmentTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + fragmentDefinition.getTypeCondition().getName() + "` for fragment " + $this$validate.getName(), fragmentDefinition.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(fragmentTypeDefinition, parentTypeDefinition, this.schema)) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Fragment `" + $this$validate.getName() + "` cannot be spread here as result can never be of type `" + parentTypeDefinition.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate(fragmentDefinition.getSelectionSet(), fragmentTypeDefinition, (GQLNode)$this$validate, path);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate, (Function1<? super VariableUsage, Unit>)((Function1)new Function1<VariableUsage, Unit>(this){
                final /* synthetic */ ExecutableValidationScope this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VariableUsage it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ExecutableValidationScope.access$getVariableUsages$p(this.this$0).add(it);
                }
            }));
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"defer") || StringsKt.startsWith$default((CharSequence)path, (char)'-', (boolean)false, (int)2, null)) continue;
            this.validateDeferDirective(it, selectionSetParent, path);
        }
    }

    private final void validateExecutable(GQLDocument $this$validateExecutable) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$validateExecutable.getDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLDefinition it = (GQLDefinition)element$iv;
                boolean bl = false;
                if (!(!(it instanceof GQLOperationDefinition) && !(it instanceof GQLFragmentDefinition))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GQLDefinition gQLDefinition = v0;
        if (gQLDefinition != null) {
            GQLDefinition it = gQLDefinition;
            boolean bl = false;
            ValidationScope.DefaultImpls.registerIssue$default(this, "Found an non-executable definition.", it.getSourceLocation(), null, null, 12, null);
            return;
        }
    }

    private final void validate(GQLFragmentDefinition $this$validate) {
        GQLTypeDefinition fragmentRootTypeDefinition = this.getTypeDefinitions().get($this$validate.getTypeCondition().getName());
        if (fragmentRootTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for fragment `" + $this$validate.getName() + '`', $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate($this$validate.getSelectionSet(), fragmentRootTypeDefinition, (GQLNode)$this$validate, "-");
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), fragmentRootTypeDefinition.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(GQLOperationDefinition $this$validate) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        this.variableUsages.clear();
        this.deferDirectiveLabels.clear();
        this.deferDirectivePathAndLabels.clear();
        GQLTypeDefinition rootTypeDefinition = GqloperationdefinitionKt.rootTypeDefinition($this$validate, this.schema);
        if (rootTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find a root type for operation type `" + $this$validate.getOperationType() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        ExecutableValidationScope.validate$default(this, $this$validate.getSelectionSet(), rootTypeDefinition, $this$validate, null, 4, null);
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), rootTypeDefinition.getName()));
        Iterable $this$forEach$iv = this.variableUsages;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            VariableUsage it = (VariableUsage)element$iv2;
            boolean bl = false;
            ValidationCommonKt.validateVariable(this, $this$validate, it);
        }
        Iterable $this$map$iv = this.variableUsages;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VariableUsage variableUsage = (VariableUsage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVariable().getName());
        }
        Set foundVariables = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv2 = $this$validate.getVariableDefinitions();
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            GQLVariableDefinition it = (GQLVariableDefinition)element$iv3;
            boolean bl = false;
            if (foundVariables.contains(it.getName())) continue;
            this.getIssues().add(new Issue.UnusedVariable("Variable `" + it.getName() + "` is unused", it.getSourceLocation()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void validateDeferDirective(GQLDirective $this$validateDeferDirective, GQLNode selectionSetParent, String path) {
        block10: {
            v0 = $this$validateDeferDirective.getArguments();
            if (v0 == null || (v0 = v0.getArguments()) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = (Iterable)v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (GQLArgument)element$iv;
                $i$a$-firstOrNull-ExecutableValidationScope$validateDeferDirective$label$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"label")) continue;
                v1 = element$iv;
                break block10;
            }
            v1 = null;
        }
        if ((v0 = (GQLArgument)v1) != null) {
            v2 = v0.getValue();
        } else lbl-1000:
        // 2 sources

        {
            v2 = label = null;
        }
        if (label instanceof GQLVariableValue) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "@defer label argument must not be a variable", $this$validateDeferDirective.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (selectionSetParent instanceof GQLOperationDefinition && (Intrinsics.areEqual((Object)((GQLOperationDefinition)selectionSetParent).getOperationType(), (Object)"mutation") || Intrinsics.areEqual((Object)((GQLOperationDefinition)selectionSetParent).getOperationType(), (Object)"subscription"))) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "The @defer directive is not allowed to be used on root fields of mutations or subscriptions", $this$validateDeferDirective.getSourceLocation(), null, null, 12, null);
        }
        labelStringValue = "";
        if (label != null) {
            if (!(label instanceof GQLStringValue)) {
                return;
            }
            labelStringValue = ((GQLStringValue)label).getValue();
            var6_12 = labelStringValue;
            if (!new Regex("[a-zA-Z0-9_]+").matches(var6_12)) {
                ValidationScope.DefaultImpls.registerIssue$default(this, "@defer label '" + labelStringValue + "' must only contain letters, numbers, or underscores", $this$validateDeferDirective.getSourceLocation(), null, null, 12, null);
            }
            if (this.deferDirectiveLabels.containsKey(labelStringValue)) {
                v3 = this;
                v4 = new StringBuilder().append("@defer label '").append(labelStringValue).append("' must be unique within all other @defer directives in the document. Same label found in ");
                v5 = this.deferDirectiveLabels.get(labelStringValue);
                Intrinsics.checkNotNull((Object)v5);
                ValidationScope.DefaultImpls.registerIssue$default(v3, v4.append(v5.pretty()).toString(), $this$validateDeferDirective.getSourceLocation(), null, null, 12, null);
                return;
            }
            this.deferDirectiveLabels.put(labelStringValue, $this$validateDeferDirective.getSourceLocation());
        }
        if (this.deferDirectivePathAndLabels.containsKey(pathAndLabel = path + '/' + labelStringValue)) {
            labelMessage = ((CharSequence)labelStringValue).length() == 0 != false ? "no label" : "label '" + labelStringValue + '\'';
            v6 = this;
            v7 = new StringBuilder().append("A @defer directive with the same path '").append(path).append("' and ").append(labelMessage).append(" is already defined in ");
            v8 = this.deferDirectivePathAndLabels.get(pathAndLabel);
            Intrinsics.checkNotNull((Object)v8);
            ValidationScope.DefaultImpls.registerIssue$default(v6, v7.append(v8.pretty()).append(". Set a unique label to distinguish them.").toString(), $this$validateDeferDirective.getSourceLocation(), null, null, 12, null);
            return;
        }
        this.deferDirectivePathAndLabels.put(pathAndLabel, $this$validateDeferDirective.getSourceLocation());
    }

    private final void validate(GQLSelectionSet $this$validate, GQLTypeDefinition parentTypeDefinition, GQLNode selectionSetParent, String path) {
        if ($this$validate.getSelections().isEmpty()) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Selection of type `" + parentTypeDefinition.getName() + "` must have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getSelections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                this.validate((GQLField)it, parentTypeDefinition, path);
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                this.validate((GQLInlineFragment)it, parentTypeDefinition, selectionSetParent, path);
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread)) continue;
            this.validate((GQLFragmentSpread)it, parentTypeDefinition, selectionSetParent, path);
        }
    }

    static /* synthetic */ void validate$default(ExecutableValidationScope executableValidationScope, GQLSelectionSet gQLSelectionSet, GQLTypeDefinition gQLTypeDefinition, GQLNode gQLNode, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        executableValidationScope.validate(gQLSelectionSet, gQLTypeDefinition, gQLNode, string);
    }

    private final void fieldPairCanMerge(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        List<FieldWithParent> list;
        List<FieldWithParent> setA;
        Object object;
        GQLType typeB;
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        if (!Intrinsics.areEqual((Object)parentTypeDefinitionA.getName(), (Object)parentTypeDefinitionB.getName()) && parentTypeDefinitionA instanceof GQLObjectTypeDefinition && parentTypeDefinitionB instanceof GQLObjectTypeDefinition) {
            this.sameResponseShapeRecursive(fieldWithParentA, fieldWithParentB);
            return;
        }
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLFieldDefinition gQLFieldDefinition = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLType typeA = gQLFieldDefinition != null ? gQLFieldDefinition.getType() : null;
        GQLFieldDefinition gQLFieldDefinition2 = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        GQLType gQLType = typeB = gQLFieldDefinition2 != null ? gQLFieldDefinition2.getType() : null;
        if (typeA == null || typeB == null) {
            return;
        }
        if (!this.areTypesEqual(typeA, typeB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different types");
            return;
        }
        Object object2 = fieldA.getArguments();
        if (object2 == null || (object2 = ((GQLArguments)object2).getArguments()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        if ((object = fieldB.getArguments()) == null || (object = ((GQLArguments)object).getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        if (!this.areArgumentsEqual((List<GQLArgument>)object2, (List<GQLArgument>)object)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different arguments");
            return;
        }
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return;
        }
        Object object3 = fieldA.getSelectionSet();
        if (object3 == null || (object3 = this.collectFields((GQLSelectionSet)object3, GqltypeKt.rawType(typeA).getName())) == null) {
            object3 = setA = CollectionsKt.emptyList();
        }
        if ((list = fieldB.getSelectionSet()) == null || (list = this.collectFields((GQLSelectionSet)((Object)list), GqltypeKt.rawType(typeB).getName())) == null) {
            list = CollectionsKt.emptyList();
        }
        List<FieldWithParent> setB = list;
        this.fieldsInSetCanMerge(CollectionsKt.plus((Collection)setA, (Iterable)setB));
    }

    /*
     * WARNING - void declaration
     */
    private final void fieldsInSetCanMerge(List<FieldWithParent> fieldsWithParent) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = fieldsWithParent;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List fieldsForName = (List)element$iv;
            boolean bl = false;
            if (fieldsForName.size() == 1) {
                FieldWithParent first = (FieldWithParent)CollectionsKt.first((List)fieldsForName);
                GQLFieldDefinition fieldDefinition = GqlfieldKt.definitionFromScope(first.getField(), this.schema, first.getParentTypeDefinition().getName());
                if (fieldDefinition == null) continue;
                Object object = first.getField().getSelectionSet();
                if (object == null || (object = this.collectFields((GQLSelectionSet)object, GqltypeKt.rawType(fieldDefinition.getType()).getName())) == null) {
                    object = CollectionsKt.emptyList();
                }
                List<FieldWithParent> set = object;
                this.fieldsInSetCanMerge(set);
                continue;
            }
            Iterable $this$forEach$iv2 = this.pairs(fieldsForName);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair it = (Pair)element$iv2;
                boolean bl3 = false;
                this.fieldPairCanMerge((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond());
            }
        }
    }

    private final boolean areTypesEqual(GQLType typeA, GQLType typeB) {
        boolean bl;
        GQLType gQLType = typeA;
        if (gQLType instanceof GQLNonNullType) {
            bl = typeB instanceof GQLNonNullType && this.areTypesEqual(((GQLNonNullType)typeA).getType(), ((GQLNonNullType)typeB).getType());
        } else if (gQLType instanceof GQLListType) {
            bl = typeB instanceof GQLListType && this.areTypesEqual(((GQLListType)typeA).getType(), ((GQLListType)typeB).getType());
        } else if (gQLType instanceof GQLNamedType) {
            bl = typeB instanceof GQLNamedType && Intrinsics.areEqual((Object)((GQLNamedType)typeA).getName(), (Object)((GQLNamedType)typeB).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areArgumentsEqual(List<GQLArgument> argumentsA, List<GQLArgument> argumentsB) {
        void $this$groupByTo$iv$iv;
        if (argumentsA.size() != argumentsB.size()) {
            return false;
        }
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)argumentsA, (Iterable)argumentsB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GQLArgument it = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            if (it.size() != 2) {
                return false;
            }
            if (this.areValuesEqual(((GQLArgument)it.get(0)).getValue(), ((GQLArgument)it.get(1)).getValue())) continue;
            return false;
        }
        return true;
    }

    private final String buildMessage(GQLField fieldA, GQLField fieldB, String message) {
        return '`' + GqlfieldKt.responseName(fieldA) + "` cannot be merged with `" + GqlfieldKt.responseName(fieldB) + "` (at " + fieldB.getSourceLocation().pretty() + "): " + message + ". Use different aliases on the fields to fetch both if this was intentional.";
    }

    private final void addFieldMergingIssue(GQLField fieldA, GQLField fieldB, String message) {
        ValidationScope.DefaultImpls.registerIssue$default(this, this.buildMessage(fieldA, fieldB, message), fieldA.getSourceLocation(), null, null, 12, null);
        ValidationScope.DefaultImpls.registerIssue$default(this, this.buildMessage(fieldB, fieldA, message), fieldB.getSourceLocation(), null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areValuesEqual(GQLValue valueA, GQLValue valueB) {
        boolean bl;
        GQLValue gQLValue = valueA;
        if (gQLValue instanceof GQLIntValue) {
            GQLIntValue gQLIntValue = valueB instanceof GQLIntValue ? (GQLIntValue)valueB : null;
            bl = gQLIntValue != null ? gQLIntValue.getValue() == ((GQLIntValue)valueA).getValue() : false;
        } else if (gQLValue instanceof GQLFloatValue) {
            GQLFloatValue gQLFloatValue = valueB instanceof GQLFloatValue ? (GQLFloatValue)valueB : null;
            bl = Intrinsics.areEqual((Double)(gQLFloatValue != null ? Double.valueOf(gQLFloatValue.getValue()) : null), (double)((GQLFloatValue)valueA).getValue());
        } else if (gQLValue instanceof GQLStringValue) {
            GQLStringValue gQLStringValue = valueB instanceof GQLStringValue ? (GQLStringValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLStringValue != null ? gQLStringValue.getValue() : null), (Object)((GQLStringValue)valueA).getValue());
        } else if (gQLValue instanceof GQLBooleanValue) {
            GQLBooleanValue gQLBooleanValue = valueB instanceof GQLBooleanValue ? (GQLBooleanValue)valueB : null;
            bl = gQLBooleanValue != null ? gQLBooleanValue.getValue() == ((GQLBooleanValue)valueA).getValue() : false;
        } else if (gQLValue instanceof GQLEnumValue) {
            GQLEnumValue gQLEnumValue = valueB instanceof GQLEnumValue ? (GQLEnumValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLEnumValue != null ? gQLEnumValue.getValue() : null), (Object)((GQLEnumValue)valueA).getValue());
        } else if (gQLValue instanceof GQLNullValue) {
            bl = valueB instanceof GQLNullValue;
        } else if (gQLValue instanceof GQLListValue) {
            if (!(valueB instanceof GQLListValue)) {
                return false;
            }
            int n = ((GQLListValue)valueA).getValues().size();
            for (int i = 0; i < n; ++i) {
                if (this.areValuesEqual(((GQLListValue)valueA).getValues().get(i), ((GQLListValue)valueB).getValues().get(i))) continue;
                return false;
            }
            bl = true;
        } else if (gQLValue instanceof GQLObjectValue) {
            void $this$groupByTo$iv$iv;
            if (!(valueB instanceof GQLObjectValue)) {
                return false;
            }
            Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)((GQLObjectValue)valueA).getFields(), (Iterable)((GQLObjectValue)valueB).getFields());
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                GQLObjectField it = (GQLObjectField)element$iv$iv;
                boolean bl2 = false;
                String key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = destination$iv$iv.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl4 = false;
                if (it.size() != 2) {
                    return false;
                }
                if (this.areValuesEqual(((GQLObjectField)it.get(0)).getValue(), ((GQLObjectField)it.get(1)).getValue())) continue;
                return false;
            }
            bl = true;
        } else if (gQLValue instanceof GQLVariableValue) {
            GQLVariableValue gQLVariableValue = valueB instanceof GQLVariableValue ? (GQLVariableValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLVariableValue != null ? gQLVariableValue.getName() : null), (Object)((GQLVariableValue)valueA).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean sameResponseShapeRecursive(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        void $this$groupByTo$iv$iv;
        List<FieldWithParent> list;
        List<FieldWithParent> setA;
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return false;
        }
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        Object object = fieldWithParentA.getField().getSelectionSet();
        if (object == null || (object = this.collectFields((GQLSelectionSet)object, parentTypeDefinitionA.getName())) == null) {
            object = setA = CollectionsKt.emptyList();
        }
        if ((list = fieldWithParentA.getField().getSelectionSet()) == null || (list = this.collectFields((GQLSelectionSet)((Object)list), parentTypeDefinitionB.getName())) == null) {
            list = CollectionsKt.emptyList();
        }
        List<FieldWithParent> setB = list;
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)setA, (Iterable)setB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v3;
            block8: {
                List fieldsForName = (List)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.pairs(fieldsForName);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv2;
                    boolean bl3 = false;
                    if (!this.sameResponseShapeRecursive((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond())) continue;
                    v3 = element$iv2;
                    break block8;
                }
                v3 = null;
            }
            if (v3 == null) continue;
            return false;
        }
        return true;
    }

    private final boolean haveSameResponseShape(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        if (!this.fieldsOnDisjointTypesMustMerge) {
            return true;
        }
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        GQLFieldDefinition fieldDefinitionA = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLFieldDefinition fieldDefinitionB = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        if (fieldDefinitionA == null || fieldDefinitionB == null) {
            return true;
        }
        GQLType typeA = null;
        typeA = fieldDefinitionA.getType();
        GQLType typeB = null;
        typeB = fieldDefinitionB.getType();
        while (true) {
            if (!(typeA instanceof GQLNonNullType || typeA instanceof GQLListType || typeB instanceof GQLNonNullType)) {
                if (!(typeB instanceof GQLListType)) break;
            }
            if (typeA instanceof GQLNonNullType && !(typeB instanceof GQLNonNullType)) {
                return false;
            }
            if (!(typeA instanceof GQLNonNullType) && typeB instanceof GQLNonNullType) {
                return false;
            }
            if (typeA instanceof GQLNonNullType && typeB instanceof GQLNonNullType) {
                typeA = ((GQLNonNullType)typeA).getType();
                typeB = ((GQLNonNullType)typeB).getType();
            }
            if (typeA instanceof GQLListType && !(typeB instanceof GQLListType)) {
                return false;
            }
            if (!(typeA instanceof GQLListType) && typeB instanceof GQLListType) {
                return false;
            }
            if (!(typeA instanceof GQLListType) || !(typeB instanceof GQLListType)) continue;
            typeA = ((GQLListType)typeA).getType();
            typeB = ((GQLListType)typeB).getType();
        }
        if (!(typeA instanceof GQLNamedType && typeB instanceof GQLNamedType)) {
            boolean $i$a$-check-ExecutableValidationScope$haveSameResponseShape$22 = false;
            String $i$a$-check-ExecutableValidationScope$haveSameResponseShape$22 = GqltypeKt.pretty(typeA) + " and " + GqltypeKt.pretty(typeB) + " should be GQLNamedType";
            throw new IllegalStateException($i$a$-check-ExecutableValidationScope$haveSameResponseShape$22.toString());
        }
        GQLTypeDefinition typeDefinitionA = this.getTypeDefinitions().get(((GQLNamedType)typeA).getName());
        GQLTypeDefinition typeDefinitionB = this.getTypeDefinitions().get(((GQLNamedType)typeB).getName());
        if (typeDefinitionA == null || typeDefinitionB == null) {
            return true;
        }
        if (typeDefinitionA instanceof GQLScalarTypeDefinition || typeDefinitionA instanceof GQLEnumTypeDefinition || typeDefinitionB instanceof GQLScalarTypeDefinition || typeDefinitionB instanceof GQLEnumTypeDefinition) {
            return Intrinsics.areEqual((Object)typeDefinitionA.getName(), (Object)typeDefinitionB.getName());
        }
        return true;
    }

    private final <T> List<Pair<T, T>> pairs(List<? extends T> $this$pairs) {
        List pairs = new ArrayList();
        int n = $this$pairs.size();
        for (int i = 0; i < n; ++i) {
            int n2 = $this$pairs.size();
            for (int j = i + 1; j < n2; ++j) {
                pairs.add(TuplesKt.to($this$pairs.get(i), $this$pairs.get(j)));
            }
        }
        return pairs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldWithParent> collectFields(GQLSelectionSet $this$collectFields, String parentType) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectFields.getSelections();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            GQLSelection selection = (GQLSelection)element$iv$iv;
            boolean bl = false;
            GQLSelection gQLSelection = selection;
            if (gQLSelection instanceof GQLField) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object)this.getTypeDefinitions().get(parentType));
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FieldWithParent fieldWithParent;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    GQLTypeDefinition typeDefinition = (GQLTypeDefinition)element$iv$iv2;
                    boolean bl3 = false;
                    if (typeDefinition != null) {
                        GQLTypeDefinition it;
                        boolean bl4 = false;
                        fieldWithParent = new FieldWithParent((GQLField)selection, it);
                    } else {
                        fieldWithParent = null;
                    }
                    if (fieldWithParent == null) continue;
                    FieldWithParent it$iv$iv = fieldWithParent;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else if (gQLSelection instanceof GQLInlineFragment) {
                list = this.collectFields((GQLInlineFragment)selection);
            } else if (gQLSelection instanceof GQLFragmentSpread) {
                list = this.collectFields((GQLFragmentSpread)selection);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FieldWithParent> collectFields(GQLInlineFragment $this$collectFields) {
        return this.collectFields($this$collectFields.getSelectionSet(), $this$collectFields.getTypeCondition().getName());
    }

    private final List<FieldWithParent> collectFields(GQLFragmentSpread $this$collectFields) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$collectFields.getName());
        if (fragmentDefinition == null) {
            return CollectionsKt.emptyList();
        }
        return this.collectFields(fragmentDefinition.getSelectionSet(), fragmentDefinition.getTypeCondition().getName());
    }

    private final List<Issue> checkDuplicateFragments(List<GQLFragmentDefinition> $this$checkDuplicateFragments) {
        Map filtered = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$checkDuplicateFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)element$iv;
            boolean bl = false;
            GQLFragmentDefinition existing = filtered.putIfAbsent(it.getName(), it);
            if (existing == null) continue;
            this.getIssues().add(new Issue.ValidationError("Fragment " + it.getName() + " is already defined", it.getSourceLocation(), null, null, 12, null));
        }
        return this.getIssues();
    }

    private final List<Issue> checkDuplicateOperations(List<GQLOperationDefinition> $this$checkDuplicateOperations) {
        Map filtered = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$checkDuplicateOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLOperationDefinition it = (GQLOperationDefinition)element$iv;
            boolean bl = false;
            if (it.getName() == null) {
                this.getIssues().add(new Issue.ValidationError("Apollo does not support anonymous operations", it.getSourceLocation(), null, null, 12, null));
                continue;
            }
            GQLOperationDefinition existing = filtered.putIfAbsent(it.getName(), it);
            if (existing == null) continue;
            this.getIssues().add(new Issue.ValidationError("Operation " + it.getName() + " is already defined", it.getSourceLocation(), null, null, 12, null));
        }
        return this.getIssues();
    }

    @Override
    @NotNull
    public String originalDirectiveName(@NotNull String name) {
        return ValidationScope.DefaultImpls.originalDirectiveName(this, name);
    }

    @Override
    @NotNull
    public String originalTypeName(@NotNull String name) {
        return ValidationScope.DefaultImpls.originalTypeName(this, name);
    }

    @Override
    public void registerIssue(@NotNull String message, @NotNull SourceLocation sourceLocation, @NotNull Issue.Severity severity, @NotNull ValidationDetails details) {
        ValidationScope.DefaultImpls.registerIssue(this, message, sourceLocation, severity, details);
    }

    public static final /* synthetic */ List access$getVariableUsages$p(ExecutableValidationScope $this) {
        return $this.variableUsages;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope$FieldWithParent;", "", "field", "Lcom/apollographql/apollo3/ast/GQLField;", "parentTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "(Lcom/apollographql/apollo3/ast/GQLField;Lcom/apollographql/apollo3/ast/GQLTypeDefinition;)V", "getField", "()Lcom/apollographql/apollo3/ast/GQLField;", "getParentTypeDefinition", "()Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "apollo-ast"})
    private static final class FieldWithParent {
        @NotNull
        private final GQLField field;
        @NotNull
        private final GQLTypeDefinition parentTypeDefinition;

        public FieldWithParent(@NotNull GQLField field, @NotNull GQLTypeDefinition parentTypeDefinition) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)parentTypeDefinition, (String)"parentTypeDefinition");
            this.field = field;
            this.parentTypeDefinition = parentTypeDefinition;
        }

        @NotNull
        public final GQLField getField() {
            return this.field;
        }

        @NotNull
        public final GQLTypeDefinition getParentTypeDefinition() {
            return this.parentTypeDefinition;
        }
    }
}

