/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u0005"}, d2={"decodeAsGraphQLSingleQuoted", "", "decodeAsGraphQLTripleQuoted", "encodeToGraphQLSingleQuoted", "encodeToGraphQLTripleQuoted", "apollo-ast"})
public final class GqlstringsKt {
    @NotNull
    public static final String decodeAsGraphQLSingleQuoted(@NotNull String $this$decodeAsGraphQLSingleQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeAsGraphQLSingleQuoted, (String)"<this>");
        StringBuilder writer = new StringBuilder($this$decodeAsGraphQLSingleQuoted.length());
        int i = 0;
        while (i < $this$decodeAsGraphQLSingleQuoted.length()) {
            char c = $this$decodeAsGraphQLSingleQuoted.charAt(i);
            ++i;
            if (c != '\\') {
                writer.append(c);
                continue;
            }
            char escaped = $this$decodeAsGraphQLSingleQuoted.charAt(i);
            char c2 = escaped;
            if (c2 == '\"') {
                writer.append('\"');
                ++i;
                continue;
            }
            if (c2 == '/') {
                writer.append('/');
                ++i;
                continue;
            }
            if (c2 == '\\') {
                writer.append('\\');
                ++i;
                continue;
            }
            if (c2 == 'b') {
                writer.append('\b');
                ++i;
                continue;
            }
            if (c2 == 'f') {
                writer.append(12);
                ++i;
                continue;
            }
            if (c2 == 'n') {
                writer.append(10);
                ++i;
                continue;
            }
            if (c2 == 'r') {
                writer.append('\r');
                ++i;
                continue;
            }
            if (c2 == 't') {
                writer.append('\t');
                ++i;
                continue;
            }
            if (c2 == 'u') {
                String string = $this$decodeAsGraphQLSingleQuoted.substring(i + 1, i + 5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int codepoint = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                writer.appendCodePoint(codepoint);
                i += 5;
                continue;
            }
            throw new IllegalStateException("Bad escaped character: " + c);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeAsGraphQLTripleQuoted(@NotNull String $this$decodeAsGraphQLTripleQuoted) {
        List list;
        List lines;
        block16: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$decodeAsGraphQLTripleQuoted, (String)"<this>");
            String value = StringsKt.replace$default((String)$this$decodeAsGraphQLTripleQuoted, (String)"\\\"\"\"", (String)"\"\"\"", (boolean)false, (int)4, null);
            String[] stringArray = new String[]{"\n"};
            lines = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Integer commonIndent = null;
            for (String line : CollectionsKt.drop((Iterable)lines, (int)1)) {
                int firstNonWhitespace;
                int n;
                block13: {
                    CharSequence $this$indexOfFirst$iv = line;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it != ' ' && it != '\t')) continue;
                        n = index$iv;
                        break block13;
                    }
                    n = -1;
                }
                if ((firstNonWhitespace = n) == -1 || commonIndent != null && firstNonWhitespace >= ((Number)commonIndent).intValue()) continue;
                commonIndent = firstNonWhitespace;
            }
            Iterable iterable = CollectionsKt.drop((Iterable)lines, (int)1);
            Collection collection = CollectionsKt.listOf((Object)CollectionsKt.first((List)lines));
            boolean $i$f$map = false;
            void firstNonWhitespace = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String it = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if (commonIndent == null) {
                    string = it;
                } else if (it.length() > ((Number)commonIndent).intValue()) {
                    String string2 = it.substring(((Number)commonIndent).intValue());
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = it;
                }
                collection2.add(string);
            }
            lines = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            Iterable $this$dropWhile$iv = lines;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                int n;
                block14: {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    String it = (String)item$iv;
                    boolean bl = false;
                    CharSequence $this$indexOfFirst$iv = it;
                    boolean $i$f$indexOfFirst = false;
                    int n3 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n3; ++index$iv) {
                        char it2 = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (!(it2 != ' ' && it2 != '\t')) continue;
                        n = index$iv;
                        break block14;
                    }
                    n = -1;
                }
                if (n == -1) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List $this$dropLastWhile$iv = lines = (List)list$iv;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    int n;
                    block15: {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        CharSequence $this$indexOfFirst$iv = it;
                        boolean $i$f$indexOfFirst = false;
                        int n4 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n4; ++index$iv) {
                            char it3 = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl3 = false;
                            if (!(it3 != ' ' && it3 != '\t')) continue;
                            n = index$iv;
                            break block15;
                        }
                        n = -1;
                    }
                    if (n == -1) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break block16;
                }
            }
            list = CollectionsKt.emptyList();
        }
        lines = list;
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String encodeToGraphQLSingleQuoted(@NotNull String $this$encodeToGraphQLSingleQuoted) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToGraphQLSingleQuoted, (String)"<this>");
        StringBuilder $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence $this$forEach$iv = $this$encodeToGraphQLSingleQuoted;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            char c2 = c;
            if (c2 == '\"') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\\\");
                continue;
            }
            if (c2 == '/') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\/");
                continue;
            }
            if (c2 == '\b') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\t");
                continue;
            }
            if (c2 == '\n') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append("\\t");
                continue;
            }
            $this$encodeToGraphQLSingleQuoted_u24lambda_u2d7.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String encodeToGraphQLTripleQuoted(@NotNull String $this$encodeToGraphQLTripleQuoted) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToGraphQLTripleQuoted, (String)"<this>");
        String it = StringsKt.replace$default((String)$this$encodeToGraphQLTripleQuoted, (String)"\"\"\"", (String)"\\\"\"\"", (boolean)false, (int)4, null);
        boolean bl = false;
        if (((CharSequence)$this$encodeToGraphQLTripleQuoted).length() == 0) {
            string = it;
        } else {
            String leading = it.charAt(0) != '\n' ? "\n" : "";
            String trailing = it.charAt(it.length() - 1) != '\n' ? "\n" : "";
            string = leading + it + trailing;
        }
        return string;
    }
}

