/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLNamed;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLOperationTypeDefinition;
import com.apollographql.apollo3.ast.GQLSchemaDefinition;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.internal.SchemaValidationScope;
import com.apollographql.apollo3.ast.internal.TypeExtensionsMergeScopeKt;
import com.apollographql.apollo3.ast.internal.ValidationCommonKt;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\u0006H\u0002\u001a\f\u0010\n\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\u0006H\u0000\u00a8\u0006\f"}, d2={"syntheticSchemaDefinition", "Lcom/apollographql/apollo3/ast/GQLSchemaDefinition;", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "validateDocumentAndMergeExtensions", "", "Lcom/apollographql/apollo3/ast/GQLDefinition;", "Lcom/apollographql/apollo3/ast/internal/SchemaValidationScope;", "validateInterfaces", "", "validateNoIntrospectionNames", "validateObjects", "validateRootOperationTypes", "apollo-ast"})
public final class SchemaValidationScopeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GQLDefinition> validateDocumentAndMergeExtensions(@NotNull SchemaValidationScope $this$validateDocumentAndMergeExtensions) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$validateDocumentAndMergeExtensions, (String)"<this>");
        SchemaValidationScopeKt.validateNoIntrospectionNames($this$validateDocumentAndMergeExtensions);
        SchemaValidationScopeKt.validateRootOperationTypes($this$validateDocumentAndMergeExtensions);
        SchemaValidationScopeKt.validateInterfaces($this$validateDocumentAndMergeExtensions);
        SchemaValidationScopeKt.validateObjects($this$validateDocumentAndMergeExtensions);
        GQLSchemaDefinition gQLSchemaDefinition = $this$validateDocumentAndMergeExtensions.getSchemaDefinition();
        if (gQLSchemaDefinition == null) {
            gQLSchemaDefinition = SchemaValidationScopeKt.syntheticSchemaDefinition($this$validateDocumentAndMergeExtensions);
        }
        GQLSchemaDefinition schemaDefinition = gQLSchemaDefinition;
        Iterable iterable = $this$validateDocumentAndMergeExtensions.getAllDefinitions();
        Collection collection = CollectionsKt.listOf((Object)schemaDefinition);
        ValidationScope validationScope = $this$validateDocumentAndMergeExtensions;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GQLDefinition it = (GQLDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof GQLSchemaDefinition))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return TypeExtensionsMergeScopeKt.mergeExtensions(validationScope, CollectionsKt.plus((Collection)collection, (Iterable)list));
    }

    public static final void validateRootOperationTypes(@NotNull SchemaValidationScope $this$validateRootOperationTypes) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$validateRootOperationTypes, (String)"<this>");
            Object object = $this$validateRootOperationTypes.getSchemaDefinition();
            if (object == null || (object = ((GQLSchemaDefinition)object).getRootOperationTypeDefinitions()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GQLOperationTypeDefinition it = (GQLOperationTypeDefinition)element$iv;
                boolean bl = false;
                GQLTypeDefinition typeDefinition = $this$validateRootOperationTypes.getTypeDefinitions().get(it.getNamedType());
                if (typeDefinition != null) continue;
                ValidationScope.DefaultImpls.registerIssue$default($this$validateRootOperationTypes, "Schema defines `" + it.getNamedType() + "` as root for `" + it.getNamedType() + "` but `" + it.getNamedType() + "` is not defined", it.getSourceLocation(), null, null, 12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GQLSchemaDefinition syntheticSchemaDefinition(@NotNull ValidationScope $this$syntheticSchemaDefinition) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$syntheticSchemaDefinition, (String)"<this>");
        Object[] objectArray = new String[]{"query", "mutation", "subscription"};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GQLOperationTypeDefinition gQLOperationTypeDefinition;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            switch (it) {
                case "query": {
                    string = "Query";
                    break;
                }
                case "mutation": {
                    string = "Mutation";
                    break;
                }
                case "subscription": {
                    string = "Subscription";
                    break;
                }
                default: {
                    throw new IllegalStateException("".toString());
                }
            }
            String typeName = string;
            GQLTypeDefinition typeDefinition = $this$syntheticSchemaDefinition.getTypeDefinitions().get(typeName);
            if (typeDefinition == null) {
                if (Intrinsics.areEqual((Object)it, (Object)"query")) {
                    ValidationScope.DefaultImpls.registerIssue$default($this$syntheticSchemaDefinition, "No schema definition and not 'Query' type found", SourceLocation.Companion.getUNKNOWN(), null, null, 12, null);
                }
                gQLOperationTypeDefinition = null;
            } else {
                gQLOperationTypeDefinition = new GQLOperationTypeDefinition(null, it, typeName, 1, null);
            }
            if (gQLOperationTypeDefinition == null) continue;
            GQLOperationTypeDefinition it$iv$iv = gQLOperationTypeDefinition;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List operationTypeDefinitions = (List)destination$iv$iv;
        return new GQLSchemaDefinition(null, null, CollectionsKt.emptyList(), operationTypeDefinitions, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void validateInterfaces(ValidationScope $this$validateInterfaces) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateInterfaces.getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLInterfaceTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLInterfaceTypeDefinition it = (GQLInterfaceTypeDefinition)element$iv;
            boolean bl = false;
            if (!it.getFields().isEmpty()) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateInterfaces, "Interfaces must specify one or more fields", it.getSourceLocation(), null, null, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void validateObjects(ValidationScope $this$validateObjects) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateObjects.getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLObjectTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLObjectTypeDefinition o = (GQLObjectTypeDefinition)element$iv;
            boolean bl = false;
            if (o.getFields().isEmpty()) {
                ValidationScope.DefaultImpls.registerIssue$default($this$validateObjects, "Object must specify one or more fields", o.getSourceLocation(), null, null, 12, null);
            }
            Iterable $this$forEach$iv2 = o.getImplementsInterfaces();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String implementsInterface = (String)element$iv2;
                boolean bl2 = false;
                GQLTypeDefinition gQLTypeDefinition = $this$validateObjects.getTypeDefinitions().get(implementsInterface);
                GQLInterfaceTypeDefinition iface = gQLTypeDefinition instanceof GQLInterfaceTypeDefinition ? (GQLInterfaceTypeDefinition)gQLTypeDefinition : null;
                if (iface != null) continue;
                ValidationScope.DefaultImpls.registerIssue$default($this$validateObjects, "Object '" + o.getName() + "' cannot implement non-interface '" + implementsInterface + '\'', o.getSourceLocation(), null, null, 12, null);
            }
            $this$forEach$iv2 = o.getDirectives();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GQLDirective directive = (GQLDirective)element$iv2;
                boolean bl3 = false;
                ValidationCommonKt.validateDirective($this$validateObjects, directive, o);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void validateNoIntrospectionNames(SchemaValidationScope $this$validateNoIntrospectionNames) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$validateNoIntrospectionNames.getDocumentDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLNamed)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLNamed definition = (GQLNamed)element$iv;
            boolean bl = false;
            GQLDefinition cfr_ignored_0 = (GQLDefinition)((Object)definition);
            if (!StringsKt.startsWith$default((String)definition.getName(), (String)"__", (boolean)false, (int)2, null)) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateNoIntrospectionNames, "names starting with '__' are reserved for introspection", ((GQLDefinition)((Object)definition)).getSourceLocation(), null, null, 12, null);
        }
    }
}

