/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.GQLArgument;
import com.apollographql.apollo3.ast.GQLArguments;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLDirectiveDefinition;
import com.apollographql.apollo3.ast.GQLDirectiveLocation;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValueDefinition;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFieldDefinition;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputValueDefinition;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLOperationTypeDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLSchemaDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableDefinition;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.ValidationDetails;
import com.apollographql.apollo3.ast.VariableUsage;
import com.apollographql.apollo3.ast.internal.InputValueValidationScopeKt;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a*\u0010\u000b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a8\u0010\u0012\u001a\u00020\u0004*\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0000\u001a\u001c\u0010\u0016\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001e\u0010\u0017\u001a\u00020\u0004*\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"buffer", "Lokio/Buffer;", "", "extraValidateNonNullDirective", "", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "directive", "Lcom/apollographql/apollo3/ast/GQLDirective;", "directiveContext", "Lcom/apollographql/apollo3/ast/GQLNode;", "extraValidateTypePolicyDirective", "validateArgument", "argument", "Lcom/apollographql/apollo3/ast/GQLArgument;", "inputValueDefinitions", "", "Lcom/apollographql/apollo3/ast/GQLInputValueDefinition;", "debug", "validateArguments", "arguments", "sourceLocation", "Lcom/apollographql/apollo3/ast/SourceLocation;", "validateDirective", "validateVariable", "operation", "Lcom/apollographql/apollo3/ast/GQLOperationDefinition;", "variableUsage", "Lcom/apollographql/apollo3/ast/VariableUsage;", "apollo-ast"})
public final class ValidationCommonKt {
    public static final void validateDirective(@NotNull ValidationScope $this$validateDirective, @NotNull GQLDirective directive, @NotNull GQLNode directiveContext) {
        GQLDirectiveLocation gQLDirectiveLocation;
        block40: {
            GQLNode gQLNode;
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block39: {
                                Intrinsics.checkNotNullParameter((Object)$this$validateDirective, (String)"<this>");
                                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                                Intrinsics.checkNotNullParameter((Object)directiveContext, (String)"directiveContext");
                                gQLNode = directiveContext;
                                if (!(gQLNode instanceof GQLField)) break block39;
                                gQLDirectiveLocation = GQLDirectiveLocation.FIELD;
                                break block40;
                            }
                            if (!(gQLNode instanceof GQLInlineFragment)) break block41;
                            gQLDirectiveLocation = GQLDirectiveLocation.INLINE_FRAGMENT;
                            break block40;
                        }
                        if (!(gQLNode instanceof GQLFragmentSpread)) break block42;
                        gQLDirectiveLocation = GQLDirectiveLocation.FRAGMENT_SPREAD;
                        break block40;
                    }
                    if (!(gQLNode instanceof GQLObjectTypeDefinition)) break block43;
                    gQLDirectiveLocation = GQLDirectiveLocation.OBJECT;
                    break block40;
                }
                if (!(gQLNode instanceof GQLOperationTypeDefinition)) break block44;
                switch (((GQLOperationTypeDefinition)directiveContext).getOperationType()) {
                    case "query": {
                        gQLDirectiveLocation = GQLDirectiveLocation.QUERY;
                        break block40;
                    }
                    case "mutation": {
                        gQLDirectiveLocation = GQLDirectiveLocation.MUTATION;
                        break block40;
                    }
                    case "subscription": {
                        gQLDirectiveLocation = GQLDirectiveLocation.SUBSCRIPTION;
                        break block40;
                    }
                    default: {
                        throw new IllegalStateException(Intrinsics.stringPlus((String)"unknown operation: ", (Object)directiveContext).toString());
                    }
                }
            }
            if (gQLNode instanceof GQLFragmentDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.FRAGMENT_DEFINITION;
            } else if (gQLNode instanceof GQLVariableDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.VARIABLE_DEFINITION;
            } else if (gQLNode instanceof GQLSchemaDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.SCHEMA;
            } else if (gQLNode instanceof GQLScalarTypeDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.SCALAR;
            } else if (gQLNode instanceof GQLFieldDefinition) {
                gQLDirectiveLocation = GQLDirectiveLocation.FIELD_DEFINITION;
            } else {
                if (gQLNode instanceof GQLInputValueDefinition) {
                    throw new IllegalStateException("validating directices on input values is not supported yet as we need to distinguish between arguments and inputfields".toString());
                }
                if (gQLNode instanceof GQLInterfaceTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.INTERFACE;
                } else if (gQLNode instanceof GQLUnionTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.UNION;
                } else if (gQLNode instanceof GQLEnumTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.ENUM;
                } else if (gQLNode instanceof GQLEnumValueDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.ENUM_VALUE;
                } else if (gQLNode instanceof GQLInputObjectTypeDefinition) {
                    gQLDirectiveLocation = GQLDirectiveLocation.INPUT_OBJECT;
                } else {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot determine directive location for ", (Object)directiveContext).toString());
                }
            }
        }
        GQLDirectiveLocation directiveLocation = gQLDirectiveLocation;
        GQLDirectiveDefinition directiveDefinition = $this$validateDirective.getDirectiveDefinitions().get(directive.getName());
        if (directiveDefinition == null) {
            String string = "Unknown directive '" + directive.getName() + '\'';
            SourceLocation sourceLocation = directive.getSourceLocation();
            ValidationDetails validationDetails = ValidationDetails.UnknownDirective;
            Issue.Severity severity = Issue.Severity.WARNING;
            $this$validateDirective.registerIssue(string, sourceLocation, severity, validationDetails);
            return;
        }
        if (!directiveDefinition.getLocations().contains((Object)directiveLocation)) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateDirective, "Directive '" + directive.getName() + "' cannot be applied on '" + (Object)((Object)directiveLocation) + '\'', directive.getSourceLocation(), null, null, 12, null);
            return;
        }
        GQLArguments gQLArguments = directive.getArguments();
        List list = gQLArguments == null ? null : gQLArguments.getArguments();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        ValidationCommonKt.validateArguments($this$validateDirective, list, directive.getSourceLocation(), directiveDefinition.getArguments(), "directive '" + directiveDefinition.getName() + '\'');
        if (Intrinsics.areEqual((Object)directive.getName(), (Object)"nonnull")) {
            ValidationCommonKt.extraValidateNonNullDirective($this$validateDirective, directive, directiveContext);
        }
        if (Intrinsics.areEqual((Object)directive.getName(), (Object)"fieldPolicy")) {
            ValidationCommonKt.extraValidateTypePolicyDirective($this$validateDirective, directive);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void extraValidateNonNullDirective(@NotNull ValidationScope $this$extraValidateNonNullDirective, @NotNull GQLDirective directive, @NotNull GQLNode directiveContext) {
        Collection collection;
        Object v7;
        List selections;
        String stringValue;
        block10: {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)$this$extraValidateNonNullDirective, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Intrinsics.checkNotNullParameter((Object)directiveContext, (String)"directiveContext");
            if (directiveContext instanceof GQLField) {
                int n3;
                GQLArguments gQLArguments = directive.getArguments();
                if (gQLArguments == null) {
                    n3 = 0;
                } else {
                    List<GQLArgument> list = gQLArguments.getArguments();
                    n3 = list == null ? 0 : (n2 = list.size());
                }
                if (n3 > 0) {
                    ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateNonNullDirective, "" + '\'' + directive + ".name' cannot have arguments when applied on a field", directive.getSourceLocation(), null, null, 12, null);
                    return;
                }
            }
            if (!(directiveContext instanceof GQLObjectTypeDefinition)) return;
            GQLArguments gQLArguments = directive.getArguments();
            if (gQLArguments == null) {
                n = 0;
            } else {
                List<GQLArgument> list = gQLArguments.getArguments();
                n = list == null ? 0 : (n2 = list.size());
            }
            if (n != 0) return;
            ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateNonNullDirective, '\'' + directive.getName() + "' must contain a selection of fields", directive.getSourceLocation(), null, null, 12, null);
            GQLArguments gQLArguments2 = directive.getArguments();
            Intrinsics.checkNotNull((Object)gQLArguments2);
            stringValue = ((GQLStringValue)((GQLArgument)CollectionsKt.first(gQLArguments2.getArguments())).getValue()).getValue();
            selections = (List)ApolloParser.parseAsGQLSelections$default((BufferedSource)ValidationCommonKt.buffer(stringValue), null, 1, null).valueAssertNoErrors();
            Iterable $this$firstOrNull$iv = selections;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                GQLSelection gQLSelection = (GQLSelection)t;
                boolean bl = false;
                if (!(!(gQLSelection instanceof GQLField))) continue;
                v7 = t;
                break block10;
            }
            v7 = null;
        }
        GQLSelection badSelection = v7;
        if (!(badSelection == null)) {
            boolean $i$a$-check-ValidationCommonKt$extraValidateNonNullDirective$32 = false;
            String $i$a$-check-ValidationCommonKt$extraValidateNonNullDirective$32 = "" + '\'' + badSelection + "' cannot be made non-null. '" + stringValue + "' should only contain fields.";
            throw new IllegalStateException($i$a$-check-ValidationCommonKt$extraValidateNonNullDirective$32.toString());
        }
        Iterable $this$map$iv = selections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            GQLSelection gQLSelection = (GQLSelection)item$iv$iv;
            collection = collection2;
            boolean bl2 = false;
            collection.add(((GQLField)it).getName());
        }
        Set nonNullFields = CollectionsKt.toSet((Iterable)((List)collection2));
        Iterable $this$map$iv2 = ((GQLObjectTypeDefinition)directiveContext).getFields();
        boolean bl = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable2) {
            void it;
            GQLFieldDefinition bl2 = (GQLFieldDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getName());
        }
        Set schemaFields = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownFields = SetsKt.minus((Set)nonNullFields, (Iterable)schemaFields);
        if (unknownFields.isEmpty()) return;
        boolean bl4 = false;
        String string = "Fields '" + CollectionsKt.joinToString$default((Iterable)unknownFields, null, null, null, (int)0, null, null, (int)63, null) + "' are not defined in " + ((GQLObjectTypeDefinition)directiveContext).getName();
        throw new IllegalStateException(string.toString());
    }

    public static final void extraValidateTypePolicyDirective(@NotNull ValidationScope $this$extraValidateTypePolicyDirective, @NotNull GQLDirective directive) {
        Intrinsics.checkNotNullParameter((Object)$this$extraValidateTypePolicyDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        GQLArguments gQLArguments = directive.getArguments();
        Intrinsics.checkNotNull((Object)gQLArguments);
        Iterable $this$forEach$iv = (Iterable)ApolloParser.parseAsGQLSelections$default((BufferedSource)ValidationCommonKt.buffer(((GQLStringValue)((GQLArgument)CollectionsKt.first(gQLArguments.getArguments())).getValue()).getValue()), null, 1, null).valueAssertNoErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            if (!(it instanceof GQLField)) {
                ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateTypePolicyDirective, "Fragments are not supported in @typePolicy directives", it.getSourceLocation(), null, null, 12, null);
                continue;
            }
            if (((GQLField)it).getSelectionSet() == null) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$extraValidateTypePolicyDirective, "Composite fields are not supported in @typePolicy directives", it.getSourceLocation(), null, null, 12, null);
        }
    }

    @NotNull
    public static final Buffer buffer(@NotNull String $this$buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$buffer, (String)"<this>");
        return new Buffer().writeUtf8($this$buffer);
    }

    private static final void validateArgument(ValidationScope $this$validateArgument, GQLArgument argument, List<GQLInputValueDefinition> inputValueDefinitions, String debug) {
        Object v0;
        GQLArgument $this$validateArgument_u24lambda_u2d7;
        block3: {
            $this$validateArgument_u24lambda_u2d7 = argument;
            boolean bl = false;
            Iterable $this$firstOrNull$iv = inputValueDefinitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$validateArgument_u24lambda_u2d7.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        GQLInputValueDefinition schemaArgument = v0;
        if (schemaArgument == null) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArgument, "Unknown argument `" + $this$validateArgument_u24lambda_u2d7.getName() + "` on " + debug, $this$validateArgument_u24lambda_u2d7.getSourceLocation(), null, null, 12, null);
        } else {
            InputValueValidationScopeKt.validateAndCoerceValue($this$validateArgument, argument.getValue(), schemaArgument.getType(), schemaArgument.getDefaultValue() != null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateArguments(@NotNull ValidationScope $this$validateArguments, @NotNull List<GQLArgument> arguments, @NotNull SourceLocation sourceLocation, @NotNull List<GQLInputValueDefinition> inputValueDefinitions, @NotNull String debug) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$validateArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)sourceLocation, (String)"sourceLocation");
        Intrinsics.checkNotNullParameter(inputValueDefinitions, (String)"inputValueDefinitions");
        Intrinsics.checkNotNullParameter((Object)debug, (String)"debug");
        Object $this$groupBy$iv = arguments;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ((GQLArgument)it).getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)MapsKt.toList((Map)destination$iv$iv));
        if (pair != null) {
            Pair it2 = pair;
            boolean bl = false;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArguments, "Argument `" + (String)it2.getFirst() + "` is defined multiple times", ((GQLArgument)CollectionsKt.first((List)((List)it2.getSecond()))).getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = inputValueDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v2;
            GQLInputValueDefinition inputValueDefinition;
            block8: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = arguments;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLArgument it3 = (GQLArgument)element$iv2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it3.getName(), (Object)inputValueDefinition.getName())) continue;
                    v2 = element$iv2;
                    break block8;
                }
                v2 = null;
            }
            GQLArgument gQLArgument = v2;
            GQLValue argumentValue = gQLArgument == null ? null : gQLArgument.getValue();
            if (argumentValue instanceof GQLNullValue || argumentValue != null) continue;
            ValidationScope.DefaultImpls.registerIssue$default($this$validateArguments, Intrinsics.stringPlus((String)"No value passed for required argument ", (Object)inputValueDefinition.getName()), sourceLocation, null, null, 12, null);
        }
        $this$forEach$iv = arguments;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLArgument it4 = (GQLArgument)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateArgument($this$validateArguments, it4, inputValueDefinitions, debug);
        }
    }

    public static final void validateVariable(@NotNull ValidationScope $this$validateVariable, @Nullable GQLOperationDefinition operation, @NotNull VariableUsage variableUsage) {
        Object v0;
        GQLVariableValue variable;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$validateVariable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)variableUsage, (String)"variableUsage");
            if (operation == null) {
                return;
            }
            variable = variableUsage.getVariable();
            Iterable $this$firstOrNull$iv = operation.getVariableDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLVariableDefinition it = (GQLVariableDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)variable.getName())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        GQLVariableDefinition variableDefinition = v0;
        if (variableDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateVariable, "Variable `" + variable.getName() + "` is not defined by operation `" + operation.getName() + '`', variable.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypeKt.isVariableUsageAllowed(variableDefinition, variableUsage)) {
            ValidationScope.DefaultImpls.registerIssue$default($this$validateVariable, "Variable `" + variable.getName() + "` of type `" + GqltypeKt.pretty(variableDefinition.getType()) + "` used in position expecting type `" + GqltypeKt.pretty(variableUsage.getLocationType()) + '`', variable.getSourceLocation(), null, null, 12, null);
        }
    }
}

