/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast;

import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo3.ast.GQLVariableDefinition;
import com.apollographql.apollo3.ast.VariableUsage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\n\u001a\u00020\u0001*\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0000\u001a \u0010\u000f\u001a\u00020\u0001*\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0000\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0003\u001a\n\u0010\u0012\u001a\u00020\r*\u00020\u0003\u00a8\u0006\u0013"}, d2={"areTypesCompatible", "", "variableType", "Lcom/apollographql/apollo3/ast/GQLType;", "locationType", "isVariableUsageAllowed", "variableDefinition", "Lcom/apollographql/apollo3/ast/GQLVariableDefinition;", "usage", "Lcom/apollographql/apollo3/ast/VariableUsage;", "isInputType", "typeDefinitions", "", "", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "isOutputType", "leafType", "Lcom/apollographql/apollo3/ast/GQLNamedType;", "pretty", "apollo-ast"})
public final class GqltypeKt {
    @NotNull
    public static final GQLNamedType leafType(@NotNull GQLType $this$leafType) {
        GQLNamedType gQLNamedType;
        Intrinsics.checkNotNullParameter((Object)$this$leafType, (String)"<this>");
        GQLType gQLType = $this$leafType;
        if (gQLType instanceof GQLNonNullType) {
            gQLNamedType = GqltypeKt.leafType(((GQLNonNullType)$this$leafType).getType());
        } else if (gQLType instanceof GQLListType) {
            gQLNamedType = GqltypeKt.leafType(((GQLListType)$this$leafType).getType());
        } else if (gQLType instanceof GQLNamedType) {
            gQLNamedType = (GQLNamedType)$this$leafType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gQLNamedType;
    }

    @NotNull
    public static final String pretty(@NotNull GQLType $this$pretty) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$pretty, (String)"<this>");
        GQLType gQLType = $this$pretty;
        if (gQLType instanceof GQLNonNullType) {
            string = Intrinsics.stringPlus((String)GqltypeKt.pretty(((GQLNonNullType)$this$pretty).getType()), (Object)"!");
        } else if (gQLType instanceof GQLListType) {
            string = '[' + GqltypeKt.pretty(((GQLListType)$this$pretty).getType()) + ']';
        } else if (gQLType instanceof GQLNamedType) {
            string = ((GQLNamedType)$this$pretty).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final boolean isVariableUsageAllowed(@NotNull GQLVariableDefinition variableDefinition, @NotNull VariableUsage usage) {
        Intrinsics.checkNotNullParameter((Object)variableDefinition, (String)"variableDefinition");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        GQLType variableType = variableDefinition.getType();
        GQLType locationType = usage.getLocationType();
        if (locationType instanceof GQLNonNullType && !(variableType instanceof GQLNonNullType)) {
            if (variableDefinition.getDefaultValue() == null && !usage.getHasLocationDefaultValue()) {
                return false;
            }
            return GqltypeKt.areTypesCompatible(variableType, ((GQLNonNullType)locationType).getType());
        }
        return GqltypeKt.areTypesCompatible(variableType, locationType);
    }

    public static final boolean areTypesCompatible(@NotNull GQLType variableType, @NotNull GQLType locationType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)variableType, (String)"variableType");
        Intrinsics.checkNotNullParameter((Object)locationType, (String)"locationType");
        if (locationType instanceof GQLNonNullType) {
            bl = !(variableType instanceof GQLNonNullType) ? false : GqltypeKt.areTypesCompatible(((GQLNonNullType)variableType).getType(), ((GQLNonNullType)locationType).getType());
        } else if (variableType instanceof GQLNonNullType) {
            bl = GqltypeKt.areTypesCompatible(((GQLNonNullType)variableType).getType(), locationType);
        } else if (locationType instanceof GQLListType) {
            bl = !(variableType instanceof GQLListType) ? false : GqltypeKt.areTypesCompatible(((GQLListType)variableType).getType(), ((GQLListType)locationType).getType());
        } else if (variableType instanceof GQLListType) {
            bl = false;
        } else {
            if (!(variableType instanceof GQLNamedType)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(locationType instanceof GQLNamedType)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            bl = Intrinsics.areEqual((Object)((GQLNamedType)variableType).getName(), (Object)((GQLNamedType)locationType).getName());
        }
        return bl;
    }

    public static final boolean isInputType(@NotNull GQLType $this$isInputType, @NotNull Map<String, ? extends GQLTypeDefinition> typeDefinitions) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInputType, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeDefinitions, (String)"typeDefinitions");
        GQLType gQLType = $this$isInputType;
        if (gQLType instanceof GQLNonNullType) {
            bl = GqltypeKt.isInputType(((GQLNonNullType)$this$isInputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLListType) {
            bl = GqltypeKt.isInputType(((GQLListType)$this$isInputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition it = typeDefinitions.get(((GQLNamedType)$this$isInputType).getName());
            boolean bl2 = false;
            bl = it instanceof GQLInputObjectTypeDefinition || it instanceof GQLScalarTypeDefinition || it instanceof GQLEnumTypeDefinition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isOutputType(@NotNull GQLType $this$isOutputType, @NotNull Map<String, ? extends GQLTypeDefinition> typeDefinitions) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isOutputType, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeDefinitions, (String)"typeDefinitions");
        GQLType gQLType = $this$isOutputType;
        if (gQLType instanceof GQLNonNullType) {
            bl = GqltypeKt.isInputType(((GQLNonNullType)$this$isOutputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLListType) {
            bl = GqltypeKt.isInputType(((GQLListType)$this$isOutputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition it = typeDefinitions.get(((GQLNamedType)$this$isOutputType).getName());
            boolean bl2 = false;
            bl = it instanceof GQLObjectTypeDefinition || it instanceof GQLUnionTypeDefinition || it instanceof GQLInterfaceTypeDefinition || it instanceof GQLScalarTypeDefinition || it instanceof GQLEnumTypeDefinition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

