/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.CountingSink;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.json.-JsonWriters;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/api/http/UploadsHttpBody;", "Lcom/apollographql/apollo3/api/http/HttpBody;", "uploads", "", "", "Lcom/apollographql/apollo3/api/Upload;", "operationByteString", "Lokio/ByteString;", "(Ljava/util/Map;Lokio/ByteString;)V", "boundary", "contentLength", "", "getContentLength", "()J", "contentLength$delegate", "Lkotlin/Lazy;", "contentType", "getContentType", "()Ljava/lang/String;", "buildUploadMap", "writeTo", "", "bufferedSink", "Lokio/BufferedSink;", "writeBoundaries", "writeUploadContents", "", "apollo-api"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/UploadsHttpBody\n+ 2 uuid.kt\ncom/benasher44/uuid/UuidKt\n+ 3 JsonWriters.kt\ncom/apollographql/apollo3/api/json/-JsonWriters\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n96#2:356\n79#3,6:357\n85#3:368\n1559#4:363\n1590#4,4:364\n1860#4,3:369\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo3/api/http/UploadsHttpBody\n*L\n282#1:356\n299#1:357,6\n299#1:368\n301#1:363\n301#1:364,4\n323#1:369,3\n*E\n"})
public final class UploadsHttpBody
implements HttpBody {
    @NotNull
    private final Map<String, Upload> uploads;
    @NotNull
    private final ByteString operationByteString;
    @NotNull
    private final String boundary;
    @NotNull
    private final String contentType;
    @NotNull
    private final Lazy contentLength$delegate;

    public UploadsHttpBody(@NotNull Map<String, ? extends Upload> uploads, @NotNull ByteString operationByteString) {
        Intrinsics.checkNotNullParameter(uploads, (String)"uploads");
        Intrinsics.checkNotNullParameter((Object)operationByteString, (String)"operationByteString");
        this.uploads = uploads;
        this.operationByteString = operationByteString;
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        String string = uUID.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid4().toString()");
        this.boundary = string;
        this.contentType = "multipart/form-data; boundary=" + this.boundary;
        this.contentLength$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ UploadsHttpBody this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Long invoke() {
                long l;
                CountingSink countingSink = new CountingSink(Okio.blackhole());
                BufferedSink bufferedCountingSink = Okio.buffer((Sink)countingSink);
                UploadsHttpBody.access$writeBoundaries(this.this$0, bufferedCountingSink, false);
                bufferedCountingSink.flush();
                Iterable iterable = UploadsHttpBody.access$getUploads$p(this.this$0).values();
                long l2 = countingSink.getBytesWritten();
                long l3 = 0L;
                for (T t : iterable) {
                    void it;
                    Upload upload = (Upload)t;
                    l = l3;
                    boolean bl = false;
                    long l4 = it.getContentLength();
                    l3 = l + l4;
                }
                l = l3;
                long result = l2 + l;
                return result;
            }
        }));
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
        this.writeBoundaries(bufferedSink, true);
    }

    /*
     * WARNING - void declaration
     */
    private final ByteString buildUploadMap(Map<String, ? extends Upload> uploads) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        String indent$iv = null;
        boolean $i$f$buildJsonByteString = false;
        Buffer buffer$iv = new Buffer();
        JsonWriter $this$buildUploadMap_u24lambda_u241 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
        boolean bl = false;
        Iterable iterable = uploads.entrySet();
        JsonWriter jsonWriter = $this$buildUploadMap_u24lambda_u241;
        boolean $i$f$mapIndexed = false;
        void var10_10 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)String.valueOf((int)index), (Object)CollectionsKt.listOf(entry.getKey())));
        }
        -JsonWriters.writeAny(jsonWriter, MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        return buffer$iv.readByteString();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeBoundaries(BufferedSink $this$writeBoundaries, boolean writeUploadContents) {
        $this$writeBoundaries.writeUtf8("--" + this.boundary + "\r\n");
        $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"operations\"\r\n");
        $this$writeBoundaries.writeUtf8("Content-Type: application/json\r\n");
        $this$writeBoundaries.writeUtf8("Content-Length: " + this.operationByteString.size() + "\r\n");
        $this$writeBoundaries.writeUtf8("\r\n");
        $this$writeBoundaries.write(this.operationByteString);
        ByteString uploadsMap = this.buildUploadMap(this.uploads);
        $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "\r\n");
        $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"map\"\r\n");
        $this$writeBoundaries.writeUtf8("Content-Type: application/json\r\n");
        $this$writeBoundaries.writeUtf8("Content-Length: " + uploadsMap.size() + "\r\n");
        $this$writeBoundaries.writeUtf8("\r\n");
        $this$writeBoundaries.write(uploadsMap);
        Iterable $this$forEachIndexed$iv = this.uploads.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void upload;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Upload upload2 = (Upload)item$iv;
            int index = n;
            boolean bl = false;
            $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "\r\n");
            $this$writeBoundaries.writeUtf8("Content-Disposition: form-data; name=\"" + index + '\"');
            if (upload.getFileName() != null) {
                $this$writeBoundaries.writeUtf8("; filename=\"" + upload.getFileName() + '\"');
            }
            $this$writeBoundaries.writeUtf8("\r\n");
            $this$writeBoundaries.writeUtf8("Content-Type: " + upload.getContentType() + "\r\n");
            long contentLength2 = upload.getContentLength();
            if (contentLength2 != -1L) {
                $this$writeBoundaries.writeUtf8("Content-Length: " + contentLength2 + "\r\n");
            }
            $this$writeBoundaries.writeUtf8("\r\n");
            if (!writeUploadContents) continue;
            upload.writeTo($this$writeBoundaries);
        }
        $this$writeBoundaries.writeUtf8("\r\n--" + this.boundary + "--\r\n");
    }

    public static final /* synthetic */ void access$writeBoundaries(UploadsHttpBody $this, BufferedSink $receiver, boolean writeUploadContents) {
        $this.writeBoundaries($receiver, writeUploadContents);
    }

    public static final /* synthetic */ Map access$getUploads$p(UploadsHttpBody $this) {
        return $this.uploads;
    }
}

