/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.json;

import com.apollographql.apollo3.api.json.JsonNumber;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.internal.JsonScope;
import com.apollographql.apollo3.exception.JsonDataException;
import com.apollographql.apollo3.exception.JsonEncodingException;
import java.io.EOFException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 M2\u00020\u0001:\u0001MB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020\fH\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\fH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\nH\u0016J\b\u0010-\u001a\u00020\u0014H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\fH\u0002J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0002J\n\u00108\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u00109\u001a\u00020\u0010H\u0002J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\nH\u0002J\b\u0010=\u001a\u00020\nH\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\nH\u0002J\b\u0010@\u001a\u00020(H\u0002J\b\u0010A\u001a\u00020\u001cH\u0016J\u0016\u0010B\u001a\u00020\n2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\u0010\u0010D\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u0010H\u0002J\b\u0010G\u001a\u00020\u001cH\u0002J\b\u0010H\u001a\u00020\u001cH\u0002J\b\u0010I\u001a\u00020\u001cH\u0016J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/apollographql/apollo3/api/json/BufferedSourceJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "buffer", "Lokio/Buffer;", "indexStack", "", "indexStackSize", "", "lenient", "", "pathIndices", "pathNames", "", "", "[Ljava/lang/String;", "peeked", "peekedLong", "", "peekedNumberLength", "peekedString", "stack", "stackSize", "beginArray", "beginObject", "checkLenient", "", "close", "doPeek", "endArray", "endObject", "getPath", "", "", "getPathAsString", "hasNext", "isLiteral", "c", "", "nextBoolean", "nextDouble", "", "nextInt", "nextLong", "nextName", "nextNonWhitespace", "throwOnEof", "nextNull", "", "nextNumber", "Lcom/apollographql/apollo3/api/json/JsonNumber;", "nextQuotedValue", "runTerminator", "Lokio/ByteString;", "nextString", "nextUnquotedValue", "peek", "Lcom/apollographql/apollo3/api/json/JsonReader$Token;", "peekKeyword", "peekNumber", "push", "newTop", "readEscapeCharacter", "rewind", "selectName", "names", "skipQuotedValue", "skipTo", "toFind", "skipToEndOfLine", "skipUnquotedValue", "skipValue", "syntaxError", "Lcom/apollographql/apollo3/exception/JsonEncodingException;", "message", "Companion", "apollo-api"})
public final class BufferedSourceJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    @Nullable
    private String peekedString;
    @NotNull
    private final int[] stack;
    private int stackSize;
    @NotNull
    private final String[] pathNames;
    @NotNull
    private final int[] pathIndices;
    private boolean lenient;
    @NotNull
    private final int[] indexStack;
    private int indexStackSize;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    @NotNull
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
    @NotNull
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
    @NotNull
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");
    @NotNull
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN = ByteString.Companion.encodeUtf8("\n\r");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    public static final int MAX_STACK_SIZE = 256;

    public BufferedSourceJsonReader(@NotNull BufferedSource source) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.buffer = this.source.getBuffer();
        int[] nArray2 = nArray = new int[256];
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        $this$stack_u24lambda_u240[0] = 6;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[256];
        this.pathIndices = new int[256];
        int[] $this$stack_u24lambda_u240 = nArray = new int[256];
        bufferedSourceJsonReader = this;
        boolean bl2 = false;
        $this$indexStack_u24lambda_u241[0] = false;
        bufferedSourceJsonReader.indexStack = nArray;
        this.indexStackSize = 1;
    }

    @Override
    @NotNull
    public JsonReader beginArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginArray_u24lambda_u243 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginArray_u24lambda_u243.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginArray_u24lambda_u243.doPeek();
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u243.peek()) + " at path " + $this$beginArray_u24lambda_u243.getPathAsString());
        }
        $this$beginArray_u24lambda_u243.push(1);
        $this$beginArray_u24lambda_u243.pathIndices[$this$beginArray_u24lambda_u243.stackSize - 1] = 0;
        $this$beginArray_u24lambda_u243.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endArray_u24lambda_u245 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endArray_u24lambda_u245.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endArray_u24lambda_u245.doPeek();
        if (p != 4) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u245.peek()) + " at path " + $this$endArray_u24lambda_u245.getPathAsString());
        }
        int n4 = $this$endArray_u24lambda_u245.stackSize;
        $this$endArray_u24lambda_u245.stackSize = n4 + -1;
        int[] nArray = $this$endArray_u24lambda_u245.pathIndices;
        int n5 = $this$endArray_u24lambda_u245.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endArray_u24lambda_u245.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader beginObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginObject_u24lambda_u247 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginObject_u24lambda_u247.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginObject_u24lambda_u247.doPeek();
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u247.peek()) + " at path " + $this$beginObject_u24lambda_u247.getPathAsString());
        }
        $this$beginObject_u24lambda_u247.push(3);
        $this$beginObject_u24lambda_u247.peeked = 0;
        int n4 = $this$beginObject_u24lambda_u247.indexStackSize;
        $this$beginObject_u24lambda_u247.indexStackSize = n4 + 1;
        $this$beginObject_u24lambda_u247.indexStack[$this$beginObject_u24lambda_u247.indexStackSize - 1] = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endObject_u24lambda_u249 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endObject_u24lambda_u249.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endObject_u24lambda_u249.doPeek();
        if (p != 2) {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$endObject_u24lambda_u249.peek()) + " at path " + $this$endObject_u24lambda_u249.getPathAsString());
        }
        int n4 = $this$endObject_u24lambda_u249.stackSize;
        $this$endObject_u24lambda_u249.stackSize = n4 + -1;
        $this$endObject_u24lambda_u249.pathNames[$this$endObject_u24lambda_u249.stackSize] = null;
        int[] nArray = $this$endObject_u24lambda_u249.pathIndices;
        int n5 = $this$endObject_u24lambda_u249.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endObject_u24lambda_u249.peeked = 0;
        int n7 = $this$endObject_u24lambda_u249.indexStackSize;
        $this$endObject_u24lambda_u249.indexStackSize = n7 + -1;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        return p != 2 && p != 4;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() {
        JsonReader.Token token;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int doPeek() {
        int n;
        int c;
        int peekStack = this.stack[this.stackSize - 1];
        switch (peekStack) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                n = c;
                if (n == 93) {
                    int n2;
                    int it = n2 = 4;
                    boolean bl = false;
                    this.peeked = it;
                    return n2;
                }
                if (n == 59) {
                    this.checkLenient();
                    break;
                }
                if (n == 44) break;
                throw this.syntaxError("Unterminated array");
            }
            case 3: 
            case 5: {
                int n3;
                char c2;
                int c3;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c3 = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    c2 = (char)c3;
                    if (c2 == '}') {
                        int n4;
                        int it = n4 = 2;
                        boolean bl = false;
                        this.peeked = it;
                        return n4;
                    }
                    if (c2 == ';') {
                        this.checkLenient();
                    } else if (c2 != ',') {
                        throw this.syntaxError("Unterminated object");
                    }
                }
                if ((c2 = (char)(c3 = this.nextNonWhitespace(true))) == '\"') {
                    int n5;
                    this.buffer.readByte();
                    int it = n5 = 13;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n5;
                    return n3;
                } else if (c2 == '\'') {
                    int n6;
                    this.buffer.readByte();
                    this.checkLenient();
                    int it = n6 = 12;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n6;
                    return n3;
                } else if (c2 == '}') {
                    int n7;
                    if (peekStack == 5) throw this.syntaxError("Expected name");
                    this.buffer.readByte();
                    int it = n7 = 2;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n7;
                    return n3;
                } else {
                    int n8;
                    this.checkLenient();
                    if (!this.isLiteral((char)c3)) throw this.syntaxError("Expected name");
                    int it = n8 = 14;
                    boolean bl = false;
                    this.peeked = it;
                    n3 = n8;
                }
                return n3;
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                n = (char)c;
                if (n == 58) break;
                if (n != 61) throw this.syntaxError("Expected ':'");
                this.checkLenient();
                if (!this.source.request(1L) || this.buffer.getByte(0L) != (byte)62) break;
                this.buffer.readByte();
                break;
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    int n9;
                    int it = n9 = 17;
                    boolean bl = false;
                    this.peeked = it;
                    return n9;
                }
                this.checkLenient();
                break;
            }
            default: {
                if (peekStack != 8) break;
                boolean bl = false;
                String string = "JsonReader is closed";
                throw new IllegalStateException(string.toString());
            }
        }
        int c4 = this.nextNonWhitespace(true);
        c = (char)c4;
        if (c == 93) {
            if (peekStack == 1) {
                this.buffer.readByte();
                int it = n = 4;
                boolean bl = false;
                this.peeked = it;
                return n;
            }
            switch (peekStack) {
                case 1: 
                case 2: {
                    this.checkLenient();
                    int it = n = 7;
                    boolean bl = false;
                    this.peeked = it;
                    return n;
                }
                default: {
                    throw this.syntaxError("Unexpected value");
                }
            }
        }
        if (c == 59 ? true : c == 44) {
            switch (peekStack) {
                case 1: 
                case 2: {
                    this.checkLenient();
                    int it = n = 7;
                    boolean bl = false;
                    this.peeked = it;
                    return n;
                }
                default: {
                    throw this.syntaxError("Unexpected value");
                }
            }
        }
        if (c == 39) {
            this.checkLenient();
            this.buffer.readByte();
            int it = n = 8;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        if (c == 34) {
            this.buffer.readByte();
            int it = n = 9;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        if (c == 91) {
            this.buffer.readByte();
            int it = n = 3;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        if (c == 123) {
            this.buffer.readByte();
            int it = n = 1;
            boolean bl = false;
            this.peeked = it;
            return n;
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        int it = n = 10;
        boolean bl = false;
        this.peeked = it;
        return n;
    }

    private final int peekKeyword() {
        int n;
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        byte by = this.buffer.getByte(0L);
        if (by == (byte)116 ? true : by == (byte)84) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (by == (byte)102 ? true : by == (byte)70) {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (by == (byte)110 ? true : by == (byte)78) {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (!this.source.request((long)i + 1L)) {
                return 0;
            }
            byte c = this.buffer.getByte((long)i);
            if (c == (byte)keyword.charAt(i) || c == (byte)keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte((long)length))) {
            return 0;
        }
        this.buffer.skip((long)length);
        int it = n = peeking;
        boolean bl = false;
        this.peeked = it;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int peekNumber() {
        int n;
        int it;
        int n2;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        while (this.source.request((long)i + 1L)) {
            block22: {
                char c;
                byte c2;
                block24: {
                    block23: {
                        block21: {
                            c2 = this.buffer.getByte((long)i);
                            c = (char)c2;
                            if (c != '-') break block21;
                            switch (last) {
                                case 0: {
                                    negative = true;
                                    last = 1;
                                    break block22;
                                }
                                case 5: {
                                    last = 6;
                                    break block22;
                                }
                                default: {
                                    return 0;
                                }
                            }
                        }
                        if (c != '+') break block23;
                        if (last != 5) return 0;
                        last = 6;
                        break block22;
                    }
                    if (!(c == 'e' ? true : c == 'E')) break block24;
                    switch (last) {
                        case 2: 
                        case 4: {
                            last = 5;
                            break block22;
                        }
                        default: {
                            return 0;
                        }
                    }
                }
                if (c == '.') {
                    if (last != 2) return 0;
                    last = 3;
                } else {
                    if (c2 < (byte)48 || c2 > (byte)57) {
                        if (this.isLiteral((char)c2)) return 0;
                        break;
                    }
                    switch (last) {
                        case 0: 
                        case 1: {
                            value = -((long)(c2 - (byte)48));
                            last = 2;
                            break;
                        }
                        case 2: {
                            if (value == 0L) {
                                return 0;
                            }
                            long newValue = value * (long)10 - (long)(c2 - (byte)48);
                            fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                            value = newValue;
                            break;
                        }
                        case 3: {
                            last = 4;
                            break;
                        }
                        case 5: 
                        case 6: {
                            last = 7;
                        }
                    }
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip((long)i);
            it = n2 = 15;
            boolean bl = false;
            this.peeked = it;
            n = n2;
            return n;
        } else {
            if (last != 2 && last != 4) {
                if (last != 7) return 0;
            }
            this.peekedNumberLength = i;
            it = n2 = 16;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        }
        return n;
    }

    private final boolean isLiteral(char c) {
        boolean bl;
        char c2 = c;
        if ((((c2 == '/' ? true : c2 == '\\') ? true : c2 == ';') ? true : c2 == '#') ? true : c2 == '=') {
            this.checkLenient();
            bl = false;
        } else {
            bl = !(((((((((c2 == '{' ? true : c2 == '}') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',') ? true : c2 == ' ') ? true : c2 == '\t') ? true : c2 == '\r') ? true : c2 == '\n');
        }
        return bl;
    }

    @Override
    @NotNull
    public String nextName() {
        String string;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    @Nullable
    public String nextString() {
        Object object;
        Object object2 = this.peeked;
        int it = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it == 0) ? object2 : null;
        switch (object3 != null ? ((Integer)object3).intValue() : this.doPeek()) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                String string = this.peekedString;
                if (string != null) {
                    Object it2 = object2 = string;
                    boolean bl2 = false;
                    this.peekedString = null;
                    object = object2;
                    break;
                }
                object = null;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8((long)this.peekedNumberLength);
                break;
            }
            default: {
                throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result = object;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result;
    }

    @Override
    public boolean nextBoolean() {
        boolean bl;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 5: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n3 = this.stackSize - 1;
                int n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n5 = this.stackSize - 1;
                int n4 = nArray[n5];
                nArray[n5] = n4 + 1;
                bl = false;
                break;
            }
            default: {
                throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Void nextNull() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        if ((n2 != null ? n2.intValue() : this.doPeek()) != 7) {
            throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n3 = this.stackSize - 1;
        int n4 = nArray[n3];
        nArray[n3] = n4 + 1;
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9) {
            this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 8) {
            this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double result = d;
        if (!this.lenient && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n5 = this.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        return result;
    }

    @Override
    public long nextLong() {
        double it22;
        Integer n = this.peeked;
        int it22 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it22 == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            it22 = nArray[n3];
            nArray[n3] = it22 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull((Object)string);
                long result = Long.parseLong(string);
                this.peeked = 0;
                int[] it22 = this.pathIndices;
                int n4 = this.stackSize - 1;
                int n5 = it22[n4];
                it22[n4] = n5 + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            it22 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it22;
        long result = (long)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n6 = this.stackSize - 1;
        int n7 = nArray[n6];
        nArray[n6] = n7 + 1;
        return result;
    }

    @Override
    @NotNull
    public JsonNumber nextNumber() {
        String string = this.nextString();
        Intrinsics.checkNotNull((Object)string);
        return new JsonNumber(string);
    }

    private final String nextQuotedValue(ByteString runTerminator) {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != (byte)92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        builder.append\u2026uilder.toString()\n      }");
            string = string2;
        }
        return string;
    }

    private final String nextUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != (byte)92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() {
        double it2;
        Object object;
        Object object2 = this.peeked;
        int it2 = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it2 == 0) ? object2 : null;
        int p = object3 != null ? ((Integer)object3).intValue() : this.doPeek();
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            object2 = this.pathIndices;
            it2 = this.stackSize - 1;
            object = object2[it2];
            object2[it2] = object + true;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull((Object)string);
                int result = Integer.parseInt(string);
                this.peeked = 0;
                object2 = this.pathIndices;
                it2 = this.stackSize - 1;
                object = object2[it2];
                object2[it2] = object + true;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            it2 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it2;
        int result = (int)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() {
        int n;
        int count = 0;
        do {
            Integer n2 = this.peeked;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = !(it == 0) ? n2 : null;
            switch (n3 != null ? n3.intValue() : this.doPeek()) {
                case 3: {
                    this.push(1);
                    ++count;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++count;
                    break;
                }
                case 4: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 2: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip((long)this.peekedNumberLength);
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int[] nArray = this.pathIndices;
        n = this.stackSize - 1;
        int n4 = nArray[n];
        nArray[n] = n4 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    @Override
    public int selectName(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (names.isEmpty()) {
            return -1;
        }
        while (this.hasNext()) {
            block7: {
                int n;
                String name = this.nextName();
                int expectedIndex = this.indexStack[this.indexStackSize - 1];
                if (Intrinsics.areEqual((Object)names.get(expectedIndex), (Object)name)) {
                    int n2;
                    int it = n2 = expectedIndex;
                    boolean bl = false;
                    this.indexStack[this.indexStackSize - 1] = expectedIndex + 1;
                    if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                        this.indexStack[this.indexStackSize - 1] = 0;
                    }
                    return n2;
                }
                int index = 0;
                index = expectedIndex;
                do {
                    if ((index = (n = index) + 1) == names.size()) {
                        index = 0;
                    }
                    if (index == expectedIndex) break block7;
                } while (!Intrinsics.areEqual((Object)names.get(index), (Object)name));
                int it = n = index;
                boolean bl = false;
                this.indexStack[this.indexStackSize - 1] = index + 1;
                if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                    this.indexStack[this.indexStackSize - 1] = 0;
                }
                return n;
            }
            this.skipValue();
        }
        return -1;
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            throw new JsonDataException("Nesting too deep at " + this.getPath());
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) {
        int p = 0;
        while (this.source.request((long)p + 1L)) {
            byte c;
            if ((c = this.buffer.getByte((long)p++)) == 10 || c == 32 || c == 13 || c == 9) continue;
            this.buffer.skip((long)p - 1L);
            if (c == 47) {
                if (!this.source.request(2L)) {
                    return c;
                }
                this.checkLenient();
                byte peek = this.buffer.getByte(1L);
                char c2 = (char)peek;
                if (c2 == '*') {
                    this.buffer.readByte();
                    this.buffer.readByte();
                    if (!this.skipTo("*/")) {
                        throw this.syntaxError("Unterminated comment");
                    }
                    this.buffer.readByte();
                    this.buffer.readByte();
                    p = 0;
                    continue;
                }
                if (c2 == '/') {
                    this.buffer.readByte();
                    this.buffer.readByte();
                    this.skipToEndOfLine();
                    p = 0;
                    continue;
                }
                return c;
            }
            if (c == 35) {
                this.checkLenient();
                this.skipToEndOfLine();
                p = 0;
                continue;
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    private final void checkLenient() {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private final void skipToEndOfLine() {
        long index = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(index != -1L ? index + 1L : this.buffer.size());
    }

    private final boolean skipTo(String toFind) {
        block0: while (this.source.request((long)toFind.length())) {
            int n = toFind.length();
            for (int c = 0; c < n; ++c) {
                if (this.buffer.getByte((long)c) == (byte)toFind.charAt(c)) continue;
                this.buffer.readByte();
                continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Object> getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    private final String getPathAsString() {
        return CollectionsKt.joinToString$default((Iterable)this.getPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final char readEscapeCharacter() {
        int n;
        if (!this.source.request(1L)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char escaped = (char)this.buffer.readByte();
        if (escaped == 'u') {
            void var2_2;
            int i;
            if (!this.source.request(4L)) {
                throw new EOFException("Unterminated escape sequence at path " + this.getPath());
            }
            char result = (char)0;
            int end = i + 4;
            for (i = 0; i < end; ++i) {
                int n2;
                byte c = this.buffer.getByte((long)i);
                result = (char)(result << 4);
                if (c >= (byte)48 && c <= (byte)57) {
                    n2 = c - (byte)48;
                } else if (c >= (byte)97 && c <= (byte)102) {
                    n2 = c - (byte)97 + 10;
                } else if (c >= (byte)65 && c <= (byte)70) {
                    n2 = c - (byte)65 + 10;
                } else {
                    throw this.syntaxError("\\u" + this.buffer.readUtf8(4L));
                }
                result = (char)(result + n2);
            }
            this.buffer.skip(4L);
            n = var2_2;
        } else if (escaped == 't') {
            n = 9;
        } else if (escaped == 'b') {
            n = 8;
        } else if (escaped == 'n') {
            n = 10;
        } else if (escaped == 'r') {
            n = 13;
        } else if (escaped == 'f') {
            n = 12;
        } else if ((((escaped == '\n' ? true : escaped == '\'') ? true : escaped == '\"') ? true : escaped == '\\') ? true : escaped == '/') {
            n = escaped;
        } else {
            void var1_1;
            if (!this.lenient) {
                throw this.syntaxError("Invalid escape sequence: \\" + escaped);
            }
            n = var1_1;
        }
        return (char)n;
    }

    @Override
    public void rewind() {
        throw new IllegalStateException("BufferedSourceJsonReader cannot rewind.".toString());
    }

    private final JsonEncodingException syntaxError(String message) {
        return new JsonEncodingException(message + " at path " + this.getPath());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u001d\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo3/api/json/BufferedSourceJsonReader$Companion;", "", "()V", "DOUBLE_QUOTE_OR_SLASH", "Lokio/ByteString;", "LINEFEED_OR_CARRIAGE_RETURN", "MAX_STACK_SIZE", "", "MIN_INCOMPLETE_INTEGER", "", "NUMBER_CHAR_DECIMAL", "NUMBER_CHAR_DIGIT", "NUMBER_CHAR_EXP_DIGIT", "NUMBER_CHAR_EXP_E", "NUMBER_CHAR_EXP_SIGN", "NUMBER_CHAR_FRACTION_DIGIT", "NUMBER_CHAR_NONE", "NUMBER_CHAR_SIGN", "PEEKED_BEGIN_ARRAY", "PEEKED_BEGIN_OBJECT", "PEEKED_BUFFERED", "PEEKED_DOUBLE_QUOTED", "PEEKED_DOUBLE_QUOTED_NAME", "PEEKED_END_ARRAY", "PEEKED_END_OBJECT", "PEEKED_EOF", "PEEKED_FALSE", "PEEKED_LONG", "PEEKED_NONE", "PEEKED_NULL", "PEEKED_NUMBER", "PEEKED_SINGLE_QUOTED", "PEEKED_SINGLE_QUOTED_NAME", "PEEKED_TRUE", "PEEKED_UNQUOTED", "PEEKED_UNQUOTED_NAME", "SINGLE_QUOTE_OR_SLASH", "UNQUOTED_STRING_TERMINALS", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

