/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.UploadsHttpBody;
import com.apollographql.apollo3.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.api.json.MapJsonWriter;
import com.apollographql.apollo3.api.json.internal.FileUploadAwareJsonWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serverUrl;
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE = "multipart/mixed; deferSpec=20220824, application/json";

    public DefaultHttpRequestComposer(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        Object[] objectArray = new HttpHeader[]{new HttpHeader(HEADER_APOLLO_OPERATION_ID, operation.id()), new HttpHeader(HEADER_APOLLO_OPERATION_NAME, operation.name()), new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE)};
        List<HttpHeader> list = apolloRequest.getHttpHeaders();
        List requestHeaders = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        Boolean bl = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl != null ? bl : false;
        Boolean bl2 = apolloRequest.getSendDocument();
        boolean sendDocument = bl2 != null ? bl2 : true;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                httpRequest = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, sendApqExtensions, sendDocument)).addHeaders(requestHeaders).build();
                break;
            }
            case 2: {
                String query = sendDocument ? operation.document() : null;
                httpRequest = new HttpRequest.Builder(HttpMethod.Post, this.serverUrl).addHeaders(requestHeaders).body(Companion.buildPostBody(operation, customScalarAdapters2, sendApqExtensions, query)).build();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\b\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J6\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J8\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004JD\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J,\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\t0\u001dJN\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u001a\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010 \u001a\u00020!2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\"\u001a\u00020\u0004*\u00020\u00042\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "()V", "HEADER_ACCEPT_NAME", "", "HEADER_ACCEPT_VALUE", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "buildGetUrl", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "sendApqExtensions", "", "sendDocument", "buildParamsMap", "Lokio/ByteString;", "autoPersistQueries", "buildPostBody", "Lcom/apollographql/apollo3/api/http/HttpBody;", "query", "composeGetParams", "", "composePayload", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "composePostParams", "Lcom/apollographql/apollo3/api/Upload;", "writer", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "appendQueryParameters", "parameters", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, String query) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u2d3 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u2d3.name("operationName");
            $this$composePostParams_u24lambda_u2d3.value(operation.name());
            $this$composePostParams_u24lambda_u2d3.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u2d3);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d0 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u2d3_u24lambda_u2d0, customScalarAdapters);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u2d3.name("query");
                $this$composePostParams_u24lambda_u2d3.value(query);
            }
            if (sendApqExtensions) {
                $this$composePostParams_u24lambda_u2d3.name("extensions");
                $this$writeObject$iv2 = $this$composePostParams_u24lambda_u2d3;
                $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2 = $this$writeObject$iv2;
                boolean bl3 = false;
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2;
                boolean $i$f$writeObject3 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = $this$writeObject$iv3;
                boolean bl4 = false;
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("version").value(1);
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv2.endObject();
            }
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u2d6 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u2d6);
            JsonWriter $this$writeObject$iv = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u2d6_u24lambda_u2d4 = $this$writeObject$iv;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u2d6_u24lambda_u2d4, customScalarAdapters);
            $this$writeObject$iv.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                String indent$iv2 = null;
                boolean $i$f$buildJsonString2 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$composeGetParams_u24lambda_u2d9 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2, indent$iv2);
                boolean bl3 = false;
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u2d9;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8 = $this$writeObject$iv;
                boolean bl4 = false;
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8.name("persistedQuery");
                JsonWriter $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8;
                boolean $i$f$writeObject2 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7.name("version").value(1);
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7.name("sha256Hash").value(operation.id());
                $this$writeObject$iv2.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u2d11 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u2d11.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    $this$appendQueryParameters_u24lambda_u2d11.append('&');
                } else {
                    hasQuestionMark = true;
                    $this$appendQueryParameters_u24lambda_u2d11.append('?');
                }
                $this$appendQueryParameters_u24lambda_u2d11.append(UrlEncodeKt.urlEncode$default((String)it.getKey(), false, 1, null));
                $this$appendQueryParameters_u24lambda_u2d11.append('=');
                $this$appendQueryParameters_u24lambda_u2d11.append(UrlEncodeKt.urlEncode$default((String)it.getValue(), false, 1, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2d12 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u2d12, operation, customScalarAdapters, autoPersistQueries, query);
            ByteString operationByteString = buffer$iv.readByteString();
            if (uploads.isEmpty()) {
                return new HttpBody(operationByteString){
                    @NotNull
                    private final String contentType;
                    private final long contentLength;
                    final /* synthetic */ ByteString $operationByteString;
                    {
                        this.$operationByteString = $operationByteString;
                        this.contentType = "application/json";
                        this.contentLength = $operationByteString.size();
                    }

                    @NotNull
                    public String getContentType() {
                        return this.contentType;
                    }

                    public long getContentLength() {
                        return this.contentLength;
                    }

                    public void writeTo(@NotNull BufferedSink bufferedSink) {
                        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                        bufferedSink.write(this.$operationByteString);
                    }
                };
            }
            return new UploadsHttpBody(uploads, operationByteString);
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2d13 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2d13, operation, customScalarAdapters, autoPersistQueries, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                throw new IllegalStateException("Cannot find a ResponseAdapterCache".toString());
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2d14 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2d14, operation, customScalarAdapters2, sendApqExtensions, query);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            nArray[HttpMethod.Get.ordinal()] = 1;
            nArray[HttpMethod.Post.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

