/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.json;

import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.json.JsonNumber;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.apollographql.apollo3.api.json.internal.JsonScope;
import com.apollographql.apollo3.exception.JsonDataException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J \u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\u000e\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0005J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020\u0018H\u0002J\b\u0010'\u001a\u00020\u0001H\u0016J\u0018\u0010(\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020/H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u000200H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u000201H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u000202H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0005H\u0016J\b\u00103\u001a\u00020\u0018H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/apollographql/apollo3/api/json/BufferedSinkJsonWriter;", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "sink", "Lokio/BufferedSink;", "indent", "", "(Lokio/BufferedSink;Ljava/lang/String;)V", "deferredName", "isLenient", "", "path", "getPath", "()Ljava/lang/String;", "pathIndices", "", "pathNames", "", "[Ljava/lang/String;", "scopes", "separator", "getSeparator", "stackSize", "", "beforeName", "", "beforeValue", "beginArray", "beginObject", "close", "empty", "nonempty", "closeBracket", "endArray", "endObject", "flush", "jsonValue", "value", "name", "newline", "nullValue", "open", "openBracket", "peekScope", "pushScope", "newTop", "replaceTop", "topOfStack", "Lcom/apollographql/apollo3/api/Upload;", "Lcom/apollographql/apollo3/api/json/JsonNumber;", "", "", "writeDeferredName", "Companion", "apollo-api"})
public final class BufferedSinkJsonWriter
implements JsonWriter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final BufferedSink sink;
    @Nullable
    private final String indent;
    private int stackSize;
    @NotNull
    private final int[] scopes;
    @NotNull
    private final String[] pathNames;
    @NotNull
    private final int[] pathIndices;
    private boolean isLenient;
    @Nullable
    private String deferredName;
    @NotNull
    private static final String HEX_ARRAY = "0123456789abcdef";
    @NotNull
    private static final String[] REPLACEMENT_CHARS;

    @JvmOverloads
    public BufferedSinkJsonWriter(@NotNull BufferedSink sink, @Nullable String indent) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
        this.indent = indent;
        this.scopes = new int[256];
        this.pathNames = new String[256];
        this.pathIndices = new int[256];
        this.pushScope(6);
    }

    public /* synthetic */ BufferedSinkJsonWriter(BufferedSink bufferedSink, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(bufferedSink, string);
    }

    private final String getSeparator() {
        CharSequence charSequence = this.indent;
        return charSequence == null || charSequence.length() == 0 ? ":" : ": ";
    }

    @Override
    @NotNull
    public String getPath() {
        return CollectionsKt.joinToString$default((Iterable)JsonScope.INSTANCE.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public JsonWriter beginArray() {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    @Override
    @NotNull
    public JsonWriter endArray() {
        return this.close(1, 2, "]");
    }

    @Override
    @NotNull
    public JsonWriter beginObject() {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    @Override
    @NotNull
    public JsonWriter endObject() {
        return this.close(3, 5, "}");
    }

    private final JsonWriter open(int empty, String openBracket) {
        this.beforeValue();
        this.pushScope(empty);
        this.pathIndices[this.stackSize - 1] = 0;
        this.sink.writeUtf8(openBracket);
        return this;
    }

    private final JsonWriter close(int empty, int nonempty, String closeBracket) {
        int context = this.peekScope();
        if (!(context == nonempty || context == empty)) {
            boolean $i$a$-check-BufferedSinkJsonWriter$close$32 = false;
            String $i$a$-check-BufferedSinkJsonWriter$close$32 = "Nesting problem.";
            throw new IllegalStateException($i$a$-check-BufferedSinkJsonWriter$close$32.toString());
        }
        if (!(this.deferredName == null)) {
            boolean bl = false;
            String string = "Dangling name: " + this.deferredName;
            throw new IllegalStateException(string.toString());
        }
        int n = this.stackSize;
        this.stackSize = n + -1;
        this.pathNames[this.stackSize] = null;
        int[] nArray = this.pathIndices;
        int n2 = this.stackSize - 1;
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
        if (context == nonempty) {
            this.newline();
        }
        this.sink.writeUtf8(closeBracket);
        return this;
    }

    @Override
    @NotNull
    public JsonWriter name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(this.stackSize != 0)) {
            boolean $i$a$-check-BufferedSinkJsonWriter$name$32 = false;
            String $i$a$-check-BufferedSinkJsonWriter$name$32 = "JsonWriter is closed.";
            throw new IllegalStateException($i$a$-check-BufferedSinkJsonWriter$name$32.toString());
        }
        if (!(this.deferredName == null)) {
            boolean bl = false;
            String string = "Nesting problem.";
            throw new IllegalStateException(string.toString());
        }
        this.deferredName = name;
        this.pathNames[this.stackSize - 1] = name;
        return this;
    }

    private final void writeDeferredName() {
        if (this.deferredName != null) {
            this.beforeName();
            String string = this.deferredName;
            Intrinsics.checkNotNull((Object)string);
            Companion.string(this.sink, string);
            this.deferredName = null;
        }
    }

    @Override
    @NotNull
    public JsonWriter value(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeDeferredName();
        this.beforeValue();
        Companion.string(this.sink, value);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return this;
    }

    @Override
    @NotNull
    public JsonWriter nullValue() {
        return this.jsonValue("null");
    }

    @Override
    @NotNull
    public JsonWriter value(boolean value) {
        return this.jsonValue(value ? "true" : "false");
    }

    @Override
    @NotNull
    public JsonWriter value(double value) {
        if (!(this.isLenient || !Double.isNaN(value) && !Double.isInfinite(value))) {
            boolean bl = false;
            String string = "Numeric values must be finite, but was " + value;
            throw new IllegalArgumentException(string.toString());
        }
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    @NotNull
    public JsonWriter value(int value) {
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    @NotNull
    public JsonWriter value(long value) {
        return this.jsonValue(String.valueOf(value));
    }

    @Override
    @NotNull
    public JsonWriter value(@NotNull JsonNumber value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.jsonValue(value.toString());
    }

    @Override
    @NotNull
    public BufferedSinkJsonWriter value(@NotNull Upload value) {
        BufferedSinkJsonWriter bufferedSinkJsonWriter;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BufferedSinkJsonWriter $this$value_u24lambda_u2d5 = bufferedSinkJsonWriter = this;
        boolean bl = false;
        $this$value_u24lambda_u2d5.nullValue();
        return bufferedSinkJsonWriter;
    }

    @NotNull
    public final JsonWriter jsonValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(value);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return this;
    }

    @Override
    public void flush() {
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonWriter is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.sink.flush();
    }

    @Override
    public void close() {
        this.sink.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.scopes[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private final void newline() {
        if (this.indent == null) {
            return;
        }
        this.sink.writeByte(10);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.sink.writeUtf8(this.indent);
        }
    }

    private final void beforeName() {
        int context = this.peekScope();
        if (context == 5) {
            this.sink.writeByte(44);
        } else if (!(context == 3)) {
            boolean bl = false;
            String string = "Nesting problem.";
            throw new IllegalStateException(string.toString());
        }
        this.newline();
        this.replaceTop(4);
    }

    private final void beforeValue() {
        switch (this.peekScope()) {
            case 7: {
                if (!this.isLenient) {
                    boolean bl = false;
                    String string = "JSON must have only one top-level value.";
                    throw new IllegalStateException(string.toString());
                }
                this.replaceTop(7);
                break;
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.sink.writeByte(44);
                this.newline();
                break;
            }
            case 4: {
                this.sink.writeUtf8(this.getSeparator());
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    private final int peekScope() {
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonWriter is closed.";
            throw new IllegalStateException(string.toString());
        }
        return this.scopes[this.stackSize - 1];
    }

    private final void pushScope(int newTop) {
        if (this.stackSize == this.scopes.length) {
            throw new JsonDataException("Nesting too deep at " + this.getPath() + ": circular reference?");
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.scopes[n] = newTop;
    }

    private final void replaceTop(int topOfStack) {
        this.scopes[this.stackSize - 1] = topOfStack;
    }

    @JvmOverloads
    public BufferedSinkJsonWriter(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this(sink, null, 2, null);
    }

    static {
        String[] stringArray;
        Companion = new Companion(null);
        String[] $this$REPLACEMENT_CHARS_u24lambda_u2d10 = stringArray = new String[128];
        boolean bl = false;
        for (int i = 0; i < 32; ++i) {
            $this$REPLACEMENT_CHARS_u24lambda_u2d10[i] = "\\u00" + BufferedSinkJsonWriter.Companion.hexString((byte)i);
        }
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[34] = "\\\"";
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[92] = "\\\\";
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[9] = "\\t";
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[8] = "\\b";
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[10] = "\\n";
        $this$REPLACEMENT_CHARS_u24lambda_u2d10[13] = "\\r";
        REPLACEMENT_CHARS = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\f\u0010\r\u001a\u00020\u0004*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/apollo3/api/json/BufferedSinkJsonWriter$Companion;", "", "()V", "HEX_ARRAY", "", "REPLACEMENT_CHARS", "", "[Ljava/lang/String;", "string", "", "sink", "Lokio/BufferedSink;", "value", "hexString", "", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        private final String hexString(byte $this$hexString) {
            byte value = $this$hexString;
            return "" + BufferedSinkJsonWriter.HEX_ARRAY.charAt(value >>> 4) + BufferedSinkJsonWriter.HEX_ARRAY.charAt(value & 0xF);
        }

        public final void string(@NotNull BufferedSink sink, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String[] replacements = REPLACEMENT_CHARS;
            sink.writeByte(34);
            int last = 0;
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                String replacement = null;
                if (c < '\u0080') {
                    replacement = replacements[c];
                    if (replacement == null) {
                        continue;
                    }
                } else if (c == '\u2028') {
                    replacement = "\\u2028";
                } else {
                    if (c != '\u2029') continue;
                    replacement = "\\u2029";
                }
                if (last < i) {
                    sink.writeUtf8(value, last, i);
                }
                sink.writeUtf8(replacement);
                last = i + 1;
            }
            if (last < length) {
                sink.writeUtf8(value, last, length);
            }
            sink.writeByte(34);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

