/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api;

import com.apollographql.apollo3.api.Upload;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B5\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo3/api/DefaultUpload;", "Lcom/apollographql/apollo3/api/Upload;", "bufferedSource", "Lokio/BufferedSource;", "byteString", "Lokio/ByteString;", "contentType", "", "contentLength", "", "fileName", "(Lokio/BufferedSource;Lokio/ByteString;Ljava/lang/String;JLjava/lang/String;)V", "getContentLength", "()J", "getContentType", "()Ljava/lang/String;", "getFileName", "writeTo", "", "sink", "Lokio/BufferedSink;", "Builder", "apollo-api"})
public final class DefaultUpload
implements Upload {
    @Nullable
    private final BufferedSource bufferedSource;
    @Nullable
    private final ByteString byteString;
    @NotNull
    private final String contentType;
    private final long contentLength;
    @Nullable
    private final String fileName;

    public DefaultUpload(@Nullable BufferedSource bufferedSource, @Nullable ByteString byteString, @NotNull String contentType, long contentLength2, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.bufferedSource = bufferedSource;
        this.byteString = byteString;
        this.contentType = contentType;
        this.contentLength = contentLength2;
        this.fileName = fileName;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (this.bufferedSource != null) {
            Closeable $this$use$iv = (Closeable)this.bufferedSource;
            boolean $i$f$use = false;
            Long result$iv = null;
            Throwable thrown$iv = null;
            try {
                BufferedSource it = (BufferedSource)$this$use$iv;
                boolean bl = false;
                result$iv = sink.writeAll((Source)it);
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                if (thrown$iv == null) {
                    thrown$iv = t$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
            }
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            Intrinsics.checkNotNull((Object)result$iv);
        } else if (this.byteString != null) {
            sink.write(this.byteString);
        } else {
            throw new IllegalStateException("No upload content found".toString());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/api/DefaultUpload$Builder;", "", "()V", "bufferedSource", "Lokio/BufferedSource;", "byteString", "Lokio/ByteString;", "contentLength", "", "contentType", "", "fileName", "hasContent", "", "getHasContent", "()Z", "build", "Lcom/apollographql/apollo3/api/DefaultUpload;", "content", "byteArray", "", "apollo-api"})
    public static final class Builder {
        @Nullable
        private BufferedSource bufferedSource;
        @Nullable
        private ByteString byteString;
        @Nullable
        private String contentType;
        private long contentLength = -1L;
        @Nullable
        private String fileName;

        private final boolean getHasContent() {
            return this.bufferedSource != null || this.byteString != null;
        }

        @NotNull
        public final Builder content(@NotNull BufferedSource content) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Builder $this$content_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            if (!(!$this$content_u24lambda_u2d1.getHasContent())) {
                boolean bl2 = false;
                String string = "content() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$content_u24lambda_u2d1.bufferedSource = content;
            return builder;
        }

        @NotNull
        public final Builder content(@NotNull String content) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Builder $this$content_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            if (!(!$this$content_u24lambda_u2d3.getHasContent())) {
                boolean bl2 = false;
                String string = "content() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$content_u24lambda_u2d3.byteString = ByteString.Companion.encodeUtf8(content);
            $this$content_u24lambda_u2d3.contentLength = content.length();
            return builder;
        }

        @NotNull
        public final Builder content(@NotNull ByteString byteString) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
            Builder $this$content_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            if (!(!$this$content_u24lambda_u2d5.getHasContent())) {
                boolean bl2 = false;
                String string = "content() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$content_u24lambda_u2d5.byteString = byteString;
            $this$content_u24lambda_u2d5.contentLength = byteString.size();
            return builder;
        }

        @NotNull
        public final Builder content(@NotNull byte[] byteArray) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            Builder $this$content_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            if (!(!$this$content_u24lambda_u2d7.getHasContent())) {
                boolean bl2 = false;
                String string = "content() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$content_u24lambda_u2d7.byteString = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byteArray, (int)0, (int)0, (int)3, null);
            $this$content_u24lambda_u2d7.contentLength = byteArray.length;
            return builder;
        }

        @NotNull
        public final Builder contentType(@NotNull String contentType) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Builder $this$contentType_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$contentType_u24lambda_u2d8.contentType = contentType;
            return builder;
        }

        @NotNull
        public final Builder contentLength(long contentLength2) {
            Builder builder;
            Builder $this$contentLength_u24lambda_u2d9 = builder = this;
            boolean bl = false;
            $this$contentLength_u24lambda_u2d9.contentLength = contentLength2;
            return builder;
        }

        @NotNull
        public final Builder fileName(@NotNull String fileName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Builder $this$fileName_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$fileName_u24lambda_u2d10.fileName = fileName;
            return builder;
        }

        @NotNull
        public final DefaultUpload build() {
            String string = this.contentType;
            if (string == null) {
                string = "application/octet-stream";
            }
            return new DefaultUpload(this.bufferedSource, this.byteString, string, this.contentLength, this.fileName);
        }
    }
}

