/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.Adapters;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.MapJsonReader;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010J\f\u0010\u0012\u001a\u00020\u000e*\u00020\bH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\bH\u0002J\u0014\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016*\u00020\bH\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016*\u00020\bH\u0002J\u0014\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0016*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseParser;", "", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "payload", "", "", "readError", "readErrorLocation", "Lcom/apollographql/apollo3/api/Error$Location;", "readErrorLocations", "", "readErrors", "readPath", "apollo-api"})
public final class ResponseParser {
    @NotNull
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Closeable $this$use$iv = jsonReader;
        boolean $i$f$use = false;
        ApolloResponse<Operation.Data> result$iv = null;
        Throwable thrown$iv = null;
        try {
            JsonReader jsonReader2 = (JsonReader)$this$use$iv;
            boolean bl = false;
            jsonReader2.beginObject();
            Operation.Data data = null;
            List<Error> errors = null;
            Map extensions = null;
            block14: while (jsonReader2.hasNext()) {
                switch (jsonReader2.nextName()) {
                    case "data": {
                        data = (Operation.Data)Adapters.-nullable(operation.adapter()).fromJson(jsonReader2, customScalarAdapters);
                        continue block14;
                    }
                    case "errors": {
                        errors = INSTANCE.readErrors(jsonReader2);
                        continue block14;
                    }
                    case "extensions": {
                        Object object = -JsonReaders.readAny(jsonReader2);
                        extensions = object instanceof Map ? (Map)object : null;
                        continue block14;
                    }
                }
                jsonReader2.skipValue();
            }
            jsonReader2.endObject();
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            Object object = uUID;
            Operation.Data data2 = data;
            result$iv = new ApolloResponse.Builder<Operation.Data>(operation, (UUID)object, data2).errors(errors).extensions(extensions).build();
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            t$iv.close();
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        ApolloResponse<Operation.Data> apolloResponse = result$iv;
        Intrinsics.checkNotNull(apolloResponse);
        return apolloResponse;
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.readError(new MapJsonReader(payload));
    }

    private final List<Error> readErrors(JsonReader $this$readErrors) {
        if ($this$readErrors.peek() == JsonReader.Token.NULL) {
            $this$readErrors.nextNull();
            return CollectionsKt.emptyList();
        }
        $this$readErrors.beginArray();
        List list = new ArrayList();
        while ($this$readErrors.hasNext()) {
            list.add(this.readError($this$readErrors));
        }
        $this$readErrors.endArray();
        return list;
    }

    private final Error readError(JsonReader $this$readError) {
        String message = "";
        List<Error.Location> locations = null;
        List<Object> path = null;
        Map extensions = null;
        Object nonStandardFields = null;
        $this$readError.beginObject();
        block12: while ($this$readError.hasNext()) {
            String name;
            Object object;
            switch ($this$readError.nextName()) {
                case "message": {
                    String string = $this$readError.nextString();
                    if (string == null) {
                        string = "";
                    }
                    message = string;
                    continue block12;
                }
                case "locations": {
                    locations = this.readErrorLocations($this$readError);
                    continue block12;
                }
                case "path": {
                    path = this.readPath($this$readError);
                    continue block12;
                }
                case "extensions": {
                    object = -JsonReaders.readAny($this$readError);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block12;
                }
            }
            if (nonStandardFields == null) {
                nonStandardFields = new LinkedHashMap();
            }
            object = nonStandardFields;
            Object object2 = -JsonReaders.readAny($this$readError);
            object.put(name, object2);
        }
        $this$readError.endObject();
        return new Error(message, locations, (List<? extends Object>)path, extensions, (Map<String, ? extends Object>)nonStandardFields);
    }

    private final List<Object> readPath(JsonReader $this$readPath) {
        if ($this$readPath.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readPath.nextNull());
        }
        List list = new ArrayList();
        $this$readPath.beginArray();
        block3: while ($this$readPath.hasNext()) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$readPath.peek().ordinal()]) {
                case 1: 
                case 2: {
                    list.add($this$readPath.nextInt());
                    continue block3;
                }
            }
            String string = $this$readPath.nextString();
            Intrinsics.checkNotNull((Object)string);
            list.add(string);
        }
        $this$readPath.endArray();
        return list;
    }

    private final List<Error.Location> readErrorLocations(JsonReader $this$readErrorLocations) {
        if ($this$readErrorLocations.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readErrorLocations.nextNull());
        }
        List list = new ArrayList();
        $this$readErrorLocations.beginArray();
        while ($this$readErrorLocations.hasNext()) {
            list.add(this.readErrorLocation($this$readErrorLocations));
        }
        $this$readErrorLocations.endArray();
        return list;
    }

    private final Error.Location readErrorLocation(JsonReader $this$readErrorLocation) {
        int line = -1;
        int column = -1;
        $this$readErrorLocation.beginObject();
        while ($this$readErrorLocation.hasNext()) {
            String string = $this$readErrorLocation.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"line")) {
                line = $this$readErrorLocation.nextInt();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"column")) {
                column = $this$readErrorLocation.nextInt();
                continue;
            }
            $this$readErrorLocation.skipValue();
        }
        $this$readErrorLocation.endObject();
        return new Error.Location(line, column);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            nArray[JsonReader.Token.NUMBER.ordinal()] = 1;
            nArray[JsonReader.Token.LONG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

