/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal.json;

import com.apollographql.apollo3.api.internal.json.JsonScope;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.exception.JsonDataException;
import com.apollographql.apollo3.exception.JsonEncodingException;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0001JB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0002J\t\u0010#\u001a\u00020\bH\u0096\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\fH\u0016J\b\u0010+\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\bH\u0002J\u0015\u0010.\u001a\u0004\u0018\u0001H/\"\u0004\b\u0000\u0010/H\u0016\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u000203H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u00105\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\fH\u0002J\b\u00109\u001a\u00020\fH\u0002J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\fH\u0002J\b\u0010<\u001a\u00020&H\u0002J\b\u0010=\u001a\u00020\u001dH\u0016J\u0016\u0010>\u001a\u00020\f2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110@H\u0016J\u0010\u0010A\u001a\u00020\u001d2\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\u0011H\u0002J\b\u0010D\u001a\u00020\u001dH\u0002J\b\u0010E\u001a\u00020\u001dH\u0002J\b\u0010F\u001a\u00020\u001dH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/apollographql/apollo3/api/internal/json/BufferedSourceJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "buffer", "Lokio/Buffer;", "failOnUnknown", "", "indexStack", "", "indexStackSize", "", "lenient", "pathIndices", "pathNames", "", "", "[Ljava/lang/String;", "peeked", "peekedLong", "", "peekedNumberLength", "peekedString", "stack", "stackSize", "beginArray", "beginObject", "checkLenient", "", "close", "doPeek", "endArray", "endObject", "getPath", "hasNext", "isLiteral", "c", "", "nextBoolean", "nextDouble", "", "nextInt", "nextName", "nextNonWhitespace", "throwOnEof", "nextNull", "T", "()Ljava/lang/Object;", "nextQuotedValue", "runTerminator", "Lokio/ByteString;", "nextString", "nextUnquotedValue", "peek", "Lcom/apollographql/apollo3/api/json/JsonReader$Token;", "peekKeyword", "peekNumber", "push", "newTop", "readEscapeCharacter", "rewind", "selectName", "names", "", "skipQuotedValue", "skipTo", "toFind", "skipToEndOfLine", "skipUnquotedValue", "skipValue", "syntaxError", "Lcom/apollographql/apollo3/exception/JsonEncodingException;", "message", "Companion", "apollo-api"})
public final class BufferedSourceJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    @Nullable
    private String peekedString;
    @NotNull
    private final int[] stack;
    private int stackSize;
    @NotNull
    private final String[] pathNames;
    @NotNull
    private final int[] pathIndices;
    private boolean lenient;
    private boolean failOnUnknown;
    @NotNull
    private final int[] indexStack;
    private int indexStackSize;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    @NotNull
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
    @NotNull
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
    @NotNull
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");
    @NotNull
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN = ByteString.Companion.encodeUtf8("\n\r");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    public static final int MAX_STACK_SIZE = 256;

    public BufferedSourceJsonReader(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.buffer = this.source.getBuffer();
        int[] nArray = new int[256];
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = nArray;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl3 = false;
        $this$stack_u24lambda_u2d0[0] = 6;
        Unit unit = Unit.INSTANCE;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[256];
        this.pathIndices = new int[256];
        nArray = new int[256];
        bl = false;
        bl2 = false;
        int[] $this$stack_u24lambda_u2d0 = nArray;
        bufferedSourceJsonReader = this;
        boolean bl4 = false;
        $this$indexStack_u24lambda_u2d1[0] = false;
        unit = Unit.INSTANCE;
        bufferedSourceJsonReader.indexStack = nArray;
        this.indexStackSize = 1;
    }

    @Override
    @NotNull
    public JsonReader beginArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$beginArray_u24lambda_u2d3 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$beginArray_u24lambda_u2d3.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 == null ? $this$beginArray_u24lambda_u2d3.doPeek() : n2.intValue();
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u2d3.peek()) + " at path " + $this$beginArray_u24lambda_u2d3.getPath());
        }
        $this$beginArray_u24lambda_u2d3.push(1);
        $this$beginArray_u24lambda_u2d3.pathIndices[$this$beginArray_u24lambda_u2d3.stackSize - 1] = 0;
        $this$beginArray_u24lambda_u2d3.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$endArray_u24lambda_u2d5 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$endArray_u24lambda_u2d5.peeked;
        boolean n2 = false;
        boolean bl4 = false;
        int it = ((Number)n).intValue();
        boolean bl5 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = p = object == null ? $this$endArray_u24lambda_u2d5.doPeek() : ((Integer)object).intValue();
        if (p != 4) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u2d5.peek()) + " at path " + $this$endArray_u24lambda_u2d5.getPath());
        }
        object = $this$endArray_u24lambda_u2d5;
        int n4 = ((BufferedSourceJsonReader)object).stackSize;
        ((BufferedSourceJsonReader)object).stackSize = n4 + -1;
        object = $this$endArray_u24lambda_u2d5.pathIndices;
        n4 = $this$endArray_u24lambda_u2d5.stackSize - 1;
        Object object2 = object[n4];
        object[n4] = object2 + true;
        $this$endArray_u24lambda_u2d5.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader beginObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$beginObject_u24lambda_u2d7 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$beginObject_u24lambda_u2d7.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Object object = !(it == 0) ? n : null;
        int n2 = p = object == null ? $this$beginObject_u24lambda_u2d7.doPeek() : ((Integer)object).intValue();
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u2d7.peek()) + " at path " + $this$beginObject_u24lambda_u2d7.getPath());
        }
        $this$beginObject_u24lambda_u2d7.push(3);
        $this$beginObject_u24lambda_u2d7.peeked = 0;
        object = $this$beginObject_u24lambda_u2d7;
        int n3 = ((BufferedSourceJsonReader)object).indexStackSize;
        ((BufferedSourceJsonReader)object).indexStackSize = n3 + 1;
        $this$beginObject_u24lambda_u2d7.indexStack[$this$beginObject_u24lambda_u2d7.indexStackSize - 1] = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$endObject_u24lambda_u2d9 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$endObject_u24lambda_u2d9.peeked;
        boolean n2 = false;
        boolean bl4 = false;
        int it = ((Number)n).intValue();
        boolean bl5 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = p = object == null ? $this$endObject_u24lambda_u2d9.doPeek() : ((Integer)object).intValue();
        if (p != 2) {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$endObject_u24lambda_u2d9.peek()) + " at path " + $this$endObject_u24lambda_u2d9.getPath());
        }
        object = $this$endObject_u24lambda_u2d9;
        int n4 = ((BufferedSourceJsonReader)object).stackSize;
        ((BufferedSourceJsonReader)object).stackSize = n4 + -1;
        $this$endObject_u24lambda_u2d9.pathNames[$this$endObject_u24lambda_u2d9.stackSize] = null;
        object = $this$endObject_u24lambda_u2d9.pathIndices;
        n4 = $this$endObject_u24lambda_u2d9.stackSize - 1;
        Object object2 = object[n4];
        object[n4] = object2 + true;
        $this$endObject_u24lambda_u2d9.peeked = 0;
        object = $this$endObject_u24lambda_u2d9;
        n4 = ((BufferedSourceJsonReader)object).indexStackSize;
        ((BufferedSourceJsonReader)object).indexStackSize = n4 + -1;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() throws IOException {
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 == null ? this.doPeek() : n2.intValue();
        return p != 2 && p != 4;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() throws IOException {
        JsonReader.Token token;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = n2 == null ? this.doPeek() : n2.intValue();
        switch (n3) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int doPeek() throws IOException {
        boolean bl;
        int n;
        char c;
        int c2;
        int peekStack;
        int n2 = peekStack = this.stack[this.stackSize - 1];
        switch (n2) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                c2 = this.nextNonWhitespace(true);
                this.buffer.readByte();
                c = (char)c2;
                if (c == ']') {
                    int n3 = 4;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it = n3;
                    boolean bl4 = false;
                    this.peeked = it;
                    return n3;
                }
                if (c == ';') {
                    this.checkLenient();
                    break;
                }
                if (c == ',') break;
                throw this.syntaxError("Unterminated array");
            }
            case 3: 
            case 5: {
                int n4;
                char c3;
                int c4;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c4 = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    c3 = (char)c4;
                    if (c3 == '}') {
                        int n5 = 2;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        int it = n5;
                        boolean bl7 = false;
                        this.peeked = it;
                        return n5;
                    }
                    if (c3 == ';') {
                        this.checkLenient();
                    } else if (c3 != ',') {
                        throw this.syntaxError("Unterminated object");
                    }
                }
                if ((c3 = (char)(c4 = this.nextNonWhitespace(true))) == '\"') {
                    this.buffer.readByte();
                    int n6 = 13;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    int it = n6;
                    boolean bl10 = false;
                    this.peeked = it;
                    n4 = n6;
                    return n4;
                } else if (c3 == '\'') {
                    this.buffer.readByte();
                    this.checkLenient();
                    int n7 = 12;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    int it = n7;
                    boolean bl13 = false;
                    this.peeked = it;
                    n4 = n7;
                    return n4;
                } else if (c3 == '}') {
                    if (peekStack == 5) throw this.syntaxError("Expected name");
                    this.buffer.readByte();
                    int n8 = 2;
                    boolean bl14 = false;
                    boolean bl15 = false;
                    int it = n8;
                    boolean bl16 = false;
                    this.peeked = it;
                    n4 = n8;
                    return n4;
                } else {
                    this.checkLenient();
                    if (!this.isLiteral((char)c4)) throw this.syntaxError("Expected name");
                    int n9 = 14;
                    boolean bl17 = false;
                    boolean bl18 = false;
                    int it = n9;
                    boolean bl19 = false;
                    this.peeked = it;
                    n4 = n9;
                }
                return n4;
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                c2 = this.nextNonWhitespace(true);
                this.buffer.readByte();
                c = (char)c2;
                if (c == ':') break;
                if (c != '=') throw this.syntaxError("Expected ':'");
                this.checkLenient();
                if (!this.source.request(1L)) break;
                n = 62;
                bl = false;
                if (this.buffer.getByte(0L) != (byte)n) break;
                this.buffer.readByte();
                break;
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                c2 = this.nextNonWhitespace(false);
                if (c2 == -1) {
                    int n10 = 17;
                    boolean bl20 = false;
                    boolean bl21 = false;
                    int it = n10;
                    boolean bl22 = false;
                    this.peeked = it;
                    return n10;
                }
                this.checkLenient();
                break;
            }
            default: {
                c2 = peekStack != 8 ? 1 : 0;
                c = '\u0000';
                n = 0;
                if (c2 != 0) break;
                boolean bl23 = false;
                String string = "JsonReader is closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        int c5 = this.nextNonWhitespace(true);
        c2 = (char)c5;
        if (c2 == 93) {
            if (peekStack == 1) {
                this.buffer.readByte();
                c = (char)4;
                n = 0;
                bl = false;
                char it = c;
                boolean bl24 = false;
                this.peeked = it;
                return c;
            }
            switch (peekStack) {
                case 1: 
                case 2: {
                    this.checkLenient();
                    c = (char)7;
                    n = 0;
                    bl = false;
                    char it = c;
                    boolean bl25 = false;
                    this.peeked = it;
                    return c;
                }
                default: {
                    throw this.syntaxError("Unexpected value");
                }
            }
        }
        if (c2 == 59 ? true : c2 == 44) {
            switch (peekStack) {
                case 1: 
                case 2: {
                    this.checkLenient();
                    c = (char)7;
                    n = 0;
                    bl = false;
                    char it = c;
                    boolean bl26 = false;
                    this.peeked = it;
                    return c;
                }
                default: {
                    throw this.syntaxError("Unexpected value");
                }
            }
        }
        if (c2 == 39) {
            this.checkLenient();
            this.buffer.readByte();
            c = (char)8;
            n = 0;
            bl = false;
            char it = c;
            boolean bl27 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 34) {
            this.buffer.readByte();
            c = (char)9;
            n = 0;
            bl = false;
            char it = c;
            boolean bl28 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 91) {
            this.buffer.readByte();
            c = (char)3;
            n = 0;
            bl = false;
            char it = c;
            boolean bl29 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 123) {
            this.buffer.readByte();
            c = '\u0001';
            n = 0;
            bl = false;
            char it = c;
            boolean bl30 = false;
            this.peeked = it;
            return c;
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        c = (char)10;
        n = 0;
        bl = false;
        char it = c;
        boolean bl31 = false;
        this.peeked = it;
        return c;
    }

    private final int peekKeyword() throws IOException {
        boolean bl;
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        byte by = this.buffer.getByte(0L);
        int n = 116;
        boolean bl2 = false;
        if (by == (byte)n) {
            bl = true;
        } else {
            n = 84;
            bl2 = false;
            bl = by == (byte)n;
        }
        if (bl) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else {
            boolean bl3;
            n = 102;
            bl2 = false;
            if (by == (byte)n) {
                bl3 = true;
            } else {
                n = 70;
                bl2 = false;
                bl3 = by == (byte)n;
            }
            if (bl3) {
                keyword = "false";
                keywordUpper = "FALSE";
                peeking = 6;
            } else {
                boolean bl4;
                n = 110;
                bl2 = false;
                if (by == (byte)n) {
                    bl4 = true;
                } else {
                    n = 78;
                    bl2 = false;
                    bl4 = by == (byte)n;
                }
                if (bl4) {
                    keyword = "null";
                    keywordUpper = "NULL";
                    peeking = 7;
                } else {
                    return 0;
                }
            }
        }
        int length = keyword.length();
        n = 1;
        if (n < length) {
            do {
                int i;
                if (!this.source.request((long)(i = n++) + 1L)) {
                    return 0;
                }
                byte c = this.buffer.getByte((long)i);
                char c2 = keyword.charAt(i);
                boolean bl5 = false;
                if (c == (byte)c2) continue;
                c2 = keywordUpper.charAt(i);
                bl5 = false;
                if (c == (byte)c2) continue;
                return 0;
            } while (n < length);
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte((long)length))) {
            return 0;
        }
        this.buffer.skip((long)length);
        n = peeking;
        bl2 = false;
        boolean bl6 = false;
        int it = n;
        boolean bl7 = false;
        this.peeked = it;
        return n;
    }

    private final int peekNumber() throws IOException {
        int n;
        int it;
        int n2;
        int n3;
        int n4;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        while (this.source.request((long)i + 1L)) {
            block23: {
                int n5;
                byte c;
                block30: {
                    block29: {
                        block27: {
                            block28: {
                                block26: {
                                    block24: {
                                        block25: {
                                            block22: {
                                                c = this.buffer.getByte((long)i);
                                                n4 = c;
                                                if (n4 != 45) break block22;
                                                n3 = last;
                                                switch (n3) {
                                                    case 0: {
                                                        negative = true;
                                                        last = 1;
                                                        break block23;
                                                    }
                                                    case 5: {
                                                        last = 6;
                                                        break block23;
                                                    }
                                                    default: {
                                                        return 0;
                                                    }
                                                }
                                            }
                                            if (n4 != 43) break block24;
                                            if (last != 5) break block25;
                                            last = 6;
                                            break block23;
                                        }
                                        return 0;
                                    }
                                    if (!(n4 == 101 ? true : n4 == 69)) break block26;
                                    switch (last) {
                                        case 2: 
                                        case 4: {
                                            last = 5;
                                            break block23;
                                        }
                                        default: {
                                            return 0;
                                        }
                                    }
                                }
                                if (n4 != 46) break block27;
                                if (last != 2) break block28;
                                last = 3;
                                break block23;
                            }
                            return 0;
                        }
                        n3 = 48;
                        n5 = 0;
                        if (c < (byte)n3) break block29;
                        n3 = 57;
                        n5 = 0;
                        if (c <= (byte)n3) break block30;
                    }
                    if (!this.isLiteral((char)c)) break;
                    return 0;
                }
                n3 = last;
                switch (n3) {
                    case 0: 
                    case 1: {
                        n5 = 48;
                        boolean bl = false;
                        value = -((long)(c - (byte)n5));
                        last = 2;
                        break;
                    }
                    case 2: {
                        if (value == 0L) {
                            return 0;
                        }
                        int n6 = 48;
                        boolean bl = false;
                        long newValue = value * (long)10 - (long)(c - (byte)n6);
                        fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                        value = newValue;
                        break;
                    }
                    case 3: {
                        last = 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        last = 7;
                    }
                }
            }
            n4 = i;
            i = n4 + 1;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip((long)i);
            n2 = 15;
            n4 = 0;
            n3 = 0;
            it = n2;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        } else if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            n2 = 16;
            n4 = 0;
            n3 = 0;
            it = n2;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isLiteral(char c) throws IOException {
        boolean bl;
        char c2 = c;
        if ((((c2 == '/' ? true : c2 == '\\') ? true : c2 == ';') ? true : c2 == '#') ? true : c2 == '=') {
            this.checkLenient();
            bl = false;
        } else {
            bl = !(((((((((c2 == '{' ? true : c2 == '}') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',') ? true : c2 == ' ') ? true : c2 == '\t') ? true : c2 == '\r') ? true : c2 == '\n');
        }
        return bl;
    }

    @Override
    @NotNull
    public String nextName() throws IOException {
        String string;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = n2 == null ? this.doPeek() : n2.intValue();
        switch (n3) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    @Nullable
    public String nextString() throws IOException {
        Object object;
        Object object2 = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)object2).intValue();
        boolean bl3 = false;
        Object object3 = !(it == 0) ? object2 : null;
        int n = object3 == null ? this.doPeek() : ((Integer)object3).intValue();
        switch (n) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                object3 = this.peekedString;
                if (object3 == null) {
                    object = null;
                    break;
                }
                object2 = object3;
                bl = false;
                bl2 = false;
                Object it2 = object2;
                boolean bl4 = false;
                this.peekedString = null;
                object = object2;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8((long)this.peekedNumberLength);
                break;
            }
            default: {
                throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = object;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n2 = this.stackSize - 1;
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
        return result;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        boolean bl;
        Integer n = this.peeked;
        boolean n2 = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = object == null ? this.doPeek() : ((Integer)object).intValue();
        switch (n3) {
            case 5: {
                this.peeked = 0;
                object = this.pathIndices;
                int n4 = this.stackSize - 1;
                Object object2 = object[n4];
                object[n4] = object2 + true;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                object = this.pathIndices;
                int n5 = this.stackSize - 1;
                Object object3 = object[n5];
                object[n5] = object3 + true;
                bl = false;
                break;
            }
            default: {
                throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public <T> T nextNull() throws IOException {
        int n;
        Integer n2 = this.peeked;
        boolean n3 = false;
        boolean bl = false;
        int it = ((Number)n2).intValue();
        boolean bl2 = false;
        Object object = !(it == 0) ? n2 : null;
        int n4 = n = object == null ? this.doPeek() : ((Integer)object).intValue();
        if (n != 7) {
            throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        object = this.pathIndices;
        int n5 = this.stackSize - 1;
        Object object2 = object[n5];
        object[n5] = object2 + true;
        return null;
    }

    @Override
    public double nextDouble() throws IOException {
        int n;
        double result;
        int n2;
        block15: {
            block16: {
                double nArray;
                Integer n3 = this.peeked;
                boolean n4 = false;
                n2 = 0;
                int it = ((Number)n3).intValue();
                boolean bl = false;
                Object object = !(it == 0) ? n3 : null;
                int p = object == null ? this.doPeek() : ((Integer)object).intValue();
                if (p == 15) {
                    this.peeked = 0;
                    object = this.pathIndices;
                    int n5 = this.stackSize - 1;
                    Object string2 = object[n5];
                    object[n5] = string2 + true;
                    return this.peekedLong;
                }
                if (p == 16) {
                    this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
                } else if (p == 9) {
                    this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                } else if (p == 8) {
                    this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                } else if (p == 10) {
                    this.peekedString = this.nextUnquotedValue();
                } else if (p != 11) {
                    throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
                }
                this.peeked = 11;
                try {
                    String string = this.peekedString;
                    Intrinsics.checkNotNull((Object)string);
                    String d = string;
                    n2 = 0;
                    nArray = Double.parseDouble(d);
                }
                catch (NumberFormatException e) {
                    throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPath());
                }
                result = nArray;
                if (this.lenient) break block15;
                nArray = result;
                n = 0;
                if (Double.isNaN(nArray)) break block16;
                nArray = result;
                n = 0;
                if (!Double.isInfinite(nArray)) break block15;
            }
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        n2 = this.stackSize - 1;
        n = nArray[n2];
        nArray[n2] = n + 1;
        return result;
    }

    private final String nextQuotedValue(ByteString runTerminator) throws IOException {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            int n = 92;
            boolean bl = false;
            if (this.buffer.getByte(index) != (byte)n) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        builder.append\u2026uilder.toString()\n      }");
            string = string2;
        }
        return string;
    }

    private final String nextUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) throws IOException {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            int n = 92;
            boolean bl = false;
            if (this.buffer.getByte(index) != (byte)n) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() throws IOException {
        double d;
        Object object = this.peeked;
        int n = 0;
        boolean n2 = false;
        int it = ((Number)object).intValue();
        boolean bl = false;
        Integer n3 = !(it == 0) ? object : null;
        int p = n3 == null ? this.doPeek() : n3.intValue();
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            object = this.pathIndices;
            n = this.stackSize - 1;
            Object nArray = object[n];
            object[n] = nArray + true;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull((Object)string);
                object = string;
                n = 0;
                int result = Integer.parseInt((String)object);
                this.peeked = 0;
                object = this.pathIndices;
                n = this.stackSize - 1;
                Object object2 = object[n];
                object[n] = object2 + true;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            boolean bl2 = false;
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        double asDouble = d;
        int result = (int)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n4 = this.stackSize - 1;
        int n5 = nArray[n4];
        nArray[n4] = n5 + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() throws IOException {
        if (this.failOnUnknown) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int count = 0;
        do {
            Integer n = this.peeked;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Object object = !(it == 0) ? n : null;
            int n2 = object == null ? this.doPeek() : ((Integer)object).intValue();
            switch (n2) {
                case 3: {
                    this.push(1);
                    int n3 = count;
                    count = n3 + 1;
                    break;
                }
                case 1: {
                    this.push(3);
                    int n4 = count;
                    count = n4 + 1;
                    break;
                }
                case 4: {
                    object = this;
                    int n5 = ((BufferedSourceJsonReader)object).stackSize;
                    ((BufferedSourceJsonReader)object).stackSize = n5 + -1;
                    int n6 = count;
                    count = n6 + -1;
                    break;
                }
                case 2: {
                    object = this;
                    int n7 = ((BufferedSourceJsonReader)object).stackSize;
                    ((BufferedSourceJsonReader)object).stackSize = n7 + -1;
                    int n8 = count;
                    count = n8 + -1;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip((long)this.peekedNumberLength);
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n9 = nArray[n];
        nArray[n] = n9 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    @Override
    public int selectName(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (names.isEmpty()) {
            return -1;
        }
        while (this.hasNext()) {
            block7: {
                int n;
                String name = this.nextName();
                int expectedIndex = this.indexStack[this.indexStackSize - 1];
                if (Intrinsics.areEqual((Object)names.get(expectedIndex), (Object)name)) {
                    int n2 = expectedIndex;
                    n = 0;
                    boolean bl = false;
                    int it = n2;
                    boolean bl2 = false;
                    this.indexStack[this.indexStackSize - 1] = expectedIndex + 1;
                    if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                        this.indexStack[this.indexStackSize - 1] = 0;
                    }
                    return n2;
                }
                int index = 0;
                index = expectedIndex;
                do {
                    if ((index = (n = index) + 1) == names.size()) {
                        index = 0;
                    }
                    if (index == expectedIndex) break block7;
                } while (!Intrinsics.areEqual((Object)names.get(index), (Object)name));
                n = index;
                boolean bl = false;
                boolean bl3 = false;
                int it = n;
                boolean bl4 = false;
                this.indexStack[this.indexStackSize - 1] = index + 1;
                if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                    this.indexStack[this.indexStackSize - 1] = 0;
                }
                return n;
            }
            this.skipValue();
        }
        return -1;
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            throw new JsonDataException(Intrinsics.stringPlus((String)"Nesting too deep at ", (Object)this.getPath()));
        }
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        int n = bufferedSourceJsonReader.stackSize;
        bufferedSourceJsonReader.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) throws IOException {
        int p = 0;
        while (this.source.request((long)p + 1L)) {
            int n = p;
            p = n + 1;
            int c = this.buffer.getByte((long)n);
            n = 10;
            char c2 = '\u0000';
            if (c == n) continue;
            n = 32;
            c2 = '\u0000';
            if (c == n) continue;
            n = 13;
            c2 = '\u0000';
            if (c == n) continue;
            n = 9;
            c2 = '\u0000';
            if (c == n) continue;
            this.buffer.skip((long)p - 1L);
            n = 47;
            c2 = '\u0000';
            if (c == n) {
                if (!this.source.request(2L)) {
                    return c;
                }
                this.checkLenient();
                byte peek = this.buffer.getByte(1L);
                c2 = (char)peek;
                if (c2 == '*') {
                    this.buffer.readByte();
                    this.buffer.readByte();
                    if (!this.skipTo("*/")) {
                        throw this.syntaxError("Unterminated comment");
                    }
                    this.buffer.readByte();
                    this.buffer.readByte();
                    p = 0;
                    continue;
                }
                if (c2 == '/') {
                    this.buffer.readByte();
                    this.buffer.readByte();
                    this.skipToEndOfLine();
                    p = 0;
                    continue;
                }
                return c;
            }
            n = 35;
            c2 = '\u0000';
            if (c == n) {
                this.checkLenient();
                this.skipToEndOfLine();
                p = 0;
                continue;
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    private final void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private final void skipToEndOfLine() throws IOException {
        long index = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(index != -1L ? index + 1L : this.buffer.size());
    }

    private final boolean skipTo(String toFind) throws IOException {
        block0: while (this.source.request((long)toFind.length())) {
            int n = 0;
            int n2 = toFind.length() + -1;
            if (n <= n2) {
                do {
                    int c = n++;
                    char c2 = toFind.charAt(c);
                    boolean bl = false;
                    if (this.buffer.getByte((long)c) == (byte)c2) continue;
                    this.buffer.readByte();
                    continue block0;
                } while (n <= n2);
            }
            return true;
        }
        return false;
    }

    private final String getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    /*
     * Unable to fully structure code
     */
    private final char readEscapeCharacter() throws IOException {
        block22: {
            block18: {
                if (!this.source.request(1L)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                escaped = (char)this.buffer.readByte();
                if (escaped != 'u') break block18;
                if (!this.source.request(4L)) {
                    throw new EOFException(Intrinsics.stringPlus((String)"Unterminated escape sequence at path ", (Object)this.getPath()));
                }
                result = 0;
                i = 0;
                end = i + 4;
                while (i < end) {
                    block20: {
                        block21: {
                            block19: {
                                c = this.buffer.getByte((long)i);
                                var6_6 = result;
                                var7_7 = false;
                                result = (char)(var6_6 << 4);
                                var6_6 = 48;
                                var7_7 = false;
                                if (c < (byte)var6_6) break block19;
                                var6_6 = 57;
                                var7_7 = false;
                                if (c > (byte)var6_6) break block19;
                                var6_6 = 48;
                                var7_7 = false;
                                v0 = c - (byte)var6_6;
                                break block20;
                            }
                            var6_6 = 97;
                            var7_7 = false;
                            if (c < (byte)var6_6) break block21;
                            var6_6 = 102;
                            var7_7 = false;
                            if (c > (byte)var6_6) break block21;
                            var6_6 = 97;
                            var7_7 = false;
                            v0 = c - (byte)var6_6 + 10;
                            break block20;
                        }
                        var6_6 = 65;
                        var7_7 = false;
                        if (c < (byte)var6_6) ** GOTO lbl-1000
                        var6_6 = 70;
                        var7_7 = false;
                        if (c <= (byte)var6_6) {
                            var6_6 = 65;
                            var7_7 = false;
                            v0 = c - (byte)var6_6 + 10;
                        } else lbl-1000:
                        // 2 sources

                        {
                            throw this.syntaxError(Intrinsics.stringPlus((String)"\\u", (Object)this.buffer.readUtf8(4L)));
                        }
                    }
                    result = (char)(result + v0);
                    var6_6 = i;
                    i = var6_6 + 1;
                }
                this.buffer.skip(4L);
                v1 = var2_2;
                break block22;
            }
            if (escaped == 't') {
                v1 = 9;
            } else if (escaped == 'b') {
                v1 = 8;
            } else if (escaped == 'n') {
                v1 = 10;
            } else if (escaped == 'r') {
                v1 = 13;
            } else if (escaped == 'f') {
                v1 = 12;
            } else if ((((escaped == '\n' ? true : escaped == '\'') != false ? true : escaped == '\"') != false ? true : escaped == '\\') != false ? true : escaped == '/') {
                v1 = escaped;
            } else {
                if (!this.lenient) {
                    throw this.syntaxError(Intrinsics.stringPlus((String)"Invalid escape sequence: \\", (Object)Character.valueOf(escaped)));
                }
                v1 = var1_1;
            }
        }
        return (char)v1;
    }

    @Override
    public void rewind() {
        String string = "BufferedSourceJsonReader cannot rewind.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final JsonEncodingException syntaxError(String message) {
        return new JsonEncodingException(message + " at path " + this.getPath());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u001d\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo3/api/internal/json/BufferedSourceJsonReader$Companion;", "", "()V", "DOUBLE_QUOTE_OR_SLASH", "Lokio/ByteString;", "LINEFEED_OR_CARRIAGE_RETURN", "MAX_STACK_SIZE", "", "MIN_INCOMPLETE_INTEGER", "", "NUMBER_CHAR_DECIMAL", "NUMBER_CHAR_DIGIT", "NUMBER_CHAR_EXP_DIGIT", "NUMBER_CHAR_EXP_E", "NUMBER_CHAR_EXP_SIGN", "NUMBER_CHAR_FRACTION_DIGIT", "NUMBER_CHAR_NONE", "NUMBER_CHAR_SIGN", "PEEKED_BEGIN_ARRAY", "PEEKED_BEGIN_OBJECT", "PEEKED_BUFFERED", "PEEKED_DOUBLE_QUOTED", "PEEKED_DOUBLE_QUOTED_NAME", "PEEKED_END_ARRAY", "PEEKED_END_OBJECT", "PEEKED_EOF", "PEEKED_FALSE", "PEEKED_LONG", "PEEKED_NONE", "PEEKED_NULL", "PEEKED_NUMBER", "PEEKED_SINGLE_QUOTED", "PEEKED_SINGLE_QUOTED_NAME", "PEEKED_TRUE", "PEEKED_UNQUOTED", "PEEKED_UNQUOTED_NAME", "SINGLE_QUOTE_OR_SLASH", "UNQUOTED_STRING_TERMINALS", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

