(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'apollo-kotlin-apollo-api-js-legacy', 'Kotlin-DateTime-library-kotlinx-datetime-js-legacy', 'big.js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('apollo-kotlin-apollo-api-js-legacy'), require('Kotlin-DateTime-library-kotlinx-datetime-js-legacy'), require('big.js'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-adapters-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-kotlin-apollo-adapters-js-legacy'.");
    }if (typeof this['apollo-kotlin-apollo-api-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-adapters-js-legacy'. Its dependency 'apollo-kotlin-apollo-api-js-legacy' was not found. Please, check whether 'apollo-kotlin-apollo-api-js-legacy' is loaded prior to 'apollo-kotlin-apollo-adapters-js-legacy'.");
    }if (typeof this['Kotlin-DateTime-library-kotlinx-datetime-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-adapters-js-legacy'. Its dependency 'Kotlin-DateTime-library-kotlinx-datetime-js-legacy' was not found. Please, check whether 'Kotlin-DateTime-library-kotlinx-datetime-js-legacy' is loaded prior to 'apollo-kotlin-apollo-adapters-js-legacy'.");
    }if (typeof jsBig === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-adapters-js-legacy'. Its dependency 'big.js' was not found. Please, check whether 'big.js' is loaded prior to 'apollo-kotlin-apollo-adapters-js-legacy'.");
    }root['apollo-kotlin-apollo-adapters-js-legacy'] = factory(typeof this['apollo-kotlin-apollo-adapters-js-legacy'] === 'undefined' ? {} : this['apollo-kotlin-apollo-adapters-js-legacy'], kotlin, this['apollo-kotlin-apollo-api-js-legacy'], this['Kotlin-DateTime-library-kotlinx-datetime-js-legacy'], jsBig);
  }
}(this, function (_, Kotlin, $module$apollo_kotlin_apollo_api_js_legacy, $module$Kotlin_DateTime_library_kotlinx_datetime_js_legacy, $module$big_js) {
  'use strict';
  var ensureNotNull = Kotlin.ensureNotNull;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Adapter = $module$apollo_kotlin_apollo_api_js_legacy.com.apollographql.apollo3.api.Adapter;
  var Instant = $module$Kotlin_DateTime_library_kotlinx_datetime_js_legacy.kotlinx.datetime.Instant;
  var LocalDateTime = $module$Kotlin_DateTime_library_kotlinx_datetime_js_legacy.kotlinx.datetime.LocalDateTime;
  var LocalDate = $module$Kotlin_DateTime_library_kotlinx_datetime_js_legacy.kotlinx.datetime.LocalDate;
  var numberToInt = Kotlin.numberToInt;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var numberToShort = Kotlin.numberToShort;
  var numberToByte = Kotlin.numberToByte;
  var numberToChar = Kotlin.numberToChar;
  var toBoxedChar = Kotlin.toBoxedChar;
  var numberToDouble = Kotlin.numberToDouble;
  var hashCode = Kotlin.hashCode;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var isNaN_0 = Kotlin.kotlin.isNaN_yrwdxr$;
  var isInfinite = Kotlin.kotlin.isInfinite_yrwdxr$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  function BigDecimalAdapter() {
    BigDecimalAdapter_instance = this;
  }
  BigDecimalAdapter.prototype.fromJson_p35aje$ = function (reader, customScalarAdapters) {
    return BigDecimal_init_1(ensureNotNull(reader.nextString()));
  };
  BigDecimalAdapter.prototype.toJson_dotswr$ = function (writer, customScalarAdapters, value) {
    writer.value_61zpoe$(value.toString());
  };
  BigDecimalAdapter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'BigDecimalAdapter',
    interfaces: [Adapter]
  };
  var BigDecimalAdapter_instance = null;
  function BigDecimalAdapter_getInstance() {
    if (BigDecimalAdapter_instance === null) {
      new BigDecimalAdapter();
    }return BigDecimalAdapter_instance;
  }
  function KotlinxInstantAdapter() {
    KotlinxInstantAdapter_instance = this;
  }
  KotlinxInstantAdapter.prototype.fromJson_p35aje$ = function (reader, customScalarAdapters) {
    return Instant.Companion.parse_61zpoe$(ensureNotNull(reader.nextString()));
  };
  KotlinxInstantAdapter.prototype.toJson_dotswr$ = function (writer, customScalarAdapters, value) {
    writer.value_61zpoe$(value.toString());
  };
  KotlinxInstantAdapter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinxInstantAdapter',
    interfaces: [Adapter]
  };
  var KotlinxInstantAdapter_instance = null;
  function KotlinxInstantAdapter_getInstance() {
    if (KotlinxInstantAdapter_instance === null) {
      new KotlinxInstantAdapter();
    }return KotlinxInstantAdapter_instance;
  }
  function KotlinxLocalDateTimeAdapter() {
    KotlinxLocalDateTimeAdapter_instance = this;
  }
  KotlinxLocalDateTimeAdapter.prototype.fromJson_p35aje$ = function (reader, customScalarAdapters) {
    return LocalDateTime.Companion.parse_61zpoe$(ensureNotNull(reader.nextString()));
  };
  KotlinxLocalDateTimeAdapter.prototype.toJson_dotswr$ = function (writer, customScalarAdapters, value) {
    writer.value_61zpoe$(value.toString());
  };
  KotlinxLocalDateTimeAdapter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinxLocalDateTimeAdapter',
    interfaces: [Adapter]
  };
  var KotlinxLocalDateTimeAdapter_instance = null;
  function KotlinxLocalDateTimeAdapter_getInstance() {
    if (KotlinxLocalDateTimeAdapter_instance === null) {
      new KotlinxLocalDateTimeAdapter();
    }return KotlinxLocalDateTimeAdapter_instance;
  }
  function KotlinxLocalDateAdapter() {
    KotlinxLocalDateAdapter_instance = this;
  }
  KotlinxLocalDateAdapter.prototype.fromJson_p35aje$ = function (reader, customScalarAdapters) {
    return LocalDate.Companion.parse_61zpoe$(ensureNotNull(reader.nextString()));
  };
  KotlinxLocalDateAdapter.prototype.toJson_dotswr$ = function (writer, customScalarAdapters, value) {
    writer.value_61zpoe$(value.toString());
  };
  KotlinxLocalDateAdapter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinxLocalDateAdapter',
    interfaces: [Adapter]
  };
  var KotlinxLocalDateAdapter_instance = null;
  function KotlinxLocalDateAdapter_getInstance() {
    if (KotlinxLocalDateAdapter_instance === null) {
      new KotlinxLocalDateAdapter();
    }return KotlinxLocalDateAdapter_instance;
  }
  function BigDecimal() {
    this.raw_8be2vx$ = null;
  }
  BigDecimal.prototype.add_f4xmbf$ = function (augend) {
    return BigDecimal_init(this.raw_8be2vx$.plus(augend.raw_8be2vx$));
  };
  BigDecimal.prototype.subtract_f4xmbf$ = function (subtrahend) {
    return BigDecimal_init(this.raw_8be2vx$.minus(subtrahend.raw_8be2vx$));
  };
  BigDecimal.prototype.multiply_f4xmbf$ = function (multiplicand) {
    return BigDecimal_init(this.raw_8be2vx$.times(multiplicand.raw_8be2vx$));
  };
  BigDecimal.prototype.divide_f4xmbf$ = function (divisor) {
    return BigDecimal_init(this.raw_8be2vx$.div(divisor.raw_8be2vx$));
  };
  BigDecimal.prototype.negate = function () {
    return BigDecimal_init_0().subtract_f4xmbf$(this);
  };
  BigDecimal.prototype.signum = function () {
    return this.raw_8be2vx$.cmp($module$big_js(0));
  };
  BigDecimal.prototype.toInt = function () {
    return numberToInt(Number(this.raw_8be2vx$));
  };
  BigDecimal.prototype.toLong = function () {
    return toLong(this.toString());
  };
  BigDecimal.prototype.toShort = function () {
    return numberToShort(Number(this.raw_8be2vx$));
  };
  BigDecimal.prototype.toByte = function () {
    return numberToByte(Number(this.raw_8be2vx$));
  };
  BigDecimal.prototype.toChar = function () {
    return toBoxedChar(numberToChar(Number(this.raw_8be2vx$)));
  };
  BigDecimal.prototype.toDouble = function () {
    return numberToDouble(Number(this.raw_8be2vx$));
  };
  BigDecimal.prototype.toFloat = function () {
    return numberToDouble(Number(this.raw_8be2vx$));
  };
  BigDecimal.prototype.equals = function (other) {
    if (Kotlin.isType(other, BigDecimal)) {
      return this.raw_8be2vx$.eq(other.raw_8be2vx$);
    }return false;
  };
  BigDecimal.prototype.hashCode = function () {
    return hashCode(this.raw_8be2vx$.toString());
  };
  BigDecimal.prototype.toString = function () {
    return this.raw_8be2vx$.toString();
  };
  BigDecimal.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BigDecimal',
    interfaces: []
  };
  function BigDecimal_init(raw, $this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal.call($this);
    $this.raw_8be2vx$ = raw;
    return $this;
  }
  function BigDecimal_init_0($this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal_init($module$big_js(0), $this);
    return $this;
  }
  function BigDecimal_init_1(strVal, $this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal_init($module$big_js(strVal), $this);
    return $this;
  }
  function BigDecimal_init_2(doubleVal, $this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal.call($this);
    if (!(!isNaN_0(doubleVal) && !isInfinite(doubleVal))) {
      var message = 'Check failed.';
      throw IllegalStateException_init(message.toString());
    }$this.raw_8be2vx$ = $module$big_js(doubleVal);
    return $this;
  }
  function BigDecimal_init_3(intVal, $this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal_init($module$big_js(intVal), $this);
    return $this;
  }
  function BigDecimal_init_4(longVal, $this) {
    $this = $this || Object.create(BigDecimal.prototype);
    BigDecimal_init($module$big_js(longVal.toString()), $this);
    return $this;
  }
  function toNumber($receiver) {
    var tmp$;
    var rounded = $receiver.raw_8be2vx$.round(0, 0);
    if ($receiver.raw_8be2vx$.minus(rounded).eq($module$big_js(0))) {
      tmp$ = $receiver.toLong();
    } else {
      tmp$ = $receiver.toDouble();
    }
    return tmp$;
  }
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$adapter = package$apollo3.adapter || (package$apollo3.adapter = {});
  Object.defineProperty(package$adapter, 'BigDecimalAdapter', {
    get: BigDecimalAdapter_getInstance
  });
  Object.defineProperty(package$adapter, 'KotlinxInstantAdapter', {
    get: KotlinxInstantAdapter_getInstance
  });
  Object.defineProperty(package$adapter, 'KotlinxLocalDateTimeAdapter', {
    get: KotlinxLocalDateTimeAdapter_getInstance
  });
  Object.defineProperty(package$adapter, 'KotlinxLocalDateAdapter', {
    get: KotlinxLocalDateAdapter_getInstance
  });
  package$adapter.BigDecimal_init_jp5rk7$ = BigDecimal_init;
  package$adapter.BigDecimal_init = BigDecimal_init_0;
  package$adapter.BigDecimal_init_61zpoe$ = BigDecimal_init_1;
  package$adapter.BigDecimal_init_14dthe$ = BigDecimal_init_2;
  package$adapter.BigDecimal_init_za3lpa$ = BigDecimal_init_3;
  package$adapter.BigDecimal_init_s8cxhz$ = BigDecimal_init_4;
  package$adapter.BigDecimal = BigDecimal;
  package$adapter.toNumber_ryu5yk$ = toNumber;
  Kotlin.defineModule('apollo-kotlin-apollo-adapters-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-kotlin-apollo-adapters-js-legacy.js.map
