/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.ResponseFieldSpec;
import com.apollographql.apollo.compiler.ResponseFieldSpec$WhenMappings;
import com.apollographql.apollo.compiler.UtilKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.Field;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 ?2\u00020\u0001:\u0001?B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0006\u0010\"\u001a\u00020 J&\u0010#\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010(\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010+\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010,\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010-\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010.\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010/\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0016\u00100\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 J\u0018\u00101\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u00102\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u00105\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u00106\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u00107\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u00109\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J \u0010:\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J \u0010;\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u0010<\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u0018\u0010=\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002J\u001e\u0010>\u001a\u00020 2\u0006\u00104\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u00108\u001a\u00020 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006@"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec;", "", "irField", "Lcom/apollographql/apollo/compiler/ir/Field;", "fieldSpec", "Lcom/squareup/javapoet/FieldSpec;", "normalizedFieldSpec", "responseFieldType", "Lcom/apollographql/apollo/api/ResponseField$Type;", "typeConditions", "", "", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/ir/Field;Lcom/squareup/javapoet/FieldSpec;Lcom/squareup/javapoet/FieldSpec;Lcom/apollographql/apollo/api/ResponseField$Type;Ljava/util/List;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getFieldSpec", "()Lcom/squareup/javapoet/FieldSpec;", "getIrField", "()Lcom/apollographql/apollo/compiler/ir/Field;", "getNormalizedFieldSpec", "getResponseFieldType", "()Lcom/apollographql/apollo/api/ResponseField$Type;", "getTypeConditions", "()Ljava/util/List;", "conditionalResponseFieldReaderTypeName", "Lcom/squareup/javapoet/ParameterizedTypeName;", "kotlin.jvm.PlatformType", "type", "Lcom/squareup/javapoet/TypeName;", "customTypeFactoryCode", "Lcom/squareup/javapoet/CodeBlock;", "factoryMethod", "factoryCode", "fragmentFactoryCode", "genericFactoryCode", "readCustomCode", "readerParam", "fieldParam", "readCustomListCode", "readEnumCode", "readFragmentsCode", "readInlineFragmentCode", "readObjectCode", "readObjectListCode", "readScalarCode", "readScalarListCode", "readValueCode", "responseFieldListItemReaderType", "responseFieldObjectReaderTypeName", "writeCustomCode", "writerParam", "writeCustomList", "writeEnumCode", "writeFragmentsCode", "marshaller", "writeInlineFragmentCode", "writeObjectCode", "writeObjectList", "writeScalarCode", "writeScalarList", "writeValueCode", "Companion", "apollo-compiler_main"})
public final class ResponseFieldSpec {
    @NotNull
    private final Field irField;
    @NotNull
    private final FieldSpec fieldSpec;
    @NotNull
    private final FieldSpec normalizedFieldSpec;
    @NotNull
    private final ResponseField.Type responseFieldType;
    @NotNull
    private final List<String> typeConditions;
    @NotNull
    private final CodeGenerationContext context;
    private static final Map<ResponseField.Type, String> FACTORY_METHODS;
    private static final Map<ResponseField.Type, String> READ_METHODS;
    private static final Map<ResponseField.Type, String> WRITE_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_READ_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec RESPONSE_READER_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_READER_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_WRITER_PARAM;
    private static final ClassName FRAGMENTS_CLASS;
    private static final String CONDITIONAL_TYPE_VAR = "conditionalType";
    public static final Companion Companion;

    @NotNull
    public final CodeBlock factoryCode() {
        CodeBlock codeBlock;
        Object v = ResponseFieldSpec.Companion.getFACTORY_METHODS().get(this.responseFieldType);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String factoryMethod = (String)v;
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$0[this.responseFieldType.ordinal()]) {
            case 1: {
                codeBlock = this.customTypeFactoryCode(this.irField, factoryMethod);
                break;
            }
            case 2: 
            case 3: {
                codeBlock = this.fragmentFactoryCode(this.irField, factoryMethod, this.typeConditions);
                break;
            }
            default: {
                codeBlock = this.genericFactoryCode(this.irField, factoryMethod);
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock readValueCode(@NotNull CodeBlock readerParam, @NotNull CodeBlock fieldParam) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)readerParam, (String)"readerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$1[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.readScalarCode(readerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.readCustomCode(readerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.readEnumCode(readerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 9: {
                codeBlock = this.readScalarListCode(readerParam, fieldParam);
                break;
            }
            case 10: {
                codeBlock = this.readCustomListCode(readerParam, fieldParam);
                break;
            }
            case 11: {
                codeBlock = this.readObjectListCode(readerParam, fieldParam);
                break;
            }
            case 12: {
                codeBlock = this.readInlineFragmentCode(readerParam, fieldParam);
                break;
            }
            case 13: {
                codeBlock = this.readFragmentsCode(readerParam, fieldParam);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock fieldParam, @NotNull CodeBlock marshaller) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)writerParam, (String)"writerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$2[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.writeScalarCode(writerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.writeEnumCode(writerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.writeCustomCode(writerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.writeObjectCode(writerParam, fieldParam, marshaller);
                break;
            }
            case 9: {
                codeBlock = this.writeScalarList(writerParam, fieldParam);
                break;
            }
            case 10: {
                codeBlock = this.writeCustomList(writerParam, fieldParam);
                break;
            }
            case 11: {
                codeBlock = this.writeObjectList(writerParam, fieldParam, marshaller);
                break;
            }
            case 12: {
                codeBlock = this.writeInlineFragmentCode(writerParam, marshaller);
                break;
            }
            case 13: {
                codeBlock = this.writeFragmentsCode(writerParam, marshaller);
                break;
            }
            default: {
                CodeBlock codeBlock2 = CodeBlock.of((String)"", (Object[])new Object[0]);
                codeBlock = codeBlock2;
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"CodeBlock.of(\"\")");
            }
        }
        return codeBlock;
    }

    private final CodeBlock customTypeFactoryCode(Field irField, String factoryMethod) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = UtilKt.normalizeGraphQlType(irField.getType());
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string3;
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $T.$L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), customScalarEnum, customScalarEnumConst});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026   customScalarEnumConst)");
        return codeBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock fragmentFactoryCode(Field irField, String factoryMethod, List<String> typeConditions) {
        void $receiver$iv;
        void initial$iv;
        Iterable iterable = typeConditions;
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.asList(", new Object[]{Arrays.class});
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void typeCondition;
            void builder2;
            int n = index$iv++;
            String string = (String)element$iv;
            void var12_11 = accumulator$iv;
            int i = n;
            accumulator$iv = builder2.add(i > 0 ? ",\n" : "", new Object[0]).add("$S", new Object[]{typeCondition});
        }
        CodeBlock typeConditionListCode = accumulator$iv.add(")", new Object[0]).build();
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), typeConditionListCode});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026e, typeConditionListCode)");
        return codeBlock;
    }

    private final CodeBlock genericFactoryCode(Field irField, String factoryMethod) {
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional()});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026(), irField.isOptional())");
        return codeBlock;
    }

    private final CodeBlock readEnumCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock readValueCode = CodeBlock.builder().addStatement("final $T $L", new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name}).beginControlFlow("if ($LStr != null)", new Object[]{this.fieldSpec.name}).addStatement("$L = $T.valueOf($LStr)", new Object[]{this.fieldSpec.name, this.normalizedFieldSpec.type, this.fieldSpec.name}).nextControlFlow("else", new Object[0]).addStatement("$L = null", new Object[]{this.fieldSpec.name}).endControlFlow().build();
        CodeBlock codeBlock = CodeBlock.builder().addStatement("final $T $LStr = $L.$L($L)", new Object[]{ClassNames.INSTANCE.getSTRING(), this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(ResponseField.Type.STRING), fieldParam}).add(readValueCode).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock\n        .build\u2026lueCode)\n        .build()");
        return codeBlock;
    }

    private final CodeBlock readScalarCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026seFieldType], fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readCustomCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026::class.java, fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readObjectCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        Object[] objectArray = new Object[2];
        TypeName typeName2 = this.normalizedFieldSpec.type;
        if (typeName2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName2);
        objectArray[1] = ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name;
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.responseFieldObjectReaderTypeName(typeName)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L)", objectArray).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readScalarListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        String string = (String)ResponseFieldSpec.Companion.getSCALAR_LIST_ITEM_READ_METHODS().get(rawFieldType);
        if (string == null) {
            string = "readString";
        }
        String readMethod = string;
        CodeBlock readStatement = UtilKt.isEnum(rawFieldType, this.context) ? CodeBlock.of((String)"return $T.valueOf($L.$L());\n", (Object[])new Object[]{rawFieldType, ((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_READER_PARAM().name, readMethod}) : CodeBlock.of((String)"return $L.$L();\n", (Object[])new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_READER_PARAM().name, readMethod});
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName2 = rawFieldType;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"rawFieldType");
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.responseFieldListItemReaderType(typeName2)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_READER_PARAM()).addCode(readStatement).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readCustomListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName it = typeName;
        TypeName rawFieldType = UtilKt.isList(it) ? UtilKt.listParamType(it) : it;
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String $i$a$1$let = UtilKt.normalizeGraphQlType(this.irField.getType());
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string = $i$a$1$let;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string2;
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName2 = rawFieldType;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"rawFieldType");
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.responseFieldListItemReaderType(typeName2)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_READER_PARAM()).addStatement("return $L.readCustomType($T.$L)", new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_READER_PARAM().name, customScalarEnum, customScalarEnumConst}).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readObjectListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName it = typeName;
        TypeName rawFieldType = UtilKt.isList(it) ? UtilKt.listParamType(it) : it;
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName2 = rawFieldType;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"rawFieldType");
        Object[] objectArray = new Object[2];
        TypeName typeName3 = rawFieldType;
        if (typeName3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName3);
        objectArray[1] = ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name;
        TypeSpec objectReaderTypeSpec = builder.superclass((TypeName)this.responseFieldObjectReaderTypeName(typeName2)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L)", objectArray).build()).build();
        TypeSpec listReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this.responseFieldListItemReaderType(rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_READER_PARAM()).addStatement("return $L.readObject($L)", new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_READER_PARAM().name, objectReaderTypeSpec}).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, listReaderTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026aram, listReaderTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readInlineFragmentCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        Object[] objectArray = new Object[2];
        TypeName typeName2 = this.normalizedFieldSpec.type;
        if (typeName2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName2);
        objectArray[1] = ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name;
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.conditionalResponseFieldReaderTypeName(typeName)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(ParameterSpec.builder((Type)((Type)((Object)String.class)), (String)ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR(), (Modifier[])new Modifier[0]).build()).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L)", objectArray).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), ResponseField.ConditionalTypeField.class, fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026,\n        readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readFragmentsCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        ClassName className = ResponseFieldSpec.Companion.getFRAGMENTS_CLASS();
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"FRAGMENTS_CLASS");
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.conditionalResponseFieldReaderTypeName((TypeName)className)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ResponseFieldSpec.Companion.getFRAGMENTS_CLASS()).addParameter(ParameterSpec.builder((Type)((Type)((Object)String.class)), (String)ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR(), (Modifier[])new Modifier[0]).build()).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L, $L)", new Object[]{UtilKt.mapperFieldName(ResponseFieldSpec.Companion.getFRAGMENTS_CLASS()), ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name, ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR()}).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), ResponseField.ConditionalTypeField.class, fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026,\n        readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L(($T) $L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L((\\\u2026a, fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, (Function1)new Function1<CodeBlock, CodeBlock>(marshaller){
            final /* synthetic */ CodeBlock $marshaller;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])new Object[]{it, this.$marshaller});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
            {
                this.$marshaller = codeBlock;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeScalarList(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        String string = (String)ResponseFieldSpec.Companion.getSCALAR_LIST_ITEM_WRITE_METHODS().get(rawFieldType);
        if (string == null) {
            string = "writeString";
        }
        String writeMethod = string;
        CodeBlock.Builder builder = CodeBlock.builder();
        Object[] objectArray = new Object[3];
        objectArray[0] = rawFieldType;
        objectArray[1] = "$item";
        TypeName typeName2 = this.fieldSpec.type;
        String string2 = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fieldSpec.name");
        objectArray[2] = UtilKt.unwrapOptionalValue$default(typeName2, string2, false, null, 4, null);
        CodeBlock writeStatement = builder.beginControlFlow("for ($T $L : $L)", objectArray).add(UtilKt.isEnum(rawFieldType, this.context) ? CodeBlock.of((String)"$L.$L($L.name());\n", (Object[])new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_WRITER_PARAM().name, writeMethod, "$item"}) : CodeBlock.of((String)"$L.$L($L);\n", (Object[])new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_WRITER_PARAM().name, writeMethod, "$item"})).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_WRITER_PARAM()).addCode(writeStatement).build()).build();
        TypeName typeName3 = this.fieldSpec.type;
        String string3 = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName3, string3, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomList(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName it = typeName;
        TypeName rawFieldType = UtilKt.isList(it) ? UtilKt.listParamType(it) : it;
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String $i$a$1$let = UtilKt.normalizeGraphQlType(this.irField.getType());
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string = $i$a$1$let;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string2;
        CodeBlock.Builder builder = CodeBlock.builder();
        Object[] objectArray = new Object[3];
        objectArray[0] = rawFieldType;
        objectArray[1] = "$item";
        TypeName typeName2 = this.fieldSpec.type;
        String string3 = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fieldSpec.name");
        objectArray[2] = UtilKt.unwrapOptionalValue$default(typeName2, string3, false, null, 4, null);
        CodeBlock writeStatement = builder.beginControlFlow("for ($T $L : $L)", objectArray).addStatement("$L.writeCustom($T.$L, $L)", new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_WRITER_PARAM().name, customScalarEnum, customScalarEnumConst, "$item"}).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_WRITER_PARAM()).addCode(writeStatement).build()).build();
        TypeName typeName3 = this.fieldSpec.type;
        String string4 = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName3, string4, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectList(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName typeName = this.normalizedFieldSpec.type;
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        CodeBlock.Builder builder = CodeBlock.builder();
        Object[] objectArray = new Object[3];
        objectArray[0] = rawFieldType;
        objectArray[1] = "$item";
        TypeName typeName2 = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        objectArray[2] = UtilKt.unwrapOptionalValue$default(typeName2, string, false, null, 4, null);
        CodeBlock writeStatement = builder.beginControlFlow("for ($T $L : $L)", objectArray).addStatement("$L.writeObject($L.$L)", new Object[]{((Companion)ResponseFieldSpec.Companion).getRESPONSE_LIST_ITEM_WRITER_PARAM().name, "$item", marshaller}).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_WRITER_PARAM()).addCode(writeStatement).build()).build();
        TypeName typeName3 = this.fieldSpec.type;
        String string2 = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName3, string2, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeInlineFragmentCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock.Builder builder = CodeBlock.builder();
        Object[] objectArray = new Object[3];
        objectArray[0] = UtilKt.unwrapOptionalType(this.fieldSpec.type).withoutAnnotations();
        objectArray[1] = "$" + this.fieldSpec.name;
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        objectArray[2] = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = builder.addStatement("final $T $L = $L", objectArray).beginControlFlow("if ($L != null)", new Object[]{"$" + this.fieldSpec.name}).addStatement("$L.$L.marshal($L)", new Object[]{"$" + this.fieldSpec.name, marshaller, writerParam}).endControlFlow().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026olFlow()\n        .build()");
        return codeBlock;
    }

    private final CodeBlock writeFragmentsCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])new Object[]{this.fieldSpec.name, marshaller, writerParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L.ma\u2026 marshaller, writerParam)");
        return codeBlock;
    }

    private final ParameterizedTypeName responseFieldObjectReaderTypeName(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ObjectReader.class), (TypeName[])new TypeName[]{type});
    }

    private final ParameterizedTypeName conditionalResponseFieldReaderTypeName(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ConditionalTypeReader.class), (TypeName[])new TypeName[]{type});
    }

    private final ParameterizedTypeName responseFieldListItemReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ListReader.class), (TypeName[])new TypeName[]{type});
    }

    @NotNull
    public final Field getIrField() {
        return this.irField;
    }

    @NotNull
    public final FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    @NotNull
    public final FieldSpec getNormalizedFieldSpec() {
        return this.normalizedFieldSpec;
    }

    @NotNull
    public final ResponseField.Type getResponseFieldType() {
        return this.responseFieldType;
    }

    @NotNull
    public final List<String> getTypeConditions() {
        return this.typeConditions;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    public ResponseFieldSpec(@NotNull Field irField, @NotNull FieldSpec fieldSpec, @NotNull FieldSpec normalizedFieldSpec, @NotNull ResponseField.Type responseFieldType, @NotNull List<String> typeConditions, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)irField, (String)"irField");
        Intrinsics.checkParameterIsNotNull((Object)fieldSpec, (String)"fieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)normalizedFieldSpec, (String)"normalizedFieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)responseFieldType, (String)"responseFieldType");
        Intrinsics.checkParameterIsNotNull(typeConditions, (String)"typeConditions");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.irField = irField;
        this.fieldSpec = fieldSpec;
        this.normalizedFieldSpec = normalizedFieldSpec;
        this.responseFieldType = responseFieldType;
        this.typeConditions = typeConditions;
        this.context = context;
    }

    public /* synthetic */ ResponseFieldSpec(Field field, FieldSpec fieldSpec, FieldSpec fieldSpec2, ResponseField.Type type, List list, CodeGenerationContext codeGenerationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(field, fieldSpec, fieldSpec2, type, list, codeGenerationContext);
    }

    static {
        Companion = new Companion(null);
        FACTORY_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"forInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"forLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"forDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"forBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"forObject"), TuplesKt.to((Object)ResponseField.Type.SCALAR_LIST, (Object)"forScalarList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM_LIST, (Object)"forCustomList"), TuplesKt.to((Object)ResponseField.Type.OBJECT_LIST, (Object)"forObjectList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"forCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"forFragment"), TuplesKt.to((Object)ResponseField.Type.INLINE_FRAGMENT, (Object)"forInlineFragment")});
        READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"readInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"readLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"readObject"), TuplesKt.to((Object)ResponseField.Type.SCALAR_LIST, (Object)"readList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM_LIST, (Object)"readList"), TuplesKt.to((Object)ResponseField.Type.OBJECT_LIST, (Object)"readList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"readCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"readConditional"), TuplesKt.to((Object)ResponseField.Type.INLINE_FRAGMENT, (Object)"readConditional")});
        WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"writeInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"writeLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"writeCustom"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"writeObject"), TuplesKt.to((Object)ResponseField.Type.SCALAR_LIST, (Object)"writeList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM_LIST, (Object)"writeList"), TuplesKt.to((Object)ResponseField.Type.OBJECT_LIST, (Object)"writeList")});
        SCALAR_LIST_ITEM_READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"readString"), TuplesKt.to((Object)TypeName.INT, (Object)"readInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"readInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"readLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"readLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"readDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"readBoolean")});
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"writeString"), TuplesKt.to((Object)TypeName.INT, (Object)"writeInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"writeInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"writeLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"writeLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"writeDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"writeBoolean")});
        RESPONSE_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.class)), (String)"reader", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.ListItemReader.class)), (String)"reader", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
        FRAGMENTS_CLASS = ClassName.get((String)"", (String)"Fragments", (String[])new String[0]);
        CONDITIONAL_TYPE_VAR = CONDITIONAL_TYPE_VAR;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001c\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R(\u0010\u001b\u001a\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001c0\u001c\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR(\u0010\u001e\u001a\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001c0\u001c\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec$Companion;", "", "()V", "CONDITIONAL_TYPE_VAR", "", "getCONDITIONAL_TYPE_VAR", "()Ljava/lang/String;", "FACTORY_METHODS", "", "Lcom/apollographql/apollo/api/ResponseField$Type;", "getFACTORY_METHODS", "()Ljava/util/Map;", "FRAGMENTS_CLASS", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "getFRAGMENTS_CLASS", "()Lcom/squareup/javapoet/ClassName;", "READ_METHODS", "getREAD_METHODS", "RESPONSE_LIST_ITEM_READER_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "getRESPONSE_LIST_ITEM_READER_PARAM", "()Lcom/squareup/javapoet/ParameterSpec;", "RESPONSE_LIST_ITEM_WRITER_PARAM", "getRESPONSE_LIST_ITEM_WRITER_PARAM", "RESPONSE_READER_PARAM", "getRESPONSE_READER_PARAM", "SCALAR_LIST_ITEM_READ_METHODS", "Lcom/squareup/javapoet/TypeName;", "getSCALAR_LIST_ITEM_READ_METHODS", "SCALAR_LIST_ITEM_WRITE_METHODS", "getSCALAR_LIST_ITEM_WRITE_METHODS", "WRITE_METHODS", "getWRITE_METHODS", "apollo-compiler_main"})
    public static final class Companion {
        private final Map<ResponseField.Type, String> getFACTORY_METHODS() {
            return FACTORY_METHODS;
        }

        private final Map<ResponseField.Type, String> getREAD_METHODS() {
            return READ_METHODS;
        }

        private final Map<ResponseField.Type, String> getWRITE_METHODS() {
            return WRITE_METHODS;
        }

        private final Map<TypeName, String> getSCALAR_LIST_ITEM_READ_METHODS() {
            return SCALAR_LIST_ITEM_READ_METHODS;
        }

        private final Map<TypeName, String> getSCALAR_LIST_ITEM_WRITE_METHODS() {
            return SCALAR_LIST_ITEM_WRITE_METHODS;
        }

        private final ParameterSpec getRESPONSE_READER_PARAM() {
            return RESPONSE_READER_PARAM;
        }

        private final ParameterSpec getRESPONSE_LIST_ITEM_READER_PARAM() {
            return RESPONSE_LIST_ITEM_READER_PARAM;
        }

        private final ParameterSpec getRESPONSE_LIST_ITEM_WRITER_PARAM() {
            return RESPONSE_LIST_ITEM_WRITER_PARAM;
        }

        private final ClassName getFRAGMENTS_CLASS() {
            return FRAGMENTS_CLASS;
        }

        private final String getCONDITIONAL_TYPE_VAR() {
            return CONDITIONAL_TYPE_VAR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

