/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.tooling;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLNode;
import com.apollographql.apollo.ast.GqldocumentKt;
import com.apollographql.apollo.ast.GqlnodeKt;
import com.apollographql.apollo.ast.introspection.ApolloIntrospectionSchema;
import com.apollographql.apollo.ast.introspection.Introspection;
import com.apollographql.apollo.ast.introspection.IntrospectionSchema;
import com.apollographql.apollo.network.OkHttpExtensionsKt;
import com.apollographql.apollo.tooling.ExceptionsKt;
import com.apollographql.apollo.tooling.GraphQLFeature;
import com.apollographql.apollo.tooling.GraphQLFeatureKt;
import com.apollographql.apollo.tooling.GraphosKt;
import com.apollographql.apollo.tooling.SchemaHelper;
import com.apollographql.apollo.tooling.graphql.PreIntrospectionQuery;
import com.apollographql.apollo.tooling.platformapi.public.DownloadSchemaQuery;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.OkHttpClient;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J^\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0011J\u0016\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J,\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J4\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000fJD\u0010\u0018\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0006\b\u0000\u0010\u001c\u0018\u0001*\u0004\u0018\u00010\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo/tooling/SchemaDownloader;", "", "<init>", "()V", "download", "", "endpoint", "", "graph", "key", "graphVariant", "registryUrl", "schema", "Ljava/io/File;", "insecure", "", "headers", "", "getIntrospectionQuery", "features", "", "Lcom/apollographql/apollo/tooling/GraphQLFeature;", "downloadIntrospection", "failSafe", "downloadRegistry", "variant", "shutdown", "cast", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "apollo-tooling"})
@ApolloExperimental
public final class SchemaDownloader {
    @NotNull
    public static final SchemaDownloader INSTANCE = new SchemaDownloader();

    private SchemaDownloader() {
    }

    public final void download(@Nullable String endpoint, @Nullable String graph, @Nullable String key, @NotNull String graphVariant, @NotNull String registryUrl, @NotNull File schema, boolean insecure, @NotNull Map<String, String> headers) {
        String string;
        Intrinsics.checkNotNullParameter((Object)graphVariant, (String)"graphVariant");
        Intrinsics.checkNotNullParameter((Object)registryUrl, (String)"registryUrl");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String introspectionDataJson = null;
        IntrospectionSchema introspectionSchema = null;
        String sdlSchema = null;
        if (endpoint != null) {
            try {
                IntrospectionSchema introspectionSchema2;
                introspectionDataJson = this.downloadIntrospection(endpoint, headers, insecure, false);
                try {
                    introspectionSchema2 = Introspection.toIntrospectionSchema((String)introspectionDataJson);
                }
                catch (Exception e2) {
                    throw new Exception("Introspection response from " + endpoint + " can not be parsed", e2);
                }
                introspectionSchema = introspectionSchema2;
            }
            catch (Exception e) {
                IntrospectionSchema e2;
                introspectionDataJson = this.downloadIntrospection(endpoint, headers, insecure, true);
                try {
                    e2 = Introspection.toIntrospectionSchema((String)introspectionDataJson);
                }
                catch (Exception e3) {
                    throw new Exception("Introspection response from " + endpoint + " can not be parsed", e3);
                }
                introspectionSchema = e2;
            }
        } else {
            String graph2;
            if (!(key != null)) {
                boolean bl = false;
                String string2 = "Apollo: either endpoint (for introspection) or key (for registry) is required";
                throw new IllegalStateException(string2.toString());
            }
            String string3 = graph;
            if (string3 == null) {
                string3 = GraphosKt.getGraph(key);
            }
            if (!((graph2 = string3) != null)) {
                boolean bl = false;
                String string4 = "Apollo: graph is required to download from the registry";
                throw new IllegalStateException(string4.toString());
            }
            sdlSchema = this.downloadRegistry(key, graph2, graphVariant, registryUrl, headers, insecure);
        }
        File file = schema.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        String string5 = FilesKt.getExtension((File)schema).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string5, (Object)"json")) {
            if (introspectionSchema == null) {
                if (!(sdlSchema != null)) {
                    string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Introspection.writeTo((ApolloIntrospectionSchema)Introspection.toIntrospectionSchema((GQLDocument)GqldocumentKt.toFullSchemaGQLDocument((GQLDocument)ApolloParser.toGQLDocument$default((String)sdlSchema, null, (int)1, null))), (File)schema);
            } else {
                if (!(introspectionDataJson != null)) {
                    string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                FilesKt.writeText$default((File)schema, (String)introspectionDataJson, null, (int)2, null);
            }
        } else if (sdlSchema == null) {
            if (!(introspectionSchema != null)) {
                string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            FilesKt.writeText$default((File)schema, (String)GqldocumentKt.toSDL((GQLDocument)Introspection.toGQLDocument((IntrospectionSchema)introspectionSchema), (String)"  "), null, (int)2, null);
        } else {
            FilesKt.writeText$default((File)schema, (String)sdlSchema, null, (int)2, null);
        }
    }

    public static /* synthetic */ void download$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, String string5, File file, boolean bl, Map map, int n, Object object) {
        if ((n & 0x10) != 0) {
            string5 = "https://api.apollographql.com/graphql";
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        schemaDownloader.download(string, string2, string3, string4, string5, file, bl, map);
    }

    @ApolloExperimental
    @NotNull
    public final String getIntrospectionQuery(@NotNull Set<? extends GraphQLFeature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        ClassLoader classLoader = SchemaHelper.class.getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        InputStream inputStream = classLoader.getResourceAsStream("base-introspection.graphql");
        Intrinsics.checkNotNull((Object)inputStream);
        BufferedSource baseIntrospectionSource = Okio.buffer((Source)Okio.source((InputStream)inputStream));
        Object object = ApolloParser.parseAsGQLDocument$default((BufferedSource)baseIntrospectionSource, null, null, (int)3, null).getValue();
        Intrinsics.checkNotNull((Object)object);
        GQLDocument baseIntrospectionGql = (GQLDocument)object;
        GQLDocument introspectionGql = GQLDocument.copy$default((GQLDocument)baseIntrospectionGql, SchemaHelper.INSTANCE.reworkInputValueFragment$apollo_tooling(SchemaHelper.INSTANCE.reworkFullTypeFragment$apollo_tooling(SchemaHelper.INSTANCE.reworkIntrospectionQuery$apollo_tooling(baseIntrospectionGql.getDefinitions(), features), features), features), null, (int)2, null);
        return GqlnodeKt.toUtf8$default((GQLNode)((GQLNode)introspectionGql), null, (int)1, null);
    }

    @Deprecated(message="Kept for binary compatibility", level=DeprecationLevel.HIDDEN)
    public final /* synthetic */ String downloadIntrospection(String endpoint, Map headers, boolean insecure) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return this.downloadIntrospection(endpoint, headers, insecure, false);
    }

    @NotNull
    public final String downloadIntrospection(@NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure, boolean failSafe) {
        Set<GraphQLFeature> set;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (failSafe) {
            set = SetsKt.emptySet();
        } else {
            PreIntrospectionQuery.Data preIntrospectionData = SchemaHelper.INSTANCE.executePreIntrospectionQuery$apollo_tooling(endpoint, headers, insecure);
            set = GraphQLFeatureKt.getFeatures(preIntrospectionData);
        }
        Set<GraphQLFeature> features = set;
        String introspectionQuery = this.getIntrospectionQuery((Set<? extends GraphQLFeature>)features);
        return SchemaHelper.INSTANCE.executeIntrospectionQuery$apollo_tooling(introspectionQuery, endpoint, headers, insecure);
    }

    public static /* synthetic */ String downloadIntrospection$default(SchemaDownloader schemaDownloader, String string, Map map, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return schemaDownloader.downloadIntrospection(string, map, bl, bl2);
    }

    @NotNull
    public final String downloadRegistry(@NotNull String key, @NotNull String graph, @NotNull String variant, @NotNull String endpoint, @NotNull Map<String, String> headers, boolean insecure) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        ApolloClient apolloClient = OkHttpExtensionsKt.okHttpClient((ApolloClient.Builder)new ApolloClient.Builder().serverUrl(endpoint), (OkHttpClient)SchemaHelper.INSTANCE.newOkHttpClient$apollo_tooling(insecure)).httpExposeErrorBody(Boolean.valueOf(true)).build();
        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<DownloadSchemaQuery.Data>>, Object>(apolloClient, graph, variant, headers, key, null){
            int label;
            final /* synthetic */ ApolloClient $apolloClient;
            final /* synthetic */ String $graph;
            final /* synthetic */ String $variant;
            final /* synthetic */ Map<String, String> $headers;
            final /* synthetic */ String $key;
            {
                this.$apolloClient = $apolloClient;
                this.$graph = $graph;
                this.$variant = $variant;
                this.$headers = $headers;
                this.$key = $key;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Map<String, String> map = this.$headers;
                        ApolloCall apolloCall = this.$apolloClient.query((Query)new DownloadSchemaQuery(this.$graph, this.$variant));
                        boolean $i$f$map = false;
                        void var4_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            Map.Entry<K, V> item$iv$iv;
                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
                        }
                        this.label = 1;
                        Object object3 = apolloCall.httpHeaders(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new HttpHeader("x-api-key", this.$key))).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ApolloResponse<DownloadSchemaQuery.Data>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        DownloadSchemaQuery.Data data = (DownloadSchemaQuery.Data)response2.data;
        if (data == null) {
            throw ExceptionsKt.toException(response2, "Cannot download schema");
        }
        if (data.getGraph() == null) {
            List list = response2.errors;
            throw new Exception("Cannot retrieve graph '" + graph + "': " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, SchemaDownloader::downloadRegistry$lambda$2, (int)31, null) : null));
        }
        if (data.getGraph().getVariant() == null) {
            List list = response2.errors;
            throw new Exception("Cannot retrieve variant '" + variant + "': " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, SchemaDownloader::downloadRegistry$lambda$3, (int)31, null) : null));
        }
        return data.getGraph().getVariant().getLatestPublication().getSchema().getDocument();
    }

    public static /* synthetic */ String downloadRegistry$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, String string4, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "https://api.apollographql.com/graphql";
        }
        return schemaDownloader.downloadRegistry(string, string2, string3, string4, map, bl);
    }

    public final void shutdown() {
        SchemaHelper.INSTANCE.getClient$apollo_tooling().dispatcher().executorService().shutdown();
        SchemaHelper.INSTANCE.getClient$apollo_tooling().connectionPool().evictAll();
    }

    public final /* synthetic */ <T> T cast(Object $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$cast;
    }

    private static final CharSequence downloadRegistry$lambda$2(Error it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence downloadRegistry$lambda$3(Error it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }
}

