/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.android.rx2;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloWatcher;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.util.Cancelable;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import javax.annotation.Nonnull;

public class Rx2Apollo {
    private Rx2Apollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    public static <T> Observable<T> from(final @Nonnull ApolloWatcher<T> watcher) {
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(final ObservableEmitter<T> emitter) throws Exception {
                Rx2Apollo.cancelOnObservableDisposed(emitter, (Cancelable)watcher);
                watcher.enqueueAndWatch(new ApolloCall.Callback<T>(){

                    public void onResponse(@Nonnull Response<T> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response.data());
                        }
                    }

                    public void onFailure(@Nonnull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @Nonnull
    public static <T> Single<T> from(final @Nonnull ApolloCall<T> originalCall) {
        Utils.checkNotNull(originalCall, (Object)"call == null");
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(SingleEmitter<T> emitter) {
                block3: {
                    Rx2Apollo.cancelOnSingleDisposed(emitter, (Cancelable)originalCall);
                    try {
                        Response response = originalCall.execute();
                        if (!emitter.isDisposed()) {
                            emitter.onSuccess(response.data());
                        }
                    }
                    catch (ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (emitter.isDisposed()) break block3;
                        emitter.onError((Throwable)e);
                    }
                }
            }
        });
    }

    @Nonnull
    public static Completable from(final @Nonnull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(CompletableEmitter emitter) {
                block3: {
                    Rx2Apollo.cancelOnCompletableDisposed(emitter, (Cancelable)prefetch);
                    try {
                        prefetch.execute();
                        if (!emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }
                    catch (ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (emitter.isDisposed()) break block3;
                        emitter.onError((Throwable)e);
                    }
                }
            }
        });
    }

    private static void cancelOnCompletableDisposed(CompletableEmitter emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnSingleDisposed(SingleEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnObservableDisposed(ObservableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static Disposable getRx2Disposable(final Cancelable cancelable) {
        return new Disposable(){

            public void dispose() {
                cancelable.cancel();
            }

            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

