/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.response;

import com.apollographql.apollo.api.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.internal.response.ResolveDelegate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealResponseWriter
implements ResponseWriter {
    private final Operation.Variables operationVariables;
    private final ScalarTypeAdapters scalarTypeAdapters;
    final Map<String, FieldDescriptor> buffer = new LinkedHashMap<String, FieldDescriptor>();

    public RealResponseWriter(Operation.Variables operationVariables, ScalarTypeAdapters scalarTypeAdapters) {
        this.operationVariables = operationVariables;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    public void writeString(@NotNull ResponseField field, @Nullable String value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeInt(@NotNull ResponseField field, @Nullable Integer value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value.intValue()) : null);
    }

    public void writeLong(@NotNull ResponseField field, @Nullable Long value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeDouble(@NotNull ResponseField field, @Nullable Double value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeBoolean(@NotNull ResponseField field, @Nullable Boolean value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeCustom(@NotNull ResponseField.CustomTypeField field, @Nullable Object value) {
        CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
        this.writeScalarFieldValue((ResponseField)field, value != null ? typeAdapter.encode((Object)value).value : null);
    }

    public void writeObject(@NotNull ResponseField field, @Nullable ResponseFieldMarshaller marshaller) {
        RealResponseWriter.checkFieldValue(field, marshaller);
        if (marshaller == null) {
            this.buffer.put(field.responseName(), new FieldDescriptor(field, null));
            return;
        }
        RealResponseWriter nestedResponseWriter = new RealResponseWriter(this.operationVariables, this.scalarTypeAdapters);
        marshaller.marshal((ResponseWriter)nestedResponseWriter);
        this.buffer.put(field.responseName(), new FieldDescriptor(field, nestedResponseWriter.buffer));
    }

    public void writeFragment(@Nullable ResponseFieldMarshaller marshaller) {
        if (marshaller != null) {
            marshaller.marshal((ResponseWriter)this);
        }
    }

    public void writeList(@NotNull ResponseField field, @Nullable List values, @NotNull ResponseWriter.ListWriter listWriter) {
        RealResponseWriter.checkFieldValue(field, values);
        if (values == null) {
            this.buffer.put(field.responseName(), new FieldDescriptor(field, null));
            return;
        }
        ArrayList accumulated = new ArrayList();
        listWriter.write(values, (ResponseWriter.ListItemWriter)new ListItemWriter(this.operationVariables, this.scalarTypeAdapters, accumulated));
        this.buffer.put(field.responseName(), new FieldDescriptor(field, accumulated));
    }

    public void resolveFields(ResolveDelegate<Map<String, Object>> delegate) {
        this.resolveFields(this.operationVariables, delegate, this.buffer);
    }

    private void writeScalarFieldValue(ResponseField field, Object value) {
        RealResponseWriter.checkFieldValue(field, value);
        this.buffer.put(field.responseName(), new FieldDescriptor(field, value));
    }

    private Map<String, Object> rawFieldValues(Map<String, FieldDescriptor> buffer) {
        LinkedHashMap<String, Object> fieldValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, FieldDescriptor> entry : buffer.entrySet()) {
            String fieldResponseName = entry.getKey();
            Object fieldValue = entry.getValue().value;
            if (fieldValue == null) {
                fieldValues.put(fieldResponseName, null);
                continue;
            }
            if (fieldValue instanceof Map) {
                Map<String, Object> nestedMap = this.rawFieldValues((Map)fieldValue);
                fieldValues.put(fieldResponseName, nestedMap);
                continue;
            }
            if (fieldValue instanceof List) {
                fieldValues.put(fieldResponseName, this.rawListFieldValues((List)fieldValue));
                continue;
            }
            fieldValues.put(fieldResponseName, fieldValue);
        }
        return fieldValues;
    }

    private List rawListFieldValues(List values) {
        ArrayList<Object> listValues = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof Map) {
                listValues.add(this.rawFieldValues((Map)value));
                continue;
            }
            if (value instanceof List) {
                listValues.add(this.rawListFieldValues((List)value));
                continue;
            }
            listValues.add(value);
        }
        return listValues;
    }

    private void resolveFields(Operation.Variables operationVariables, ResolveDelegate<Map<String, Object>> delegate, Map<String, FieldDescriptor> buffer) {
        Map<String, Object> rawFieldValues = this.rawFieldValues(buffer);
        for (String fieldResponseName : buffer.keySet()) {
            FieldDescriptor fieldDescriptor = buffer.get(fieldResponseName);
            Object rawFieldValue = rawFieldValues.get(fieldResponseName);
            delegate.willResolve(fieldDescriptor.field, operationVariables, Optional.fromNullable((Object)fieldDescriptor.value));
            switch (fieldDescriptor.field.type()) {
                case OBJECT: {
                    this.resolveObjectFields(fieldDescriptor, (Map)rawFieldValue, delegate);
                    break;
                }
                case LIST: {
                    this.resolveListField(fieldDescriptor.field, (List)fieldDescriptor.value, (List)rawFieldValue, delegate);
                    break;
                }
                default: {
                    if (rawFieldValue == null) {
                        delegate.didResolveNull();
                        break;
                    }
                    delegate.didResolveScalar(rawFieldValue);
                }
            }
            delegate.didResolve(fieldDescriptor.field, operationVariables);
        }
    }

    private void resolveObjectFields(FieldDescriptor fieldDescriptor, Map<String, Object> rawFieldValues, ResolveDelegate<Map<String, Object>> delegate) {
        delegate.willResolveObject(fieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(rawFieldValues));
        if (fieldDescriptor.value == null) {
            delegate.didResolveNull();
        } else {
            this.resolveFields(this.operationVariables, delegate, (Map)fieldDescriptor.value);
        }
        delegate.didResolveObject(fieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(rawFieldValues));
    }

    private void resolveListField(ResponseField listResponseField, List fieldValues, List rawFieldValues, ResolveDelegate<Map<String, Object>> delegate) {
        if (fieldValues == null) {
            delegate.didResolveNull();
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            delegate.willResolveElement(i);
            Object fieldValue = fieldValues.get(i);
            if (fieldValue instanceof Map) {
                delegate.willResolveObject(listResponseField, (Optional<Map<String, Object>>)Optional.fromNullable((Object)((Map)rawFieldValues.get(i))));
                this.resolveFields(this.operationVariables, delegate, (Map)fieldValue);
                delegate.didResolveObject(listResponseField, (Optional<Map<String, Object>>)Optional.fromNullable((Object)((Map)rawFieldValues.get(i))));
            } else if (fieldValue instanceof List) {
                this.resolveListField(listResponseField, (List)fieldValue, (List)rawFieldValues.get(i), delegate);
            } else {
                delegate.didResolveScalar(rawFieldValues.get(i));
            }
            delegate.didResolveElement(i);
        }
        delegate.didResolveList(rawFieldValues);
    }

    private static void checkFieldValue(ResponseField field, Object value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException(String.format("Mandatory response field `%s` resolved with null value", field.responseName()));
        }
    }

    private static class FieldDescriptor {
        final ResponseField field;
        final Object value;

        FieldDescriptor(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }
    }

    private static final class ListItemWriter
    implements ResponseWriter.ListItemWriter {
        final Operation.Variables operationVariables;
        final ScalarTypeAdapters scalarTypeAdapters;
        final List accumulator;

        ListItemWriter(Operation.Variables operationVariables, ScalarTypeAdapters scalarTypeAdapters, List accumulator) {
            this.operationVariables = operationVariables;
            this.scalarTypeAdapters = scalarTypeAdapters;
            this.accumulator = accumulator;
        }

        public void writeString(@Nullable String value) {
            this.accumulator.add(value);
        }

        public void writeInt(@Nullable Integer value) {
            this.accumulator.add(value != null ? BigDecimal.valueOf(value.intValue()) : null);
        }

        public void writeLong(@Nullable Long value) {
            this.accumulator.add(value != null ? BigDecimal.valueOf(value) : null);
        }

        public void writeDouble(@Nullable Double value) {
            this.accumulator.add(value != null ? BigDecimal.valueOf(value) : null);
        }

        public void writeBoolean(@Nullable Boolean value) {
            this.accumulator.add(value);
        }

        public void writeCustom(@NotNull ScalarType scalarType, @Nullable Object value) {
            CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
            this.accumulator.add(value != null ? typeAdapter.encode((Object)value).value : null);
        }

        public void writeObject(ResponseFieldMarshaller marshaller) {
            RealResponseWriter nestedResponseWriter = new RealResponseWriter(this.operationVariables, this.scalarTypeAdapters);
            marshaller.marshal((ResponseWriter)nestedResponseWriter);
            this.accumulator.add(nestedResponseWriter.buffer);
        }

        public void writeList(@Nullable List items, @NotNull ResponseWriter.ListWriter listWriter) {
            if (items == null) {
                this.accumulator.add(null);
            } else {
                ArrayList nestedAccumulated = new ArrayList();
                listWriter.write(items, (ResponseWriter.ListItemWriter)new ListItemWriter(this.operationVariables, this.scalarTypeAdapters, nestedAccumulated));
                this.accumulator.add(nestedAccumulated);
            }
        }
    }
}

