/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.exception.ApolloException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public abstract class ApolloStoreOperation<T> {
    private final Executor dispatcher;
    private AtomicReference<Callback<T>> callback = new AtomicReference();
    private final AtomicBoolean executed = new AtomicBoolean();

    public static <T> ApolloStoreOperation<T> emptyOperation(final T result) {
        return new ApolloStoreOperation<T>(null){

            @Override
            protected T perform() {
                return result;
            }

            @Override
            public void enqueue(Callback<T> callback) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }
        };
    }

    protected ApolloStoreOperation(Executor dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected abstract T perform();

    public final T execute() throws ApolloException {
        this.checkIfExecuted();
        try {
            return this.perform();
        }
        catch (Exception e) {
            throw new ApolloException("Failed to perform store operation", e);
        }
    }

    public void enqueue(@Nullable Callback<T> callback) {
        this.checkIfExecuted();
        this.callback.set(callback);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = ApolloStoreOperation.this.perform();
                }
                catch (Exception e) {
                    ApolloStoreOperation.this.notifyFailure(new ApolloException("Failed to perform store operation", e));
                    return;
                }
                ApolloStoreOperation.this.notifySuccess(result);
            }
        });
    }

    void notifySuccess(T result) {
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        callback.onSuccess(result);
    }

    void notifyFailure(Throwable t) {
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        callback.onFailure(t);
    }

    private void checkIfExecuted() {
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Executed");
        }
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(Throwable var1);
    }
}

