/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.subscription;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.internal.json.JsonReader;
import com.apollographql.apollo.internal.json.ResponseJsonStreamReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import okio.Buffer;
import okio.BufferedSource;

public abstract class OperationServerMessage {
    static final String JSON_KEY_ID = "id";
    static final String JSON_KEY_TYPE = "type";
    static final String JSON_KEY_PAYLOAD = "payload";

    OperationServerMessage() {
    }

    @Nonnull
    public static OperationServerMessage fromJsonString(@Nonnull String json) {
        Utils.checkNotNull((Object)json, (Object)"json == null");
        try {
            Buffer buffer = new Buffer();
            buffer.writeUtf8(json);
            return OperationServerMessage.readFromJson(new BufferedSourceJsonReader((BufferedSource)buffer));
        }
        catch (Exception e) {
            return new Unsupported(json);
        }
    }

    private static OperationServerMessage readFromJson(@Nonnull JsonReader reader) throws IOException {
        String type;
        Utils.checkNotNull((Object)reader, (Object)"reader == null");
        ResponseJsonStreamReader responseJsonStreamReader = new ResponseJsonStreamReader(reader);
        Map<String, Object> messageData = responseJsonStreamReader.toMap();
        String id = (String)messageData.get(JSON_KEY_ID);
        switch (type = (String)messageData.get(JSON_KEY_TYPE)) {
            case "connection_error": {
                return new ConnectionError(OperationServerMessage.messagePayload(messageData));
            }
            case "connection_ack": {
                return new ConnectionAcknowledge();
            }
            case "data": {
                return new Data(id, OperationServerMessage.messagePayload(messageData));
            }
            case "error": {
                return new Error(id, OperationServerMessage.messagePayload(messageData));
            }
            case "complete": {
                return new Complete(id);
            }
        }
        throw new IOException("Unsupported message");
    }

    private static Map<String, Object> messagePayload(Map<String, Object> messageData) {
        Map messagePayload = (Map)messageData.get(JSON_KEY_PAYLOAD);
        return messagePayload == null ? Collections.emptyMap() : Collections.unmodifiableMap(messagePayload);
    }

    public static final class Unsupported
    extends OperationServerMessage {
        public final String rawMessage;

        public Unsupported(String rawMessage) {
            this.rawMessage = rawMessage;
        }
    }

    public static final class Complete
    extends OperationServerMessage {
        public static final String TYPE = "complete";
        public final String id;

        public Complete(String id) {
            this.id = id;
        }
    }

    public static final class Error
    extends OperationServerMessage {
        public static final String TYPE = "error";
        public final String id;
        public final Map<String, Object> payload;

        public Error(String id, Map<String, Object> payload) {
            this.id = id;
            this.payload = payload;
        }
    }

    public static final class Data
    extends OperationServerMessage {
        public static final String TYPE = "data";
        public final String id;
        public final Map<String, Object> payload;

        public Data(String id, Map<String, Object> payload) {
            this.id = id;
            this.payload = payload;
        }
    }

    public static final class ConnectionAcknowledge
    extends OperationServerMessage {
        public static final String TYPE = "connection_ack";
    }

    public static final class ConnectionError
    extends OperationServerMessage {
        public static final String TYPE = "connection_error";
        public final Map<String, Object> payload;

        public ConnectionError(Map<String, Object> payload) {
            this.payload = payload;
        }
    }
}

