/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.subscription;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionServerException;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.response.OperationResponseParser;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import com.apollographql.apollo.subscription.OperationClientMessage;
import com.apollographql.apollo.subscription.OperationServerMessage;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class RealSubscriptionManager
implements SubscriptionManager {
    static final int CONNECTION_ACKNOWLEDGE_TIMEOUT_TIMER_TASK_ID = 1;
    static final int INACTIVITY_TIMEOUT_TIMER_TASK_ID = 2;
    static final long CONNECTION_ACKNOWLEDGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    static final long INACTIVITY_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    Map<String, SubscriptionRecord> subscriptions = new LinkedHashMap<String, SubscriptionRecord>();
    State state = State.DISCONNECTED;
    final AutoReleaseTimer timer = new AutoReleaseTimer();
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final SubscriptionTransport transport;
    private final Executor dispatcher;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final Runnable connectionAcknowledgeTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onConnectionAcknowledgeTimeout();
        }
    };
    private final Runnable inactivityTimeoutTimerTask = new Runnable(){

        @Override
        public void run() {
            RealSubscriptionManager.this.onInactivityTimeout();
        }
    };

    public RealSubscriptionManager(@Nonnull ScalarTypeAdapters scalarTypeAdapters, @Nonnull SubscriptionTransport.Factory transportFactory, @Nonnull Executor dispatcher) {
        Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        Utils.checkNotNull((Object)transportFactory, (Object)"transportFactory == null");
        Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.transport = transportFactory.create(new SubscriptionTransportCallback(this, dispatcher));
        this.dispatcher = dispatcher;
    }

    @Override
    public <T> void subscribe(final @Nonnull Subscription<?, T, ?> subscription, final @Nonnull SubscriptionManager.Callback<T> callback) {
        Utils.checkNotNull(subscription, (Object)"subscription == null");
        Utils.checkNotNull(callback, (Object)"callback == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doSubscribe(subscription, callback);
            }
        });
    }

    public void unsubscribe(final @Nonnull Subscription subscription) {
        Utils.checkNotNull((Object)subscription, (Object)"subscription == null");
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.doUnsubscribe(subscription);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSubscribe(Subscription subscription, SubscriptionManager.Callback callback) {
        this.timer.cancelTask(2);
        String subscriptionId = RealSubscriptionManager.idForSubscription(subscription);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            if (this.subscriptions.containsKey(subscriptionId)) {
                callback.onError(new ApolloSubscriptionException("Already subscribed"));
                return;
            }
            this.subscriptions.put(subscriptionId, new SubscriptionRecord(subscription, callback));
            if (this.state == State.DISCONNECTED) {
                this.state = State.CONNECTING;
                this.transport.connect();
            } else if (this.state == State.ACTIVE) {
                this.transport.send(new OperationClientMessage.Start(subscriptionId, subscription, this.scalarTypeAdapters));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnsubscribe(Subscription subscription) {
        String subscriptionId = RealSubscriptionManager.idForSubscription(subscription);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            SubscriptionRecord subscriptionRecord = this.subscriptions.remove(subscriptionId);
            if (subscriptionRecord != null && this.state == State.ACTIVE) {
                this.transport.send(new OperationClientMessage.Stop(subscriptionId));
            }
            if (this.subscriptions.isEmpty()) {
                this.startInactivityTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTransportConnected() {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.state = State.CONNECTED;
            this.transport.send(new OperationClientMessage.Init());
        }
        this.timer.schedule(1, this.connectionAcknowledgeTimeoutTimerTask, CONNECTION_ACKNOWLEDGE_TIMEOUT);
    }

    void onConnectionAcknowledgeTimeout() {
        this.timer.cancelTask(1);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.onTransportFailure(new ApolloNetworkException("Subscription server is not responding"));
            }
        });
    }

    void onInactivityTimeout() {
        this.timer.cancelTask(2);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                RealSubscriptionManager.this.disconnect(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTransportFailure(Throwable t) {
        Map<String, SubscriptionRecord> subscriptions;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptions = this.subscriptions;
            this.disconnect(true);
        }
        for (SubscriptionRecord record : subscriptions.values()) {
            record.notifyOnNetworkError(t);
        }
    }

    void onOperationServerMessage(OperationServerMessage message) {
        if (message instanceof OperationServerMessage.ConnectionAcknowledge) {
            this.onConnectionAcknowledgeServerMessage();
        } else if (message instanceof OperationServerMessage.Data) {
            this.onOperationDataServerMessage((OperationServerMessage.Data)message);
        } else if (message instanceof OperationServerMessage.Error) {
            this.onErrorServerMessage((OperationServerMessage.Error)message);
        } else if (message instanceof OperationServerMessage.Complete) {
            this.onCompleteServerMessage((OperationServerMessage.Complete)message);
        } else if (message instanceof OperationServerMessage.ConnectionError) {
            this.disconnect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean force) {
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            if (force || this.subscriptions.isEmpty()) {
                this.transport.disconnect(new OperationClientMessage.Terminate());
                this.state = State.DISCONNECTED;
                this.subscriptions = new LinkedHashMap<String, SubscriptionRecord>();
            }
        }
    }

    private void startInactivityTimer() {
        this.timer.schedule(2, this.inactivityTimeoutTimerTask, INACTIVITY_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOperationDataServerMessage(OperationServerMessage.Data message) {
        SubscriptionRecord subscriptionRecord;
        String subscriptionId = message.id != null ? message.id : "";
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecord = this.subscriptions.get(subscriptionId);
        }
        if (subscriptionRecord != null) {
            Response<?> response;
            ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create((Operation)subscriptionRecord.subscription);
            OperationResponseParser parser = new OperationResponseParser((Operation<?, ?, ?>)subscriptionRecord.subscription, responseFieldMapper, this.scalarTypeAdapters);
            try {
                response = parser.parse(message.payload);
            }
            catch (Exception e) {
                subscriptionRecord = this.removeSubscriptionById(subscriptionId);
                if (subscriptionRecord != null) {
                    subscriptionRecord.notifyOnError(new ApolloSubscriptionException("Failed to parse server message", e));
                }
                return;
            }
            subscriptionRecord.notifyOnResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionAcknowledgeServerMessage() {
        this.timer.cancelTask(1);
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            this.state = State.ACTIVE;
            for (Map.Entry<String, SubscriptionRecord> entry : this.subscriptions.entrySet()) {
                String subscriptionId = entry.getKey();
                Subscription<?, ?, ?> subscription = entry.getValue().subscription;
                this.transport.send(new OperationClientMessage.Start(subscriptionId, subscription, this.scalarTypeAdapters));
            }
        }
    }

    private void onErrorServerMessage(OperationServerMessage.Error message) {
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord != null) {
            subscriptionRecord.notifyOnError(new ApolloSubscriptionServerException(message.payload));
        }
    }

    private void onCompleteServerMessage(OperationServerMessage.Complete message) {
        String subscriptionId = message.id != null ? message.id : "";
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        if (subscriptionRecord != null) {
            subscriptionRecord.notifyOnCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionRecord removeSubscriptionById(String subscriptionId) {
        SubscriptionRecord subscriptionRecord;
        RealSubscriptionManager realSubscriptionManager = this;
        synchronized (realSubscriptionManager) {
            subscriptionRecord = this.subscriptions.remove(subscriptionId);
            if (this.subscriptions.isEmpty()) {
                this.startInactivityTimer();
            }
        }
        return subscriptionRecord;
    }

    static String idForSubscription(Subscription<?, ?, ?> subscription) {
        return subscription.operationId() + "$" + subscription.variables().valueMap().hashCode();
    }

    static final class AutoReleaseTimer {
        final Map<Integer, TimerTask> tasks = new LinkedHashMap<Integer, TimerTask>();
        Timer timer;

        AutoReleaseTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(final int taskId, final Runnable task, long delay) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        AutoReleaseTimer.this.cancelTask(taskId);
                    }
                }
            };
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask previousTimerTask = this.tasks.put(taskId, timerTask);
                if (previousTimerTask != null) {
                    previousTimerTask.cancel();
                }
                if (this.timer == null) {
                    this.timer = new Timer("Subscription SmartTimer", true);
                }
            }
            this.timer.schedule(timerTask, delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelTask(int taskId) {
            AutoReleaseTimer autoReleaseTimer = this;
            synchronized (autoReleaseTimer) {
                TimerTask timerTask = this.tasks.remove(taskId);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.tasks.isEmpty() && this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
    }

    private static final class SubscriptionTransportCallback
    implements SubscriptionTransport.Callback {
        private final RealSubscriptionManager delegate;
        private final Executor dispatcher;

        SubscriptionTransportCallback(RealSubscriptionManager delegate, Executor dispatcher) {
            this.delegate = delegate;
            this.dispatcher = dispatcher;
        }

        @Override
        public void onConnected() {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportConnected();
                }
            });
        }

        @Override
        public void onFailure(final Throwable t) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onTransportFailure(t);
                }
            });
        }

        @Override
        public void onMessage(final OperationServerMessage message) {
            this.dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    SubscriptionTransportCallback.this.delegate.onOperationServerMessage(message);
                }
            });
        }
    }

    private static class SubscriptionRecord {
        final Subscription<?, ?, ?> subscription;
        final SubscriptionManager.Callback<?> callback;

        SubscriptionRecord(Subscription<?, ?, ?> subscription, SubscriptionManager.Callback<?> callback) {
            this.subscription = subscription;
            this.callback = callback;
        }

        void notifyOnResponse(Response response) {
            this.callback.onResponse(response);
        }

        void notifyOnError(ApolloSubscriptionException error) {
            this.callback.onError(error);
        }

        void notifyOnNetworkError(Throwable t) {
            this.callback.onNetworkError(t);
        }

        void notifyOnCompleted() {
            this.callback.onCompleted();
        }
    }

    static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        ACTIVE;

    }
}

