/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.json.JsonWriter;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class InputFieldJsonWriter
implements InputFieldWriter {
    private final JsonWriter jsonWriter;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;

    public InputFieldJsonWriter(JsonWriter jsonWriter, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
        this.jsonWriter = jsonWriter;
        this.customTypeAdapters = customTypeAdapters;
    }

    public void writeString(@Nonnull String fieldName, String value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeInt(@Nonnull String fieldName, Integer value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeLong(@Nonnull String fieldName, Long value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeDouble(@Nonnull String fieldName, Double value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeBoolean(@Nonnull String fieldName, Boolean value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeCustom(@Nonnull String fieldName, ScalarType scalarType, Object value) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        CustomTypeAdapter customTypeAdapter = this.customTypeAdapters.get(scalarType);
        if (customTypeAdapter != null) {
            this.writeString(fieldName, customTypeAdapter.encode(value));
        } else {
            this.writeString(fieldName, value != null ? value.toString() : null);
        }
    }

    public void writeObject(@Nonnull String fieldName, InputFieldMarshaller marshaller) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (marshaller != null) {
            this.jsonWriter.name(fieldName).beginObject();
            marshaller.marshal((InputFieldWriter)this);
            this.jsonWriter.endObject();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    public void writeList(@Nonnull String fieldName, InputFieldWriter.ListWriter listWriter) throws IOException {
        Utils.checkNotNull((Object)fieldName, (Object)"fieldName == null");
        if (listWriter != null) {
            this.jsonWriter.name(fieldName).beginArray();
            listWriter.write((InputFieldWriter.ListItemWriter)new JsonListItemWriter(this.jsonWriter, this.customTypeAdapters));
            this.jsonWriter.endArray();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    private static final class JsonListItemWriter
    implements InputFieldWriter.ListItemWriter {
        private final JsonWriter jsonWriter;
        private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;

        JsonListItemWriter(JsonWriter jsonWriter, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
            this.jsonWriter = jsonWriter;
            this.customTypeAdapters = customTypeAdapters;
        }

        public void writeString(String value) throws IOException {
            if (value != null) {
                this.jsonWriter.value(value);
            }
        }

        public void writeInt(Integer value) throws IOException {
            if (value != null) {
                this.jsonWriter.value(value);
            }
        }

        public void writeLong(Long value) throws IOException {
            if (value != null) {
                this.jsonWriter.value(value);
            }
        }

        public void writeDouble(Double value) throws IOException {
            if (value != null) {
                this.jsonWriter.value(value);
            }
        }

        public void writeBoolean(Boolean value) throws IOException {
            if (value != null) {
                this.jsonWriter.value(value);
            }
        }

        public void writeCustom(ScalarType scalarType, Object value) throws IOException {
            if (value == null) {
                return;
            }
            CustomTypeAdapter customTypeAdapter = this.customTypeAdapters.get(scalarType);
            if (customTypeAdapter != null) {
                this.writeString(customTypeAdapter.encode(value));
            } else {
                this.writeString(value.toString());
            }
        }

        public void writeObject(InputFieldMarshaller marshaller) throws IOException {
            if (marshaller != null) {
                this.jsonWriter.beginObject();
                marshaller.marshal((InputFieldWriter)new InputFieldJsonWriter(this.jsonWriter, this.customTypeAdapters));
                this.jsonWriter.endObject();
            }
        }
    }
}

