/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ApolloCacheInterceptor
implements ApolloInterceptor {
    private final ApolloStore apolloStore;
    private final ResponseFieldMapper responseFieldMapper;
    private final ExecutorService dispatcher;
    private final ApolloLogger logger;
    private volatile boolean disposed;

    public ApolloCacheInterceptor(@Nonnull ApolloStore apolloStore, @Nonnull ResponseFieldMapper responseFieldMapper, @Nonnull ExecutorService dispatcher, @Nonnull ApolloLogger logger) {
        this.apolloStore = (ApolloStore)Utils.checkNotNull((Object)apolloStore, (Object)"cache == null");
        this.responseFieldMapper = (ResponseFieldMapper)Utils.checkNotNull((Object)responseFieldMapper, (Object)"responseFieldMapper == null");
        this.dispatcher = (ExecutorService)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain) throws ApolloException {
        if (this.disposed) {
            throw new ApolloCanceledException("Canceled");
        }
        if (request.fetchOptions.fetchFromCache) {
            return this.resolveFromCache(request.operation, request.fetchOptions);
        }
        this.writeOptimisticUpdatesAndPublish(request);
        try {
            ApolloInterceptor.InterceptorResponse networkResponse = chain.proceed(request);
            Set<String> networkResponseCacheKeys = this.cacheResponse(networkResponse, request);
            Set<String> rolledBackCacheKeys = this.rollbackOptimisticUpdates(request);
            HashSet<String> changedCacheKeys = new HashSet<String>();
            changedCacheKeys.addAll(rolledBackCacheKeys);
            changedCacheKeys.addAll(networkResponseCacheKeys);
            this.publishCacheKeys(changedCacheKeys);
            return networkResponse;
        }
        catch (Exception rethrow) {
            this.rollbackOptimisticUpdatesAndPublish(request);
            throw rethrow;
        }
    }

    @Override
    public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                if (ApolloCacheInterceptor.this.disposed) {
                    return;
                }
                if (request.fetchOptions.fetchFromCache) {
                    try {
                        ApolloInterceptor.InterceptorResponse cachedResponse = ApolloCacheInterceptor.this.resolveFromCache(request.operation, request.fetchOptions);
                        callBack.onResponse(cachedResponse);
                        callBack.onCompleted();
                    }
                    catch (ApolloException e) {
                        callBack.onFailure(e);
                    }
                } else {
                    ApolloCacheInterceptor.this.writeOptimisticUpdatesAndPublish(request);
                    chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

                        @Override
                        public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse networkResponse) {
                            if (ApolloCacheInterceptor.this.disposed) {
                                return;
                            }
                            try {
                                Set networkResponseCacheKeys = ApolloCacheInterceptor.this.cacheResponse(networkResponse, request);
                                Set rolledBackCacheKeys = ApolloCacheInterceptor.this.rollbackOptimisticUpdates(request);
                                HashSet changedCacheKeys = new HashSet();
                                changedCacheKeys.addAll(rolledBackCacheKeys);
                                changedCacheKeys.addAll(networkResponseCacheKeys);
                                ApolloCacheInterceptor.this.publishCacheKeys(changedCacheKeys);
                            }
                            catch (Exception rethrow) {
                                ApolloCacheInterceptor.this.rollbackOptimisticUpdatesAndPublish(request);
                                throw rethrow;
                            }
                            callBack.onResponse(networkResponse);
                            callBack.onCompleted();
                        }

                        @Override
                        public void onFailure(@Nonnull ApolloException t) {
                            ApolloCacheInterceptor.this.rollbackOptimisticUpdatesAndPublish(request);
                            callBack.onFailure(t);
                        }

                        @Override
                        public void onCompleted() {
                        }
                    });
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    private ApolloInterceptor.InterceptorResponse resolveFromCache(Operation operation, FetchOptions options) throws ApolloException {
        ResponseNormalizer<Record> responseNormalizer = this.apolloStore.cacheResponseNormalizer();
        ApolloStoreOperation apolloStoreOperation = this.apolloStore.read(operation, this.responseFieldMapper, responseNormalizer, options.cacheHeaders);
        Response cachedResponse = apolloStoreOperation.execute();
        if (cachedResponse.data() != null) {
            this.logger.d("Cache HIT for operation %s", operation);
            return new ApolloInterceptor.InterceptorResponse(null, cachedResponse, responseNormalizer.records());
        }
        this.logger.d("Cache MISS for operation %s", operation);
        throw new ApolloException(String.format("Cache miss for operation %s", operation));
    }

    private Set<String> cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse, final ApolloInterceptor.InterceptorRequest request) {
        final Optional records = networkResponse.cacheRecords.map((Function)new Function<Collection<Record>, List<Record>>(){

            @Nonnull
            public List<Record> apply(@Nonnull Collection<Record> records) {
                ArrayList<Record> result = new ArrayList<Record>(records.size());
                for (Record record : records) {
                    result.add(record.toBuilder().mutationId(request.uniqueId).build());
                }
                return result;
            }
        });
        if (!records.isPresent()) {
            return Collections.emptySet();
        }
        try {
            return this.apolloStore.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                @Override
                @Nullable
                public Set<String> execute(WriteableStore cache) {
                    return cache.merge((Collection)records.get(), request.fetchOptions.cacheHeaders);
                }
            });
        }
        catch (Exception e) {
            this.logger.e("Failed to cache operation response", e);
            return Collections.emptySet();
        }
    }

    private void writeOptimisticUpdatesAndPublish(final ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (request.optimisticUpdates.isPresent()) {
                        Operation.Data optimisticUpdates = (Operation.Data)request.optimisticUpdates.get();
                        ApolloCacheInterceptor.this.apolloStore.writeOptimisticUpdatesAndPublish(request.operation, optimisticUpdates, request.uniqueId).execute();
                    }
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e(e, "failed to write operation optimistic updates, for: %s", request.operation);
                }
            }
        });
    }

    private void rollbackOptimisticUpdatesAndPublish(final ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.rollbackOptimisticUpdatesAndPublish(request.uniqueId).execute();
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e(e, "failed to rollback operation optimistic updates, for: %s", request.operation);
                }
            }
        });
    }

    private Set<String> rollbackOptimisticUpdates(ApolloInterceptor.InterceptorRequest request) {
        try {
            return this.apolloStore.rollbackOptimisticUpdates(request.uniqueId).execute();
        }
        catch (Exception e) {
            this.logger.e(e, "failed to rollback operation optimistic updates, for: %s", request.operation);
            return Collections.emptySet();
        }
    }

    private void publishCacheKeys(final Set<String> cacheKeys) {
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.publish(cacheKeys);
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e(e, "Failed to publish cache changes", new Object[0]);
                }
            }
        });
    }
}

