/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class CacheOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheOnlyInterceptor();
    }

    private static final class CacheOnlyInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        private CacheOnlyInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain) throws ApolloException {
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
            try {
                return chain.proceed(cacheRequest);
            }
            catch (Exception e) {
                return this.cacheMissResponse(request.operation);
            }
        }

        @Override
        public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    callBack.onResponse(CacheOnlyInterceptor.this.cacheMissResponse(request.operation));
                    callBack.onCompleted();
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }
            });
        }

        @Override
        public void dispose() {
        }

        private ApolloInterceptor.InterceptorResponse cacheMissResponse(Operation operation) {
            return new ApolloInterceptor.InterceptorResponse(null, Response.builder((Operation)operation).fromCache(true).build(), null);
        }
    }
}

