/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ApolloCacheInterceptor
implements ApolloInterceptor {
    private final ApolloStore apolloStore;
    private final ResponseFieldMapper responseFieldMapper;
    private final ExecutorService dispatcher;
    private final ApolloLogger logger;
    private volatile boolean disposed;

    public ApolloCacheInterceptor(@Nonnull ApolloStore apolloStore, @Nonnull ResponseFieldMapper responseFieldMapper, @Nonnull ExecutorService dispatcher, @Nonnull ApolloLogger logger) {
        this.apolloStore = (ApolloStore)Utils.checkNotNull((Object)apolloStore, (Object)"cache == null");
        this.responseFieldMapper = (ResponseFieldMapper)Utils.checkNotNull((Object)responseFieldMapper, (Object)"responseFieldMapper == null");
        this.dispatcher = (ExecutorService)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
        if (this.disposed) {
            throw new ApolloCanceledException("Canceled");
        }
        if (options.fetchFromCache) {
            return this.resolveFromCache(operation, options);
        }
        ApolloInterceptor.InterceptorResponse networkResponse = chain.proceed(options);
        this.cacheResponse(networkResponse, options);
        return networkResponse;
    }

    @Override
    public void interceptAsync(final @Nonnull Operation operation, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull FetchOptions options, final @Nonnull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                if (ApolloCacheInterceptor.this.disposed) {
                    return;
                }
                if (options.fetchFromCache) {
                    try {
                        ApolloInterceptor.InterceptorResponse cachedResponse = ApolloCacheInterceptor.this.resolveFromCache(operation, options);
                        callBack.onResponse(cachedResponse);
                        callBack.onCompleted();
                    }
                    catch (ApolloException e) {
                        callBack.onFailure(e);
                    }
                } else {
                    chain.proceedAsync(dispatcher, options, new ApolloInterceptor.CallBack(){

                        @Override
                        public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse networkResponse) {
                            if (ApolloCacheInterceptor.this.disposed) {
                                return;
                            }
                            ApolloCacheInterceptor.this.cacheResponse(networkResponse, options);
                            callBack.onResponse(networkResponse);
                            callBack.onCompleted();
                        }

                        @Override
                        public void onFailure(@Nonnull ApolloException e) {
                            callBack.onFailure(e);
                        }

                        @Override
                        public void onCompleted() {
                        }
                    });
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    private ApolloInterceptor.InterceptorResponse resolveFromCache(Operation operation, FetchOptions options) throws ApolloException {
        ResponseNormalizer<Record> responseNormalizer = this.apolloStore.cacheResponseNormalizer();
        ApolloStoreOperation apolloStoreOperation = this.apolloStore.read(operation, this.responseFieldMapper, responseNormalizer, options.cacheHeaders);
        Response cachedResponse = apolloStoreOperation.execute();
        if (cachedResponse.data() != null) {
            this.logger.d("Cache HIT for operation %s", operation);
            return new ApolloInterceptor.InterceptorResponse(null, cachedResponse, responseNormalizer.records());
        }
        this.logger.d("Cache MISS for operation %s", operation);
        throw new ApolloException(String.format("Cache miss for operation %s", operation));
    }

    private void cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse, final FetchOptions options) {
        Set<String> changedKeys;
        final Optional<Collection<Record>> records = networkResponse.cacheRecords;
        if (!records.isPresent()) {
            return;
        }
        try {
            changedKeys = this.apolloStore.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                @Override
                @Nullable
                public Set<String> execute(WriteableStore cache) {
                    return cache.merge((Collection)records.get(), options.cacheHeaders);
                }
            });
        }
        catch (Exception e) {
            this.logger.e("Failed to cache operation response", e);
            return;
        }
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.publish(changedKeys);
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e("Failed to publish cache changes", e);
                }
            }
        });
    }
}

