/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class CacheOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheOnlyInterceptor();
    }

    private static final class CacheOnlyInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        private CacheOnlyInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            FetchOptions cacheFetchOptions = options.toCacheFetchOptions();
            try {
                return chain.proceed(cacheFetchOptions);
            }
            catch (Exception e) {
                return this.cacheMissResponse(operation);
            }
        }

        @Override
        public void interceptAsync(final @Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, @Nonnull FetchOptions options, final @Nonnull ApolloInterceptor.CallBack callBack) {
            FetchOptions cacheFetchOptions = options.toCacheFetchOptions();
            chain.proceedAsync(dispatcher, cacheFetchOptions, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    callBack.onResponse(CacheOnlyInterceptor.this.cacheMissResponse(operation));
                    callBack.onCompleted();
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }
            });
        }

        @Override
        public void dispose() {
        }

        private ApolloInterceptor.InterceptorResponse cacheMissResponse(Operation operation) {
            return new ApolloInterceptor.InterceptorResponse(null, Response.builder((Operation)operation).fromCache(true).build(), null);
        }
    }
}

